/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.payablebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.business.ebservice.draftbill.impl.ElcManagerImpl;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.data.NoteResult;

public class PayableBillSubmitEleService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(10);
        sic.add("draftbillno");
        sic.add("draftbilltype");
        sic.add("draftbilltranstatus");
        sic.add("electag");
        sic.add("company");
        sic.add("istransfer");
        sic.add("rptype");
        sic.add("bizdate");
        sic.add("issuedate");
        sic.add("draftbillexpiredate");
        sic.add("drawername");
        sic.add("draweraccountname");
        sic.add("drawerbankname");
        sic.add("drawerbankno");
        sic.add("drawername");
        sic.add("receivername");
        sic.add("receiveraccount");
        sic.add("receiverbank");
        sic.add("receiverbankno");
        sic.add("currency");
        sic.add("amount");
        sic.add("acceptername");
        sic.add("accepteraccount");
        sic.add("accepterbankno");
        sic.add("accepterbankname");
        sic.add("issuepromisername");
        sic.add("issuepromiseraccount");
        sic.add("issuepromiseraddr");
        sic.add("issueticketcreditlevel");
        sic.add("issueticketexpiredate");
        sic.add("issueticketgrade");
        sic.add("promisegrade");
        sic.add("promisecreditlevel");
        sic.add("promiseexpiredate");
        sic.add("acceptpromisername");
        sic.add("acceptpromiseraccount");
        sic.add("acceptpromiseraddr");
        sic.add("description");
        sic.add("sourcebillid");
        sic.add("subbillrange");
        sic.add("acceptdate");
        sic.add("issplit");
        sic.add("eledraftstatusnew");
        sic.add("autoaccept");
        sic.add("autoreceive");
        sic.add("accepteraccountid");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject data : dataEntities) {
            data.set("draftbilltranstatus", (Object)DraftTranStatusEnum.HANDLEING.getValue());
            data.set("electag", (Object)"1");
            data.set("draftbillno", null);
            data.set("basedraftbillno", null);
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        ElcManagerImpl elcManager = new ElcManagerImpl();
        List<NoteResult> electIds = elcManager.payBillToElePayBill(dataEntities);
        List<Long> successIds = electIds == null ? null : electIds.stream().filter(o -> EBResultStatusCode.SUCCESS.equals((Object)o.getStatusCode())).map(NoteResult::getBillId).collect(Collectors.toList());
        ArrayList<DynamicObject> payBills = new ArrayList<DynamicObject>(4);
        if (successIds != null && successIds.size() > 0) {
            List<NoteResult> results = elcManager.remitRegister(successIds);
            Map payBillMap = Arrays.stream(dataEntities).collect(Collectors.toMap(o -> o.getLong("id"), Function.identity(), (k1, k2) -> k1));
            for (NoteResult result : results) {
                if (result.getStatusCode() == EBResultStatusCode.SUCCESS) continue;
                DynamicObject[] payEleBills = BusinessDataServiceHelper.load((String)"cdm_electronic_pay_deal", (String)"sourceid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)result.getBillId())});
                if (payEleBills.length > 0) {
                    DynamicObject payBil = (DynamicObject)payBillMap.get(payEleBills[0].getLong("sourceid"));
                    payBil.set("draftbilltranstatus", null);
                    payBil.set("electag", (Object)"0");
                    payBills.add(payBil);
                }
                this.operationResult.setSuccess(false);
                this.operationResult.setMessage(result.getErrMsg());
            }
            SaveServiceHelper.save((DynamicObject[])payBills.toArray(new DynamicObject[0]));
        } else {
            for (DynamicObject data : dataEntities) {
                data.set("draftbilltranstatus", null);
                data.set("electag", (Object)"0");
            }
            this.operationResult.setSuccess(false);
            this.operationResult.setMessage(ResManager.loadKDString((String)"\u201c\u5f00\u7968\u767b\u8bb0\u201d\u63d0\u4ea4\u7535\u7968\u540e\u521b\u5efa\u5728\u7ebf\u51fa\u7968\u5355\u636e\u5b9e\u4f53\u5931\u8d25\u3002", (String)"PayableBillSubmitEleService_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
            SaveServiceHelper.save((DynamicObject[])dataEntities);
        }
    }
}

