/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.payablebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.common.enums.DraftBillStatusEnum;
import kd.tmc.cdm.common.enums.PayBillStatusEnum;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.cdm.common.enums.SourceEnum;
import kd.tmc.cdm.common.helper.CasWriteBackHelper;
import kd.tmc.cdm.common.helper.ChequeHelper;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.cdm.common.helper.PayableBillHelp;
import kd.tmc.cdm.common.helper.SystemParameterHelper;
import kd.tmc.cdm.common.resource.CdmBizResource;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.model.CreditLimitInfo;
import kd.tmc.fbp.common.model.CreditLimitUseBean;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PayableBillSubmitService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(PayableBillSubmitService.class);
    private Set<Long> openParamOrgIdSet = new HashSet<Long>(16);
    private boolean isRpcSuccess;
    private Set<Long> sightDraftIds = new HashSet<Long>(10);

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(20);
        sic.add("creditlimit");
        sic.add("basedraftbillno");
        sic.add("draftbillno");
        sic.add("amount");
        sic.add("supperbillamount");
        sic.add("billno");
        sic.add("sourcebillid");
        sic.add("draftbilltype");
        sic.add("source");
        sic.add("issuedate");
        sic.add("receiver");
        sic.add("bizdate");
        sic.add("draftbillstatus");
        sic.add("billstatus");
        sic.add("company");
        sic.add("payeetype");
        sic.add("subbillrange");
        sic.add("billidentitycode");
        sic.add("originalsubbillamount");
        sic.add("originalsubbillrang");
        sic.add("availableamount");
        sic.add("lockedamount");
        sic.add("usedamount");
        sic.add("accepterfinorg");
        sic.add("creditlimitorg");
        sic.add("creditlimitcompany");
        sic.add("issplit");
        sic.add("subbillstartflag");
        sic.add("subbillendflag");
        sic.add("issuedate");
        sic.add("innercreditlimit");
        sic.add("suretymoney");
        sic.add("paybilltype");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        logger.info("is start to do process" + dataEntities.length);
        String cdmBizResourceTipSubmitCheck = new CdmBizResource().getTipSumbtiCheck();
        Set<Long> exsitPayBillIdSet = this.preDealDbData(dataEntities);
        for (DynamicObject data : dataEntities) {
            Object billNo;
            BigDecimal billamount = data.getBigDecimal("supperbillamount");
            BigDecimal amount = data.getBigDecimal("amount");
            if (EmptyUtil.isEmpty((BigDecimal)billamount)) {
                data.set("supperbillamount", (Object)amount);
            }
            if (!EmptyUtil.isEmpty((Object)(billNo = data.get("basedraftbillno")))) {
                data.set("draftbillno", ((DynamicObject)billNo).get("billno"));
                Long id = data.getLong("id");
                ArrayList<Long> ids = new ArrayList<Long>();
                ids.add(((DynamicObject)billNo).getLong("id"));
                Map resultMsg = ChequeHelper.updateCheques4Fill(ids, (Long)id, (String)"cdm_payablebill", (String)data.getString("billno"), (BigDecimal)data.getBigDecimal("amount"));
                if (resultMsg.size() > 0) {
                    throw new TmcBizException(TmcErrorCode.COMMON, (Object[])new String[]{String.format(cdmBizResourceTipSubmitCheck, data.getString("draftbillno"), resultMsg.get(((DynamicObject)billNo).getLong("id")))});
                }
                if (this.isFromCasPromissory(data)) {
                    Date issueDate = data.getDate("issuedate");
                    if (DateUtils.getCurrentDate().compareTo(DateUtils.truncateDate((Date)issueDate)) >= 0) {
                        data.set("draftbillstatus", (Object)DraftBillStatusEnum.PAYOFFED.getValue());
                        data.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
                        this.sightDraftIds.add((Long)data.getPkValue());
                    }
                }
            }
            long draftBillId = data.getLong("id");
            boolean isExsit = false;
            if (EmptyUtil.isNoEmpty(exsitPayBillIdSet)) {
                isExsit = exsitPayBillIdSet.contains(draftBillId);
            }
            DraftHelper.setBillCodeinfo((DynamicObject)data, (boolean)isExsit);
            DraftHelper.setSubBillInfo((DynamicObject)data);
            if (EmptyUtil.isNoEmpty((DynamicObject)data.getDynamicObject("creditlimit"))) {
                logger.info("start to do cfm");
                long id = data.getLong("id");
                DynamicObject creditLimit = data.getDynamicObject("creditlimit");
                if (EmptyUtil.isNoEmpty((DynamicObject)creditLimit)) {
                    CreditLimitUseBean useBean = this.getCreditLimitUseInfo(data);
                    useBean.setPreOccupy(Boolean.valueOf(false));
                    useBean.setCreditLimitNo(creditLimit.getString("number"));
                    useBean.setCreditLimitId(Long.valueOf(creditLimit.getLong("id")));
                    CreditLimitServiceHelper.autoUseCreditLimit((CreditLimitUseBean)useBean);
                    logger.info("do cfm end");
                    DynamicObject srcdate = this.findSrcdate(data);
                    CreditLimitInfo creditLimitInfo = CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)data, (DynamicObject)srcdate, (boolean)false, (Date)data.getDate("issuedate"));
                    this.isRpcSuccess = creditLimitInfo.isSuccess();
                    if (!this.isRpcSuccess) {
                        this.operationResult.setSuccess(false);
                        throw new TmcBizException(TmcErrorCode.COMMON, (Object[])new String[]{creditLimitInfo.getMessage()});
                    }
                }
            }
            long companyId = data.getDynamicObject("company").getLong("id");
            boolean isSucWriteBack = this.openParamOrgIdSet.contains(companyId);
            long sourceBillid = data.getLong("sourcebillid");
            if (EmptyUtil.isEmpty((Long)sourceBillid)) continue;
            String sourceStr = data.getString("source");
            String failErrorMsg = "";
            if (!"ifm".equalsIgnoreCase(sourceStr)) continue;
            if (!isSucWriteBack) {
                failErrorMsg = DraftHelper.callIfmTransBillPayStatus((DynamicObject)data, (String)"D");
                if (EmptyUtil.isEmpty((String)failErrorMsg)) {
                    HashSet<DynamicObject> billSet = new HashSet<DynamicObject>(1);
                    billSet.add(data);
                    DraftHelper.updateDratBillCasEntry(billSet, (String)"ifm_transhandlebill", (String)"add", (Long)sourceBillid);
                }
            } else {
                failErrorMsg = DraftHelper.callIfmTransBillPayStatus((DynamicObject)data, (String)"B");
            }
            if (!EmptyUtil.isNoEmpty((String)failErrorMsg)) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7968\u636e %1$s \u4ed8\u6b3e\u4ea4\u6613\u5904\u7406\u4ed8\u6b3e\u5931\u8d25\uff1a%2$s\u3002", (String)"PayableBillSubmitService_2", (String)"tmc-cdm-business", (Object[])new Object[0]), data.getString("billno"), failErrorMsg));
        }
    }

    private boolean isFromCasPromissory(DynamicObject data) {
        DynamicObject billtypeObj;
        return !EmptyUtil.isEmpty((Long)data.getLong("sourcebillid")) && SourceEnum.CAS.getValue().equals(data.getString("source")) && DraftHelper.isPromissory((Object)(billtypeObj = data.getDynamicObject("draftbilltype")));
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        logger.info("sightDraftIds is:" + this.sightDraftIds.size());
        HashSet<DynamicObject> needReleaAssureSet = new HashSet<DynamicObject>(16);
        for (DynamicObject data : dataEntities) {
            Object companyIdReceiver;
            String billingTypeStr = data.getString("paybilltype");
            if (EmptyUtil.isNoEmpty((String)billingTypeStr) && (billingTypeStr.contains("assure") || billingTypeStr.contains("pledge") || billingTypeStr.contains("mortgage"))) {
                needReleaAssureSet.add(data);
            }
            long companyId = data.getDynamicObject("company").getLong("id");
            boolean isSucWriteBack = this.openParamOrgIdSet.contains(companyId);
            long sourceBillid = data.getLong("sourcebillid");
            if (!EmptyUtil.isEmpty((Long)sourceBillid)) {
                logger.info("isSucWriteBack is:" + isSucWriteBack);
                if (!isSucWriteBack) {
                    Date issuedate = data.getDate("issuedate");
                    if (EmptyUtil.isEmpty((Object)issuedate)) {
                        issuedate = data.getDate("bizdate");
                    }
                    this.genPurPay(sourceBillid, data.getString("id"), issuedate);
                    HashSet<DynamicObject> billSet = new HashSet<DynamicObject>(1);
                    billSet.add(data);
                    Set needUpdateDySet = DraftHelper.updateDratBillCasEntry(billSet, (String)"cas_paybill", (String)"add", (Long)sourceBillid);
                    if (EmptyUtil.isNoEmpty((Object)needUpdateDySet)) {
                        SaveServiceHelper.save((DynamicObject[])needUpdateDySet.toArray(new DynamicObject[0]));
                    }
                } else {
                    CasWriteBackHelper.writePayStatus((String)String.valueOf(sourceBillid), (String)PayBillStatusEnum.DRAFTING.getValue());
                }
            }
            if (this.sightDraftIds.size() <= 0 || !this.sightDraftIds.contains(data.getPkValue()) || !EmptyUtil.isNoEmpty((Object)(companyIdReceiver = PayableBillHelp.getCompanyIdByRec((DynamicObject)data)))) continue;
            boolean isReceiveOppNote = DraftHelper.getCdmParameterBoolean((long)((Long)companyIdReceiver), (String)"isreceiveoppnote");
            Object[] bankrollDy = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,fisbankroll", (QFilter[])new QFilter[]{new QFilter("id", "=", companyIdReceiver), new QFilter("fisbankroll", "=", (Object)"1")});
            logger.info("companyId" + companyIdReceiver + "is isbankroll?" + EmptyUtil.isNoEmpty((Object[])bankrollDy));
            if (!EmptyUtil.isNoEmpty((Object[])bankrollDy) || !isReceiveOppNote) continue;
            TmcOperateServiceHelper.execOperate((String)"pushrece", (String)"cdm_payablebill", (DynamicObject[])new DynamicObject[]{data}, (OperateOption)OperateOption.create());
        }
        if (EmptyUtil.isNoEmpty(needReleaAssureSet)) {
            GuaranteeUseHelper.confirmGuaranteeUse((DynamicObject[])needReleaAssureSet.toArray(new DynamicObject[0]));
        }
        logger.info("start to do confirmGuaranteeUse");
    }

    private DynamicObject findSrcdate(DynamicObject data) {
        String source = data.getString("source");
        if (!"apply".equals(source)) {
            return null;
        }
        long sourcebillid = data.getLong("sourcebillid");
        QFilter qFilter = new QFilter("entryentity.id", "=", (Object)sourcebillid);
        QFilter qFilterCriedamount = new QFilter("entryentity.entry_amountofcredit", ">", (Object)0);
        DynamicObject srcbill = BusinessDataServiceHelper.loadSingle((String)"cdm_payablebill_ap_manual", (QFilter[])new QFilter[]{qFilter, qFilterCriedamount});
        return srcbill;
    }

    private CreditLimitUseBean getCreditLimitUseInfo(DynamicObject bill) {
        CreditLimitUseBean useBean = new CreditLimitUseBean();
        useBean.setPkId(Long.valueOf(bill.getLong("id")));
        useBean.setEntityName(bill.getDataEntityType().getName());
        useBean.setOrgId((Long)bill.getDynamicObject("company").getPkValue());
        useBean.setCurrencyId((Long)bill.getDynamicObject("currency").getPkValue());
        DynamicObject draftbilltype = bill.getDynamicObject("draftbilltype");
        if (EmptyUtil.isNoEmpty((DynamicObject)draftbilltype)) {
            String settlementType = draftbilltype.getString("settlementtype");
            if (SettleMentTypeEnum.BANK.getValue().equals(settlementType)) {
                useBean.setFinOrgId(Long.valueOf(bill.getDynamicObject("creditlimitorg").getLong("id")));
                useBean.setCreditFinType("bd_finorginfo");
            } else if (SettleMentTypeEnum.BUSINESS.getValue().equals(settlementType)) {
                boolean innerCreditLimit = bill.getBoolean("innercreditlimit");
                if (innerCreditLimit) {
                    DynamicObject creditLimitCompany = bill.getDynamicObject("creditlimitcompany");
                    useBean.setFinOrgId(Long.valueOf(creditLimitCompany.getLong("id")));
                    useBean.setCreditFinType("bos_org");
                } else {
                    DynamicObject drawerAccount = bill.getDynamicObject("draweraccount");
                    if (EmptyUtil.isEmpty((DynamicObject)drawerAccount)) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u8bf7\u5148\u586b\u5199\u51fa\u7968\u4eba\u5f00\u6237\u94f6\u884c\u3002", (String)"PayableBillSubmitService_1", (String)"tmc-cdm-business", (Object[])new Object[0]), bill.getString("billno")));
                    }
                    long bankId = drawerAccount.getDynamicObject("bank").getLong("id");
                    useBean.setFinOrgId(Long.valueOf(bankId));
                    useBean.setCreditFinType("bd_finorginfo");
                }
            }
            DynamicObject credittypeDO = draftbilltype.getDynamicObject("credittype");
            if (EmptyUtil.isNoEmpty((DynamicObject)credittypeDO)) {
                useBean.setCreditTypeId((Long)credittypeDO.getPkValue());
            } else {
                DynamicObject creditType = TmcDataServiceHelper.loadSingle((String)"cfm_credittype", (String)"iscomprehensive", (QFilter[])new QFilter[]{new QFilter("iscomprehensive", "=", (Object)"1")});
                useBean.setCreditTypeId((Long)creditType.getPkValue());
            }
            useBean.setCreditVariety(draftbilltype.getString("name"));
        }
        useBean.setMaxAmt(bill.getBigDecimal("amount"));
        useBean.setStartDate(bill.getDate("issuedate"));
        useBean.setEndDate(bill.getDate("draftbillexpiredate"));
        useBean.setBizAmt(bill.getBigDecimal("creditamount"));
        DynamicObject srcdate = this.findSrcdate(bill);
        if (null != srcdate) {
            logger.info("srcdate is not null");
            useBean.setSourceBillId(Long.valueOf(srcdate.getLong("id")));
            useBean.setSourceType(srcdate.getDataEntityType().getName());
        }
        return useBean;
    }

    private BigDecimal getCreditRatio(DynamicObject bill) {
        String entityName = bill.getDataEntityType().getName();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryCreditUseBill", (String)"cfm_credituse", (String)"creditratio", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", bill.getPkValue()).and("sourcetype", "=", (Object)entityName).and("isrelease", "=", (Object)"0")}, (String)"createtime desc");){
            if (ds.hasNext()) {
                Row r = ds.next();
                BigDecimal bigDecimal = r.getBigDecimal("creditratio");
                return bigDecimal;
            }
        }
        return Constants.ONE_HUNDRED;
    }

    public void genPurPay(long sourceBillId, String draftbillno, Date issuedate) {
        try (TXHandle tx = TX.requiresNew();){
            ArrayList<Long> ids = new ArrayList<Long>(10);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"genPurPay", (String)"cas_paybill", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sourceBillId)}, null);){
                while (ds.hasNext()) {
                    Row r = ds.next();
                    if (BillStatusEnum.PAYED.getValue().equals(r.getString("billstatus"))) continue;
                    ids.add(r.getLong("id"));
                }
            }
            if (ids.size() > 0) {
                logger.info("=======\u8c03\u7528\u4ed8\u6b3e\u5355\u4ed8\u6b3e\u64cd\u4f5c\u8bf7\u6c42\u53c2\u6570\uff1adraftbillno:{}, issuedate:{}", (Object)draftbillno, (Object)issuedate);
                OperateOption create = OperateOption.create();
                create.setVariableValue("draftbillno", draftbillno);
                create.setVariableValue("isfrompaydraft", "Y");
                create.setVariableValue("bizFinishDate", DateUtils.formatString((Date)issuedate, (String)"yyyy-MM-dd"));
                TmcOperateServiceHelper.execOperate((String)"pay", (String)"cas_paybill", (Object[])ids.toArray(), (OperateOption)create);
            }
        }
    }

    public void handlerException(DynamicObject[] dataEntities) throws KDException {
        super.handlerException(dataEntities);
        if (this.isRpcSuccess) {
            try {
                for (DynamicObject data : dataEntities) {
                    DynamicObject srcdate;
                    CreditLimitInfo creditLimitInfo;
                    if (!EmptyUtil.isNoEmpty((DynamicObject)data.getDynamicObject("creditlimit")) || (creditLimitInfo = CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)data, (DynamicObject)(srcdate = this.findSrcdate(data)), (boolean)false)).isSuccess()) continue;
                    throw new TmcBizException(TmcErrorCode.COMMON, (Object[])new String[]{creditLimitInfo.getMessage()});
                }
            }
            catch (Exception e) {
                logger.error("handlerException\u5f02\u5e38\u3002", (Throwable)e);
                throw e;
            }
        }
    }

    private Set<Long> preDealDbData(DynamicObject[] dataEntities) {
        DynamicObjectCollection exsitPayBillColl;
        HashSet<Long> companyIdSet = new HashSet<Long>(16);
        HashSet<Long> paybillIdSet = new HashSet<Long>(16);
        Set<Long> exsitPayBillIdSet = new HashSet<Long>(16);
        for (DynamicObject data : dataEntities) {
            DynamicObject company = data.getDynamicObject("company");
            long companyId = company.getLong("id");
            companyIdSet.add(companyId);
            long id = data.getLong("id");
            if (0L == id) continue;
            paybillIdSet.add(id);
        }
        Map paraMaps = SystemParameterHelper.getSysParamMap(companyIdSet);
        for (Map.Entry paraMap : paraMaps.entrySet()) {
            String keyId = (String)paraMap.getKey();
            Map valueMap = (Map)paraMap.getValue();
            boolean issucwriteback = (Boolean)valueMap.get("issucwriteback");
            if (!issucwriteback) continue;
            this.openParamOrgIdSet.add(Long.parseLong(keyId));
        }
        if (EmptyUtil.isNoEmpty(paybillIdSet) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(exsitPayBillColl = QueryServiceHelper.query((String)"cdm_payablebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", paybillIdSet), new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.PAYBILL.getValue())})))) {
            exsitPayBillIdSet = exsitPayBillColl.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        }
        logger.info("PayableBillSaveService preDealDbData is end:");
        return exsitPayBillIdSet;
    }
}

