/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.payablebill;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.CreditLimitInfo;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PayableBillUnAuditService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(PayableBillUnAuditService.class);
    private boolean isRpcSuccess;

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("creditlimit");
        sic.add("draftbilltranstatus");
        sic.add("draftbilltype");
        sic.add("billstatus");
        sic.add("drawercompany");
        sic.add("bizdate");
        sic.add("billno");
        sic.add("source");
        sic.add("sourcebillid");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataObj : dataEntities) {
            dataObj.set("draftbilltranstatus", null);
            if (!EmptyUtil.isNoEmpty((DynamicObject)dataObj.getDynamicObject("creditlimit"))) continue;
            logger.info("PayableBillUnAuditService start cancelCreditLimit");
            DynamicObject srcdate = this.findSrcdate(dataObj);
            CreditLimitInfo creditLimitInfo = CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)dataObj, (DynamicObject)srcdate, (boolean)false);
            this.isRpcSuccess = creditLimitInfo.isSuccess();
            logger.info("PayableBillUnAuditService cancelCreditLimit isRpcSuccess:" + this.isRpcSuccess);
            if (this.isRpcSuccess) continue;
            this.operationResult.setSuccess(false);
            throw new TmcBizException(TmcErrorCode.COMMON, (Object[])new String[]{creditLimitInfo.getMessage()});
        }
        TmcDataServiceHelper.save((DynamicObject[])dataEntities);
    }

    public void handlerException(DynamicObject[] dataEntities) throws KDException {
        super.handlerException(dataEntities);
        if (this.isRpcSuccess) {
            try {
                for (DynamicObject data : dataEntities) {
                    if (!EmptyUtil.isNoEmpty((DynamicObject)data.getDynamicObject("creditlimit"))) continue;
                    DynamicObject srcdate = this.findSrcdate(data);
                    CreditLimitInfo creditLimitInfo = CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)data, (DynamicObject)srcdate, (boolean)false, (Date)data.getDate("bizdate"));
                    this.isRpcSuccess = creditLimitInfo.isSuccess();
                    if (this.isRpcSuccess) continue;
                    throw new TmcBizException(TmcErrorCode.COMMON, (Object[])new String[]{creditLimitInfo.getMessage()});
                }
            }
            catch (Exception e) {
                logger.error("Exception", (Throwable)e);
                throw e;
            }
        }
    }

    private DynamicObject findSrcdate(DynamicObject data) {
        String source = data.getString("source");
        if (!"apply".equals(source)) {
            return null;
        }
        long sourcebillid = data.getLong("sourcebillid");
        QFilter qFilter = new QFilter("entryentity.id", "=", (Object)sourcebillid);
        DynamicObject srcbill = BusinessDataServiceHelper.loadSingle((String)"cdm_payablebill_ap_manual", (QFilter[])new QFilter[]{qFilter});
        return srcbill;
    }
}

