/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.receivablebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.common.helper.OperateServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RecBillCallPayEndorseService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(RecBillCallPayEndorseService.class);

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("sourcebillid");
        sic.add("company");
        sic.add("draftbillstatus");
        sic.add("draftbillno");
        sic.add("billstatus");
        sic.add("draftbilltype");
        sic.add("source");
        sic.add("amount");
        sic.add("availableamount");
        return sic;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        logger.info("RecBillCallPayEndorseService is start");
        try {
            for (DynamicObject dataEntity : dynamicObjects) {
                String draftbillno = dataEntity.getString("draftbillno");
                String draftbillstatus = dataEntity.getString("draftbillstatus");
                String billstatus = dataEntity.getString("billstatus");
                BigDecimal availableamount = dataEntity.getBigDecimal("availableamount");
                logger.info("RecBillCallPayEndorseService  draftbillno is:" + draftbillno + ",and id is:" + dataEntity.getLong("id") + ",availableamount is:" + availableamount);
                Long companyId = dataEntity.getDynamicObject("company").getLong("id");
                if ("registered".equals(draftbillstatus) && "C".equalsIgnoreCase(billstatus)) {
                    QFilter qFilterOrg = new QFilter("org", "=", (Object)companyId);
                    QFilter qFilterBillStatus = new QFilter("billstatus", "=", (Object)"J");
                    Object[] casPaybills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"cas_draftinfo,transamount,draftbillinfo,billno,draftbill,id,org", (QFilter[])new QFilter[]{qFilterOrg, qFilterBillStatus});
                    if (EmptyUtil.isNoEmpty((Object[])casPaybills)) {
                        Long payBillId = this.getCorrectPayBIll(availableamount, draftbillno, (DynamicObject[])casPaybills);
                        if (EmptyUtil.isNoEmpty((Long)payBillId)) {
                            OperateOption operateOption = OperateOption.create();
                            operateOption.setVariableValue("autoallocation", "true");
                            OperationResult result = null;
                            try {
                                result = OperateServiceHelper.execOperate((String)"pushdrafttrade", (String)"cas_paybill", (Object[])new Object[]{payBillId}, (OperateOption)operateOption);
                            }
                            catch (Exception e) {
                                logger.error("\u4ed8\u6b3e\u5355\u4e0b\u63a8\u4e1a\u52a1\u5904\u7406\u5355\u5931\u8d25\u3002", (Throwable)e);
                            }
                            if (result == null || result.isSuccess()) continue;
                            logger.error("\u4ed8\u6b3e\u5355\u4e0b\u63a8\u4e1a\u52a1\u5904\u7406\u5355\u5931\u8d25\u3002");
                            continue;
                        }
                        logger.info("can not get CorrectPayBIll");
                        continue;
                    }
                    logger.info("can not find casPaybills");
                    continue;
                }
                logger.info("draftbill is not correct");
            }
        }
        catch (Exception e) {
            logger.error("has exception:", (Throwable)e);
        }
    }

    private Long getCorrectPayBIll(BigDecimal availableamount, String draftbillno, DynamicObject[] casPaybills) {
        for (DynamicObject casPaybill : casPaybills) {
            List needChangeDraftsList;
            DynamicObjectCollection cas_draftinfos = casPaybill.getDynamicObjectCollection("cas_draftinfo");
            DynamicObjectCollection draftbills = casPaybill.getDynamicObjectCollection("draftbill");
            DynamicObject payBillDy = null;
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)cas_draftinfos)) {
                for (DynamicObject cas_draftinfo : cas_draftinfos) {
                    BigDecimal transamount = cas_draftinfo.getBigDecimal("transamount");
                    String draftBillnoCas = cas_draftinfo.getDynamicObject("draftbillinfo").getString("draftbillno");
                    if (availableamount.compareTo(transamount) != 0 || !draftbillno.equals(draftBillnoCas)) continue;
                    logger.info("recIds is:" + casPaybill.getString("billno"));
                    payBillDy = casPaybill;
                    break;
                }
            } else {
                for (DynamicObject draftbill : draftbills) {
                    DynamicObject fbasedataid = draftbill.getDynamicObject("fbasedataid");
                    if (null == fbasedataid) continue;
                    String billno = fbasedataid.getString("draftbillno");
                    String rptypeStr = fbasedataid.getString("rptype");
                    BigDecimal availableamountPay = fbasedataid.getBigDecimal("availableamount");
                    if (!draftbillno.equals(billno) || !"receivebill".equals(rptypeStr) || availableamount.compareTo(availableamountPay) != 0) continue;
                    logger.info("recIds is:" + casPaybill.getString("billno"));
                    payBillDy = casPaybill;
                    break;
                }
            }
            if (null == payBillDy) continue;
            int payEntryBillSize = 0;
            long payOrgId = payBillDy.getDynamicObject("org").getLong("id");
            HashSet<String> billNosSet = new HashSet<String>(8);
            HashSet<BigDecimal> billAmountSet = new HashSet<BigDecimal>(8);
            HashMap draftDraftBillnoAndAmountMap = new HashMap(8);
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)cas_draftinfos)) {
                needChangeDraftsList = cas_draftinfos.stream().filter(x -> payOrgId != x.getDynamicObject("draftbillinfo").getDynamicObject("company").getLong("id")).collect(Collectors.toList());
                if (EmptyUtil.isEmpty(needChangeDraftsList)) {
                    return null;
                }
                payEntryBillSize = needChangeDraftsList.size();
                for (DynamicObject cas_draftinfo : needChangeDraftsList) {
                    BigDecimal transamount = cas_draftinfo.getBigDecimal("transamount");
                    String draftBillno = cas_draftinfo.getDynamicObject("draftbillinfo").getString("draftbillno");
                    billNosSet.add(draftBillno);
                    billAmountSet.add(transamount);
                    if (!draftDraftBillnoAndAmountMap.containsKey(draftBillno)) {
                        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
                        list.add(transamount);
                        draftDraftBillnoAndAmountMap.put(draftBillno, list);
                        continue;
                    }
                    ((List)draftDraftBillnoAndAmountMap.get(draftBillno)).add(transamount);
                }
            } else if (EmptyUtil.isNoEmpty((DynamicObjectCollection)draftbills)) {
                needChangeDraftsList = draftbills.stream().filter(x -> payOrgId != x.getDynamicObject("fbasedataid").getDynamicObject("company").getLong("id")).collect(Collectors.toList());
                if (EmptyUtil.isEmpty(needChangeDraftsList)) {
                    return null;
                }
                payEntryBillSize = needChangeDraftsList.size();
                for (DynamicObject draftbill : needChangeDraftsList) {
                    DynamicObject fbasedataid = draftbill.getDynamicObject("fbasedataid");
                    String billno = fbasedataid.getString("draftbillno");
                    BigDecimal amount = fbasedataid.getBigDecimal("amount");
                    billNosSet.add(billno);
                    billAmountSet.add(amount);
                    if (!draftDraftBillnoAndAmountMap.containsKey(billno)) {
                        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
                        list.add(amount);
                        draftDraftBillnoAndAmountMap.put(billno, list);
                        continue;
                    }
                    ((List)draftDraftBillnoAndAmountMap.get(billno)).add(amount);
                }
            }
            logger.info("billno is:" + SerializationUtils.toJsonString(billNosSet));
            QFilter qFilterCompany = new QFilter("company", "=", casPaybill.getDynamicObject("org").getPkValue());
            QFilter qFilterBillno = new QFilter("draftbillno", "in", billNosSet);
            QFilter qFilterStatus = new QFilter("billstatus", "=", (Object)"C");
            QFilter qFilterRptype = new QFilter("rptype", "=", (Object)"receivebill");
            QFilter qFilterDraftBIllStatus = new QFilter("draftbillstatus", "=", (Object)"registered");
            QFilter qFilterAmount = new QFilter("availableamount", "in", billAmountSet);
            Object[] recIds = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,draftbillno,availableamount", (QFilter[])new QFilter[]{qFilterCompany, qFilterBillno, qFilterStatus, qFilterRptype, qFilterDraftBIllStatus, qFilterAmount});
            if (EmptyUtil.isNoEmpty((Object[])recIds) && recIds.length >= payEntryBillSize) {
                HashMap billnoAndAmountDbMap = new HashMap(8);
                for (Object recId : recIds) {
                    BigDecimal amount = recId.getBigDecimal("availableamount");
                    String draftbillnoStr = recId.getString("draftbillno");
                    if (!billnoAndAmountDbMap.containsKey(draftbillnoStr)) {
                        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
                        list.add(amount);
                        billnoAndAmountDbMap.put(draftbillnoStr, list);
                        continue;
                    }
                    ((List)billnoAndAmountDbMap.get(draftbillnoStr)).add(amount);
                }
                Set draftbillnoSet = billnoAndAmountDbMap.keySet();
                ArrayList bigDecimalList = new ArrayList(8);
                for (Map.Entry entry : billnoAndAmountDbMap.entrySet()) {
                    List value = (List)entry.getValue();
                    bigDecimalList.addAll(value);
                }
                if (draftbillnoSet.size() >= billNosSet.size() && bigDecimalList.size() >= payEntryBillSize) {
                    boolean isNeedBreak = false;
                    long payBillId = payBillDy.getLong("id");
                    for (Map.Entry entry : draftDraftBillnoAndAmountMap.entrySet()) {
                        String payKey = (String)entry.getKey();
                        List payValue = (List)entry.getValue();
                        List amountValueDb = (List)billnoAndAmountDbMap.get(payKey);
                        logger.info("recIds payKey is:" + payKey + ",payValue is:" + SerializationUtils.toJsonString((Object)payValue) + ",amountValueDb is:" + SerializationUtils.toJsonString((Object)amountValueDb));
                        if (!EmptyUtil.isEmpty((Collection)amountValueDb) && amountValueDb.containsAll(payValue)) {
                            if (amountValueDb.stream().filter(payValue::contains).count() >= (long)payValue.size()) continue;
                        }
                        isNeedBreak = true;
                        break;
                    }
                    if (isNeedBreak) {
                        logger.info("payBillId will contiune:" + payBillId);
                        continue;
                    }
                    return payBillId;
                }
                logger.info("draftbillnoSet not equals billNosSet and draftbillnoSet is:" + SerializationUtils.toJsonString(draftbillnoSet));
                continue;
            }
            logger.info("recIds is null");
        }
        logger.info("casPaybill is null:" + draftbillno);
        return null;
    }
}

