/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.receivablebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.business.helper.RecBillAutoClaimNoticeHelper;
import kd.tmc.cdm.business.helper.RecBillAutoMatchHelper;
import kd.tmc.cdm.common.enums.RecTypeEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;

public class ReceivableAutoGenRecBillService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(ReceivableAutoGenRecBillService.class);

    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(10);
        selector.add("id");
        selector.add("amount");
        selector.add("company");
        selector.add("draftbillno");
        selector.add("sourcebillid");
        selector.add("rectype");
        selector.add("rulename");
        selector.add("draftbillno");
        selector.add("billstatus");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
    }

    public void afterProcess(DynamicObject[] dynamicObjects) throws KDException {
        logger.info("ReceivableAutoGenRecBillService afterProcess start");
        List<Long> selectIds = Arrays.stream(dynamicObjects).map(o -> o.getLong("id")).collect(Collectors.toList());
        Map<Long, String> successCdmRecBillMap = RecBillAutoMatchHelper.autoMatch(selectIds);
        ArrayList<Long> successMatchCdmRecBillIds = new ArrayList<Long>(successCdmRecBillMap.keySet());
        logger.info("ReceivableAutoGenRecBillService afterProcess successMatchCdmRecBillIds = {}", successMatchCdmRecBillIds);
        List matchedCdmRecBills = Arrays.stream(dynamicObjects).filter(o -> !successMatchCdmRecBillIds.contains(o.getLong("id"))).collect(Collectors.toList());
        for (DynamicObject draftRecBill : matchedCdmRecBills) {
            DynamicObject ruleResult = RecBillAutoClaimNoticeHelper.getClaimInfoByNoticeRule(draftRecBill.getLong("id"), "genrecbill");
            if (ObjectUtils.isEmpty((Object)ruleResult)) continue;
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            option.setVariableValue("fromGenRecBill", "true");
            option.setVariableValue("e_receivingtype", ruleResult.getDynamicObject("e_receivingtype") == null ? "0" : ruleResult.getDynamicObject("e_receivingtype").getPkValue().toString());
            option.setVariableValue("e_payertype", StringUtils.isEmpty((CharSequence)ruleResult.getString("e_payertype")) ? "" : ruleResult.getString("e_payertype"));
            option.setVariableValue("e_payer", StringUtils.isEmpty((CharSequence)ruleResult.getString("e_payer")) ? "" : ruleResult.getString("e_payer"));
            option.setVariableValue("e_payerid", ruleResult.getDynamicObject("e_payerid") == null ? "0" : ruleResult.getDynamicObject("e_payerid").getPkValue().toString());
            option.setVariableValue("e_payerbasetype", StringUtils.isEmpty((CharSequence)ruleResult.getString("e_payerbasetype")) ? "" : ruleResult.getString("e_payerbasetype"));
            option.setVariableValue("e_fundflowitem", ruleResult.getDynamicObject("e_fundflowitem") == null ? "0" : ruleResult.getDynamicObject("e_fundflowitem").getPkValue().toString());
            option.setVariableValue("e_explain", StringUtils.isEmpty((CharSequence)ruleResult.getString("e_explain")) ? "" : ruleResult.getString("e_explain"));
            option.setVariableValue("e_settletype", ruleResult.getDynamicObject("e_settletype") == null ? "0" : ruleResult.getDynamicObject("e_settletype").getPkValue().toString());
            this.operationResult = TmcOperateServiceHelper.execOperateWithoutThrow((String)"pushandsaverecbill", (String)"cdm_receivablebill", (Object[])new Object[]{draftRecBill.getPkValue()}, (OperateOption)option);
            if (!this.operationResult.isSuccess()) continue;
            QFilter filter = new QFilter("rule_entity.id", "=", ruleResult.getPkValue());
            DynamicObject[] rules = BusinessDataServiceHelper.load((String)"cdm_recbill_noticerule", (String)"id,name", (QFilter[])new QFilter[]{filter});
            String ruleName = rules == null ? "" : rules[0].getString("name") + "_";
            draftRecBill.set("rectype", (Object)RecTypeEnum.RULE_GEN.getValue());
            draftRecBill.set("rulename", (Object)(ruleName + "_" + ruleResult.getString("e_rulesname")));
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        logger.info("ReceivableAutoGenRecBillService afterProcess end");
    }
}

