/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.receivablebill;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.common.enums.PayBillStatusEnum;
import kd.tmc.cdm.common.enums.SourceEnum;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ReceivableBillDeleteService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(ReceivableBillDeleteService.class);

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(17);
        sic.add("draftbillno");
        sic.add("source");
        sic.add("sourcebillid");
        sic.add("locksourcebilltype");
        sic.add("locksourcebillid");
        sic.add("amount");
        sic.add("supperbillamount");
        sic.add("draftbillstatus");
        sic.add("isfromequalspilt");
        sic.add("isequalbill");
        sic.add("euqaldifferetype");
        sic.add("supperbillid");
        sic.add("draftbilltranstatus");
        sic.add("subbillrange");
        sic.add("billidentitycode");
        sic.add("originalsubbillamount");
        sic.add("originalsubbillrang");
        sic.add("availableamount");
        sic.add("lockedamount");
        sic.add("usedamount");
        sic.add("billno");
        sic.add("releatedcasbillentrys");
        sic.add("releatedcasbillentrys.rel_billtype");
        sic.add("releatedcasbillentrys.rel_billno");
        sic.add("releatedcasbillentrys.rel_billid");
        sic.add("releatedcasbillentrys.rel_bizdate");
        sic.add("releatedcasbillentrys.rel_billamount");
        sic.add("releatedcasbillentrys.rel_createtime");
        sic.add("releatedcasbillentrys.rel_modifytime");
        sic.add("releatedcasbillentrys.rel_isrefuse");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        if (EmptyUtil.isNoEmpty((Object[])dataEntities)) {
            for (DynamicObject data : dataEntities) {
                String sourceBillId = data.getString("sourcebillid");
                if (!SourceEnum.CAS.getValue().equals(data.get("source")) || !EmptyUtil.isNoEmpty((String)sourceBillId)) continue;
                OperateOption create = OperateOption.create();
                create.setVariableValue("isfrombill", "y");
                create.setVariableValue("isfrombilldelte", "y");
                try (TXHandle tx = TX.requiresNew();){
                    DynamicObject recBill = TmcDataServiceHelper.loadSingle((String)"cas_recbill", (String)"id,billstatus,settletnumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(sourceBillId))});
                    if (EmptyUtil.isNoEmpty((DynamicObject)recBill)) {
                        logger.info("recBill is:" + recBill.getLong("id"));
                        if (Objects.equals(PayBillStatusEnum.DRAFTING.getValue(), recBill.getString("billstatus"))) {
                            logger.info("writePayStatus  recBill");
                            recBill.set("billstatus", (Object)PayBillStatusEnum.AUDIT.getValue());
                        } else if (Objects.equals(PayBillStatusEnum.PAY.getValue(), recBill.getString("billstatus"))) {
                            OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"cancelrec", (String)"cas_recbill", (Object[])new Object[]{Long.valueOf(sourceBillId)}, (OperateOption)create);
                        }
                        recBill.set("settletnumber", null);
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recBill});
                    }
                }
                catch (Exception e) {
                    logger.error("cas invalid bill has error", (Throwable)e);
                    throw e;
                }
                long sourCasBillId = Long.parseLong(sourceBillId);
                HashSet<DynamicObject> billSet = new HashSet<DynamicObject>(1);
                billSet.add(data);
                Set needUpdateDySet = DraftHelper.updateDratBillCasEntry(billSet, (String)"cas_recbill", (String)"delete", (Long)sourCasBillId);
                if (!EmptyUtil.isNoEmpty((Object)needUpdateDySet)) continue;
                SaveServiceHelper.save((DynamicObject[])needUpdateDySet.toArray(new DynamicObject[0]));
            }
        }
    }
}

