/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.receivablebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ReceivableBillGenEleBillsService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(ReceivableBillGenEleBillsService.class);

    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("id");
        selector.add("draftbilltype");
        selector.add("draftbilltranstatus");
        selector.add("draftbillstatus");
        selector.add("amount");
        selector.add("supperbillamount");
        selector.add("company");
        selector.add("draftbillno");
        selector.add("isfromequalspilt");
        selector.add("isequalbill");
        selector.add("euqaldifferetype");
        selector.add("sourcebillid");
        selector.add("subbillrange");
        selector.add("supperbillid");
        selector.add("billno");
        selector.add("billstatus");
        return selector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(DynamicObject[] dynamicObjects) throws KDException {
        logger.info("start to deal EleRecDeals");
        List willGenEleBIlls = Arrays.stream(dynamicObjects).filter(x -> EmptyUtil.isNoEmpty((Long)x.getLong("supperbillid")) && EmptyUtil.isEmpty((Long)x.getLong("sourcebillid")) && x.getBoolean("isfromequalspilt") && (!x.getBoolean("isequalbill") || x.getBoolean("isequalbill") && "pledge".equals(x.getString("euqaldifferetype")))).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(willGenEleBIlls)) {
            logger.info("willGenEleBIlls is empty");
            return;
        }
        Map<String, String> idAndBillnoMap = willGenEleBIlls.stream().collect(Collectors.toMap(e -> e.getString("id"), e -> e.getString("billno")));
        StringJoiner errorMsg = new StringJoiner(";");
        ArrayList<String> requestIds = new ArrayList<String>();
        ArrayList<String> requestFailIds = new ArrayList<String>();
        List idsList = willGenEleBIlls.stream().map(e -> e.getString("id")).collect(Collectors.toList());
        Map request = MutexServiceHelper.batchRequestWithLostTime(idsList, (String)"cdm_receivablebill", (String)"equalgenelebills");
        try {
            for (Map.Entry entry : request.entrySet()) {
                String key = (String)entry.getKey();
                if (((Boolean)entry.getValue()).booleanValue()) {
                    requestIds.add(key);
                    continue;
                }
                requestFailIds.add(key);
            }
            if (requestFailIds.size() > 0) {
                for (String requestFailId : requestFailIds) {
                    String billno = idAndBillnoMap.get(requestFailId);
                    errorMsg.add(ResManager.loadKDString((String)"\u5355\u636e %s \u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ReceivableBillGenEleBillsService_0", (String)"tmc-cdm-business", (Object[])new Object[]{billno}));
                }
            }
            if (requestIds.size() > 0) {
                Map<Long, List<DynamicObject>> supperIdAndBillIdMap = willGenEleBIlls.stream().collect(Collectors.groupingBy(o -> o.getLong("supperbillid")));
                Set<Long> supperIds = supperIdAndBillIdMap.keySet();
                QFilter qFilterId = new QFilter("id", "in", supperIds);
                DynamicObject[] supperRecBills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,sourcebillid,amount", (QFilter[])new QFilter[]{qFilterId});
                Map<Long, Long> supperIdAndEleBillIdMap = Arrays.stream(supperRecBills).collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getLong("sourcebillid")));
                HashMap<Long, List<DynamicObject>> sourceIdAndBillDyMap = new HashMap<Long, List<DynamicObject>>();
                for (Map.Entry<Long, List<DynamicObject>> entry : supperIdAndBillIdMap.entrySet()) {
                    Long supperId = entry.getKey();
                    List<DynamicObject> bill = entry.getValue();
                    Long eleBillId = supperIdAndEleBillIdMap.get(supperId);
                    if (!EmptyUtil.isNoEmpty((Long)eleBillId)) continue;
                    if (sourceIdAndBillDyMap.containsKey(eleBillId)) {
                        ((List)sourceIdAndBillDyMap.get(eleBillId)).addAll(bill);
                        continue;
                    }
                    sourceIdAndBillDyMap.put(eleBillId, bill);
                }
                Set sourceIdSet = sourceIdAndBillDyMap.keySet();
                MainEntityType eleBillType = EntityMetadataCache.getDataEntityType((String)"cdm_electronic_rec_deal");
                Object[] eleRecDeals = BusinessDataServiceHelper.load((Object[])sourceIdSet.toArray(), (DynamicObjectType)eleBillType);
                if (EmptyUtil.isNoEmpty((Object[])eleRecDeals)) {
                    HashSet<DynamicObject> newEleRecDeals = new HashSet<DynamicObject>();
                    HashSet<DynamicObject> recBillSet = new HashSet<DynamicObject>();
                    for (Object eleRecDeal : eleRecDeals) {
                        long eleRecDealId = eleRecDeal.getLong("id");
                        List recBills = (List)sourceIdAndBillDyMap.get(eleRecDealId);
                        for (DynamicObject recBill : recBills) {
                            long recBIllId = recBill.getLong("id");
                            boolean isPledgeEqualBill = recBill.getBoolean("isequalbill") && "pledge".equals(recBill.getString("euqaldifferetype"));
                            long eleSourceId = eleRecDeal.getLong("sourceid");
                            if (recBIllId == eleSourceId) {
                                logger.info("ele bill:" + eleRecDealId + "has match this bill:" + recBIllId);
                                continue;
                            }
                            DynamicObject newEleBill = (DynamicObject)OrmUtils.clone((Object)eleRecDeal, (IDataEntityType)eleRecDeal.getDataEntityType(), (boolean)true, (boolean)true);
                            long eleBillId = DB.genGlobalLongId();
                            newEleBill.set("id", (Object)eleBillId);
                            newEleBill.set("amount", (Object)recBill.getBigDecimal("amount"));
                            newEleBill.set("locamt", (Object)0);
                            if (isPledgeEqualBill) {
                                logger.info("is isPledgeEqualBill" + recBill.getLong("id"));
                                newEleBill.set("locamt", (Object)recBill.getBigDecimal("amount"));
                            }
                            newEleBill.set("sourceid", (Object)recBIllId);
                            newEleBill.set("sourcenumber", (Object)recBill.getString("billno"));
                            newEleBill.set("subrange", (Object)recBill.getString("subbillrange"));
                            newEleRecDeals.add(newEleBill);
                            recBill.set("sourcebillid", (Object)eleBillId);
                            recBillSet.add(recBill);
                        }
                    }
                    logger.info("will save new EleRecDeals:" + newEleRecDeals.size());
                    if (EmptyUtil.isNoEmpty(newEleRecDeals)) {
                        TmcDataServiceHelper.save((DynamicObject[])newEleRecDeals.toArray(new DynamicObject[0]));
                        TmcDataServiceHelper.save((DynamicObject[])recBillSet.toArray(new DynamicObject[0]));
                    }
                }
            }
        }
        catch (Exception e2) {
            logger.error("to get lock Exception is:", (Throwable)e2);
            errorMsg.add(ResManager.loadKDString((String)"\u751f\u6210\u5dee\u989d\u7535\u7968\u5f02\u5e38", (String)"ReceivableBillGenEleBillsService_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
        finally {
            MutexServiceHelper.batchRelease(requestIds, (String)"cdm_receivablebill", (String)"equalgenelebills");
        }
        if (errorMsg.length() > 0) {
            logger.info("equalgenelebills eror is:" + errorMsg.toString());
            throw new KDBizException(errorMsg.toString());
        }
    }
}

