/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.receivablebill;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ReceivableBillSaveService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(ReceivableBillSaveService.class);

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(17);
        sic.add("draftbillno");
        sic.add("draftbilltype");
        sic.add("draftbilltype.billmedium");
        sic.add("elccirculatestatus");
        sic.add("source");
        sic.add("id");
        sic.add("sourcebillid");
        sic.add("locksourcebilltype");
        sic.add("locksourcebillid");
        sic.add("amount");
        sic.add("supperbillamount");
        sic.add("draftbillstatus");
        sic.add("isfromequalspilt");
        sic.add("isequalbill");
        sic.add("euqaldifferetype");
        sic.add("supperbillid");
        sic.add("draftbilltranstatus");
        sic.add("subbillrange");
        sic.add("billidentitycode");
        sic.add("originalsubbillamount");
        sic.add("originalsubbillrang");
        sic.add("availableamount");
        sic.add("lockedamount");
        sic.add("usedamount");
        sic.add("issuedate");
        sic.add("draftbillexpiredate");
        sic.add("draftbilltype");
        sic.add("drawerbank");
        sic.add("billno");
        sic.add("releatedcasbillentrys");
        sic.add("releatedcasbillentrys.rel_billtype");
        sic.add("releatedcasbillentrys.rel_billno");
        sic.add("releatedcasbillentrys.rel_billid");
        sic.add("releatedcasbillentrys.rel_bizdate");
        sic.add("releatedcasbillentrys.rel_billamount");
        sic.add("releatedcasbillentrys.rel_createtime");
        sic.add("releatedcasbillentrys.rel_modifytime");
        sic.add("releatedcasbillentrys.rel_isrefuse");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        if (EmptyUtil.isNoEmpty((Object[])dataEntities)) {
            for (DynamicObject bill : dataEntities) {
                DynamicObject draftbilltype;
                String billmedium;
                String euqaldifferetype;
                String tradeTypeStatus;
                BigDecimal billAmount = bill.getBigDecimal("supperbillamount");
                BigDecimal amount = bill.getBigDecimal("amount");
                if (EmptyUtil.isEmpty((BigDecimal)billAmount)) {
                    bill.set("supperbillamount", (Object)amount);
                }
                if (bill.getBoolean("isfromequalspilt") && bill.getBoolean("isequalbill") && EmptyUtil.isNoEmpty((String)(tradeTypeStatus = DraftHelper.tradeTypeStatus((String)(euqaldifferetype = bill.getString("euqaldifferetype")))))) {
                    bill.set("draftbillstatus", (Object)tradeTypeStatus);
                }
                boolean isExsit = bill.getDataEntityState().getFromDatabase();
                DraftHelper.setBillCodeinfo((DynamicObject)bill, (boolean)isExsit);
                String elccirculatestatus = bill.getString("elccirculatestatus");
                if (!EmptyUtil.isEmpty((String)elccirculatestatus) || !"2".equals(billmedium = (draftbilltype = bill.getDynamicObject("draftbilltype")).getString("billmedium"))) continue;
                bill.set("elccirculatestatus", (Object)"TF0301");
            }
        }
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        Map variables = this.getOperationVariable();
        if ("Y".equals(variables.get("fromdraftschedule"))) {
            DynamicObject[] origDraftBills;
            ArrayList<DynamicObject> origDrafts = new ArrayList<DynamicObject>(dataEntities.length);
            Set sourceDraftIds = Arrays.stream(dataEntities).filter(o -> o.getLong("sourcedraft") > 0L).map(o -> o.getLong("sourcedraft")).collect(Collectors.toSet());
            QFilter sourceDraftFilter = new QFilter("id", "in", sourceDraftIds);
            for (DynamicObject origDraftBill : origDraftBills = TmcDataServiceHelper.load((String)"cdm_receivablebill", (String)"billpool,intopooltime,poollockstatus,poollockorg,poollocktime,isendorsepay,locksourcebillid,locksourcebilltype", (QFilter[])new QFilter[]{sourceDraftFilter})) {
                origDraftBill.set("billpool", null);
                origDraftBill.set("intopooltime", null);
                origDraftBill.set("poollockstatus", null);
                origDraftBill.set("poollockorg", null);
                origDraftBill.set("poollocktime", null);
                origDraftBill.set("isendorsepay", (Object)"0");
                origDraftBill.set("locksourcebillid", null);
                origDraftBill.set("locksourcebilltype", null);
                origDrafts.add(origDraftBill);
            }
            SaveServiceHelper.update((DynamicObject[])origDrafts.toArray(new DynamicObject[0]));
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject data : dataEntities) {
            String src = data.getString("source");
            String sourceBillid = data.getString("sourcebillid");
            if (EmptyUtil.isEmpty((String)sourceBillid) || !"cas".equals(src)) continue;
            this.genReceivingrec(sourceBillid, data);
            long sourCasBillId = Long.parseLong(sourceBillid);
            HashSet<DynamicObject> billSet = new HashSet<DynamicObject>(1);
            billSet.add(data);
            Set needUpdateDySet = DraftHelper.updateDratBillCasEntry(billSet, (String)"cas_recbill", (String)"add", (Long)sourCasBillId);
            if (!EmptyUtil.isNoEmpty((Object)needUpdateDySet)) continue;
            SaveServiceHelper.save((DynamicObject[])needUpdateDySet.toArray(new DynamicObject[0]));
        }
    }

    public void genReceivingrec(String sourceBillId, DynamicObject cdmRecBill) {
        try (TXHandle tx = TX.requiresNew();){
            String draftbillno = cdmRecBill.getString("id");
            String draftbillnoStr = cdmRecBill.getString("draftbillno");
            BigDecimal amount = cdmRecBill.getBigDecimal("amount");
            DynamicObject currency = cdmRecBill.getDynamicObject("currency");
            DynamicObject[] recBills = TmcDataServiceHelper.load((String)"cas_recbill", (String)"id,billstatus,settletnumber,draftbill,cas_draftinfo,cas_draftinfo.transamount,cas_draftinfo.recbillcurrency,cas_draftinfo.draftbillinfo", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(sourceBillId))});
            if (null == recBills || recBills.length == 0) {
                return;
            }
            ArrayList<Long> ids = new ArrayList<Long>(recBills.length);
            ArrayList<DynamicObject> casUpdateDyns = new ArrayList<DynamicObject>(recBills.length);
            for (DynamicObject recBill : recBills) {
                if (BillStatusEnum.PAYED.getValue().equals(recBill.getString("billstatus"))) {
                    recBill.set("settletnumber", (Object)draftbillnoStr);
                    DynamicObjectCollection draftBills = recBill.getDynamicObjectCollection("draftbill");
                    if (draftBills.size() > 0) continue;
                    DynamicObject payEntry = draftBills.addNew();
                    payEntry.set("fbasedataid", (Object)cdmRecBill);
                    payEntry.set("fbasedataid_id", cdmRecBill.getPkValue());
                    DynamicObjectCollection draftInfoEntries = recBill.getDynamicObjectCollection("cas_draftinfo");
                    Set draftIdSet = draftInfoEntries.stream().map(draft -> draft.getDynamicObject("draftbillinfo").getPkValue()).collect(Collectors.toSet());
                    if (!draftIdSet.contains(cdmRecBill.getPkValue())) {
                        DynamicObject cas_draftinfo = draftInfoEntries.addNew();
                        cas_draftinfo.set("transamount", (Object)amount);
                        cas_draftinfo.set("recbillcurrency", (Object)currency);
                        cas_draftinfo.set("draftbillinfo", (Object)cdmRecBill);
                    }
                    casUpdateDyns.add(recBill);
                    continue;
                }
                ids.add(recBill.getLong("id"));
            }
            if (casUpdateDyns.size() > 0) {
                logger.info("casUpdateDyns size:" + casUpdateDyns.size());
                SaveServiceHelper.save((DynamicObject[])casUpdateDyns.toArray(new DynamicObject[0]));
            }
            if (ids.size() > 0) {
                OperateOption create = OperateOption.create();
                create.setVariableValue("isfromdraftbill", "y");
                create.setVariableValue("draftbillno", draftbillno);
                create.setVariableValue("draftids", JSON.toJSONString(Collections.singletonList(draftbillno)));
                TmcOperateServiceHelper.execOperate((String)"receivingrec", (String)"cas_recbill", (Object[])ids.toArray(), (OperateOption)create);
            }
        }
    }
}

