/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.tradebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.cdm.common.enums.GuaranteeTradeTypeEnum;
import kd.tmc.cdm.common.enums.PersonnelTypeEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.CreditLimitInfo;
import kd.tmc.fbp.common.model.interest.ReturnCreditLimitInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class GuaranteeAuditService
extends AbstractTmcBizOppService {
    private static Log LOGGER = LogFactory.getLog(GuaranteeAuditService.class);
    private static final String LOG_PREFIX = "[GuaranteeAudit]";
    private static final String SELECT_PROPERTIES = "id,guarantflag,guarantbizdate,guaranttype,guarantortext,guarantcreditlimitorg,guarantcreditlimit,guarantcreditcurrency,guarantcreditamount,unguarantbizdate,guaranteeid";
    private List<DynamicObject> cancelCreditLimitList = new ArrayList<DynamicObject>(10);
    private List<Pair<DynamicObject, DynamicObject>> cancelReturnCreditLimitList = new ArrayList<Pair<DynamicObject, DynamicObject>>(10);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billno");
        selector.add("company");
        selector.add("currency");
        selector.add("creditlimitorg");
        selector.add("creditlimit");
        selector.add("credittype");
        selector.add("drafttype");
        selector.add("name");
        selector.add("credittotalamount");
        selector.add("bizdate");
        selector.add("billentries");
        selector.add("draftbill");
        selector.add("guaranteetype");
        selector.add("biztype");
        selector.add("guarantor");
        selector.add("guarantortext");
        selector.add("creditcurrency");
        selector.add("discountorg");
        selector.add("creditamount");
        selector.add("guaranteeid");
        selector.add("entrycreditamount");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        HashSet draftIdSet = new HashSet(8);
        Arrays.stream(dataEntities).forEach(data -> draftIdSet.addAll(data.getDynamicObjectCollection("billentries").stream().map(draft -> draft.getDynamicObject("draftbill").getPkValue()).collect(Collectors.toSet())));
        DynamicObject[] drafts = TmcDataServiceHelper.load((String)"cdm_draftbillf7", (String)SELECT_PROPERTIES, (QFilter[])new QFilter[]{new QFilter("id", "in", draftIdSet)});
        Map idAndDraftMap = Arrays.stream(drafts).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o, (o1, o2) -> o1, HashMap::new));
        Map<Object, DynamicObject> draftIdAndGuaranteeBillMap = this.getUnGuaranteeDraftReleaseLimitGuaranteeBill(dataEntities);
        HashSet<DynamicObject> updateDraftSet = new HashSet<DynamicObject>(8);
        for (DynamicObject data2 : dataEntities) {
            DynamicObjectCollection entries;
            if (StringUtils.equals((CharSequence)data2.getString("biztype"), (CharSequence)GuaranteeTradeTypeEnum.GUARANTEE.getValue())) {
                LOGGER.info("[GuaranteeAudit]\u5904\u7406\u4fdd\u8d34\u767b\u8bb0\u5ba1\u6838");
                if (EmptyUtil.isEmpty((DynamicObject)data2.getDynamicObject("creditlimit"))) continue;
                try {
                    CreditLimitInfo creditLimitInfo = CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)data2, null, (boolean)false, (Date)data2.getDate("bizdate"));
                    if (!creditLimitInfo.isSuccess()) {
                        LOGGER.error("[GuaranteeAudit]\u4fdd\u8d34\u767b\u8bb0\uff0c\u786e\u8ba4\u5360\u7528\u6388\u4fe1\u5931\u8d25\uff1a{}\uff0c\u5355\u636e\u7f16\u53f7\uff1a{}", (Object)creditLimitInfo.getMessage(), (Object)data2.getString("billno"));
                        throw new TmcBizException(TmcErrorCode.COMMON, (Object[])new String[]{creditLimitInfo.getMessage()});
                    }
                    this.cancelCreditLimitList.add(data2);
                }
                catch (TmcBizException creditLimitInfo) {
                    // empty catch block
                }
                entries = data2.getDynamicObjectCollection("billentries");
                for (DynamicObject e : entries) {
                    DynamicObject guarantor;
                    DynamicObject draft = e.getDynamicObject("draftbill");
                    DynamicObject dbDraft = (DynamicObject)idAndDraftMap.get(draft.getPkValue());
                    if (EmptyUtil.isEmpty((DynamicObject)dbDraft)) {
                        LOGGER.error("[GuaranteeAudit]\u6839\u636e\u5206\u5f55\u7968\u636eid\u67e5\u8be2\u7968\u636e\u4fe1\u606f\u5f02\u5e38\uff0c\u7968\u636eid\uff1a{}", draft.getPkValue());
                        continue;
                    }
                    dbDraft.set("guarantflag", (Object)"1");
                    dbDraft.set("guarantbizdate", (Object)data2.getDate("bizdate"));
                    dbDraft.set("guaranttype", (Object)data2.getString("guaranteetype"));
                    String guaranteeType = data2.getString("guaranteetype");
                    String guarantorText = StringUtils.equals((CharSequence)guaranteeType, (CharSequence)PersonnelTypeEnum.OTHER.getValue()) ? data2.getString("guarantortext") : (EmptyUtil.isNoEmpty((DynamicObject)(guarantor = data2.getDynamicObject("guarantor"))) ? guarantor.getString("name") : null);
                    dbDraft.set("guarantortext", (Object)guarantorText);
                    dbDraft.set("guarantcreditlimitorg", data2.getDynamicObject("discountorg").get("name"));
                    dbDraft.set("guarantcreditlimit", data2.getDynamicObject("creditlimit").get("name"));
                    dbDraft.set("guarantcreditcurrency", data2.getDynamicObject("creditcurrency").getPkValue());
                    dbDraft.set("guarantcreditamount", (Object)e.getBigDecimal("creditamount"));
                    dbDraft.set("guaranteeid", data2.getPkValue());
                    dbDraft.set("unguarantbizdate", null);
                    updateDraftSet.add(dbDraft);
                }
                continue;
            }
            LOGGER.info("[GuaranteeAudit]\u5904\u7406\u89e3\u9664\u4fdd\u8d34\u767b\u8bb0\u5ba1\u6838");
            entries = data2.getDynamicObjectCollection("billentries");
            HashMap<Object, Pair> guaranteeIdAndDyMap = new HashMap<Object, Pair>();
            for (DynamicObject e : entries) {
                Pair pair;
                BigDecimal creditAmount = e.getBigDecimal("entrycreditamount");
                DynamicObject srcBill = draftIdAndGuaranteeBillMap.get(e.getDynamicObject("draftbill").getPkValue());
                if (EmptyUtil.isEmpty((DynamicObject)srcBill)) {
                    LOGGER.error("[GuaranteeAudit]\u89e3\u9664\u4fdd\u8d34\u767b\u8bb0\uff0c\u6839\u636e\u7968\u636eid\u83b7\u53d6\u4fdd\u8d34\u767b\u8bb0\u5355\u5931\u8d25\uff0c\u7968\u636eid\uff1a{}", e.getDynamicObject("draftbill").getPkValue());
                    continue;
                }
                BigDecimal bigDecimal = creditAmount = EmptyUtil.isNoEmpty((BigDecimal)creditAmount) ? creditAmount : BigDecimal.ZERO;
                if (guaranteeIdAndDyMap.containsKey(srcBill.getPkValue())) {
                    pair = (Pair)guaranteeIdAndDyMap.get(srcBill.getPkValue());
                    pair = Pair.of((Object)((BigDecimal)pair.getLeft()).add(creditAmount), (Object)srcBill);
                } else {
                    pair = Pair.of((Object)creditAmount, (Object)srcBill);
                }
                guaranteeIdAndDyMap.put(srcBill.getPkValue(), pair);
                DynamicObject draft = e.getDynamicObject("draftbill");
                DynamicObject dbDraft = (DynamicObject)idAndDraftMap.get(draft.getPkValue());
                if (EmptyUtil.isEmpty((DynamicObject)dbDraft)) continue;
                dbDraft.set("guarantflag", (Object)"0");
                dbDraft.set("guarantbizdate", null);
                dbDraft.set("guaranttype", null);
                dbDraft.set("guarantortext", null);
                dbDraft.set("guarantcreditlimitorg", null);
                dbDraft.set("guarantcreditlimit", null);
                dbDraft.set("guarantcreditcurrency", null);
                dbDraft.set("guarantcreditamount", null);
                dbDraft.set("guaranteeid", null);
                dbDraft.set("unguarantbizdate", (Object)data2.getDate("bizdate"));
                updateDraftSet.add(dbDraft);
            }
            guaranteeIdAndDyMap.forEach((k, v) -> {
                ReturnCreditLimitInfo creditLimitInfo = CreditLimitServiceHelper.returnCreditLimit((DynamicObject)data2, (DynamicObject)((DynamicObject)v.getRight()), (boolean)false, (BigDecimal)((BigDecimal)v.getLeft()), (Long)((Long)data2.getPkValue()), (boolean)false, (Date)data2.getDate("bizdate"));
                if (!creditLimitInfo.isSuccess()) {
                    LOGGER.error("[GuaranteeAudit]\u89e3\u9664\u4fdd\u8d34\u767b\u8bb0\uff0c\u8fd4\u8fd8\u6388\u4fe1\u989d\u5ea6\u5931\u8d25\uff1a{}\uff0c\u6388\u4fe1\u5355\u636eid\uff1a{}\uff0c\u8fd4\u8fd8\u5355\u636eid\uff1a{}\uff0c\u8fd4\u56de\u91d1\u989d\uff1a{}", new Object[]{creditLimitInfo.getMessage(), creditLimitInfo.getBizBillId(), creditLimitInfo.getReturnBillId(), creditLimitInfo.getReturnAmt()});
                    throw new TmcBizException(TmcErrorCode.COMMON, (Object[])new String[]{creditLimitInfo.getMessage()});
                }
                this.cancelReturnCreditLimitList.add((Pair<DynamicObject, DynamicObject>)Pair.of((Object)data2, (Object)v.getRight()));
            });
        }
        TmcDataServiceHelper.save((DynamicObject[])updateDraftSet.toArray(new DynamicObject[0]));
    }

    public void handlerException(DynamicObject[] dataEntities) throws KDException {
        super.handlerException(dataEntities);
        this.cancelCreditLimitList();
        this.cancelReturnCreditLimitList();
    }

    private void cancelCreditLimitList() {
        if (EmptyUtil.isNoEmpty(this.cancelCreditLimitList)) {
            this.cancelCreditLimitList.forEach(data -> {
                CreditLimitInfo creditLimitInfo = CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)data, null, (boolean)false);
                boolean result = creditLimitInfo.isSuccess();
                if (!result) {
                    LOGGER.error("[GuaranteeAudit]\u4fdd\u8d34\u767b\u8bb0\uff0c\u786e\u8ba4\u5360\u7528\u6388\u4fe1\u6210\u529f\u540e\u7531\u4e8e\u5f02\u5e38\u8fdb\u884c\u8865\u507f\uff0c\u53d6\u6d88\u5360\u7528\uff08\u6388\u4fe1\u91ca\u653e\uff09\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}\uff0c\u5355\u636e\u7f16\u53f7\uff1a{}", (Object)creditLimitInfo.getMessage(), (Object)data.getString("billno"));
                }
            });
        }
    }

    private void cancelReturnCreditLimitList() {
        if (EmptyUtil.isNoEmpty(this.cancelReturnCreditLimitList)) {
            this.cancelReturnCreditLimitList.forEach(pair -> {
                ReturnCreditLimitInfo creditLimitInfo = CreditLimitServiceHelper.cancelReturnCreditLimit((DynamicObject)((DynamicObject)pair.getLeft()), (DynamicObject)((DynamicObject)pair.getRight()), (boolean)false, null, (Long)((Long)((DynamicObject)pair.getLeft()).getPkValue()));
                boolean result = creditLimitInfo.isSuccess();
                if (!result) {
                    LOGGER.error("[GuaranteeAudit]\u89e3\u9664\u4fdd\u8d34\u767b\u8bb0\uff0c\u6388\u4fe1\u8fd4\u8fd8\u540e\u7531\u4e8e\u5f02\u5e38\u8fdb\u884c\u8865\u507f\uff0c\u53d6\u6d88\u6388\u4fe1\u8fd4\u8fd8\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}\uff0c\u5355\u636e\u7f16\u53f7\uff1a{}", (Object)creditLimitInfo.getMessage(), (Object)((DynamicObject)pair.getLeft()).getString("billno"));
                }
            });
        }
    }

    private Map<Object, DynamicObject> getUnGuaranteeDraftReleaseLimitGuaranteeBill(DynamicObject[] dataEntities) {
        HashMap<Object, DynamicObject> draftIdAndGuaranteeBillMap = new HashMap<Object, DynamicObject>(8);
        HashMap<Object, Object> draftIdAndGuaranteeIdMap = new HashMap<Object, Object>(8);
        Arrays.stream(dataEntities).filter(data -> StringUtils.equals((CharSequence)data.getString("biztype"), (CharSequence)GuaranteeTradeTypeEnum.UN_GUARANTEE.getValue())).forEach(data -> data.getDynamicObjectCollection("billentries").forEach(e -> draftIdAndGuaranteeIdMap.put(e.getDynamicObject("draftbill").getPkValue(), e.getLong("guaranteeid"))));
        if (EmptyUtil.isEmpty(draftIdAndGuaranteeIdMap)) {
            return draftIdAndGuaranteeBillMap;
        }
        HashSet guaranteeIdSet = new HashSet(draftIdAndGuaranteeIdMap.values());
        Object[] guaranteeBills = TmcDataServiceHelper.load((Object[])guaranteeIdSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cdm_guarantee_discount"));
        if (EmptyUtil.isNoEmpty((Object[])guaranteeBills)) {
            Map<Object, DynamicObject> dataMap = Arrays.stream(guaranteeBills).collect(Collectors.toMap(DataEntityBase::getPkValue, v -> v));
            draftIdAndGuaranteeIdMap.forEach((k, v) -> draftIdAndGuaranteeBillMap.put(k, (DynamicObject)dataMap.get(v)));
        }
        return draftIdAndGuaranteeBillMap;
    }
}

