/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.tradebill;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.cdm.common.helper.BotpHelper;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TradeBillBuildBotpReleationService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(TradeBillBuildBotpReleationService.class);
    private String type = "";

    public TradeBillBuildBotpReleationService(String typeStr) {
        this.type = typeStr;
    }

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("tradetype");
        selector.add("entrys");
        selector.add("draftbill");
        selector.add("recbody");
        selector.add("recbodyname");
        selector.add("payeetype");
        selector.add("beendorsor");
        selector.add("description");
        selector.add("oldstatus");
        selector.add("company");
        selector.add("drafttype");
        selector.add("payeetypetext");
        selector.add("beendorsortext");
        selector.add("currency");
        selector.add("bizdate");
        selector.add("amount");
        selector.add("exchangerate");
        selector.add("locamt");
        selector.add("billno");
        selector.add("createtime");
        selector.add("allocbillentryid");
        selector.add("source");
        selector.add("sourcebillid");
        selector.add("deposit");
        selector.add("isgenbysplit");
        selector.add("allbillsamount");
        selector.add("billamt");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        for (DynamicObject tradeBill : dynamicObjects) {
            String sourcebillidStr = tradeBill.getString("sourcebillid");
            Long billId = tradeBill.getLong("id");
            String source = tradeBill.getString("source");
            logger.info("bill is will BuildBotpReleation bill:" + billId + ",sourcebillidStr is:" + sourcebillidStr + ",source is:" + source + ", type is:" + this.type);
            ArrayList<Long> tradeBillIdList = new ArrayList<Long>(8);
            tradeBillIdList.add(billId);
            if (!EmptyUtil.isNoEmpty((String)sourcebillidStr) || !EmptyUtil.isNoEmpty((String)this.type)) continue;
            long sourcebillid = Long.parseLong(sourcebillidStr);
            if ("add".equals(this.type)) {
                BotpHelper.saveRelation((String)"cas_paybill", (Long)sourcebillid, (String)"cdm_drafttradebill", tradeBillIdList);
                continue;
            }
            if (!"delete".equals(this.type)) continue;
            String billIdStr = tradeBill.getString("id");
            DraftHelper.deleteRation((String)sourcebillidStr, (String)billIdStr);
        }
    }
}

