/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.tradebill;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.tmc.cdm.business.lock.DraftOperateInfo;
import kd.tmc.cdm.business.lock.DraftOperateResultInfo;
import kd.tmc.cdm.business.lock.IDraftOperateService;
import kd.tmc.cdm.business.opservice.tradebill.TradeBillAuditService;
import kd.tmc.cdm.business.service.LockDraftHelper;
import kd.tmc.cdm.common.enums.DraftBillStatusEnum;
import kd.tmc.cdm.common.enums.DraftTradeTypeEnum;
import kd.tmc.cdm.common.enums.EleDraftNoteStatusEnum;
import kd.tmc.cdm.common.enums.OperateTypeEnum;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.cdm.common.helper.TradeBillHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.bean.TransBillUpdatePaidInfo;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.model.interest.ReturnCreditLimitInfo;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TradeBillCancelDrawService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(TradeBillAuditService.class);
    private static final List<String> TRADTYPES = Arrays.asList(DraftTradeTypeEnum.ENDORSE.getValue(), DraftTradeTypeEnum.PLEDGE.getValue(), DraftTradeTypeEnum.DISCOUNT.getValue(), DraftTradeTypeEnum.COLLECT.getValue(), DraftTradeTypeEnum.RLSPLEDGE.getValue());
    public static final String BILLTYPE = "draw";
    public static final String LOGOPTYPE = OperateTypeEnum.CANCEL.getValue();
    private List<String> successLockDraftIdList = new ArrayList<String>(8);
    private Set<Long> drawFailBillIdSet = new HashSet<Long>(8);
    private List<DynamicObject> successCancelReturnCreditLimitMapList = new ArrayList<DynamicObject>();
    private final List<String> TRADELIST = Arrays.asList(DraftTradeTypeEnum.PLEDGE.getValue(), DraftTradeTypeEnum.ENDORSE.getValue(), DraftTradeTypeEnum.RLSPLEDGE.getValue(), DraftTradeTypeEnum.DISCOUNT.getValue(), DraftTradeTypeEnum.COLLECT.getValue());

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entrys");
        selector.add("draftbill");
        selector.add("tradetype");
        selector.add("oldstatus");
        selector.add("electag");
        selector.add("sourcebillid");
        selector.add("pledgeenddate");
        selector.add("company");
        selector.add("depositdeduct");
        selector.add("deductamount");
        selector.add("drafttype");
        selector.add("isrepay");
        selector.add("bizfinishdate");
        selector.add("billlogid");
        selector.add("isneedsplit");
        selector.add("billamt");
        selector.add("isequalsplit");
        selector.add("transtatus");
        selector.add("isrejectrefundgen");
        selector.add("subentrys");
        selector.add("e_subbillamount");
        selector.add("pledgeetype");
        selector.add("pledgeetext");
        selector.add("pledgeebase");
        selector.add("pledgeeaccounttext");
        selector.add("pledgeeaccount");
        selector.add("pledgeeopenbank");
        selector.add("pledgeetypebase");
        selector.add("source");
        selector.add("entryisrepay");
        selector.add("entryisrejectrefund");
        selector.add("billlogid");
        selector.add("isdrawfail");
        return selector;
    }

    public TradeBillCancelDrawService(List<String> lockDraftIdList) {
        this.successLockDraftIdList = lockDraftIdList;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        block53: {
            logger.info("TradeBillDrawBillService is start dataEntities:" + dataEntities[0].getString("billno"));
            boolean isFromRejectRefundGenDelete = Boolean.parseBoolean(this.operationVariable.getOrDefault("rejectRefundGenDelete", "false"));
            Map draftId2TradeBillMap = TradeBillHelper.getDraftId2TradeBillMap((DynamicObject[])dataEntities);
            DynamicObject[] draftArr = TradeBillHelper.getDraftArrByTradeBillArr((DynamicObject[])dataEntities);
            Map<Long, DynamicObject> idAndbillMap = Arrays.stream(draftArr).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
            ArrayList<String> rlspledgeBillIds = new ArrayList<String>();
            ArrayList<Long> rlspledgeEntryIds = new ArrayList<Long>();
            HashSet ids = new HashSet(10);
            HashSet recBIllSet = new HashSet(10);
            HashSet payBIllSet = new HashSet(10);
            HashSet botpGmPledgeMap = new HashSet();
            ArrayList<DynamicObject> needUpdateDyns = new ArrayList<DynamicObject>(8);
            for (DynamicObject data : dataEntities) {
                Object[] elePayDealArr;
                DynamicObjectCollection entrys;
                this.updateBillEqualInfo(data);
                boolean isDrawFail = data.getBoolean("isdrawfail");
                if (isDrawFail) {
                    data.set("isdrawfail", (Object)false);
                    data.set("draftbilltranstatus", null);
                    data.set("bizfinishdate", null);
                    entrys = data.getDynamicObjectCollection("entrys");
                    for (DynamicObject entry : entrys) {
                        entry.set("transtatus", null);
                    }
                    this.drawFailBillIdSet.add(data.getLong("id"));
                    continue;
                }
                if (!isFromRejectRefundGenDelete) {
                    data.set("draftbilltranstatus", null);
                    data.set("electag", (Object)"0");
                }
                entrys = data.getDynamicObjectCollection("entrys");
                DynamicObject[] draftsArr = TradeBillHelper.getDraftArrByTradeBillArr((DynamicObject[])new DynamicObject[]{data});
                HashSet<String> needDealPayOffBillSet = new HashSet<String>(16);
                HashSet<Long> needDealCollectBillSet = new HashSet<Long>(16);
                for (Object[] entry : entrys) {
                    if (isFromRejectRefundGenDelete && (entry.getBoolean("entryisrejectrefund") || entry.getBoolean("entryisrepay"))) continue;
                    DynamicObject draft = entry.getDynamicObject("draftbill");
                    DynamicObject newDraft = idAndbillMap.get(draft.getLong("id"));
                    this.setDraftBillInfo(draftId2TradeBillMap, rlspledgeBillIds, rlspledgeEntryIds, newDraft, needDealPayOffBillSet, needDealCollectBillSet);
                }
                this.rlsPledgeFillDate(draftsArr, rlspledgeBillIds, rlspledgeEntryIds);
                if (EmptyUtil.isNoEmpty(rlspledgeEntryIds)) {
                    TmcDataServiceHelper.save((DynamicObject[])draftsArr);
                } else {
                    TmcDataServiceHelper.save((DynamicObject[])draftArr);
                }
                if (EmptyUtil.isNoEmpty(needDealPayOffBillSet) && EmptyUtil.isNoEmpty((Object[])(elePayDealArr = BusinessDataServiceHelper.load((String)"cdm_electronic_pay_deal", (String)"id,notestatus,billno,cirstatus", (QFilter[])new QFilter[]{new QFilter("billno", "in", needDealPayOffBillSet)})))) {
                    logger.info("needDealPayOffBillSet is start");
                    for (Object elePayDeal : elePayDealArr) {
                        elePayDeal.set("notestatus", (Object)EleDraftNoteStatusEnum.CS03.getValue());
                    }
                    SaveServiceHelper.save((DynamicObject[])elePayDealArr);
                }
                if (EmptyUtil.isNoEmpty(needDealCollectBillSet)) {
                    logger.info("needDealCollectBillSet is start");
                    Object[] eleRecDealArr = BusinessDataServiceHelper.load((String)"cdm_electronic_sign_deal", (String)"id,notestatus,billno,cirstatus,subrange,rptype", (QFilter[])new QFilter[]{new QFilter("sourceid", "in", needDealCollectBillSet), new QFilter("rptype", "=", (Object)"receivebill")});
                    if (EmptyUtil.isNoEmpty((Object[])eleRecDealArr)) {
                        for (Object eleRecDeal : eleRecDealArr) {
                            eleRecDeal.set("notestatus", (Object)EleDraftNoteStatusEnum.CS03.getValue());
                        }
                        SaveServiceHelper.save((DynamicObject[])eleRecDealArr);
                    }
                }
                this.deleteCasBill(new DynamicObject[]{data});
                Map botpMap = BFTrackerServiceHelper.findTargetBills((String)"cdm_drafttradebill", (Long[])new Long[]{data.getLong("id")});
                HashSet pkValues = (HashSet)botpMap.get("cdm_receivablebill");
                HashSet payBillValues = (HashSet)botpMap.get("cdm_payablebill");
                String tradeType = data.getString("tradetype");
                long companyId = data.getDynamicObject("company").getLong("id");
                boolean isReceiveOppNote = DraftHelper.getCdmParameterBoolean((long)companyId, (String)"isautogenpledge");
                if (DraftTradeTypeEnum.PAYOFF.getValue().equals(tradeType)) {
                    DynamicObjectCollection ifmDeductionColl;
                    Set draftIdSet;
                    List suretyIds;
                    boolean isDeductPosit = data.getBoolean("depositdeduct");
                    if (isDeductPosit) {
                        QFilter qFilter = new QFilter("repaybillid", "=", data.getPkValue()).and("repaybilltype", "=", (Object)data.getDataEntityType().getName());
                        DynamicObjectCollection suretyReleases = QueryServiceHelper.query((String)"fbd_suretyreleasebill", (String)"id", (QFilter[])new QFilter[]{qFilter});
                        logger.info("\u53cd\u5ba1\u6838\uff0c\u5220\u9664\u4e0b\u6e38\u4fdd\u8bc1\u91d1\u5b58\u51fa\u5355\uff1asuretyReleases:" + suretyReleases.size() + "," + data.getLong("id"));
                        if (!EmptyUtil.isEmpty((DynamicObjectCollection)suretyReleases)) {
                            OperateOption operateOption = OperateOption.create();
                            operateOption.setVariableValue("debitType", data.getDataEntityType().getName());
                            suretyIds = suretyReleases.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
                            OperationResult deleteResult = TmcOperateServiceHelper.execOperate((String)"cancelsuretyrepay", (String)"fbd_suretyreleasebill", (Object[])suretyIds.toArray(), (OperateOption)operateOption);
                            if (deleteResult.isSuccess()) {
                                this.writeBackSuretyInput(data);
                            } else {
                                logger.error(String.format("\u4e0b\u6e38\u4fdd\u8bc1\u91d1\u5b58\u51fa\u5355\u636e\u5220\u9664\u5931\u8d25: [%s], ", data.getLong("id")));
                            }
                        }
                    }
                    if (EmptyUtil.isNoEmpty(draftIdSet = entrys.stream().filter(e -> EmptyUtil.isNoEmpty((DynamicObject)e.getDynamicObject("draftbill").getDynamicObject("inneraccount")) && EmptyUtil.isNoEmpty((Long)e.getDynamicObject("draftbill").getDynamicObject("inneraccount").getLong("id"))).map(item -> item.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toSet())) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(ifmDeductionColl = QueryServiceHelper.query((String)"ifm_deduction", (String)"id", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)data.getLong("id"))})))) {
                        ArrayList infos = new ArrayList(8);
                        for (DynamicObject ifmDeduction : ifmDeductionColl) {
                            TransBillUpdatePaidInfo info = new TransBillUpdatePaidInfo();
                            info.setTransBillId(Long.valueOf(ifmDeduction.getLong("id")));
                            infos.add(info);
                        }
                        suretyIds = DispatchServiceHelper.invokeBizService((String)"tmc", (String)"ifm", (String)"deductionReserveService", (String)"reserveDeduction", (Object[])new Object[]{infos});
                    }
                }
                if (DraftTradeTypeEnum.PLEDGE.getValue().equals(tradeType) && null != botpMap.get("gm_pledgebill") && isReceiveOppNote) {
                    botpGmPledgeMap.addAll((Collection)botpMap.get("gm_pledgebill"));
                }
                if (null != pkValues && pkValues.size() > 0) {
                    if (DraftTradeTypeEnum.BILLSPLIT.getValue().equals(tradeType)) {
                        recBIllSet.addAll(pkValues);
                    } else {
                        ids.addAll(pkValues);
                    }
                }
                if (null != payBillValues && payBillValues.size() > 0 && DraftTradeTypeEnum.BILLSPLIT.getValue().equals(tradeType)) {
                    payBIllSet.addAll(payBillValues);
                }
                String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
                boolean isSucWriteBack = (Boolean)SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)data.getLong("company.id"), (String)"issucwriteback");
                this.writePayStatus(data, idAndbillMap, isSucWriteBack);
                String draftType = data.getString("tradetype");
                data.set("bizfinishdate", null);
                for (DynamicObject entry : entrys) {
                    DynamicObject draft;
                    DynamicObjectCollection dynamicObjectCollection;
                    if ((DraftTradeTypeEnum.ENDORSE.getValue().equals(draftType) || DraftTradeTypeEnum.DISCOUNT.getValue().equals(draftType) || DraftTradeTypeEnum.PLEDGE.getValue().equals(draftType)) && (dynamicObjectCollection = (draft = TmcDataServiceHelper.loadSingle((Object)entry.getDynamicObject("draftbill").getLong("id"), (String)"cdm_receivablebill")).getDynamicObjectCollection("endorseentry")).size() > 0) {
                        dynamicObjectCollection.remove(dynamicObjectCollection.size() - 1);
                        needUpdateDyns.add(draft);
                    }
                    if (isFromRejectRefundGenDelete) continue;
                    entry.set("transtatus", null);
                }
                if (!DraftTradeTypeEnum.REFUND.getValue().equals(tradeType)) continue;
                Long draftTradeBillId = data.getLong("id");
                List paybillIds = new ArrayList(8);
                boolean isrejectrefundgen = data.getBoolean("isrejectrefundgen");
                if (isrejectrefundgen && EmptyUtil.isNoEmpty((Long)draftTradeBillId)) {
                    HashSet payBillIds;
                    Map sourceBillsMap = BFTrackerServiceHelper.findSourceBills((String)"cdm_drafttradebill", (Long[])new Long[]{draftTradeBillId});
                    if (EmptyUtil.isNoEmpty((Object)sourceBillsMap) && EmptyUtil.isNoEmpty((Object)(payBillIds = (HashSet)sourceBillsMap.get("cas_paybill")))) {
                        paybillIds.addAll(payBillIds);
                    }
                } else {
                    Long draftBillId = ((DynamicObject)data.getDynamicObjectCollection("entrys").get(0)).getDynamicObject("draftbill").getLong("id");
                    paybillIds = DraftHelper.getBillIds((Long)draftBillId, (boolean)true, (String)"cas_paybill");
                }
                if (!EmptyUtil.isNoEmpty(paybillIds)) continue;
                Long casPayBillId = (Long)paybillIds.get(0);
                Set draftIdSet = data.getDynamicObjectCollection("entrys").stream().map(e -> e.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toSet());
                DynamicObject needUpdateBill = DraftHelper.updateCasEntryIsRefuse(draftIdSet, (Long)casPayBillId, (String)"0");
                if (!EmptyUtil.isNoEmpty((DynamicObject)needUpdateBill)) continue;
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{needUpdateBill});
            }
            if (EmptyUtil.isNoEmpty(needUpdateDyns)) {
                TmcDataServiceHelper.save((DynamicObject[])needUpdateDyns.toArray(new DynamicObject[0]));
            }
            if (null != ids && ids.size() > 0) {
                TmcOperateServiceHelper.execOperate((String)"delete", (String)"cdm_receivablebill", (Object[])ids.toArray(), (OperateOption)OperateOption.create());
            }
            if (recBIllSet.size() > 0) {
                QFilter qFilterId = new QFilter("id", "in", recBIllSet);
                QFilter qFilterIsFrom = new QFilter("isfromequalspilt", "=", (Object)Character.valueOf('1'));
                QFilter qFilterEqualType = new QFilter("euqaldifferetype", "=", (Object)"pledge").and(new QFilter("isequalbill", "=", (Object)Character.valueOf('1')));
                QFilter qFilterEqualbill = new QFilter("isequalbill", "=", (Object)Character.valueOf('0')).or(qFilterEqualType);
                Object[] recBills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,isequalbill,sourcebillid,amount", (QFilter[])new QFilter[]{qFilterId, qFilterIsFrom, qFilterEqualbill});
                if (EmptyUtil.isNoEmpty((Object[])recBills)) {
                    Set differeBills = Arrays.stream(recBills).map(x -> x.getLong("sourcebillid")).collect(Collectors.toSet());
                    Set recBillIds = Arrays.stream(recBills).map(x -> x.getLong("id")).collect(Collectors.toSet());
                    QFilter qFilterEleBillId = new QFilter("id", "in", differeBills);
                    QFilter qFilterSourceId = new QFilter("sourceid", "in", recBillIds);
                    Object[] eleBills = BusinessDataServiceHelper.load((String)"cdm_electronic_rec_deal", (String)"id,sourceid", (QFilter[])new QFilter[]{qFilterEleBillId, qFilterSourceId});
                    logger.info("eleBills is null:" + EmptyUtil.isNoEmpty((Object[])eleBills));
                    if (EmptyUtil.isNoEmpty((Object[])eleBills)) {
                        Map<Long, Long> eleIdAndBillIdMap = Arrays.stream(eleBills).collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getLong("sourceid")));
                        HashSet<Long> needDeleteEleBillSet = new HashSet<Long>();
                        for (Object recBill : recBills) {
                            long eleBillId = recBill.getLong("sourcebillid");
                            long billId = recBill.getLong("id");
                            Long billIdInMap = eleIdAndBillIdMap.get(eleBillId);
                            if (!EmptyUtil.isNoEmpty((Long)billIdInMap) || billIdInMap != billId) continue;
                            needDeleteEleBillSet.add(eleBillId);
                        }
                        if (EmptyUtil.isNoEmpty(needDeleteEleBillSet)) {
                            logger.info("needDeleteEleBillSet is:" + SerializationUtils.toJsonString(needDeleteEleBillSet));
                            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"cdm_electronic_rec_deal"), (Object[])needDeleteEleBillSet.toArray());
                        }
                    }
                }
                TmcOperateServiceHelper.execOperate((String)"deletesplitbill", (String)"cdm_receivablebill", (Object[])recBIllSet.toArray(), (OperateOption)OperateOption.create());
            }
            if (payBIllSet.size() > 0) {
                TmcOperateServiceHelper.execOperate((String)"deletesplitbill", (String)"cdm_payablebill", (Object[])payBIllSet.toArray(), (OperateOption)OperateOption.create());
            }
            TmcDataServiceHelper.save((DynamicObject[])dataEntities);
            try {
                if (CollectionUtils.isEmpty(botpGmPledgeMap)) break block53;
                try (TXHandle tx = TX.requiresNew();){
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("cdm_drafttradebill_ignore", "1");
                    OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"delete", (String)"gm_pledgebill", (Object[])botpGmPledgeMap.toArray(), (OperateOption)option, (boolean)true);
                    if (operationResult.isSuccess()) {
                        logger.info("is success" + operationResult.getSuccessPkIds());
                    } else {
                        logger.info("is error" + operationResult.getSuccessPkIds());
                    }
                }
            }
            catch (Exception e2) {
                logger.info("delete e is:" + e2);
            }
        }
        this.fillDraftBillFinshDate(dataEntities);
    }

    private void writeBackSuretyInput(DynamicObject data) {
        List draftBillIds = data.getDynamicObjectCollection("entrys").stream().map(row -> row.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toList());
        QFilter idFilter = new QFilter("id", "in", draftBillIds);
        Object[] payableBills = TmcDataServiceHelper.load((String)"cdm_payablebill", (String)"id,draftbillno,suretymoney,suretyinput", (QFilter[])new QFilter[]{idFilter});
        Arrays.stream(payableBills).forEach(v -> v.set("suretyinput", (Object)true));
        if (!EmptyUtil.isEmpty((Object[])payableBills)) {
            SaveServiceHelper.save((DynamicObject[])payableBills);
        }
    }

    private void updateBillEqualInfo(DynamicObject newDataEntitie) {
        IDraftOperateService instance = IDraftOperateService.getInstance();
        boolean formEleUpdate = Boolean.parseBoolean(this.operationVariable.getOrDefault("COMPLETEFROM_ELEUPDATE", "false"));
        boolean isFromRejectRefundGenDelete = Boolean.parseBoolean(this.operationVariable.getOrDefault("rejectRefundGenDelete", "false"));
        if (isFromRejectRefundGenDelete) {
            DraftOperateInfo draftOperateInfo = LockDraftHelper.fillOperateInfoForRejectRefund(formEleUpdate, newDataEntitie);
            if (draftOperateInfo.getDraftOperateSubInfoList().size() > 0) {
                draftOperateInfo.setDrawfail(newDataEntitie.getBoolean("isdrawfail"));
                logger.info("\u5220\u9664\u62d2\u6536\u9000\u7968\u751f\u6210\u7684\u4e1a\u52a1\u5904\u7406\u5355\u53d6\u6d88\u5b8c\u6210\uff0c\u9700\u8981\u8c03\u7528\u53d6\u6d88\u5b8c\u6210\u63a5\u53e3\u7684\u6570\u91cf\uff1a{}", (Object)draftOperateInfo.getDraftOperateSubInfoList().size());
                List<DraftOperateResultInfo> cancelResult = instance.cancel(draftOperateInfo);
                this.fillBillLogId(newDataEntitie, cancelResult);
            }
        } else {
            DraftOperateInfo draftOperateInfo = LockDraftHelper.fillOperateInfo(formEleUpdate, newDataEntitie, 0L, false);
            draftOperateInfo.setDraftBillIdFromEle(0L);
            draftOperateInfo.setTradeBillId(newDataEntitie.getLong("id"));
            draftOperateInfo.setDrawfail(newDataEntitie.getBoolean("isdrawfail"));
            List<DraftOperateResultInfo> cancelResult = instance.cancel(draftOperateInfo);
            this.fillBillLogId(newDataEntitie, cancelResult);
        }
    }

    private void fillBillLogId(DynamicObject data, List<DraftOperateResultInfo> draftOperateResultInfoList) {
        Map<Long, Long> draftIdAndLogIdMap = draftOperateResultInfoList.stream().collect(Collectors.toMap(e -> e.getDraftId(), e -> e.getLogid()));
        DynamicObjectCollection dynamicObjectCollection = data.getDynamicObjectCollection("entrys");
        for (DynamicObject entry : dynamicObjectCollection) {
            Long logIdFromNewAdd;
            long draftId = entry.getDynamicObject("draftbill").getLong("id");
            long logId = entry.getLong("billlogid");
            if (!EmptyUtil.isEmpty((Long)logId) || !EmptyUtil.isNoEmpty(draftIdAndLogIdMap) || !EmptyUtil.isNoEmpty((Long)(logIdFromNewAdd = draftIdAndLogIdMap.get(draftId)))) continue;
            entry.set("billlogid", (Object)logIdFromNewAdd);
        }
    }

    private void setDraftBillInfo(Map<Object, DynamicObject> draftId2TradeBillMap, List<String> rlspledgeBillIds, List<Long> rlspledgeEntryIds, DynamicObject draft, Set<String> needDealPayOffBillSet, Set<Long> needDealCollectBillSet) {
        DynamicObject tradeBill = draftId2TradeBillMap.get(draft.getPkValue());
        String tradeType = tradeBill.getString("tradetype");
        String billmediumStr = tradeBill.getDynamicObject("drafttype").getString("billmedium");
        if (!"payinterest".equals(tradeType)) {
            draft.set("pledgeenddate", null);
        } else {
            draft.set("ispayinterest", (Object)"0");
        }
        tradeBill.getDynamicObjectCollection("entrys").stream().filter(o -> o.getDynamicObject("draftbill").getPkValue().equals(draft.getPkValue())).findFirst().ifPresent(o -> {
            if (DraftTradeTypeEnum.COLLECT.getValue().equals(tradeType) && DraftBillStatusEnum.PLEDGED.getValue().equals(o.getString("oldstatus"))) {
                draft.set("draftbillstatus", (Object)DraftBillStatusEnum.REGISTERED.getValue());
            } else {
                draft.set("draftbillstatus", (Object)o.getString("oldstatus"));
            }
            draft.set("beendorsor", null);
            draft.set("recbody", null);
            draft.set("use", null);
            if ("2".equals(billmediumStr) && this.TRADELIST.contains(tradeType)) {
                draft.set("eledraftstatus", null);
            }
        });
        if (DraftTradeTypeEnum.PAYOFF.getValue().equals(tradeType)) {
            DynamicObject payableBill = TmcDataServiceHelper.loadSingle((Object)draft.getPkValue(), (String)"cdm_payablebill");
            DynamicObject creditLimit = payableBill.getDynamicObject("creditlimit");
            if (creditLimit != null) {
                this.cancelReturnCreditLimit(payableBill);
            }
            draft.set("eledraftstatusnew", (Object)EleDraftNoteStatusEnum.CS03.getValue());
            needDealPayOffBillSet.add(draft.getString("draftbillno"));
        } else if (DraftTradeTypeEnum.REFUND.getValue().equals(tradeType)) {
            draft.set("isrefund", (Object)"0");
            draft.set("refunddesc", (Object)"");
        } else if (DraftTradeTypeEnum.ENDORSE.getValue().equals(tradeType) && EmptyUtil.isNotBlank((CharSequence)draft.getString("refunddesc"))) {
            draft.set("isrefund", (Object)"1");
        } else if (DraftTradeTypeEnum.RLSPLEDGE.getValue().equals(tradeType)) {
            String elccirculatestatus;
            rlspledgeBillIds.add(draft.getString("draftbillno"));
            rlspledgeEntryIds.add(draft.getLong("id"));
            if ("2".equals(draft.getDynamicObject("draftbilltype").getString("billmedium")) && EmptyUtil.isNoEmpty((String)(elccirculatestatus = draft.getString("elccirculatestatus")))) {
                draft.set("elccirculatestatus", (Object)"TF0304");
            }
        } else if (DraftTradeTypeEnum.PLEDGE.getValue().equals(tradeType)) {
            draft.set("pledgeetype", null);
            draft.set("pledgeetext", null);
            draft.set("pledgeetypebase", null);
            draft.set("pledgeebase", null);
            draft.set("pledgeeaccounttext", null);
            draft.set("pledgeeaccount", null);
            draft.set("pledgeeopenbank", null);
        } else if (DraftTradeTypeEnum.COLLECT.getValue().equals(tradeType)) {
            draft.set("eledraftstatusnew", (Object)EleDraftNoteStatusEnum.CS03.getValue());
            needDealCollectBillSet.add(draft.getLong("id"));
        }
    }

    private void fillDraftBillFinshDate(DynamicObject[] dataEntities) {
        if (EmptyUtil.isEmpty((Object[])dataEntities)) {
            return;
        }
        HashSet<Long> payids = new HashSet<Long>();
        HashSet<Long> recids = new HashSet<Long>();
        for (DynamicObject drafttradbill : dataEntities) {
            if (this.drawFailBillIdSet.contains(drafttradbill.getLong("id"))) continue;
            String tradeType = drafttradbill.getString("tradetype");
            DynamicObjectCollection entrys = drafttradbill.getDynamicObjectCollection("entrys");
            if (TRADTYPES.contains(tradeType)) {
                for (DynamicObject entry : entrys) {
                    long recid = entry.getDynamicObject("draftbill").getLong("id");
                    recids.add(recid);
                }
                continue;
            }
            if (!Objects.equals(DraftTradeTypeEnum.PAYOFF.getValue(), tradeType)) continue;
            for (DynamicObject entry : entrys) {
                long payid = entry.getDynamicObject("draftbill").getLong("id");
                payids.add(payid);
            }
        }
        DynamicObject[] paydynamicObjects = new DynamicObject[payids.size()];
        DynamicObject[] recdynamicObjects = new DynamicObject[recids.size()];
        if (recids != null && recids.size() > 0) {
            QFilter recqFilter = new QFilter("id", "in", (Object)recids.toArray(new Long[0]));
            recdynamicObjects = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,bizfinishdate", (QFilter[])new QFilter[]{recqFilter});
        }
        if (payids != null && payids.size() > 0) {
            QFilter qFilter = new QFilter("id", "in", (Object)payids.toArray(new Long[0]));
            paydynamicObjects = BusinessDataServiceHelper.load((String)"cdm_payablebill", (String)"id,bizfinishdate", (QFilter[])new QFilter[]{qFilter});
        }
        if (paydynamicObjects != null && paydynamicObjects.length > 0) {
            for (DynamicObject paybill : paydynamicObjects) {
                paybill.set("bizfinishdate", null);
            }
        }
        if (recdynamicObjects != null && recdynamicObjects.length > 0) {
            for (DynamicObject recbill : recdynamicObjects) {
                recbill.set("bizfinishdate", null);
            }
        }
        if (paydynamicObjects != null && paydynamicObjects.length > 0) {
            TmcDataServiceHelper.save((DynamicObject[])paydynamicObjects);
        }
        if (recdynamicObjects != null && recdynamicObjects.length > 0) {
            TmcDataServiceHelper.save((DynamicObject[])recdynamicObjects);
        }
        logger.info("\u786e\u8ba4\u5b8c\u6210\u56de\u586b\u7968\u636e\u4e1a\u52a1\u5904\u7406\u5b8c\u6210\u65e5\u671f\u6210\u529f!");
    }

    private void rlsPledgeFillDate(DynamicObject[] draftArr, List<String> rlspledgeBillIds, List<Long> rlspledgeEntryIds) {
        logger.info("rlsPledgeFillDate is start");
        if (!EmptyUtil.isEmpty(rlspledgeBillIds)) {
            try {
                QFilter qFilter1 = new QFilter("entrys.draftbill", "in", rlspledgeEntryIds);
                QFilter qFilter2 = new QFilter("tradetype", "=", (Object)"pledge");
                String selectFields = "pledgeenddate,pledgeetype,pledgeetext,pledgeetypebase,pledgeebase,pledgeeaccounttext,pledgeeaccount,pledgeeopenbank,entrys.draftbill";
                DynamicObjectCollection pledgebillArr = QueryServiceHelper.query((String)"cdm_drafttradebill", (String)selectFields, (QFilter[])new QFilter[]{qFilter1, qFilter2});
                HashMap<String, DynamicObject> pledgeMap = new HashMap<String, DynamicObject>();
                for (DynamicObject pledge : pledgebillArr) {
                    pledgeMap.put(pledge.getString("entrys.draftbill"), pledge);
                }
                for (DynamicObject draft : draftArr) {
                    if (null == pledgeMap.get(draft.getPkValue().toString())) continue;
                    draft.set("draftbillstatus", (Object)DraftBillStatusEnum.PLEDGED.getValue());
                    DynamicObject pledge = (DynamicObject)pledgeMap.get(draft.getPkValue().toString());
                    Date expireDate = draft.getDate("draftbillexpiredate");
                    Date pledgeEndDate = pledge.getDate("pledgeenddate");
                    if (EmptyUtil.isNoEmpty((Object)expireDate) && EmptyUtil.isNoEmpty((Object)pledgeEndDate) && pledgeEndDate.compareTo(expireDate) > 0) {
                        draft.set("pledgeenddate", (Object)expireDate);
                    } else {
                        draft.set("pledgeenddate", (Object)pledgeEndDate);
                    }
                    draft.set("pledgeetype", (Object)pledge.getString("pledgeetype"));
                    draft.set("pledgeetext", (Object)pledge.getString("pledgeetext"));
                    draft.set("pledgeetypebase", (Object)pledge.getString("pledgeetypebase"));
                    draft.set("pledgeebase", pledge.get("pledgeebase"));
                    draft.set("pledgeeaccounttext", (Object)pledge.getString("pledgeeaccounttext"));
                    draft.set("pledgeeaccount", pledge.get("pledgeeaccount"));
                    draft.set("pledgeeopenbank", pledge.get("pledgeeopenbank"));
                }
                logger.info("fill Date end");
            }
            catch (Exception e) {
                logger.error("rlsPledgeFillDate error is:" + e);
            }
        }
    }

    private void writePayStatus(DynamicObject data, Map<Long, DynamicObject> idAndbillMap, boolean isSucWriteBack) {
        String sourceBillId = data.getString("sourcebillid");
        String sourcePayBillId = DraftHelper.checkReleatedByPayBillSelectEndorseBill((DynamicObject)data);
        if (EmptyUtil.isNoEmpty((String)sourcePayBillId)) {
            sourceBillId = sourcePayBillId;
        }
        if (EmptyUtil.isNoEmpty((String)sourceBillId) && !"0".equals(sourceBillId)) {
            Set neddUpdatePayBills;
            Set payBillIdSet;
            DynamicObject[] payBills = TmcDataServiceHelper.load((String)"cas_paybill", (String)"id,billstatus,draftbill", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(sourceBillId))});
            long id = Long.parseLong(sourceBillId);
            if (payBills.length > 0) {
                boolean isFixSelectDrafts;
                boolean bl = isFixSelectDrafts = payBills[0].getDynamicObjectCollection("draftbill").stream().filter(o -> o.getDynamicObject("fbasedataid") != null).map(o -> o.getDynamicObject("fbasedataid").getString("rptype")).distinct().count() > 1L;
                if (isSucWriteBack || isFixSelectDrafts) {
                    try (TXHandle tx = TX.requiresNew();){
                        ArrayList<Long> idList = new ArrayList<Long>();
                        idList.add(id);
                        OperateOption create = OperateOption.create();
                        create.setVariableValue("isfrombill", "y");
                        create.setVariableValue("fromdraw", "y");
                        TmcOperateServiceHelper.execOperate((String)"cancelpay", (String)"cas_paybill", (Object[])idList.toArray(), (OperateOption)create);
                    }
                }
            }
            Set<Long> recBillSet = idAndbillMap.keySet();
            Object[] recBillArr = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,releatedcasbillentrys,releatedcasbillentrys.rel_billtype,releatedcasbillentrys.rel_billno,releatedcasbillentrys.rel_billid,releatedcasbillentrys.rel_bizdate,releatedcasbillentrys.rel_billamount,releatedcasbillentrys.rel_isrefuse,releatedcasbillentrys.rel_modifytime,releatedcasbillentrys.rel_createtime", (QFilter[])new QFilter[]{new QFilter("id", "in", recBillSet), new QFilter("rptype", "=", (Object)"receivebill")});
            HashSet payBillSet = new HashSet();
            DynamicObjectCollection casPayDatas = QueryServiceHelper.query((String)"cas_paybill", (String)"id,billstatus,billno,bizdate,draftbill.fbasedataid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)casPayDatas) && EmptyUtil.isNoEmpty(payBillIdSet = casPayDatas.stream().map(e -> e.getLong("draftbill.fbasedataid")).collect(Collectors.toSet()))) {
                payBillIdSet.removeAll(recBillSet);
                Object[] payBillArr = BusinessDataServiceHelper.load((String)"cdm_payablebill", (String)"id,releatedcasbillentrys,releatedcasbillentrys.rel_billtype,releatedcasbillentrys.rel_billno,releatedcasbillentrys.rel_billid,releatedcasbillentrys.rel_bizdate,releatedcasbillentrys.rel_billamount,releatedcasbillentrys.rel_isrefuse,releatedcasbillentrys.rel_modifytime,releatedcasbillentrys.rel_createtime", (QFilter[])new QFilter[]{new QFilter("id", "in", payBillIdSet), new QFilter("rptype", "=", (Object)"paybill")});
                if (EmptyUtil.isNoEmpty((Object[])payBillArr)) {
                    payBillSet.addAll(Arrays.stream(payBillArr).collect(Collectors.toSet()));
                }
            }
            Set sourceRecBillSet = DraftHelper.getSourceSuccDraftBillWhenRepay((boolean)false, (boolean)false, (DynamicObject)data);
            if (EmptyUtil.isNoEmpty((Object[])recBillArr)) {
                Set neddUpdateRecBills;
                Set recBillDySet = Arrays.stream(recBillArr).collect(Collectors.toSet());
                if (EmptyUtil.isNoEmpty((Object)sourceRecBillSet)) {
                    recBillDySet.addAll(sourceRecBillSet);
                }
                if (EmptyUtil.isNoEmpty((Object)(neddUpdateRecBills = DraftHelper.updateDratBillCasEntry(recBillDySet, (String)"cas_paybill", (String)"delete", (Long)id)))) {
                    SaveServiceHelper.save((DynamicObject[])neddUpdateRecBills.toArray(new DynamicObject[0]));
                }
            }
            if (EmptyUtil.isNoEmpty(payBillSet) && EmptyUtil.isNoEmpty((Object)(neddUpdatePayBills = DraftHelper.updateDratBillCasEntry(payBillSet, (String)"cas_paybill", (String)"delete", (Long)id)))) {
                SaveServiceHelper.save((DynamicObject[])neddUpdatePayBills.toArray(new DynamicObject[0]));
            }
        }
    }

    public void handlerException(DynamicObject[] dataEntities) throws KDException {
        super.handlerException(dataEntities);
        this.returnCreditLimit();
    }

    private void returnCreditLimit() {
        for (DynamicObject payableBill : this.successCancelReturnCreditLimitMapList) {
            ReturnCreditLimitInfo creditLimitInfo;
            boolean isRpcSuccess;
            Date date = payableBill.getDate("issuedate");
            if (EmptyUtil.isEmpty((Object)date)) {
                date = new Date();
            }
            if (isRpcSuccess = (creditLimitInfo = CreditLimitServiceHelper.returnCreditLimit((DynamicObject)payableBill, (DynamicObject)payableBill, (boolean)false, (BigDecimal)payableBill.getBigDecimal("creditamount"), (Long)payableBill.getLong("id"), (boolean)false, (Date)date)).isSuccess()) continue;
            logger.error("\u8fd4\u8fd8\u6388\u4fe1\u989d\u5ea6\u5931\u8d25:" + creditLimitInfo.getMessage());
        }
    }

    private void cancelReturnCreditLimit(DynamicObject payableBill) {
        ReturnCreditLimitInfo creditLimitInfo = CreditLimitServiceHelper.cancelReturnCreditLimit((DynamicObject)payableBill, (DynamicObject)payableBill, (boolean)false, (BigDecimal)payableBill.getBigDecimal("creditamount"), (Long)payableBill.getLong("id"));
        boolean isRpcSuccess = creditLimitInfo.isSuccess();
        if (!isRpcSuccess) {
            throw new KDBizException(creditLimitInfo.getMessage());
        }
        this.successCancelReturnCreditLimitMapList.add(payableBill);
    }

    private void deleteCasBill(DynamicObject[] dataEntities) {
        Map tgtBillMap;
        HashSet recBillIdList;
        ArrayList<Long> waitDelRecBillTradeIdList = new ArrayList<Long>();
        ArrayList<Long> waitDelPayBillTradeIdList = new ArrayList<Long>();
        for (DynamicObject data : dataEntities) {
            String tradeType = data.getString("tradetype");
            if (DraftTradeTypeEnum.DISCOUNT.getValue().equals(tradeType) || DraftTradeTypeEnum.COLLECT.getValue().equals(tradeType)) {
                waitDelRecBillTradeIdList.add((Long)data.getPkValue());
                continue;
            }
            if (DraftTradeTypeEnum.PAYOFF.getValue().equals(tradeType)) {
                waitDelPayBillTradeIdList.add((Long)data.getPkValue());
                continue;
            }
            if (DraftTradeTypeEnum.REFUND.getValue().equals(tradeType)) {
                waitDelPayBillTradeIdList.add((Long)data.getPkValue());
                continue;
            }
            if (!DraftTradeTypeEnum.PAYINTEREST.getValue().equals(tradeType)) continue;
            waitDelPayBillTradeIdList.add((Long)data.getPkValue());
        }
        if (!CollectionUtils.isEmpty(waitDelRecBillTradeIdList) && !CollectionUtils.isEmpty((Collection)(recBillIdList = (HashSet)(tgtBillMap = BFTrackerServiceHelper.findTargetBills((String)"cdm_drafttradebill", (Long[])waitDelRecBillTradeIdList.toArray(new Long[0]))).get("cas_recbill")))) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("cdm_drafttradebill_ignore", "1");
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"cas_recbill", (Object[])recBillIdList.toArray(), (OperateOption)option, (boolean)true);
        }
        boolean isCancelbyCas = this.operationVariable.containsKey("cancelbycas");
        logger.info("cancelbycas is:" + isCancelbyCas);
        if (!CollectionUtils.isEmpty(waitDelPayBillTradeIdList)) {
            HashSet bankBillIdList;
            Map tgtBillMap2 = BFTrackerServiceHelper.findTargetBills((String)"cdm_drafttradebill", (Long[])waitDelPayBillTradeIdList.toArray(new Long[0]));
            HashSet payBillIdList = (HashSet)tgtBillMap2.get("cas_paybill");
            if (!CollectionUtils.isEmpty((Collection)payBillIdList) && !isCancelbyCas) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("cdm_drafttradebill_ignore", "1");
                option.setVariableValue("isdelbydraft", "1");
                TmcOperateServiceHelper.execOperate((String)"delete", (String)"cas_paybill", (Object[])payBillIdList.toArray(), (OperateOption)option, (boolean)true);
            }
            if (!CollectionUtils.isEmpty((Collection)(bankBillIdList = (HashSet)tgtBillMap2.get("cas_bankjournal")))) {
                OperateOption create = OperateOption.create();
                create.setVariableValue("delByOp", "op");
                TmcOperateServiceHelper.execOperate((String)"delete", (String)"cas_bankjournal", (Object[])bankBillIdList.toArray(), (OperateOption)create, (boolean)true);
            }
        }
        if (!isCancelbyCas) {
            logger.info("is will to do lock deal");
        }
    }

    public void updateDraftLockInfo(List<DynamicObject> waitLockDraftList) {
    }

    public void onReturnOperation(IOperationResult e) throws KDException {
        super.onReturnOperation(e);
        logger.info("TradeBillCancelDrawService onReturnOperation start");
        if (CollectionUtils.isEmpty(this.successLockDraftIdList)) {
            logger.info("release TradeBillCancelDrawService succLockSet is null");
            return;
        }
        try {
            logger.info("release lock\uff1a" + JSON.toJSONString(this.successLockDraftIdList));
            Map releaseResultMap = MutexServiceHelper.batchRelease(this.successLockDraftIdList, (String)"tmc-cdm-business", (String)BILLTYPE);
            logger.info("releaseResultMap is:", (Object)SerializationUtils.toJsonString((Object)releaseResultMap));
        }
        catch (Exception e1) {
            logger.error("release eror is:", (Throwable)e1);
            throw new KDBizException(ResManager.loadKDString((String)"\u91ca\u653e\u4e92\u65a5\u9501\u5931\u8d25", (String)"ReceivErrorCode_31", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
        finally {
            this.successLockDraftIdList.clear();
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntity : dataEntities) {
            if (this.drawFailBillIdSet.contains(dataEntity.getLong("id"))) continue;
            String source = dataEntity.getString("source");
            String tradeType = dataEntity.getString("tradetype");
            if (!"fromcollect".equals(source) && !"collect".equals(tradeType)) continue;
            DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("entrys");
            Set billLogIds = entrys.stream().map(o -> o.getLong("billlogid")).collect(Collectors.toSet());
            QFilter idQf = new QFilter("id", "in", billLogIds);
            DynamicObject[] draftLogArr = BusinessDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id,bizstatus,draftid,deleteflag", (QFilter[])new QFilter[]{idQf});
            HashSet<DynamicObject> needupdateLogDySet = new HashSet<DynamicObject>();
            for (DynamicObject draftLog : draftLogArr) {
                if (!draftLog.getBoolean("deleteflag") && "process".equals(draftLog.getString("bizstatus"))) continue;
                draftLog.set("deleteflag", (Object)Boolean.FALSE);
                draftLog.set("bizstatus", (Object)"process");
                needupdateLogDySet.add(draftLog);
            }
            if (!EmptyUtil.isNoEmpty(needupdateLogDySet)) continue;
            SaveServiceHelper.save((DynamicObject[])needupdateLogDySet.toArray(new DynamicObject[0]));
        }
    }
}

