/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.tradebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.business.lock.DraftLockServiceFactory;
import kd.tmc.cdm.business.service.DraftAmountLockSubInfo;
import kd.tmc.cdm.business.service.DraftLockInfo;
import kd.tmc.cdm.business.service.LockResult;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.cdm.common.enums.LogBizStatusEnum;
import kd.tmc.cdm.common.enums.OperateTypeEnum;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class TradeBillChangeAuditService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(TradeBillChangeAuditService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("havechange_entry");
        selector.add("bechange_entry");
        selector.add("sourcebillid");
        selector.add("draftbill");
        selector.add("billlogid");
        selector.add("billamt");
        selector.add("billoldelestatus");
        selector.add("oldstatus");
        selector.add("transtatus");
        selector.add("b_draftbill");
        selector.add("b_billlogid");
        selector.add("b_billamt");
        selector.add("b_billoldelestatus");
        selector.add("b_oldstatus");
        selector.add("b_transtatus");
        selector.add("id");
        selector.add("tradetype");
        selector.add("tradebillno");
        selector.add("b_tradeentryid");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        Object[] tradeNos = Arrays.stream(dataEntities).map(changeBill -> changeBill.getString("tradebillno")).toArray();
        DynamicObject[] draftTradeBills = TmcDataServiceHelper.load((String)"cdm_drafttradebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "in", (Object)tradeNos)});
        Object[] tradeIds = Arrays.stream(draftTradeBills).map(DataEntityBase::getPkValue).toArray();
        DynamicObject[] draftTradeBillList = TmcDataServiceHelper.load((Object[])tradeIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_drafttradebill"));
        Map<String, DynamicObject> tradeNoToTradeBillMap = Arrays.stream(draftTradeBillList).collect(Collectors.toMap(tradeBill -> tradeBill.getString("billno"), Function.identity()));
        this.replaceTradeBillEntry(dataEntities, tradeNoToTradeBillMap);
        this.updateBillLogInfo(dataEntities);
        this.updateDraftBillTranStatus(dataEntities);
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        this.submitEle(dataEntities);
    }

    private void updateBillLogInfo(DynamicObject[] dataEntities) {
        ArrayList logIdList = new ArrayList(10);
        Arrays.stream(dataEntities).forEach(changeBill -> {
            DynamicObjectCollection beChangeEntries = changeBill.getDynamicObjectCollection("bechange_entry");
            logIdList.addAll(beChangeEntries.stream().map(b -> b.getLong("b_billlogid")).collect(Collectors.toList()));
        });
        DynamicObject[] beChangeLogList = TmcDataServiceHelper.load((Object[])logIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbill_log"));
        Map<Long, DynamicObject> idToLogMap = Arrays.stream(beChangeLogList).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
        ArrayList<DraftLockInfo> lockInfoList = new ArrayList<DraftLockInfo>(8);
        HashSet<DynamicObject> beChangeLogUpdateSet = new HashSet<DynamicObject>(8);
        for (DynamicObject changeBill2 : dataEntities) {
            DynamicObjectCollection beChangeEntries = changeBill2.getDynamicObjectCollection("bechange_entry");
            long anyLogId = beChangeEntries.stream().filter(e -> EmptyUtil.isNoEmpty((DynamicObject)((DynamicObject)idToLogMap.get(e.getLong("b_billlogid"))))).map(e -> e.getLong("b_billlogid")).findAny().orElse(0L);
            if (EmptyUtil.isEmpty((Long)anyLogId)) continue;
            String tradeType = changeBill2.getString("tradetype");
            DynamicObject anyLog = idToLogMap.get(anyLogId);
            DraftLockInfo draftLockInfo = new DraftLockInfo();
            draftLockInfo.setBillTrade(tradeType);
            draftLockInfo.setSourceBillId(anyLog.getLong("sourcebillid"));
            draftLockInfo.setSourceBillType(anyLog.getString("sourcebilltype"));
            draftLockInfo.setBizBillNo(anyLog.getString("bizbillno"));
            ArrayList<DraftAmountLockSubInfo> subInfoList = new ArrayList<DraftAmountLockSubInfo>(10);
            for (DynamicObject entry : beChangeEntries) {
                DynamicObject beChangeLog = idToLogMap.get(entry.getLong("b_billlogid"));
                if (EmptyUtil.isEmpty((DynamicObject)beChangeLog)) continue;
                beChangeLog.set("deleteflag", (Object)true);
                beChangeLogUpdateSet.add(beChangeLog);
                if (!this.needToReleaseAmount(beChangeLog)) continue;
                DraftAmountLockSubInfo releaseSubInfo = new DraftAmountLockSubInfo();
                releaseSubInfo.setBillId(beChangeLog.getLong("draftid"));
                releaseSubInfo.setBillLogId(beChangeLog.getLong("id"));
                releaseSubInfo.setDealAmount(beChangeLog.getBigDecimal("dealamount"));
                releaseSubInfo.setOperateType(OperateTypeEnum.DELETE.getValue());
                releaseSubInfo.setBillTrade(tradeType);
                subInfoList.add(releaseSubInfo);
            }
            if (!EmptyUtil.isNoEmpty(subInfoList)) continue;
            draftLockInfo.setLockSubInfoList(subInfoList);
            lockInfoList.add(draftLockInfo);
        }
        if (EmptyUtil.isNoEmpty(lockInfoList)) {
            List<LockResult> lockResultList = DraftLockServiceFactory.getService().lock(lockInfoList, true);
            this.checkResult(lockResultList);
        }
        if (EmptyUtil.isNoEmpty(beChangeLogUpdateSet)) {
            SaveServiceHelper.update((DynamicObject[])beChangeLogUpdateSet.toArray(new DynamicObject[0]));
        }
    }

    private void updateDraftBillTranStatus(DynamicObject[] dataEntities) {
        ArrayList beChangeBillIds = new ArrayList(10);
        for (DynamicObject changeBill : dataEntities) {
            DynamicObjectCollection beChangeEntries = changeBill.getDynamicObjectCollection("bechange_entry");
            beChangeEntries.forEach(beChangeEntry -> beChangeBillIds.add(beChangeEntry.getDynamicObject("b_draftbill").getLong("id")));
        }
        String sql = "update t_cdm_draftbill_f set fdraftbilltranstatus = ? where fid in (" + TmcBusinessBaseHelper.idListToString(beChangeBillIds) + ")";
        int result = DB.update((DBRoute)DBRouteConst.TMC, (String)sql, (Object[])new Object[]{DraftTranStatusEnum.SUCCESS.getValue()});
        if (result < beChangeBillIds.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6062\u590d\u88ab\u6362\u7968\u636e\u7684\u4ea4\u6613\u72b6\u6001\u4e3a\u4ea4\u6613\u6210\u529f\u65f6\u5931\u8d25\u3002", (String)"TradeBillChangeAuditService_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
    }

    private boolean needToReleaseAmount(DynamicObject beChangeLog) {
        return StringUtils.equals((CharSequence)beChangeLog.getString("bizstatus"), (CharSequence)LogBizStatusEnum.PROCESS.getValue()) || StringUtils.equals((CharSequence)beChangeLog.getString("bizstatus"), (CharSequence)LogBizStatusEnum.FAIL.getValue()) && !beChangeLog.getBoolean("issplit");
    }

    private void replaceTradeBillEntry(DynamicObject[] dataEntities, Map<String, DynamicObject> tradeNoToTradeBillMap) {
        ArrayList tradeBillList = new ArrayList(8);
        boolean autoChangeBill = "1".equals(this.getOperationVariable().get("changeBillWay"));
        logger.info("autoChangeBill is:" + autoChangeBill);
        HashSet needUpdateEleDrafts = new HashSet(16);
        Arrays.stream(dataEntities).forEach(changeBill -> {
            DynamicObject[] eleDraftColl;
            DynamicObject tradeBill = (DynamicObject)tradeNoToTradeBillMap.get(changeBill.getString("tradebillno"));
            DynamicObjectCollection entries = tradeBill.getDynamicObjectCollection("entrys");
            DynamicObjectCollection beChangeEntries = changeBill.getDynamicObjectCollection("bechange_entry");
            List beChangeBillIds = beChangeEntries.stream().map(beChangeEntry -> beChangeEntry.getDynamicObject("b_draftbill").getLong("id")).collect(Collectors.toList());
            String tranStatus = "";
            String bankMsg = "";
            for (DynamicObject[] entry2 : entries) {
                if (!beChangeBillIds.contains(entry2.getDynamicObject("draftbill").getLong("id"))) continue;
                tranStatus = entry2.getString("transtatus");
                bankMsg = entry2.getString("e_bankmsg");
            }
            entries.removeIf(entry -> beChangeBillIds.contains(entry.getDynamicObject("draftbill").getLong("id")));
            for (DynamicObject eleDraft : eleDraftColl = BusinessDataServiceHelper.load((String)"cdm_electronicbill", (String)"id,tradeoppname", (QFilter[])new QFilter[]{new QFilter("sourceid", "in", beChangeBillIds)})) {
                eleDraft.set("tradeoppname", null);
                needUpdateEleDrafts.add(eleDraft);
            }
            DynamicObjectCollection haveChangeEntries = changeBill.getDynamicObjectCollection("havechange_entry");
            for (DynamicObject haveChangeEntry : haveChangeEntries) {
                BigDecimal billAmount;
                BigDecimal amount;
                DynamicObject newEntry = entries.addNew();
                newEntry.set("draftbill", (Object)haveChangeEntry.getDynamicObject("draftbill"));
                newEntry.set("billamt", (Object)haveChangeEntry.getBigDecimal("billamt"));
                newEntry.set("billoldelestatus", (Object)haveChangeEntry.getString("billoldelestatus"));
                newEntry.set("oldstatus", (Object)haveChangeEntry.getString("oldstatus"));
                newEntry.set("transtatus", (Object)haveChangeEntry.getString("transtatus"));
                newEntry.set("billlogid", (Object)haveChangeEntry.getString("billlogid"));
                newEntry.set("changeflag", (Object)true);
                if (autoChangeBill) {
                    newEntry.set("transtatus", (Object)tranStatus);
                    logger.info("bankMsg is:" + bankMsg);
                    newEntry.set("e_bankmsg", (Object)bankMsg);
                }
                if ((amount = newEntry.getDynamicObject("draftbill").getBigDecimal("amount")).compareTo(billAmount = newEntry.getBigDecimal("billamt")) <= 0) continue;
                newEntry.set("isneedsplit", (Object)true);
            }
            if (!autoChangeBill) {
                tradeBill.set("electag", (Object)"0");
            }
            tradeBillList.add(tradeBill);
        });
        TmcDataServiceHelper.save((DynamicObject[])tradeBillList.toArray(new DynamicObject[0]));
        if (EmptyUtil.isNoEmpty(needUpdateEleDrafts)) {
            TmcDataServiceHelper.save((DynamicObject[])needUpdateEleDrafts.toArray(new DynamicObject[0]));
        }
    }

    private void checkResult(List<LockResult> lockResultList) {
        List failLockResultList;
        if (EmptyUtil.isNoEmpty(lockResultList) && EmptyUtil.isNoEmpty(failLockResultList = lockResultList.stream().filter(e -> EmptyUtil.isNoEmpty((Long)e.getSourceBillId()) && !e.isSuccess()).collect(Collectors.toList()))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5360\u7528\u66f4\u65b0\u65e5\u5fd7\u5931\u8d25\u3002", (String)"TradeBillChangeSaveCommon_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
    }

    private void submitEle(DynamicObject[] dataEntities) {
        if ("1".equals(this.getOperationVariable().get("changeBillWay"))) {
            return;
        }
        Object[] dataList = this.getAutoSubmitEleDataListByCdmParameter(dataEntities);
        logger.info("\u3010\u7968\u636e\u80cc\u4e66\u4e1a\u52a1\u6362\u7968\u3011\u6362\u7968\u5b8c\u65b0\u7968\u81ea\u52a8\u63d0\u4ea4\u7535\u7968\uff0c\u9700\u8981\u63d0\u4ea4\u7535\u7968\u7684\u6362\u7968\u5355\u6570\u91cf: {}", (Object)(EmptyUtil.isEmpty((Object[])dataList) ? 0 : dataList.length));
        if (EmptyUtil.isEmpty((Object[])dataList)) {
            return;
        }
        Object[] tradeNos = Arrays.stream(dataList).map(changeBill -> changeBill.getString("tradebillno")).toArray();
        DynamicObject[] draftTradeBills = TmcDataServiceHelper.load((String)"cdm_drafttradebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "in", (Object)tradeNos)});
        Object[] tradeIds = Arrays.stream(draftTradeBills).map(DataEntityBase::getPkValue).toArray();
        Object[] draftTradeBillList = TmcDataServiceHelper.load((Object[])tradeIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_drafttradebill"));
        List<DynamicObject> submitEleList = Arrays.stream(draftTradeBillList).filter(tradeBill -> this.isSubmitEle(tradeBill.getString("draftbilltranstatus"))).collect(Collectors.toList());
        logger.info("\u3010\u7968\u636e\u80cc\u4e66\u4e1a\u52a1\u6362\u7968\u3011\u6362\u7968\u5b8c\u65b0\u7968\u81ea\u52a8\u63d0\u4ea4\u7535\u7968\uff0corigin length: {}\uff0c need submit length: {}", (Object)(EmptyUtil.isEmpty((Object[])draftTradeBillList) ? 0 : draftTradeBillList.length), (Object)(EmptyUtil.isEmpty(submitEleList) ? 0 : submitEleList.size()));
        Object[] draftTradeBillIds = submitEleList.stream().map(DataEntityBase::getPkValue).toArray();
        logger.info("\u3010\u7968\u636e\u80cc\u4e66\u4e1a\u52a1\u6362\u7968\u3011\u6362\u7968\u5b8c\u65b0\u7968\u81ea\u52a8\u63d0\u4ea4\u7535\u7968\uff0cdraftTradeBillIds = {}", (Object)Arrays.toString(draftTradeBillIds));
        OperateOption opOption = OperateOption.create();
        opOption.setVariableValue("submitEleSource", "tradeChangeBill");
        OperationResult operationResult = TmcOperateServiceHelper.execOperateWithoutThrow((String)"submitele", (String)"cdm_drafttradebill", (DynamicObject[])submitEleList.toArray(new DynamicObject[0]), (OperateOption)opOption);
        logger.info("\u3010\u7968\u636e\u80cc\u4e66\u4e1a\u52a1\u6362\u7968\u3011\u6362\u7968\u5b8c\u65b0\u7968\u63d0\u4ea4\u7535\u7968\u7ed3\u679c\uff1aisSuccess\uff1a{}\uff0cisNeedSign\uff1a{}", (Object)operationResult.isSuccess(), (Object)operationResult.isNeedSign());
        if (!operationResult.isSuccess()) {
            List successIdList = operationResult.getSuccessPkIds();
            Object[] errorIds = EmptyUtil.isNoEmpty((Object)successIdList) ? Arrays.stream(draftTradeBillIds).filter(id -> !successIdList.contains(id)).toArray() : draftTradeBillIds;
            DynamicObject[] tradeBills = TmcDataServiceHelper.load((Object[])errorIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_drafttradebill"));
            Arrays.stream(tradeBills).forEach(tradeBill -> tradeBill.set("electag", (Object)"0"));
            TmcDataServiceHelper.save((DynamicObject[])tradeBills);
            List errorMsgList = operationResult.getAllErrorOrValidateInfo();
            StringBuilder sb = new StringBuilder();
            for (IOperateInfo iOperateInfo : errorMsgList) {
                sb.append(iOperateInfo.getPkValue()).append("\uff0c");
                sb.append(iOperateInfo.getMessage());
            }
            if (!operationResult.isNeedSign()) {
                logger.info("\u3010\u7968\u636e\u80cc\u4e66\u4e1a\u52a1\u6362\u7968\u3011\u6362\u7968\u5b8c\u65b0\u7968\u63d0\u4ea4\u7535\u7968\u6210\u529f\u6570\u91cf = {},\u4e0d\u6210\u529f\u6570\u91cf\u7684\u9519\u8bef\u4fe1\u606f = {}", (Object)operationResult.getSuccessPkIds().size(), (Object)sb.toString());
                throw new TmcBizException(TmcErrorCode.COMMON, new Object[]{sb.toString()});
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u7531\u4e8e\u914d\u7f6e\u4e86\u52a0\u7b7e\u3001\u9a8c\u7b7e\uff0c\u6362\u7968\u540e\u81ea\u52a8\u63d0\u4ea4\u7535\u7968\u5931\u8d25\uff0c\u8bf7\u5728\u4e1a\u52a1\u5904\u7406\u5355\u4e0a\u624b\u52a8\u63d0\u4ea4\u7535\u7968\u6216\u8005\u5173\u95ed\u201c\u6362\u7968\u81ea\u52a8\u63d0\u4ea4\u7535\u7968\u201d\u7cfb\u7edf\u53c2\u6570\u3002", (String)"TradeBillChangeAuditService_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
        logger.info("\u3010\u7968\u636e\u80cc\u4e66\u4e1a\u52a1\u6362\u7968\u3011\u6362\u7968\u5b8c\u65b0\u7968\u63d0\u4ea4\u7535\u7968\u6210\u529f\u6570\u91cf = {}", (Object)operationResult.getSuccessPkIds().size());
    }

    private boolean isSubmitEle(String tranStatus) {
        return StringUtils.equals((CharSequence)DraftTranStatusEnum.FAILING.getValue(), (CharSequence)tranStatus) || StringUtils.equals((CharSequence)DraftTranStatusEnum.HANDLEING.getValue(), (CharSequence)tranStatus) || StringUtils.equals((CharSequence)DraftTranStatusEnum.PORSUCCESS.getValue(), (CharSequence)tranStatus);
    }

    private DynamicObject[] getAutoSubmitEleDataListByCdmParameter(DynamicObject[] dataEntities) {
        Set<Object> companySet = Arrays.stream(dataEntities).filter(changeBill -> EmptyUtil.isNoEmpty((DynamicObject)changeBill.getDynamicObject("company"))).map(changeBill -> changeBill.getDynamicObject("company").getPkValue()).collect(Collectors.toSet());
        HashMap autoSubmitEleMap = new HashMap(8);
        companySet.forEach(companyId -> autoSubmitEleMap.put(companyId, DraftHelper.getCdmParameterBoolean((long)Long.parseLong(companyId.toString()), (String)"changebilltosubmitele")));
        return (DynamicObject[])Arrays.stream(dataEntities).filter(changeBill -> {
            DynamicObject company = changeBill.getDynamicObject("company");
            if (EmptyUtil.isEmpty((DynamicObject)company)) {
                return false;
            }
            return autoSubmitEleMap.getOrDefault(company.getPkValue(), false);
        }).toArray(DynamicObject[]::new);
    }
}

