/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.tradebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.tmc.cdm.business.lock.DraftLockServiceFactory;
import kd.tmc.cdm.business.service.DraftAmountLockSubInfo;
import kd.tmc.cdm.business.service.DraftLockInfo;
import kd.tmc.cdm.business.service.LockResult;
import kd.tmc.cdm.common.enums.OperateTypeEnum;
import kd.tmc.cdm.common.helper.TradeBillChangeHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TradeBillChangeDeleteService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("havechange_entry");
        selector.add("bechange_entry");
        selector.add("sourcebillid");
        selector.add("draftbill");
        selector.add("billlogid");
        selector.add("billamt");
        selector.add("b_draftbill");
        selector.add("b_billlogid");
        selector.add("b_billamt");
        selector.add("id");
        selector.add("tradetype");
        selector.add("tradebillno");
        selector.add("b_tradeentryid");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        this.updateTradeBillEntry(dataEntities);
        this.updateBillLogInfo(dataEntities);
    }

    private void updateTradeBillEntry(DynamicObject[] dataEntities) {
        HashSet tradeHaveChangeEntryIds = new HashSet(20);
        Arrays.stream(dataEntities).forEach(changeBill -> {
            DynamicObjectCollection beChangeEntries = changeBill.getDynamicObjectCollection("bechange_entry");
            beChangeEntries.forEach(entry -> tradeHaveChangeEntryIds.add(entry.getLong("b_tradeentryid")));
        });
        TradeBillChangeHelper.changBillUpdateIsChangeFlag(tradeHaveChangeEntryIds, (Object[])new Object[]{"0", "1"});
    }

    private void updateBillLogInfo(DynamicObject[] dataEntities) {
        ArrayList logIdList = new ArrayList(10);
        Arrays.stream(dataEntities).forEach(changeBill -> {
            DynamicObjectCollection haveChangeEntries = changeBill.getDynamicObjectCollection("havechange_entry");
            logIdList.addAll(haveChangeEntries.stream().map(b -> b.getLong("billlogid")).collect(Collectors.toList()));
        });
        DynamicObject[] haveChangeLogList = TmcDataServiceHelper.load((Object[])logIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbill_log"));
        Map<Long, DynamicObject> idToLogMap = Arrays.stream(haveChangeLogList).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
        ArrayList<DraftLockInfo> lockInfoList = new ArrayList<DraftLockInfo>(8);
        for (DynamicObject changeBill2 : dataEntities) {
            String tradeType = changeBill2.getString("tradetype");
            DynamicObjectCollection haveChangeEntries = changeBill2.getDynamicObjectCollection("havechange_entry");
            long anyLogId = haveChangeEntries.stream().filter(e -> EmptyUtil.isNoEmpty((DynamicObject)((DynamicObject)idToLogMap.get(e.getLong("billlogid"))))).map(e -> e.getLong("billlogid")).findAny().orElse(0L);
            if (EmptyUtil.isEmpty((Long)anyLogId)) continue;
            DynamicObject log = idToLogMap.get(anyLogId);
            DraftLockInfo draftLockInfo = new DraftLockInfo();
            draftLockInfo.setBillTrade(tradeType);
            draftLockInfo.setSourceBillId(log.getLong("sourcebillid"));
            draftLockInfo.setSourceBillType(log.getString("sourcebilltype"));
            draftLockInfo.setBizBillNo(log.getString("bizbillno"));
            ArrayList<DraftAmountLockSubInfo> subInfoList = new ArrayList<DraftAmountLockSubInfo>(10);
            for (DynamicObject entry : haveChangeEntries) {
                DynamicObject haveChangeLog = idToLogMap.get(entry.getLong("billlogid"));
                if (EmptyUtil.isEmpty((DynamicObject)haveChangeLog)) continue;
                DraftAmountLockSubInfo lockSubInfo = new DraftAmountLockSubInfo();
                lockSubInfo.setBillId(haveChangeLog.getLong("draftid"));
                lockSubInfo.setBillLogId(haveChangeLog.getLong("id"));
                lockSubInfo.setDealAmount(haveChangeLog.getBigDecimal("dealamount"));
                lockSubInfo.setOperateType(OperateTypeEnum.DELETE.getValue());
                lockSubInfo.setBillTrade(tradeType);
                subInfoList.add(lockSubInfo);
            }
            draftLockInfo.setLockSubInfoList(subInfoList);
            lockInfoList.add(draftLockInfo);
        }
        if (EmptyUtil.isNoEmpty(lockInfoList)) {
            List<LockResult> lockResultList = DraftLockServiceFactory.getService().lock(lockInfoList, true);
            this.checkResult(lockResultList);
        }
    }

    private void checkResult(List<LockResult> lockResultList) {
        List failLockResultList;
        if (EmptyUtil.isNoEmpty(lockResultList) && EmptyUtil.isNoEmpty(failLockResultList = lockResultList.stream().filter(e -> EmptyUtil.isNoEmpty((Long)e.getSourceBillId()) && !e.isSuccess()).collect(Collectors.toList()))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5360\u7528\u66f4\u65b0\u65e5\u5fd7\u5931\u8d25\u3002", (String)"TradeBillChangeSaveCommon_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
    }
}

