/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.tradebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.tmc.cdm.business.lock.DraftLockServiceFactory;
import kd.tmc.cdm.business.service.DraftAmountLockSubInfo;
import kd.tmc.cdm.business.service.DraftLockInfo;
import kd.tmc.cdm.business.service.LockResult;
import kd.tmc.cdm.common.enums.LogBizStatusEnum;
import kd.tmc.cdm.common.enums.OperateTypeEnum;
import kd.tmc.cdm.common.helper.TradeBillChangeHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TradeBillChangeSaveService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("havechange_entry");
        selector.add("bechange_entry");
        selector.add("sourcebillid");
        selector.add("draftbill");
        selector.add("billlogid");
        selector.add("billamt");
        selector.add("b_draftbill");
        selector.add("b_billlogid");
        selector.add("b_billamt");
        selector.add("id");
        selector.add("tradetype");
        selector.add("tradebillno");
        selector.add("b_tradeentryid");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        this.processBeChangeBillLock(dataEntities);
        this.processHaveChangeBillLockLogInfo(dataEntities);
    }

    private void processBeChangeBillLock(DynamicObject[] dataEntities) {
        Arrays.stream(dataEntities).forEach(changeBill -> {
            Object id = changeBill.getPkValue();
            boolean exist = TmcDataServiceHelper.exists((Object)id, (String)"cdm_draftbillchange");
            if (!exist) {
                DynamicObjectCollection beChangeEntries = changeBill.getDynamicObjectCollection("bechange_entry");
                Set tradeHaveChangeEntryIds = beChangeEntries.stream().map(entry -> entry.getLong("b_tradeentryid")).collect(Collectors.toSet());
                int count = TradeBillChangeHelper.changBillUpdateIsChangeFlag(tradeHaveChangeEntryIds, (Object[])new Object[]{"1", "0"});
                if (count < tradeHaveChangeEntryIds.size()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u7968\u636e\u6b63\u5728\u6362\u7968\uff0c\u8bf7\u5b8c\u6210\u6362\u7968\u540e\u518d\u64cd\u4f5c\u3002", (String)"TradeBillChangeSaveCommon_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                }
            }
        });
    }

    private void processHaveChangeBillLockLogInfo(DynamicObject[] dataEntities) {
        DynamicObjectType dynamicObjectType = dataEntities[0].getDynamicObjectType();
        Object[] changeBillListDB = TmcDataServiceHelper.load((Object[])Arrays.stream(dataEntities).map(e -> e.getLong("id")).distinct().toArray(), (DynamicObjectType)dynamicObjectType);
        Map<Object, Object> changeBillMapDB = new HashMap(8);
        if (EmptyUtil.isNoEmpty((Object[])changeBillListDB)) {
            changeBillMapDB = Arrays.stream(changeBillListDB).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
        }
        ArrayList logIdList = new ArrayList(10);
        Arrays.stream(dataEntities).forEach(changeBill -> {
            DynamicObjectCollection beChangeEntries = changeBill.getDynamicObjectCollection("bechange_entry");
            logIdList.addAll(beChangeEntries.stream().map(b -> b.getLong("b_billlogid")).collect(Collectors.toList()));
        });
        DynamicObject[] beChangeLogList = TmcDataServiceHelper.load((Object[])logIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbill_log"));
        Map<Long, DynamicObject> idToLogMap = Arrays.stream(beChangeLogList).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
        ArrayList<DraftLockInfo> lockInfoList = new ArrayList<DraftLockInfo>(8);
        for (DynamicObject data : dataEntities) {
            long changeBillId = data.getLong("id");
            String tradeType = data.getString("tradetype");
            DynamicObjectCollection beChangeEntries = data.getDynamicObjectCollection("bechange_entry");
            long anyLogId = beChangeEntries.stream().filter(e -> EmptyUtil.isNoEmpty((DynamicObject)((DynamicObject)idToLogMap.get(e.getLong("b_billlogid"))))).map(e -> e.getLong("b_billlogid")).findAny().orElse(0L);
            if (EmptyUtil.isEmpty((Long)anyLogId)) continue;
            DynamicObject log = idToLogMap.get(anyLogId);
            DraftLockInfo draftLockInfo = new DraftLockInfo();
            draftLockInfo.setBillTrade(tradeType);
            draftLockInfo.setSourceBillId(log.getLong("sourcebillid"));
            draftLockInfo.setSourceBillType(log.getString("sourcebilltype"));
            draftLockInfo.setBizBillNo(log.getString("bizbillno"));
            ArrayList<DraftAmountLockSubInfo> subInfoList = new ArrayList<DraftAmountLockSubInfo>(10);
            DynamicObject changeBillDB = (DynamicObject)changeBillMapDB.get(changeBillId);
            Map<Object, Object> entriesMapDB = new HashMap(10);
            DynamicObjectCollection haveChangeEntries = data.getDynamicObjectCollection("havechange_entry");
            List currentHaveChangeBillIdList = haveChangeEntries.stream().map(e -> e.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toList());
            if (EmptyUtil.isNoEmpty((DynamicObject)changeBillDB)) {
                DynamicObjectCollection entriesDB = changeBillDB.getDynamicObjectCollection("havechange_entry");
                entriesMapDB = entriesDB.stream().collect(Collectors.toMap(key -> key.getDynamicObject("draftbill").getLong("id"), val -> {
                    HashMap<String, Number> valMap = new HashMap<String, Number>(8);
                    valMap.put("billamt", val.getBigDecimal("billamt"));
                    valMap.put("billlogid", val.getLong("billlogid"));
                    return valMap;
                }, (key1, key2) -> key2));
                ArrayList releaseSubInfoList = new ArrayList(10);
                entriesMapDB.forEach((key, val) -> {
                    if (!currentHaveChangeBillIdList.contains(key)) {
                        DraftAmountLockSubInfo releaseSubInfo = new DraftAmountLockSubInfo();
                        releaseSubInfo.setBillId((Long)key);
                        releaseSubInfo.setBillLogId(val.getOrDefault("billlogid", 0L));
                        releaseSubInfo.setDealAmount(val.getOrDefault("billamt", BigDecimal.ZERO));
                        releaseSubInfo.setOperateType(OperateTypeEnum.DELETE.getValue());
                        releaseSubInfo.setBillTrade(tradeType);
                        releaseSubInfoList.add(releaseSubInfo);
                    }
                });
                subInfoList.addAll(releaseSubInfoList);
            }
            ArrayList<DraftAmountLockSubInfo> lockSubInfoList = new ArrayList<DraftAmountLockSubInfo>(10);
            for (DynamicObject haveChangeEntry : haveChangeEntries) {
                Long billId = haveChangeEntry.getDynamicObject("draftbill").getLong("id");
                Map dbMap = (Map)entriesMapDB.get(billId);
                BigDecimal dealAmount = haveChangeEntry.getBigDecimal("billamt");
                if (EmptyUtil.isNoEmpty((Object)dbMap)) {
                    boolean isTransAmountEquals = dbMap.getOrDefault("billamt", BigDecimal.ZERO).compareTo(dealAmount) == 0;
                    boolean hasBillLogId = EmptyUtil.isNoEmpty((Long)dbMap.getOrDefault("billlogid", 0L));
                    if (isTransAmountEquals && hasBillLogId) continue;
                }
                DraftAmountLockSubInfo draftAmountLockSubInfo = new DraftAmountLockSubInfo();
                draftAmountLockSubInfo.setBillId(billId);
                draftAmountLockSubInfo.setBillLogId(0L);
                draftAmountLockSubInfo.setDealAmount(dealAmount);
                draftAmountLockSubInfo.setBillTradeStatus(LogBizStatusEnum.PROCESS.getValue());
                draftAmountLockSubInfo.setBillTrade(tradeType);
                lockSubInfoList.add(draftAmountLockSubInfo);
            }
            subInfoList.addAll(lockSubInfoList);
            draftLockInfo.setLockSubInfoList(subInfoList);
            lockInfoList.add(draftLockInfo);
        }
        if (EmptyUtil.isNoEmpty(lockInfoList)) {
            List<LockResult> lockResultList = DraftLockServiceFactory.getService().lock(lockInfoList, true);
            this.checkResultAndFillLog(dataEntities, lockResultList, idToLogMap);
        }
    }

    private void checkResultAndFillLog(DynamicObject[] dataEntities, List<LockResult> lockResultList, Map<Long, DynamicObject> idToLogMap) {
        if (EmptyUtil.isNoEmpty(lockResultList)) {
            List failLockResultList = lockResultList.stream().filter(e -> EmptyUtil.isNoEmpty((Long)e.getSourceBillId()) && !e.isSuccess()).collect(Collectors.toList());
            if (EmptyUtil.isNoEmpty(failLockResultList)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5360\u7528\u66f4\u65b0\u65e5\u5fd7\u5931\u8d25\u3002", (String)"TradeBillChangeSaveCommon_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            Map<Long, LockResult> resultMap = lockResultList.stream().collect(Collectors.toMap(LockResult::getSourceBillId, x -> x));
            for (DynamicObject data : dataEntities) {
                DynamicObjectCollection beChangeEntries = data.getDynamicObjectCollection("bechange_entry");
                long anyLogId = beChangeEntries.stream().filter(e -> EmptyUtil.isNoEmpty((DynamicObject)((DynamicObject)idToLogMap.get(e.getLong("b_billlogid"))))).map(e -> e.getLong("b_billlogid")).findAny().orElse(0L);
                if (EmptyUtil.isEmpty((Long)anyLogId)) continue;
                DynamicObject log = idToLogMap.get(anyLogId);
                DynamicObjectCollection entries = data.getDynamicObjectCollection("havechange_entry");
                long sourceBillId = log.getLong("sourcebillid");
                entries.forEach(entry -> {
                    Long draftBillId = entry.getDynamicObject("draftbill").getLong("id");
                    LockResult lockResult = (LockResult)resultMap.get(sourceBillId);
                    if (EmptyUtil.isNoEmpty((Object)lockResult)) {
                        Map<Long, Long> billIdLogIdMap = lockResult.getBillIdLogIdMap();
                        boolean success = lockResult.isSuccess();
                        Long billLogId = billIdLogIdMap.get(draftBillId);
                        if (EmptyUtil.isNoEmpty((Long)billLogId) && success) {
                            entry.set("billlogid", (Object)billLogId);
                        }
                    }
                });
            }
        }
    }
}

