/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.tradebill;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.tmc.cdm.business.lock.DraftOperateInfo;
import kd.tmc.cdm.business.lock.DraftOperateResultInfo;
import kd.tmc.cdm.business.lock.IDraftOperateService;
import kd.tmc.cdm.business.opservice.tradebill.TradeBillAuditService;
import kd.tmc.cdm.business.pool.sync.TradeBillSyncTransBillService;
import kd.tmc.cdm.business.service.DraftLockInfo;
import kd.tmc.cdm.business.service.LockDraftHelper;
import kd.tmc.cdm.business.service.allocation.AsyncPushPledgeBill;
import kd.tmc.cdm.common.constant.DBRouteConst;
import kd.tmc.cdm.common.enums.BizBusinessTypeEnum;
import kd.tmc.cdm.common.enums.DraftBillStatusEnum;
import kd.tmc.cdm.common.enums.DraftTradeTypeEnum;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftCirStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftNoteStatusEnum;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.cdm.common.helper.BotpHelper;
import kd.tmc.cdm.common.helper.CasHelper;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.cdm.common.helper.OperateServiceHelper;
import kd.tmc.cdm.common.helper.PayableBillHelp;
import kd.tmc.cdm.common.helper.TradeBillAmountHelper;
import kd.tmc.cdm.common.helper.TradeBillHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.DynamicObjectCompareHelper;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.model.interest.ReturnCreditLimitInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TradeBillDrawBillService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(TradeBillAuditService.class);
    private static final List<String> TRADTYPES = Arrays.asList(DraftTradeTypeEnum.ENDORSE.getValue(), DraftTradeTypeEnum.PLEDGE.getValue(), DraftTradeTypeEnum.DISCOUNT.getValue(), DraftTradeTypeEnum.COLLECT.getValue(), DraftTradeTypeEnum.RLSPLEDGE.getValue());
    public static final String PUSHPAYBILL = "pushpaybill";
    public static final String PUSHRECBILL = "pushrecbill";
    public static final String PUSHANDSAVERECBILL = "pushandsaverecbill";
    public static final String PUSHPLEDGE = "pushpledge";
    public static final String DEPOSITPUSH = "depositpush";
    public static final String PAYINTERESTPUSH = "payinterestpush";
    public static final String SPLITPUSHRECBILL = "splitpushrecbill";
    public static final String SPLITPUSHPAYCBILL = "splitpushpaycbill";
    public static final String BILLTYPE = "draw";
    private List<String> successLockDraftIdList = new ArrayList<String>(8);
    private List<DynamicObject> successReturnCreditLimitMapList = new ArrayList<DynamicObject>();
    private boolean isDrawDail = false;

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("tradetype");
        selector.add("entrys");
        selector.add("draftbill");
        selector.add("recbody");
        selector.add("recbodyname");
        selector.add("payeetype");
        selector.add("beendorsor");
        selector.add("description");
        selector.add("oldstatus");
        selector.add("company");
        selector.add("drafttype");
        selector.add("payeetypetext");
        selector.add("beendorsortext");
        selector.add("currency");
        selector.add("bizdate");
        selector.add("amount");
        selector.add("exchangerate");
        selector.add("locamt");
        selector.add("billno");
        selector.add("createtime");
        selector.add("allocbillentryid");
        selector.add("source");
        selector.add("sourcebillid");
        selector.add("deposit");
        selector.add("depositamount");
        selector.add("transtatus");
        selector.add("electag");
        selector.add("draftbilltranstatus");
        selector.add("draftcount");
        selector.add("amount");
        selector.add("discamt");
        selector.add("discount_interest");
        selector.add("roughly_interest");
        selector.add("collection");
        selector.add("electag");
        selector.add("transtatus");
        selector.add("currency");
        selector.add("bizdate");
        selector.add("interestday");
        selector.add("discount_days");
        selector.add("rate");
        selector.add("sourcebilltype");
        selector.add("isrepay");
        selector.add("isrejectrefundgen");
        selector.add("poundage");
        selector.add("refunddesc");
        selector.add("pledgeenddate");
        selector.add("rptype");
        selector.add("depositdeduct");
        selector.add("deductamount");
        selector.add("bizfinishdate");
        selector.add("iseditdiscountentry");
        selector.add("discountentry");
        selector.add("depositentry");
        selector.add("depositentry.dpbillno");
        selector.add("depositentry.dpdeductamount");
        selector.add("depositentry.dpbillnos_tag");
        selector.add("depositentry.dpbillnos");
        selector.add("depositentry.revenueway");
        selector.add("billno");
        selector.add("isrejectrefund");
        selector.add("bizdate");
        selector.add("isrepaygen");
        selector.add("billamt");
        selector.add("agreerate");
        selector.add("alldiscountinterest");
        selector.add("owndiscountinterest");
        selector.add("agreepayertype");
        selector.add("payerofinterest");
        selector.add("payerofinterestname");
        selector.add("payinterbankaccount");
        selector.add("payinteropenbank");
        selector.add("payinterestamount");
        selector.add("dis_payinterestamount");
        selector.add("payinteramount_bank");
        selector.add("payerofinteresttype");
        selector.add("dis_owninterest_bank");
        selector.add("dis_payinterest_bank");
        selector.add("dis_subamount");
        selector.add("isgenbysplit");
        selector.add("euqaldifferetype");
        selector.add("isneedsplit");
        selector.add("billoldelestatus");
        selector.add("equalamount");
        selector.add("ispaybyagree");
        selector.add("billlogid");
        selector.add("discountentry.dis_selectbillid");
        selector.add("discountentry.dis_days");
        selector.add("pledgeetype");
        selector.add("pledgeetext");
        selector.add("pledgeebase");
        selector.add("isequalsplit");
        selector.add("subentrys");
        selector.add("e_subbillamount");
        selector.add("isnotneedgen");
        selector.add("pledgeeaccounttext");
        selector.add("pledgeeaccount");
        selector.add("pledgeeopenbank");
        selector.add("pledgeetypebase");
        selector.add("isrejectrefundgen");
        selector.add("deducttype");
        selector.add("isdrawfail");
        selector.add("depositentry.dinterestamount");
        selector.add("entrys.entryisrejectrefund");
        selector.add("entrys.entryisrepay");
        selector.add("entrys.draftbillstatus");
        return selector;
    }

    public TradeBillDrawBillService(List<String> lockDraftIdList) {
        this.successLockDraftIdList = lockDraftIdList;
    }

    public void beforeProcess(List<ExtendedDataEntity> dataEntities) throws KDException {
        block5: {
            super.beforeProcess(dataEntities);
            boolean isSuccess = false;
            Map variables = this.getOperationVariable();
            String isdrawfail = (String)variables.get("isdrawfail");
            boolean isDrawFail = "y".equals(isdrawfail);
            if (isDrawFail) {
                this.isDrawDail = true;
                return;
            }
            try {
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObjectCollection entry;
                    Object[] pledgedArray;
                    DynamicObject tradeBill = dataEntity.getDataEntity();
                    String tradeType = tradeBill.getString("tradetype");
                    if (!DraftTradeTypeEnum.COLLECT.getValue().equals(tradeType) || (pledgedArray = (entry = tradeBill.getDynamicObjectCollection("entrys")).stream().filter(o -> "pledged".equals(o.getDynamicObject("draftbill").getString("draftbillstatus"))).map(o -> o.getDynamicObject("draftbill").getPkValue()).toArray()).length == 0) continue;
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("tradeType", DraftTradeTypeEnum.RLSPLEDGE.getValue());
                    option.setVariableValue("isPledged", "true");
                    option.setVariableValue("tradeBillId", tradeBill.getPkValue().toString());
                    OperationResult operationResult = OperationServiceHelper.executeOperate((String)"autorlspledge", (String)"cdm_receivablebill", (Object[])pledgedArray, (OperateOption)option);
                    isSuccess = operationResult.isSuccess();
                    if (!isSuccess) {
                        String errMsg = TmcOperateServiceHelper.decodeErrorMsg((OperationResult)operationResult);
                        throw new KDException(new ErrorCode("autorlspledge--Exception", errMsg), new Object[]{errMsg});
                    }
                    QFilter qFilter = new QFilter("entrys.draftbill.id", "in", (Object)operationResult.getSuccessPkIds().toArray());
                    qFilter.and(new QFilter("entrys.draftbill.draftbillstatus", "=", (Object)"pledged"));
                    qFilter.and(new QFilter("tradetype", "=", (Object)DraftTradeTypeEnum.RLSPLEDGE.getValue()));
                    DynamicObject[] draftTradeBills = BusinessDataServiceHelper.load((String)"cdm_drafttradebill", (String)"id", (QFilter[])new QFilter[]{qFilter});
                    if (draftTradeBills.length <= 0) continue;
                    Object[] tradeBillIds = Arrays.stream(draftTradeBills).map(o -> o.getLong("id")).toArray();
                    this.dealPledgedToRegistered(tradeBillIds);
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                if (isSuccess) break block5;
                throw new KDException(new ErrorCode("beforeProcess--Exception", e.getMessage()), new Object[]{e.getMessage()});
            }
        }
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        logger.info("TradeBillDrawBillService is start" + dataEntities[0].getString("billno"));
        Map variables = this.getOperationVariable();
        String isdrawfail = (String)variables.get("isdrawfail");
        boolean isDrawFail = "y".equals(isdrawfail);
        boolean formEleUpdate = Boolean.parseBoolean(this.operationVariable.getOrDefault("COMPLETEFROM_ELEUPDATE", "false"));
        boolean rejectRefund = Boolean.parseBoolean(this.operationVariable.getOrDefault("rejectRefund", "false"));
        boolean isrepayrecall = Boolean.parseBoolean(this.operationVariable.getOrDefault("isrepayrecall", "false"));
        boolean isRepayOrReJect = rejectRefund || isrepayrecall;
        logger.info("formEleUpdate :" + formEleUpdate + ",rejectRefund ,isrepayrecall " + isrepayrecall + ",isRepayOrReJect " + isRepayOrReJect);
        for (DynamicObject data : dataEntities) {
            Date bizfinishdate;
            boolean needReCalcAmount;
            Object[] elePayDealArr;
            boolean isDeductPosit;
            DynamicObject[] draftArr = TradeBillHelper.getDraftArrByTradeBillArr((DynamicObject[])new DynamicObject[]{data});
            Map<Long, DynamicObject> idAndbillMap = Arrays.stream(draftArr).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
            boolean headIsRepayOrRejectRefund = data.getBoolean("isrepay") || data.getBoolean("isrejectrefund");
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("entrys");
            HashSet<String> needDealPayOffBillSet = new HashSet<String>(16);
            HashSet<Long> needDealCollectBillSet = new HashSet<Long>(16);
            for (DynamicObject entry : entrys) {
                DynamicObject draft = entry.getDynamicObject("draftbill");
                long draftBillId = draft.getLong("id");
                DynamicObject newDraft = idAndbillMap.get(draftBillId);
                BigDecimal usedAmount = newDraft.getBigDecimal("usedamount");
                BigDecimal originalsubbillamount = newDraft.getBigDecimal("originalsubbillamount");
                BigDecimal billamt = entry.getBigDecimal("billamt");
                boolean isEleDraft = "2".equals(data.getDynamicObject("drafttype").getString("billmedium"));
                if (isEleDraft) {
                    boolean isRemainBill;
                    boolean bl = isRemainBill = originalsubbillamount.compareTo(billamt.add(usedAmount)) == 0;
                    if (isRemainBill) {
                        entry.set("isneedsplit", (Object)false);
                    } else {
                        entry.set("isneedsplit", (Object)true);
                    }
                } else {
                    String tradeType = data.getString("tradetype");
                    if (DraftTradeTypeEnum.BILLSPLIT.getValue().equals(tradeType)) {
                        boolean isRemainBill;
                        boolean bl = isRemainBill = originalsubbillamount.compareTo(billamt.add(usedAmount)) == 0;
                        if (isRemainBill) {
                            entry.set("isneedsplit", (Object)false);
                        } else {
                            entry.set("isneedsplit", (Object)true);
                        }
                    } else {
                        entry.set("isneedsplit", (Object)false);
                    }
                }
                entry.set("oldstatus", (Object)entry.getDynamicObject("draftbill").getString("draftbillstatus"));
            }
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{data});
            Map<Object, Object> billLogIdAndSubBillMap = new HashMap(8);
            billLogIdAndSubBillMap = this.getSupperIdAndSubRecDyData(formEleUpdate, isRepayOrReJect || headIsRepayOrRejectRefund, data, isDrawFail);
            HashSet<DynamicObject> draftBillSet = new HashSet<DynamicObject>();
            HashSet<Long> recBillSet = new HashSet<Long>(8);
            for (DynamicObject entry : entrys) {
                Object[] draft = entry.getDynamicObject("draftbill");
                String tranStatus = entry.getString("transtatus");
                String draftBillStatus = draft.getString("draftbillstatus");
                if ((isRepayOrReJect || headIsRepayOrRejectRefund) && StringUtils.equals((CharSequence)tranStatus, (CharSequence)DraftTranStatusEnum.SUCCESS.getValue()) && !StringUtils.equals((CharSequence)draftBillStatus, (CharSequence)DraftBillStatusEnum.REGISTERED.getValue())) continue;
                long draftBillId = draft.getLong("id");
                DynamicObject newDraft = idAndbillMap.get(draftBillId);
                DynamicObject subBill = (DynamicObject)billLogIdAndSubBillMap.get(draftBillId);
                boolean isSplit = false;
                if (null != subBill) {
                    newDraft = subBill;
                    isSplit = true;
                    entry.set("isneedsplit", (Object)true);
                } else {
                    BigDecimal availableAmount = newDraft.getBigDecimal("availableamount");
                    if (BigDecimal.ZERO.compareTo(availableAmount) < 0) {
                        entry.set("isneedsplit", (Object)true);
                    } else {
                        entry.set("isneedsplit", (Object)false);
                    }
                }
                if (isDrawFail) {
                    entry.set("transtatus", (Object)DraftTranStatusEnum.FAILING.getValue());
                    continue;
                }
                String transtatus = entry.getString("transtatus");
                this.fillDraftBillInfo(data, formEleUpdate, rejectRefund, isrepayrecall, newDraft, isSplit, transtatus, needDealPayOffBillSet, needDealCollectBillSet);
                draftBillSet.add(newDraft);
                recBillSet.add(newDraft.getLong("id"));
            }
            if (isDrawFail) {
                data.set("draftbilltranstatus", (Object)DraftTranStatusEnum.FAILING.getValue());
                data.set("isdrawfail", (Object)true);
                continue;
            }
            logger.info("draftBillSet size:" + draftBillSet.size());
            boolean isPayOff = DraftTradeTypeEnum.PAYOFF.getValue().equals(data.getString("tradetype"));
            if (isPayOff && (isDeductPosit = data.getBoolean("depositdeduct"))) {
                this.pushGmDepositBill(data);
            }
            SaveServiceHelper.update((DynamicObject[])draftBillSet.toArray(new DynamicObject[0]));
            if (EmptyUtil.isNoEmpty(needDealPayOffBillSet) && EmptyUtil.isNoEmpty((Object[])(elePayDealArr = BusinessDataServiceHelper.load((String)"cdm_electronic_pay_deal", (String)"id,notestatus,billno,cirstatus", (QFilter[])new QFilter[]{new QFilter("billno", "in", needDealPayOffBillSet)})))) {
                logger.info("needDealPayOffBillSet is start");
                for (Object elePayDeal : elePayDealArr) {
                    elePayDeal.set("notestatus", (Object)EleDraftNoteStatusEnum.CS06.getValue());
                    elePayDeal.set("cirstatus", (Object)EleDraftCirStatusEnum.TF0501.getValue());
                }
                SaveServiceHelper.save((DynamicObject[])elePayDealArr);
            }
            if (EmptyUtil.isNoEmpty(needDealCollectBillSet)) {
                logger.info("needDealCollectBillSet is start");
                Object[] eleRecDealArr = BusinessDataServiceHelper.load((String)"cdm_electronic_sign_deal", (String)"id,notestatus,billno,cirstatus,subrange,rptype", (QFilter[])new QFilter[]{new QFilter("sourceid", "in", needDealCollectBillSet), new QFilter("rptype", "=", (Object)"receivebill")});
                if (EmptyUtil.isNoEmpty((Object[])eleRecDealArr)) {
                    for (Object eleRecDeal : eleRecDealArr) {
                        eleRecDeal.set("notestatus", (Object)EleDraftNoteStatusEnum.CS06.getValue());
                        eleRecDeal.set("cirstatus", (Object)EleDraftCirStatusEnum.TF0501.getValue());
                    }
                    SaveServiceHelper.save((DynamicObject[])eleRecDealArr);
                }
            }
            String src = data.getString("source");
            boolean isRepay = data.getBoolean("isrepay");
            boolean isNeedCallPay = !EmptyUtil.isEmpty((String)data.getString("sourcebillid")) && "cas".equals(src) && !isRepay && !isrepayrecall;
            String sourcePayBillid = "";
            if (!isNeedCallPay) {
                sourcePayBillid = DraftHelper.checkReleatedByPayBillSelectEndorseBill((DynamicObject)data);
            }
            this.genOppRecBill(data, isRepayOrReJect);
            boolean isSubmitEle = data.getBoolean("electag");
            boolean isrepaygen = data.getBoolean("isrepaygen");
            boolean isrejectrefund = data.getBoolean("isrejectrefund");
            String headTransStatus = DraftTranStatusEnum.SUCCESS.getValue();
            logger.info("isSubmitEle is that:" + isSubmitEle + ",formEleUpdate is:" + formEleUpdate + ",isRepay is:" + isRepay + ",isrejectrefund :" + isrejectrefund + ",isrepaygen :" + isrepaygen);
            if (isSubmitEle || formEleUpdate || isrepaygen) {
                if (!formEleUpdate && isrepaygen && !rejectRefund) {
                    DynamicObjectCollection entryList = data.getDynamicObjectCollection("entrys");
                    for (DynamicObject entry : entryList) {
                        entry.set("transtatus", (Object)DraftTranStatusEnum.SUCCESS.getValue());
                    }
                } else {
                    headTransStatus = data.getString("draftbilltranstatus");
                    boolean hasFailedRec = false;
                    boolean hasSuccessRec = false;
                    DynamicObjectCollection entryList = data.getDynamicObjectCollection("entrys");
                    for (DynamicObject entry : entryList) {
                        String transStatus = entry.getString("transtatus");
                        if (DraftTranStatusEnum.SUCCESS.getValue().equals(transStatus)) {
                            hasSuccessRec = true;
                            continue;
                        }
                        if (!DraftTranStatusEnum.FAILING.getValue().equals(transStatus)) continue;
                        hasFailedRec = true;
                    }
                    if (hasFailedRec && hasSuccessRec) {
                        headTransStatus = DraftTranStatusEnum.PORSUCCESS.getValue();
                    } else if (hasFailedRec) {
                        headTransStatus = DraftTranStatusEnum.FAILING.getValue();
                        data.set("electag", (Object)"0");
                    } else if (hasSuccessRec) {
                        headTransStatus = DraftTranStatusEnum.SUCCESS.getValue();
                    }
                }
            } else {
                DynamicObjectCollection entryList = data.getDynamicObjectCollection("entrys");
                for (DynamicObject entry : entryList) {
                    entry.set("transtatus", (Object)DraftTranStatusEnum.SUCCESS.getValue());
                }
            }
            data.set("draftbilltranstatus", (Object)headTransStatus);
            String tradeType = data.getString("tradetype");
            boolean bl = needReCalcAmount = DraftTradeTypeEnum.ENDORSE.getValue().equals(tradeType) || DraftTradeTypeEnum.DISCOUNT.getValue().equals(tradeType) || DraftTradeTypeEnum.COLLECT.getValue().equals(tradeType);
            if ((isSubmitEle || formEleUpdate) && needReCalcAmount) {
                TradeBillAmountHelper.calcTradeBillAmount((DynamicObject)data);
            }
            this.dealPushTrade(data);
            String billno = data.getString("billno");
            logger.info("billno is that:" + billno + ",isRepay is:" + isRepay + ",rejectRefund is:" + rejectRefund + ",isNeedCallPay is:" + isNeedCallPay);
            if (isNeedCallPay || EmptyUtil.isNoEmpty((String)sourcePayBillid)) {
                Date bizFinishDate = data.getDate("bizdate");
                boolean isEle = "2".equals(data.getDynamicObject("drafttype").getString("billmedium"));
                logger.info("isSubmitEle is:" + isSubmitEle + ",isEle:" + isEle);
                if (isSubmitEle && isEle) {
                    bizFinishDate = new Date();
                    data.set("bizfinishdate", (Object)bizFinishDate);
                } else {
                    Date bizFinishDateNew = data.getDate("bizfinishdate");
                    if (EmptyUtil.isEmpty((Object)bizFinishDateNew)) {
                        data.set("bizfinishdate", (Object)data.getDate("bizdate"));
                    }
                    bizFinishDate = data.getDate("bizfinishdate");
                }
                logger.info("bizFinishDate is:" + bizFinishDate);
                String sourcebillid = data.getString("sourcebillid");
                if (!isNeedCallPay && EmptyUtil.isNoEmpty((String)sourcePayBillid)) {
                    sourcebillid = sourcePayBillid;
                }
                logger.info("sourcebillid is:" + sourcebillid + ",sourcePayBillid is:" + sourcePayBillid);
                this.genPurPay(sourcebillid, data.getString("id"), bizFinishDate);
            }
            if (isNeedCallPay || EmptyUtil.isNoEmpty((String)sourcePayBillid)) {
                Set needUpdatePayBillDySet;
                String sourcebillid = data.getString("sourcebillid");
                if (!isNeedCallPay && EmptyUtil.isNoEmpty((String)sourcePayBillid)) {
                    sourcebillid = sourcePayBillid;
                }
                logger.info("sourcebillid is:" + sourcebillid + ",sourcePayBillid is:" + sourcePayBillid);
                long sourCasBillId = Long.parseLong(sourcebillid);
                Object[] recBillArr = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,releatedcasbillentrys,releatedcasbillentrys.rel_billtype,releatedcasbillentrys.rel_billno,releatedcasbillentrys.rel_billid,releatedcasbillentrys.rel_bizdate,releatedcasbillentrys.rel_billamount,releatedcasbillentrys.rel_isrefuse,releatedcasbillentrys.rel_modifytime,releatedcasbillentrys.rel_createtime", (QFilter[])new QFilter[]{new QFilter("id", "in", recBillSet), new QFilter("rptype", "=", (Object)"receivebill")});
                Set payBillDatas = DraftHelper.getPayBillDatas(recBillSet, (long)sourCasBillId, (boolean)false, (boolean)false);
                Set sourceRecBillSet = DraftHelper.getSourceSuccDraftBillWhenRepay((boolean)rejectRefund, (boolean)isrepayrecall, (DynamicObject)data);
                if (EmptyUtil.isNoEmpty((Object[])recBillArr)) {
                    Set needUpdateRecDySet;
                    Set recBillDatas = Arrays.stream(recBillArr).collect(Collectors.toSet());
                    if (EmptyUtil.isNoEmpty((Object)sourceRecBillSet)) {
                        if (!rejectRefund) {
                            recBillDatas.addAll(sourceRecBillSet);
                        } else {
                            recBillDatas = sourceRecBillSet;
                        }
                    }
                    if (EmptyUtil.isNoEmpty((Object)(needUpdateRecDySet = DraftHelper.updateDratBillCasEntry((Set)recBillDatas, (String)"cas_paybill", (String)"add", (Long)sourCasBillId)))) {
                        SaveServiceHelper.save((DynamicObject[])needUpdateRecDySet.toArray(new DynamicObject[0]));
                    }
                }
                if (EmptyUtil.isNoEmpty((Object)(needUpdatePayBillDySet = DraftHelper.updateDratBillCasEntry((Set)payBillDatas, (String)"cas_paybill", (String)"add", (Long)sourCasBillId)))) {
                    SaveServiceHelper.save((DynamicObject[])needUpdatePayBillDySet.toArray(new DynamicObject[0]));
                }
            }
            if ((bizfinishdate = data.getDate("bizfinishdate")) != null) continue;
            data.set("bizfinishdate", (Object)new Date());
        }
        TmcDataServiceHelper.save((DynamicObject[])dataEntities);
        logger.info("TradeBillDrawBillService is end!");
    }

    private void syncAllocBill(DynamicObject data) {
        String headTransStatus = data.getString("draftbilltranstatus");
        boolean isRepay = data.getBoolean("isrepay");
        String sourceType = data.getString("sourcebilltype");
        logger.info("headTransStatus is:" + headTransStatus + ",sourceType is:" + sourceType + ",isRepay is:" + isRepay);
        if (!DraftTranStatusEnum.FAILING.getValue().equals(headTransStatus) && "cdm_draftallocation".equals(sourceType) && !isRepay) {
            logger.info("sync allocation is start:" + data.getString("billno"));
            boolean isSuccess = new TradeBillSyncTransBillService(data).sync();
            if (!isSuccess) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7968\u636e\u8c03\u5ea6\u5355\u540c\u6b65\u5931\u8d25", (String)"TradeBillDrawBillService_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            this.dealIntoPool(data);
        }
        logger.info("sync allocation is end:" + data.getString("billno"));
    }

    private void dealIntoPool(DynamicObject data) {
        try {
            logger.info("sync allocation is end and start to into pool:" + data.getString("billno"));
            Set draftBillIdSet = data.getDynamicObjectCollection("entrys").stream().filter(e -> e.getBoolean("isneedsplit")).map(x -> x.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toSet());
            if (EmptyUtil.isNoEmpty(draftBillIdSet)) {
                QFilter poolQFilter = new QFilter("billpool", "=", (Object)0);
                QFilter idQFilter = new QFilter("id", "in", draftBillIdSet);
                Object[] subBillArr = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,billno,billpool", (QFilter[])new QFilter[]{idQFilter, poolQFilter});
                if (EmptyUtil.isNoEmpty((Object[])subBillArr)) {
                    logger.info("intopool start needInPoolList");
                    TmcOperateServiceHelper.execOperate((String)"intopool", (String)"cdm_receivablebill", (DynamicObject[])subBillArr, (OperateOption)OperateOption.create());
                    logger.info("intopool end,to save bills");
                } else {
                    logger.info("subBillArr is null");
                }
            }
        }
        catch (Exception e2) {
            logger.error("intopool has exception:", (Throwable)e2);
        }
    }

    private void genOppRecBill(DynamicObject data, boolean isRepayOrReJect) {
        String tradeType = data.getString("tradetype");
        long draftALlocId = data.getLong("allocbillentryid");
        Object companyId = PayableBillHelp.getCompanyIdByBeen((DynamicObject)data);
        logger.info("companid is that:" + SerializationUtils.toJsonString((Object)companyId));
        String billSourceStr = data.getString("source");
        boolean isFromAoll = false;
        if ("cdm-draftallocate".equals(billSourceStr)) {
            isFromAoll = true;
        }
        logger.info("isFromAoll is that:" + isFromAoll);
        if (EmptyUtil.isNoEmpty((Object)companyId) && (DraftTradeTypeEnum.ENDORSE.getValue().equals(tradeType) || isFromAoll)) {
            logger.info("is start oppnote");
            boolean isReceiveOppNote = DraftHelper.getCdmParameterBoolean((long)((Long)companyId), (String)"isreceiveoppnote");
            Object[] bankrollDy = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,fisbankroll", (QFilter[])new QFilter[]{new QFilter("id", "=", companyId), new QFilter("fisbankroll", "=", (Object)"1")});
            String autoAllocationStr = (String)this.getOperationVariable().get("autoallocation");
            boolean autoAllocation = Boolean.parseBoolean(autoAllocationStr);
            logger.info("isRepayOrReJect is:" + isRepayOrReJect + ",autoAllocation is:" + autoAllocation + ",isReceiveOppNote is:" + isReceiveOppNote + "companyId is:" + companyId + "is isbankroll?" + EmptyUtil.isNoEmpty((Object[])bankrollDy));
            if (EmptyUtil.isNoEmpty((Object[])bankrollDy) && (isReceiveOppNote || autoAllocation || isFromAoll)) {
                OperationResult operationResult;
                DynamicObjectCollection selectedReceivableBills = data.getDynamicObjectCollection("entrys");
                String selectFields = "id,subbillrange,billno,company,delivername";
                for (DynamicObject selectedReceivableBill : selectedReceivableBills) {
                    boolean isSplit = selectedReceivableBill.getDynamicObject("draftbill").getBoolean("issplit");
                    String draftBillNo = selectedReceivableBill.getDynamicObject("draftbill").getString("draftbillno");
                    String transtatus = selectedReceivableBill.getString("transtatus");
                    boolean isSucc = DraftTranStatusEnum.SUCCESS.getValue().equals(transtatus);
                    DynamicObject recBill = TmcDataServiceHelper.loadSingle((Object)selectedReceivableBill.getDynamicObject("draftbill").getPkValue(), (String)"cdm_receivablebill");
                    boolean isNotneedgen = selectedReceivableBill.getBoolean("isnotneedgen");
                    logger.info("draftBillNo is isNotneedgen :" + isNotneedgen);
                    if ((isRepayOrReJect || selectedReceivableBill.getBoolean("entryisrejectrefund") || selectedReceivableBill.getBoolean("entryisrepay")) && !isSucc || isNotneedgen) {
                        selectedReceivableBill.set("isnotneedgen", (Object)true);
                        logger.info("draftBillNo is rejectRefund but failed:" + draftBillNo);
                        continue;
                    }
                    selectedReceivableBill.set("isnotneedgen", (Object)false);
                    String settlementType = recBill.getDynamicObject("draftbilltype").getString("settlementtype");
                    QFilter statusFilter = new QFilter("draftbillstatus", "=", (Object)DraftBillStatusEnum.REGISTERED.getValue());
                    QFilter noteNoFilter = new QFilter("draftbillno", "=", (Object)draftBillNo);
                    QFilter rpTypeFilter = new QFilter("rptype", "=", (Object)"receivebill");
                    QFilter billStatusFilter = new QFilter("billstatus", "!=", (Object)"H");
                    QFilter idFilter = new QFilter("id", "!=", (Object)recBill.getLong("id"));
                    QFilter settlementTypeFilter = settlementType.equals(SettleMentTypeEnum.BUSINESS.getValue()) || settlementType.equals(SettleMentTypeEnum.BANK.getValue()) ? new QFilter("draftbilltype.settlementtype", "in", (Object)new String[]{SettleMentTypeEnum.BUSINESS.getValue(), SettleMentTypeEnum.BANK.getValue()}) : new QFilter("draftbilltype.settlementtype", "=", (Object)settlementType);
                    DynamicObject[] recBillColl = TmcDataServiceHelper.load((String)"cdm_receivablebill", (String)selectFields, (QFilter[])new QFilter[]{statusFilter, noteNoFilter, settlementTypeFilter, rpTypeFilter, billStatusFilter, idFilter});
                    DynamicObject[] recBillCollnew = TmcDataServiceHelper.load((String)"cdm_receivablebill", (String)selectFields, (QFilter[])new QFilter[]{noteNoFilter});
                    if (!isSplit && recBillColl.length > 0) {
                        logger.info(" not split recBillColl is that:" + recBillColl.length + ", is that:" + Arrays.stream(recBillColl).map(e -> e.getString("billno")).collect(Collectors.toSet()));
                        logger.info(" not split recBillCollnew is that:" + recBillCollnew.length + ", is that:" + Arrays.stream(recBillCollnew).map(e -> e.getString("billno")).collect(Collectors.toSet()));
                        boolean isNotNeedGen = this.isExistBeendorBill(recBillColl, data, (Long)companyId);
                        selectedReceivableBill.set("isnotneedgen", (Object)isNotNeedGen);
                        continue;
                    }
                    if (isSplit && recBillColl.length > 0) {
                        logger.info("recBillColl is that:" + recBillColl.length + ", is that:" + Arrays.stream(recBillColl).map(e -> e.getString("billno")).collect(Collectors.toSet()));
                        logger.info(" not split recBillCollnew is that:" + recBillCollnew.length + ", is that:" + Arrays.stream(recBillCollnew).map(e -> e.getString("billno")).collect(Collectors.toSet()));
                        String subBillRange = selectedReceivableBill.getDynamicObject("draftbill").getString("subbillrange");
                        Long startFlag = Long.valueOf(subBillRange.split("-", -1)[0]);
                        Long endFlag = Long.valueOf(subBillRange.split("-", -1)[1]);
                        for (DynamicObject receivableBill : recBillColl) {
                            String subBillRangeFrombase = receivableBill.getString("subbillrange");
                            if (!this.isRepeatDraftBillNo(subBillRangeFrombase, startFlag, endFlag)) continue;
                            boolean isNotNeedGen = this.isExistBeendorBill(recBillColl, data, (Long)companyId);
                            logger.info("isNotNeedGen is that:" + isNotNeedGen);
                            selectedReceivableBill.set("isnotneedgen", (Object)isNotNeedGen);
                        }
                        continue;
                    }
                    logger.info("recBillColl is null:");
                }
                List needGenDraftBillNos = selectedReceivableBills.stream().filter(o -> !o.getBoolean("isnotneedgen")).map(v -> v.getDynamicObject("draftbill").getString("draftbillno")).collect(Collectors.toList());
                logger.info("needGenDraftBillNos size:" + needGenDraftBillNos.size() + ",needGenDraftBillNos:" + SerializationUtils.toJsonString(needGenDraftBillNos));
                if (EmptyUtil.isEmpty(needGenDraftBillNos)) {
                    return;
                }
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{data});
                OperateOption operateOption = OperateOption.create();
                if (isFromAoll) {
                    operateOption.setVariableValue("autoallocation", "y");
                }
                if (EmptyUtil.isNoEmpty((Object)(operationResult = TmcOperateServiceHelper.execOperate((String)"pushrece", (String)"cdm_drafttradebill", (DynamicObject[])new DynamicObject[]{data}, (OperateOption)operateOption))) && EmptyUtil.isNoEmpty((Object)operationResult.getAllErrorInfo())) {
                    List allErrorInfo = operationResult.getAllErrorInfo();
                    ArrayList<String> errorList = new ArrayList<String>(8);
                    for (OperateErrorInfo opinfo : allErrorInfo) {
                        errorList.add(opinfo.getMessage());
                    }
                    logger.info("pushrece has exception:" + SerializationUtils.toJsonString(errorList));
                }
                for (DynamicObject selectedReceivableBill : selectedReceivableBills) {
                    selectedReceivableBill.set("isnotneedgen", (Object)false);
                }
            }
        }
    }

    private boolean isExistBeendorBill(DynamicObject[] recBillColl, DynamicObject data, long beendorsorCompanyId) {
        boolean isNotNeedGen = false;
        String companyName = data.getDynamicObject("company").getString("name");
        for (DynamicObject receivableBill : recBillColl) {
            long billCompanyId = receivableBill.getDynamicObject("company").getLong("id");
            String deliverName = receivableBill.getString("delivername");
            if (!EmptyUtil.equals((CharSequence)deliverName, (CharSequence)companyName) || beendorsorCompanyId != billCompanyId) continue;
            isNotNeedGen = true;
            break;
        }
        return isNotNeedGen;
    }

    private Map<Long, DynamicObject> getSupperIdAndSubRecDyData(boolean formEleUpdate, boolean isRepayOrReJect, DynamicObject data, boolean isDrawFail) {
        Map<Object, Object> billLogIdAndSubBillMap = new HashMap(8);
        DynamicObjectCollection entrys = data.getDynamicObjectCollection("entrys");
        if (isRepayOrReJect) {
            Object[] draftbillLogs;
            HashSet<Long> billLogIdSet = new HashSet<Long>();
            for (DynamicObject entry : entrys) {
                String transStatus = entry.getString("transtatus");
                if (!DraftTranStatusEnum.SUCCESS.getValue().equals(transStatus)) continue;
                long billlogid = entry.getLong("billlogid");
                billLogIdSet.add(billlogid);
            }
            if (EmptyUtil.isNoEmpty(billLogIdSet) && EmptyUtil.isNoEmpty((Object[])(draftbillLogs = BusinessDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id,splitedsubbillid,issplit", (QFilter[])new QFilter[]{new QFilter("id", "in", billLogIdSet), new QFilter("issplit", "=", (Object)"1")})))) {
                Set<Object> subBillRecIdSet = Arrays.stream(draftbillLogs).map(e -> e.getLong("splitedsubbillid")).collect(Collectors.toSet());
                DynamicObject[] subBillArr = BusinessDataServiceHelper.load((Object[])subBillRecIdSet.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbillf7"));
                billLogIdAndSubBillMap = Arrays.stream(subBillArr).collect(Collectors.toMap(e -> e.getLong("supperbillid"), e -> e));
            }
            IDraftOperateService instance = IDraftOperateService.getInstance();
            DraftOperateInfo draftOperateInfo = LockDraftHelper.fillOperateInfo(formEleUpdate, data, 0L, isRepayOrReJect);
            boolean isequalsplit = data.getBoolean("isequalsplit");
            draftOperateInfo.setIsequalsplit(isequalsplit);
            draftOperateInfo.setDrawfail(isDrawFail);
            if (!EmptyUtil.isEmpty(draftOperateInfo.getDraftOperateSubInfoList())) {
                List<DraftOperateResultInfo> draftOperateResultList = instance.confirm(draftOperateInfo);
                this.fillBillLogId(data, draftOperateResultList);
            }
        } else {
            IDraftOperateService instance = IDraftOperateService.getInstance();
            DraftOperateInfo draftOperateInfo = LockDraftHelper.fillOperateInfo(formEleUpdate, data, 0L, false);
            boolean isequalsplit = data.getBoolean("isequalsplit");
            draftOperateInfo.setIsequalsplit(isequalsplit);
            draftOperateInfo.setDrawfail(isDrawFail);
            List<DraftOperateResultInfo> draftOperateResultInfoList = instance.confirm(draftOperateInfo);
            this.fillBillLogId(data, draftOperateResultInfoList);
            billLogIdAndSubBillMap = draftOperateResultInfoList.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getSubBillDy())).collect(Collectors.toMap(e -> e.getDraftId(), e -> e.getSubBillDy()));
        }
        return billLogIdAndSubBillMap;
    }

    private void fillBillLogId(DynamicObject data, List<DraftOperateResultInfo> draftOperateResultInfoList) {
        Map<Long, Long> draftIdAndLogIdMap = draftOperateResultInfoList.stream().collect(Collectors.toMap(e -> e.getDraftId(), e -> e.getLogid()));
        DynamicObjectCollection dynamicObjectCollection = data.getDynamicObjectCollection("entrys");
        for (DynamicObject entry : dynamicObjectCollection) {
            Long logIdFromNewAdd;
            long draftId = entry.getDynamicObject("draftbill").getLong("id");
            long logId = entry.getLong("billlogid");
            if (!EmptyUtil.isEmpty((Long)logId) || !EmptyUtil.isNoEmpty(draftIdAndLogIdMap) || !EmptyUtil.isNoEmpty((Long)(logIdFromNewAdd = draftIdAndLogIdMap.get(draftId)))) continue;
            entry.set("billlogid", (Object)logIdFromNewAdd);
        }
    }

    private void dealPushTrade(DynamicObject data) {
        Set draftIdSet;
        boolean isReFund = DraftTradeTypeEnum.REFUND.getValue().equals(data.getString("tradetype"));
        boolean iSplit = DraftTradeTypeEnum.BILLSPLIT.getValue().equals(data.getString("tradetype"));
        boolean isPayOff = DraftTradeTypeEnum.PAYOFF.getValue().equals(data.getString("tradetype"));
        boolean isequalsplit = data.getBoolean("isequalsplit");
        DynamicObjectCollection entrys = data.getDynamicObjectCollection("entrys");
        HashSet paybillIds = new HashSet(8);
        boolean isrejectrefundgen = data.getBoolean("isrejectrefundgen");
        long draftTradeBillId = data.getLong("id");
        if (isrejectrefundgen && EmptyUtil.isNoEmpty((Long)draftTradeBillId)) {
            HashSet payBillIds;
            Map sourceBillsMap = BFTrackerServiceHelper.findSourceBills((String)"cdm_drafttradebill", (Long[])new Long[]{draftTradeBillId});
            if (EmptyUtil.isNoEmpty((Object)sourceBillsMap) && EmptyUtil.isNoEmpty((Object)(payBillIds = (HashSet)sourceBillsMap.get("cas_paybill")))) {
                paybillIds.addAll(payBillIds);
            }
        } else {
            entrys.stream().map(item -> item.getDynamicObject("draftbill").getLong("id")).forEach(draftBillId -> {
                List tBillIds = DraftHelper.getBillIds((Long)draftBillId, (boolean)true, (String)"cas_paybill");
                paybillIds.addAll(tBillIds);
            });
        }
        if (isPayOff && EmptyUtil.isNoEmpty(draftIdSet = entrys.stream().filter(e -> EmptyUtil.isNoEmpty((DynamicObject)e.getDynamicObject("draftbill").getDynamicObject("inneraccount")) && EmptyUtil.isNoEmpty((Long)e.getDynamicObject("draftbill").getDynamicObject("inneraccount").getLong("id"))).map(item -> item.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toSet()))) {
            OperateOption operateOption = OperateOption.create();
            OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"pushifmdeduction", (String)"cdm_drafttradebill", (DynamicObject[])new DynamicObject[]{data}, (OperateOption)operateOption);
        }
        logger.info("isReFund,paybillIds.size:" + paybillIds.size());
        if (isReFund && entrys != null && paybillIds.size() > 0) {
            this.redOrderOffset(data, entrys, isrejectrefundgen);
        }
        if (iSplit && !isequalsplit) {
            String rpType = ((DynamicObject)data.getDynamicObjectCollection("entrys").get(0)).getDynamicObject("draftbill").getString("rptype");
            boolean isRec = rpType.equals("receivebill");
            this.pushSplitBill(data, isRec);
        }
    }

    private boolean fillDraftBillInfo(DynamicObject tradeBill, boolean formEleUpdate, boolean rejectRefund, boolean isrepayrecall, DynamicObject draft, boolean isSplit, String transStatus, Set<String> needDealPayOffBillSet, Set<Long> needDealCollectBillSet) {
        String recBodyName;
        String beendorsor;
        long billId = draft.getLong("id");
        boolean isSubmitEle = draft.getBoolean("electag");
        boolean isRepay = tradeBill.getBoolean("isrepay");
        Date bizdate = tradeBill.getDate("bizdate");
        if (EmptyUtil.isEmpty((Object)bizdate)) {
            bizdate = new Date();
        }
        boolean isrejectrefund = tradeBill.getBoolean("isrejectrefund");
        boolean isEleBills = "2".equals(tradeBill.getDynamicObject("drafttype").getString("billmedium"));
        logger.info("isSubmitEle is that:" + isSubmitEle + ",formEleUpdate is:" + formEleUpdate + ",isRepay is:" + isRepay + ",isrejectrefund :" + isrejectrefund + ",rejectRefund :" + rejectRefund + ",isrepayrecall:" + isrepayrecall + ",bizdate:" + bizdate + ",transStatus is:" + transStatus);
        if (!DraftTranStatusEnum.SUCCESS.getValue().equals(transStatus) && (isrepayrecall || rejectRefund || isRepay || isrejectrefund)) {
            logger.info("bill " + billId + "is continue because transStatus is " + transStatus);
            return true;
        }
        draft.set("draftbilltranstatus", (Object)DraftTranStatusEnum.SUCCESS.getValue());
        String tradeType = tradeBill.getString("tradetype");
        boolean isequalsplit = tradeBill.getBoolean("isequalsplit");
        String draftStatus = "";
        if ("rlspledge".equals(tradeType)) {
            Object[] tradeBills;
            boolean isequalbill = draft.getBoolean("isequalbill");
            boolean isfromequalspilt = draft.getBoolean("isfromequalspilt");
            long draftPkId = draft.getLong("id");
            if (isfromequalspilt && isequalbill) {
                draftPkId = draft.getLong("supperbillid");
            }
            if (EmptyUtil.isNoEmpty((Object[])(tradeBills = TmcDataServiceHelper.load((String)"cdm_drafttradebill", (String)"tradetype,entrys.oldstatus,entrys.draftbill,createtime", (QFilter[])new QFilter[]{new QFilter("entrys.draftbill.id", "in", (Object)new Object[]{draftPkId}), new QFilter("tradetype", "=", (Object)"pledge"), new QFilter("billstatus", "=", (Object)"C")}, (String)"createtime desc")))) {
                DynamicObjectCollection entrys = tradeBills[0].getDynamicObjectCollection("entrys");
                for (DynamicObject entry : entrys) {
                    if (draftPkId != entry.getDynamicObject("draftbill").getLong("id")) continue;
                    draftStatus = entry.getString("oldstatus");
                    break;
                }
            } else {
                logger.info("tradeBills is null");
                draftStatus = DraftBillStatusEnum.REGISTERED.getValue();
            }
            draft.set("pledgeenddate", null);
            draft.set("pledgeetype", null);
            draft.set("pledgeetext", null);
            draft.set("pledgeetypebase", null);
            draft.set("pledgeebase", null);
            draft.set("pledgeeaccounttext", null);
            draft.set("pledgeeaccount", null);
            draft.set("pledgeeopenbank", null);
            if (isEleBills) {
                String elccirculatestatus = draft.getString("elccirculatestatus");
                if (EmptyUtil.isEmpty((String)elccirculatestatus)) {
                    draft.set("eledraftstatus", (Object)"releaseofedgsigned");
                } else {
                    draft.set("elccirculatestatus", (Object)"TF0301");
                }
            }
        } else {
            draftStatus = DraftTradeTypeEnum.RETRIEVE.getValue().equals(tradeType) ? DraftBillStatusEnum.REGISTERED.getValue() : DraftBillStatusEnum.getValue((String)tradeType);
        }
        if ("payinterest".equals(tradeType)) {
            draft.set("ispayinterest", (Object)"1");
        }
        if (!"payinterest".equals(tradeType)) {
            String eleStatusStr;
            String elccirculatestatus;
            boolean isSplitTradeType = DraftTradeTypeEnum.BILLSPLIT.getValue().equals(tradeType);
            if (isSplitTradeType) {
                if (!isequalsplit) {
                    draft.set("draftbillstatus", (Object)draftStatus);
                }
            } else {
                draft.set("draftbillstatus", (Object)draftStatus);
            }
            logger.info("bill " + billId + " draftbillstatus is that " + draft.getString("draftbillstatus"));
            if (isEleBills && EmptyUtil.isEmpty((String)(elccirculatestatus = draft.getString("elccirculatestatus"))) && EmptyUtil.isNoEmpty((String)(eleStatusStr = this.setBillEleStatus(tradeType)))) {
                draft.set("eledraftstatus", (Object)eleStatusStr);
            }
        }
        if (DraftTradeTypeEnum.PLEDGE.getValue().equals(tradeType)) {
            Date draftbillexpiredate = draft.getDate("draftbillexpiredate");
            Date pledgeDate = tradeBill.getDate("pledgeenddate");
            if (pledgeDate.compareTo(draftbillexpiredate) > 0) {
                draft.set("pledgeenddate", (Object)draftbillexpiredate);
            } else {
                draft.set("pledgeenddate", (Object)pledgeDate);
            }
            draft.set("pledgeetype", (Object)tradeBill.getString("pledgeetype"));
            draft.set("pledgeetext", (Object)tradeBill.getString("pledgeetext"));
            draft.set("pledgeetypebase", (Object)tradeBill.getString("pledgeetypebase"));
            DynamicObject pledgeebase = tradeBill.getDynamicObject("pledgeebase");
            if (EmptyUtil.isNoEmpty((DynamicObject)pledgeebase)) {
                draft.set("pledgeebase", pledgeebase.getPkValue());
            }
            draft.set("pledgeeaccounttext", (Object)tradeBill.getString("pledgeeaccounttext"));
            draft.set("pledgeeaccount", tradeBill.get("pledgeeaccount"));
            DynamicObject pledgeeopenbank = tradeBill.getDynamicObject("pledgeeopenbank");
            if (EmptyUtil.isNoEmpty((DynamicObject)pledgeeopenbank)) {
                draft.set("pledgeeopenbank", pledgeeopenbank.getPkValue());
            }
        }
        if (!EmptyUtil.isEmpty((String)(beendorsor = tradeBill.getString("beendorsortext")))) {
            draft.set("beendorsor", (Object)beendorsor);
        }
        if (EmptyUtil.isNotBlank((CharSequence)(recBodyName = tradeBill.getString("recbodyname")))) {
            draft.set("recbody", (Object)recBodyName);
        }
        draft.set("use", tradeBill.get("description"));
        if (DraftTradeTypeEnum.PAYOFF.getValue().equals(tradeType)) {
            DynamicObject payableBill = TmcDataServiceHelper.loadSingle((Object)draft.getPkValue(), (String)"cdm_payablebill");
            DynamicObject creditLimit = payableBill.getDynamicObject("creditlimit");
            if (creditLimit != null) {
                this.returnCreditLimit(payableBill, bizdate);
            }
            draft.set("eledraftstatusnew", (Object)EleDraftNoteStatusEnum.CS06.getValue());
            draft.set("elccirculatestatus", (Object)EleDraftCirStatusEnum.TF0501.getValue());
            needDealPayOffBillSet.add(draft.getString("draftbillno"));
        } else if (DraftTradeTypeEnum.REFUND.getValue().equals(tradeType)) {
            draft.set("isrefund", (Object)"1");
            draft.set("refunddesc", (Object)tradeBill.getString("refunddesc"));
        } else if (DraftTradeTypeEnum.ENDORSE.getValue().equals(tradeType)) {
            draft.set("isrefund", (Object)"0");
        } else if (DraftTradeTypeEnum.COLLECT.getValue().equals(tradeType)) {
            draft.set("eledraftstatusnew", (Object)EleDraftNoteStatusEnum.CS06.getValue());
            draft.set("elccirculatestatus", (Object)EleDraftCirStatusEnum.TF0501.getValue());
            needDealCollectBillSet.add(draft.getLong("id"));
        }
        return false;
    }

    public void onReturnOperation(IOperationResult e) throws KDException {
        super.onReturnOperation(e);
        logger.info("TradeBillDrawBillService onReturnOperation start");
        if (CollectionUtils.isEmpty(this.successLockDraftIdList)) {
            logger.info("TradeBillDrawBillService successLockDraftIdList is null");
            return;
        }
        try {
            logger.info("release lock\uff1a" + JSON.toJSONString(this.successLockDraftIdList));
            Map releaseResultMap = MutexServiceHelper.batchRelease(this.successLockDraftIdList, (String)"tmc-cdm-business", (String)BILLTYPE);
            logger.info("releaseResultMap is:", (Object)SerializationUtils.toJsonString((Object)releaseResultMap));
        }
        catch (Exception e1) {
            logger.error("release eror is:", (Throwable)e1);
            throw new KDBizException(ResManager.loadKDString((String)"\u91ca\u653e\u4e92\u65a5\u9501\u5931\u8d25", (String)"ReceivErrorCode_31", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
        finally {
            this.successLockDraftIdList.clear();
        }
    }

    private boolean isRepeatDraftBillNo(String subBillRangeDb, long startFlag, long endFlag) {
        logger.info("subBillRangeDb is:" + subBillRangeDb + "startFlag:" + startFlag + "endFlag:" + endFlag);
        if (StringUtils.isEmpty((CharSequence)subBillRangeDb) || !subBillRangeDb.contains("-")) {
            return false;
        }
        Long startFlagDb = Long.valueOf(subBillRangeDb.split("-")[0]);
        Long endFlagDb = Long.valueOf(subBillRangeDb.split("-")[1]);
        boolean isRepeat = startFlag >= startFlagDb && startFlag <= endFlagDb || endFlag >= startFlagDb && endFlag <= endFlagDb || startFlag <= startFlagDb && endFlag >= endFlagDb;
        logger.info("isRepeat is that:" + isRepeat);
        return isRepeat;
    }

    private void redOrderOffset(DynamicObject data, DynamicObjectCollection entrys, boolean isrejectrefundgen) {
        Long draftTradeBillId = data.getLong("id");
        String billno = data.getString("billno");
        HashMap<Long, Map<Long, BigDecimal>> paybillIdMap = new HashMap<Long, Map<Long, BigDecimal>>(0);
        HashMap<Long, BigDecimal> draftBillMap = new HashMap<Long, BigDecimal>(0);
        HashMap<Long, String> idAndBillnoMap = new HashMap<Long, String>(0);
        HashSet<Long> draftIdSet = new HashSet<Long>(8);
        for (DynamicObject entry : entrys) {
            DynamicObject draftBill = entry.getDynamicObject("draftbill");
            BigDecimal billamt = entry.getBigDecimal("billamt");
            Long draftBillId = draftBill.getLong("id");
            draftIdSet.add(draftBillId);
            List<Long> paybillIds = new ArrayList(8);
            if (isrejectrefundgen && EmptyUtil.isNoEmpty((Long)draftTradeBillId)) {
                HashSet hashSet;
                DynamicObject[] sourceBillsMap = BFTrackerServiceHelper.findSourceBills((String)"cdm_drafttradebill", (Long[])new Long[]{draftTradeBillId});
                if (EmptyUtil.isNoEmpty((Object)sourceBillsMap) && EmptyUtil.isNoEmpty((Object)(hashSet = (HashSet)sourceBillsMap.get("cas_paybill")))) {
                    paybillIds.addAll(hashSet);
                }
            } else {
                paybillIds = DraftHelper.getBillIds((Long)draftBillId, (boolean)true, (String)"cas_paybill");
            }
            logger.info("paybillIds:" + SerializationUtils.toJsonString(paybillIds));
            if (paybillIds.size() <= 0) continue;
            paybillIds = this.getLatestPayBillId(paybillIds);
            logger.info("getLatestPayBillId,paybillIds:" + SerializationUtils.toJsonString(paybillIds));
            paybillIdMap.put(draftBillId, paybillIds.stream().collect(Collectors.toMap(key -> key, value -> BigDecimal.ZERO)));
            draftBillMap.put(draftBillId, billamt);
            idAndBillnoMap.put(draftBillId, draftBill.getString("draftbillno"));
        }
        Set paybillIds = paybillIdMap.values().stream().map(Map::keySet).flatMap(Collection::stream).collect(Collectors.toSet());
        if (paybillIds.size() < 1) {
            return;
        }
        DynamicObject[] paybills = BusinessDataServiceHelper.load((Object[])paybillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_paybill"));
        if (paybills.length < 1) {
            return;
        }
        DynamicObject casCorrectDy = paybills[0];
        Long casCorrectId = casCorrectDy.getLong("id");
        HashMap<Long, DynamicObject> newPayBillMap = new HashMap<Long, DynamicObject>(0);
        int currPrecision = 0;
        for (DynamicObject oldPayBill : paybills) {
            logger.info("oldPayBill billno is:" + oldPayBill.getString("billno"));
            currPrecision = oldPayBill.getDynamicObject("currency").getInt("amtprecision");
            DynamicObject newPayBill = CasHelper.dealReverse((DynamicObject)oldPayBill, draftIdSet);
            if (newPayBill == null) continue;
            newPayBill.set("sourcebilltype", (Object)"cdm_drafttradebill");
            newPayBill.set("sourcebillid", (Object)draftTradeBillId);
            newPayBill.set("sourcebillnumber", (Object)billno);
            newPayBillMap.put(oldPayBill.getLong("id"), newPayBill);
            paybillIdMap.values().stream().forEach(item -> {
                if (item.containsKey(oldPayBill.getLong("id"))) {
                    item.put(oldPayBill.getLong("id"), oldPayBill.getBigDecimal("actpayamt"));
                }
            });
        }
        for (Map.Entry entry : paybillIdMap.entrySet()) {
            BigDecimal draftBillAmount = (BigDecimal)draftBillMap.get(entry.getKey());
            BigDecimal payBillAmount = (BigDecimal)((Map)entry.getValue()).values().stream().reduce(BigDecimal::add).get();
            logger.info("draftBillAmount is:" + draftBillAmount + "and payBillAmount is:" + payBillAmount);
            if (draftBillAmount.compareTo(payBillAmount) >= 0) continue;
            int scaleNum = currPrecision + payBillAmount.toBigInteger().abs().toString().length();
            BigDecimal payBillAmountProportion = draftBillAmount.divide(payBillAmount, scaleNum, 1);
            BigDecimal draftBillTail = draftBillAmount.subtract(payBillAmount.multiply(payBillAmountProportion)).negate();
            logger.info("scaleNum is:" + scaleNum + ",currPrecision is:" + currPrecision + ",payBillAmountProportion is:" + payBillAmountProportion.toString() + ",draftBillTail is:" + draftBillTail.toString());
            logger.info("paybillMap is:" + SerializationUtils.toJsonString((Object)entry));
            logger.info("idAndBillnoMap is:" + SerializationUtils.toJsonString(idAndBillnoMap));
            int finalCurrPrecision = currPrecision;
            ((Map)entry.getValue()).keySet().stream().forEach(item -> {
                DynamicObject newPayBill = (DynamicObject)newPayBillMap.get(item);
                if (newPayBill != null) {
                    DynamicObjectCollection oldAmountEntry = newPayBill.getDynamicObjectCollection("entry");
                    BigDecimal e_payableamt_all = BigDecimal.ZERO;
                    BigDecimal e_payablelocamt_all = BigDecimal.ZERO;
                    BigDecimal e_discountamt_all = BigDecimal.ZERO;
                    BigDecimal e_discountlocamt_all = BigDecimal.ZERO;
                    BigDecimal e_actamt_all = BigDecimal.ZERO;
                    BigDecimal e_localamt_all = BigDecimal.ZERO;
                    BigDecimal e_lockamt_all = BigDecimal.ZERO;
                    BigDecimal e_unlockamt_all = BigDecimal.ZERO;
                    for (DynamicObject entry : oldAmountEntry) {
                        e_payableamt_all = e_payableamt_all.add(entry.getBigDecimal("e_payablelocamt"));
                        e_payablelocamt_all = e_payablelocamt_all.add(entry.getBigDecimal("e_payablelocamt"));
                        e_discountamt_all = e_discountamt_all.add(entry.getBigDecimal("e_discountamt"));
                        e_discountlocamt_all = e_discountlocamt_all.add(entry.getBigDecimal("e_discountlocamt"));
                        e_actamt_all = e_actamt_all.add(entry.getBigDecimal("e_actamt"));
                        e_localamt_all = e_localamt_all.add(entry.getBigDecimal("e_localamt"));
                        e_lockamt_all = e_lockamt_all.add(entry.getBigDecimal("e_lockamt"));
                        e_unlockamt_all = e_unlockamt_all.add(entry.getBigDecimal("e_unlockamt"));
                    }
                    Set draftIds = newPayBill.getDynamicObjectCollection("draftbill").stream().map(x -> x.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                    logger.info("draftIds is that:" + SerializationUtils.toJsonString(draftIds));
                    logger.info(" paybillMap.getKey() is that:" + paybillMap.getKey());
                    List collect = newPayBill.getDynamicObjectCollection("draftbill").stream().filter(d -> d.getDynamicObject("fbasedataid") != null && d.getDynamicObject("fbasedataid").getLong("id") != ((Long)paybillMap.getKey()).longValue()).collect(Collectors.toList());
                    if (EmptyUtil.isEmpty(collect)) {
                        logger.info("collect is null");
                        newPayBill.getDynamicObjectCollection("draftbill").removeIf(d -> d.getDynamicObject("fbasedataid") != null && d.getDynamicObject("fbasedataid").getLong("id") != ((Long)paybillMap.getKey()).longValue());
                    } else {
                        logger.info("collect is not null");
                        newPayBill.getDynamicObjectCollection("draftbill").removeIf(d -> d.getDynamicObject("fbasedataid") != null && d.getDynamicObject("fbasedataid").getLong("id") != ((Long)paybillMap.getKey()).longValue() && !d.getDynamicObject("fbasedataid").getString("draftbillno").equals(idAndBillnoMap.get(paybillMap.getKey())));
                    }
                    newPayBill.set("actpayamt", (Object)newPayBill.getBigDecimal("actpayamt").multiply(payBillAmountProportion).add(draftBillTail));
                    newPayBill.set("fee", (Object)newPayBill.getBigDecimal("fee").multiply(payBillAmountProportion));
                    newPayBill.set("localamt", (Object)newPayBill.getBigDecimal("localamt").multiply(payBillAmountProportion).add(draftBillTail));
                    newPayBill.set("dpamt", (Object)newPayBill.getBigDecimal("dpamt").multiply(payBillAmountProportion).add(draftBillTail));
                    newPayBill.set("dplocalamt", (Object)newPayBill.getBigDecimal("dplocalamt").multiply(payBillAmountProportion).add(draftBillTail));
                    DynamicObjectCollection newPayBillEntrys = newPayBill.getDynamicObjectCollection("entry");
                    BigDecimal e_payableamt = BigDecimal.ZERO;
                    BigDecimal e_payablelocamt = BigDecimal.ZERO;
                    BigDecimal e_discountamt = BigDecimal.ZERO;
                    BigDecimal e_discountlocamt = BigDecimal.ZERO;
                    BigDecimal e_actamt = BigDecimal.ZERO;
                    BigDecimal e_localamt = BigDecimal.ZERO;
                    BigDecimal e_lockamt = BigDecimal.ZERO;
                    BigDecimal e_unlockamt = BigDecimal.ZERO;
                    BigDecimal actpayamt = newPayBill.getBigDecimal("actpayamt");
                    newPayBill.set("unmatchamountpay", (Object)actpayamt);
                    for (int i = 0; i < newPayBillEntrys.size(); ++i) {
                        DynamicObject entry = (DynamicObject)newPayBillEntrys.get(i);
                        if (i == newPayBillEntrys.size() - 1) {
                            entry.set("e_payableamt", (Object)actpayamt.subtract(e_payableamt));
                            entry.set("e_payablelocamt", (Object)e_payablelocamt_all.multiply(payBillAmountProportion).setScale(finalCurrPrecision, 4).subtract(e_payablelocamt));
                            entry.set("e_discountamt", (Object)e_discountamt_all.multiply(payBillAmountProportion).setScale(finalCurrPrecision, 4).subtract(e_discountamt));
                            entry.set("e_discountlocamt", (Object)e_discountlocamt_all.multiply(payBillAmountProportion).setScale(finalCurrPrecision, 4).subtract(e_discountlocamt));
                            entry.set("e_actamt", (Object)actpayamt.subtract(e_actamt));
                            entry.set("e_localamt", (Object)e_localamt_all.multiply(payBillAmountProportion).setScale(finalCurrPrecision, 4).subtract(e_localamt));
                            entry.set("e_lockamt", (Object)0);
                            entry.set("e_unlockamt", (Object)e_unlockamt_all.multiply(payBillAmountProportion).setScale(finalCurrPrecision, 4).subtract(e_unlockamt));
                            entry.set("e_unsettledamt", (Object)entry.getBigDecimal("e_payableamt"));
                            continue;
                        }
                        entry.set("e_payableamt", (Object)entry.getBigDecimal("e_payableamt").multiply(payBillAmountProportion).setScale(finalCurrPrecision, 4));
                        entry.set("e_payablelocamt", (Object)entry.getBigDecimal("e_payablelocamt").multiply(payBillAmountProportion).setScale(finalCurrPrecision, 4));
                        entry.set("e_discountamt", (Object)entry.getBigDecimal("e_discountamt").multiply(payBillAmountProportion).setScale(finalCurrPrecision, 4));
                        entry.set("e_discountlocamt", (Object)entry.getBigDecimal("e_discountlocamt").multiply(payBillAmountProportion).setScale(finalCurrPrecision, 4));
                        entry.set("e_actamt", (Object)entry.getBigDecimal("e_actamt").multiply(payBillAmountProportion).setScale(finalCurrPrecision, 4));
                        entry.set("e_localamt", (Object)entry.getBigDecimal("e_localamt").multiply(payBillAmountProportion).setScale(finalCurrPrecision, 4));
                        entry.set("e_lockamt", (Object)0);
                        entry.set("e_unlockamt", (Object)entry.getBigDecimal("e_unlockamt").multiply(payBillAmountProportion).setScale(finalCurrPrecision, 4));
                        entry.set("e_unsettledamt", (Object)entry.getBigDecimal("e_payableamt"));
                        e_payableamt = e_payableamt.add(entry.getBigDecimal("e_payableamt"));
                        e_payablelocamt = e_payablelocamt.add(entry.getBigDecimal("e_payablelocamt"));
                        e_discountamt = e_discountamt.add(entry.getBigDecimal("e_discountamt"));
                        e_discountlocamt = e_discountlocamt.add(entry.getBigDecimal("e_discountlocamt"));
                        e_actamt = e_actamt.add(entry.getBigDecimal("e_actamt"));
                        e_localamt = e_localamt.add(entry.getBigDecimal("e_localamt"));
                        e_lockamt = e_lockamt.add(entry.getBigDecimal("e_lockamt"));
                        e_unlockamt = e_unlockamt.add(entry.getBigDecimal("e_unlockamt"));
                    }
                    Set draftIdsForSave = newPayBill.getDynamicObjectCollection("draftbill").stream().map(x -> x.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                    logger.info("draftIdsForSave is that:" + SerializationUtils.toJsonString(draftIdsForSave));
                }
            });
        }
        if (newPayBillMap.size() > 0) {
            Throwable throwable = null;
            try (TXHandle handle = TX.requiresNew();){
                try {
                    SaveServiceHelper.save((DynamicObject[])newPayBillMap.values().toArray(new DynamicObject[0]));
                    ArrayList newPayBillIds = new ArrayList(0);
                    for (Map.Entry paybillMap : paybillIdMap.entrySet()) {
                        ((Map)paybillMap.getValue()).keySet().stream().filter(item -> newPayBillMap.containsKey(item)).forEach(item -> newPayBillIds.add(((DynamicObject)newPayBillMap.get(item)).getLong("id")));
                    }
                    if (newPayBillIds.size() > 0) {
                        BotpHelper.saveRelation((DBRoute)DBRouteConst.cas, (String)"cdm_drafttradebill", (Long)draftTradeBillId, (String)"cas_paybill", newPayBillIds);
                    }
                }
                catch (Exception e) {
                    logger.error("Exception:", (Throwable)e);
                    handle.markRollback();
                    throw new KDBizException(e.getMessage());
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            DynamicObject needUpdateBill = DraftHelper.updateCasEntryIsRefuse(draftIdSet, (Long)casCorrectId, (String)"1");
            if (EmptyUtil.isNoEmpty((DynamicObject)needUpdateBill)) {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{needUpdateBill});
            }
        }
    }

    private List<Long> getLatestPayBillId(List<Long> paybillIds) {
        ArrayList<Long> retPayBillIds = new ArrayList<Long>();
        DynamicObject[] paybills = TmcDataServiceHelper.load((Object[])paybillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_paybill"));
        List paybillList = Arrays.stream(paybills).collect(Collectors.toList());
        Collections.sort(paybillList, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject arg0, DynamicObject arg1) {
                Date createtime1 = arg0.getDate("createtime");
                Date createtime2 = arg1.getDate("createtime");
                return createtime2.compareTo(createtime1);
            }
        });
        retPayBillIds.add(((DynamicObject)paybillList.get(0)).getLong("id"));
        return retPayBillIds;
    }

    private void poolOut(DynamicObject data) {
        DynamicObjectCollection entry = data.getDynamicObjectCollection("entrys");
        Object[] draftBillIds = entry.stream().filter(e -> DraftTranStatusEnum.SUCCESS.getValue().equals(e.getString("transtatus"))).map(row -> row.getDynamicObject("draftbill")).filter(Objects::nonNull).filter(draft -> Objects.nonNull(draft.getDynamicObject("billpool"))).filter(draft -> DraftTranStatusEnum.SUCCESS.getValue().equals(draft.getString("draftbilltranstatus"))).map(DataEntityBase::getPkValue).toArray();
        if (draftBillIds.length == 0) {
            return;
        }
        OperationResult pushResult = OperateServiceHelper.execOperate((String)"pushout", (String)"cdm_receivablebill", (Object[])draftBillIds, (OperateOption)OperateOption.create());
        DynamicObject[] outBills = null;
        if (!pushResult.isSuccess()) {
            throw new KDBizException(TmcOperateServiceHelper.decodeErrorMsg((OperationResult)pushResult));
        }
        QFilter sourceBillFilter = new QFilter("sourcebillid", "in", (Object)draftBillIds);
        QFilter typeFilter = new QFilter("businesstype", "=", (Object)BizBusinessTypeEnum.OUT.getValue());
        outBills = BusinessDataServiceHelper.load((String)"cdm_billpoolbiz", (String)"id,bizdate,businesstype,billstatus", (QFilter[])new QFilter[]{sourceBillFilter, typeFilter});
        if (outBills == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7968\u636e\u4e0b\u63a8\u7684\u51fa\u6c60\u7533\u8bf7\u5355\u4e3a\u7a7a\u3002", (String)"TradeBillDrawBillService_2", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
        OperationResult result = null;
        try {
            Object[] outBillIds = Arrays.stream(outBills).filter(e -> "A".equalsIgnoreCase(e.getString("billstatus"))).map(DataEntityBase::getPkValue).toArray();
            if (EmptyUtil.isNoEmpty((Object[])outBillIds)) {
                logger.info("is will submit:" + outBillIds.length);
                OperateOption operateOption = OperateOption.create();
                result = OperateServiceHelper.execOperate((String)"submit", (String)"cdm_billpoolbiz", (Object[])outBillIds, (OperateOption)operateOption);
                if (result.isSuccess()) {
                    List needLockDrafts = entry.stream().map(row -> row.getDynamicObject("draftbill")).filter(Objects::nonNull).map(d -> (Long)d.getPkValue()).collect(Collectors.toList());
                    Long outBillId = (Long)result.getSuccessPkIds().get(0);
                    logger.info("is will audit");
                    result = OperateServiceHelper.execOperate((String)"audit", (String)"cdm_billpoolbiz", (Object[])result.getSuccessPkIds().toArray(), (OperateOption)operateOption);
                    if (!result.isSuccess()) {
                        logger.info("\u51fa\u6c60\u7533\u8bf7\u4fdd\u5b58\u5ba1\u6838\u5931\u8d25\u3002");
                    }
                } else {
                    logger.info("\u51fa\u6c60\u7533\u8bf7\u4fdd\u5b58\u63d0\u4ea4\u5931\u8d25\u3002");
                }
            } else {
                logger.info("outBillIds is null");
            }
        }
        catch (Exception e2) {
            logger.error("\u51fa\u6c60\u7533\u8bf7\u4fdd\u5b58\u63d0\u4ea4\u5ba1\u6838\u5f02\u5e38\u3002", (Throwable)e2);
            throw e2;
        }
    }

    private void lockDrafts(List<Long> needLockDrafts, Long outBillId) {
        ArrayList<DraftLockInfo> lockDraftList = new ArrayList<DraftLockInfo>();
        DraftLockInfo draftLockInfo = new DraftLockInfo();
        draftLockInfo.setSourceBillId(outBillId);
        draftLockInfo.setSourceBillType("cdm_billpoolbiz");
        draftLockInfo.setLockBillIdList(needLockDrafts);
        lockDraftList.add(draftLockInfo);
        LockDraftHelper.releaseOrLockDrafts(lockDraftList);
    }

    private void generateCasBill(DynamicObject data) {
        DynamicObject[] paymentBills = BotpHelper.pushByRule((DynamicObject)data, (String)"cas_paybill", (String)"1292067123941645312");
        DynamicObjectCollection entry = data.getDynamicObjectCollection("entrys");
        DynamicObject draftBill = ((DynamicObject)entry.get(0)).getDynamicObject("draftbill");
        DynamicObject recDraftBill = BusinessDataServiceHelper.loadSingle((Object)draftBill.getPkValue(), (String)"cdm_receivablebill");
        DynamicObject[] recBills = BotpHelper.pushByRule((DynamicObject)recDraftBill, (String)"cas_recbill", (String)"1292117912768779264");
        if (paymentBills.length > 0 && recBills.length > 0) {
            DynamicObject paymentBill;
            Set needUpdateDraftDySetByPay;
            try (TXHandle tx = TX.requiresNew();){
                try {
                    OperateServiceHelper.execOperate((String)"drafttradesave", (String)"cas_paybill", (DynamicObject[])paymentBills, (OperateOption)OperateOption.create());
                    OperateServiceHelper.execOperate((String)"save", (String)"cas_recbill", (DynamicObject[])recBills, (OperateOption)OperateOption.create());
                }
                catch (Exception e) {
                    tx.markRollback();
                    logger.error("\u4e0b\u63a8\u4fdd\u5b58\u4ed8\u6b3e\u5355\u548c\u6536\u6b3e\u5355\u5931\u8d25\u3002", (Throwable)e);
                    throw e;
                }
            }
            DynamicObject recBill = recBills[0];
            HashSet<DynamicObject> draftDySet = new HashSet<DynamicObject>(1);
            draftDySet.add(recDraftBill);
            HashSet needUpdateDySet = new HashSet();
            Set needUpdateDraftDySetByRec = DraftHelper.updateDratBillCasEntry(draftDySet, (String)"cas_recbill", (String)"add", (Long)recBill.getLong("id"));
            if (EmptyUtil.isNoEmpty((Object)needUpdateDraftDySetByRec)) {
                needUpdateDySet.addAll(needUpdateDraftDySetByRec);
            }
            if (EmptyUtil.isNoEmpty((Object)(needUpdateDraftDySetByPay = DraftHelper.updateDratBillCasEntry(draftDySet, (String)"cas_paybill", (String)"add", (Long)(paymentBill = paymentBills[0]).getLong("id"))))) {
                needUpdateDySet.addAll(needUpdateDraftDySetByPay);
            }
            if (EmptyUtil.isNoEmpty(needUpdateDySet)) {
                SaveServiceHelper.save((DynamicObject[])needUpdateDySet.toArray(new DynamicObject[0]));
            }
        }
    }

    public void handlerException(DynamicObject[] dataEntities) throws KDException {
        super.handlerException(dataEntities);
        if (!this.isDrawDail) {
            this.cancelReturnCreditLimit();
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        if (this.isDrawDail) {
            logger.info("is from drawFail");
            return;
        }
        ArrayList<DynamicObject> pushdataEmtities = new ArrayList<DynamicObject>();
        ArrayList<DraftLockInfo> draftLockInfos = new ArrayList<DraftLockInfo>();
        boolean formEleUpdate = Boolean.parseBoolean(this.operationVariable.getOrDefault("COMPLETEFROM_ELEUPDATE", "false"));
        boolean isrepayrecall = Boolean.parseBoolean(this.operationVariable.getOrDefault("isrepayrecall", "false"));
        boolean autoAllocation = Boolean.parseBoolean(this.operationVariable.getOrDefault("autoallocation", "false"));
        DynamicObject[] draftArr = TradeBillHelper.getDraftArrByTradeBillArr((DynamicObject[])dataEntities);
        Set draftArrSet = Arrays.stream(draftArr).filter(item -> DraftTranStatusEnum.SUCCESS.getValue().equals(item.getString("draftbilltranstatus")) && EmptyUtil.isNoEmpty((String)item.getString("locksourcebillid"))).map(o -> o.getLong("id")).collect(Collectors.toSet());
        logger.info("isrepayrecall is" + isrepayrecall + ",draftArrSet is:" + SerializationUtils.toJsonString(draftArrSet));
        Map<String, DynamicObject> subBillIdAndDyMap = this.getSubBIllData(dataEntities);
        for (DynamicObject data : dataEntities) {
            boolean isSubmitEle = data.getBoolean("electag");
            String tradeStatus = data.getString("draftbilltranstatus");
            String draftType = data.getString("tradetype");
            if ((isSubmitEle || formEleUpdate) && DraftTranStatusEnum.FAILING.getValue().equals(tradeStatus)) continue;
            if (!autoAllocation) {
                this.syncAllocBill(data);
            }
            Object companyId = PayableBillHelp.getCompanyIdByBeen((DynamicObject)data);
            logger.info("companid is that:" + SerializationUtils.toJsonString((Object)companyId));
            String billSourceStr = data.getString("source");
            boolean isFromAoll = false;
            if ("cdm-draftallocate".equals(billSourceStr)) {
                isFromAoll = true;
            }
            logger.info("isFromAoll is that:" + isFromAoll);
            if (EmptyUtil.isNoEmpty((Object)companyId) && (DraftTradeTypeEnum.ENDORSE.getValue().equals(draftType) || isFromAoll) && !isSubmitEle && !formEleUpdate) {
                boolean isGenerateCasBill = DraftHelper.getCdmParameterBoolean((long)((Long)companyId), (String)"isgeneratecasbill");
                String sourceStr = data.getString("source");
                boolean isFromBillSch = !EmptyUtil.isEmpty((String)data.getString("sourcebillid")) && "cdm-draftallocate".equals(sourceStr);
                logger.info("isGenerateCasBill" + isGenerateCasBill + "and isFromBillSch :" + isFromBillSch);
                if (isGenerateCasBill && isFromBillSch) {
                    this.generateCasBill(data);
                }
            }
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entrys) {
                String transStatus = entry.getString("transtatus");
                if ((isSubmitEle || formEleUpdate) && !DraftTranStatusEnum.SUCCESS.getValue().equals(transStatus)) continue;
                entry.set("oldstatus", (Object)entry.getDynamicObject("draftbill").getString("draftbillstatus"));
                if (DraftTradeTypeEnum.ENDORSE.getValue().equals(draftType)) {
                    this.genEndorseInfo(data, entry, subBillIdAndDyMap);
                    continue;
                }
                if (DraftTradeTypeEnum.DISCOUNT.getValue().equals(draftType)) {
                    this.genNoteDiscountInfo(data, entry, subBillIdAndDyMap);
                    continue;
                }
                if (!DraftTradeTypeEnum.PLEDGE.getValue().equals(draftType)) continue;
                this.genPledgeInfo(data, entry, subBillIdAndDyMap);
            }
            Long orgId = (Long)data.getDynamicObject("company").getPkValue();
            String settlementtype = data.getDynamicObject("drafttype").getString("settlementtype");
            if ((StringUtils.equals((CharSequence)SettleMentTypeEnum.BANK.getValue(), (CharSequence)settlementtype) || StringUtils.equals((CharSequence)SettleMentTypeEnum.BUSINESS.getValue(), (CharSequence)settlementtype)) && DraftHelper.getCdmParameterBoolean((long)orgId, (String)"isdraft")) {
                pushdataEmtities.add(data);
            } else if (StringUtils.equals((CharSequence)SettleMentTypeEnum.PROMISSORY.getValue(), (CharSequence)settlementtype) && DraftHelper.getCdmParameterBoolean((long)orgId, (String)"ischeck")) {
                pushdataEmtities.add(data);
            } else if (StringUtils.equals((CharSequence)SettleMentTypeEnum.CHECK.getValue(), (CharSequence)settlementtype) && DraftHelper.getCdmParameterBoolean((long)orgId, (String)"ispromissorynote")) {
                pushdataEmtities.add(data);
            }
            String tradeType = data.getString("tradetype");
            if (!pushdataEmtities.contains(data) || !tradeType.equals(DraftTradeTypeEnum.PAYOFF.getValue())) {
                ArrayList<Long> newDraftIds = new ArrayList<Long>(10);
                List draftIds = entrys.stream().filter(o -> !EmptyUtil.isEmpty((DynamicObject)o.getDynamicObject("draftbill")) && draftArrSet.contains(o.getDynamicObject("draftbill").getLong("id"))).map(p -> p.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toList());
                for (Long draftId : draftIds) {
                    String sourceType = data.getString("sourcebilltype");
                    Boolean isAllocation = EmptyUtil.isNoEmpty((String)sourceType) && "cdm_draftallocation".equals(sourceType);
                    if (LockDraftHelper.draftIsQuoteRec(draftId).booleanValue() || isAllocation.booleanValue()) continue;
                    newDraftIds.add(draftId);
                }
                if (newDraftIds.size() > 0) {
                    DraftLockInfo draftLockInfo = new DraftLockInfo();
                    draftLockInfo.getReleaseBillIdList().addAll(newDraftIds);
                    draftLockInfo.setSourceBillId(data.getLong("id"));
                    draftLockInfo.setSourceBillType(data.getDataEntityType().getName());
                    draftLockInfos.add(draftLockInfo);
                }
            }
            if (!DraftTradeTypeEnum.REFUND.getValue().equals(draftType)) continue;
            Object[] recBillIds = entrys.stream().map(o -> o.getDynamicObject("draftbill").getPkValue()).toArray();
            this.setRecDraftBillStatusIntoPool(data, recBillIds);
        }
        logger.info("pushdataEmtities size is:" + pushdataEmtities.size());
        logger.info("draftLockInfos is:" + SerializationUtils.toJsonString(draftLockInfos) + ",autoAllocation is:" + autoAllocation);
        if (!CollectionUtils.isEmpty(draftLockInfos) && !autoAllocation) {
            logger.info("TradeBillDrawBillService.afterProcess,releaseOrLockDrafts");
        }
        this.pushCasBill(pushdataEmtities.toArray(new DynamicObject[0]));
        ArrayList<Object> pushPledgeList = new ArrayList<Object>();
        for (DynamicObject data : dataEntities) {
            long companyId;
            boolean isReceiveOppNote;
            String sourceBillType = data.getString("sourcebilltype");
            String tradeType = data.getString("tradetype");
            if (Objects.equals(DraftTradeTypeEnum.ENDORSE.getValue(), tradeType) && Objects.equals(sourceBillType, "cas_paybill")) {
                this.poolOut(data);
            }
            boolean isRleDge = DraftTradeTypeEnum.PLEDGE.getValue().equals(data.getString("tradetype"));
            boolean isRlspleDge = DraftTradeTypeEnum.RLSPLEDGE.getValue().equals(data.getString("tradetype"));
            if (!isRleDge || !(isReceiveOppNote = DraftHelper.getCdmParameterBoolean((long)(companyId = data.getDynamicObject("company").getLong("id")), (String)"isautogenpledge"))) continue;
            pushPledgeList.add(data.getPkValue());
        }
        try {
            if (pushPledgeList.size() > 0) {
                ThreadPools.executeOnce((String)"synpushPledge", (Runnable)new AsyncPushPledgeBill(pushPledgeList.toArray(new Object[0])));
            }
        }
        catch (Exception e) {
            logger.error("pushPledge error:" + e);
        }
        this.deleteGmPledgeData(dataEntities);
        this.fillDraftBillFinshDate(dataEntities, subBillIdAndDyMap);
        SaveServiceHelper.update((DynamicObject[])dataEntities);
        logger.info("end that");
    }

    private Map<String, DynamicObject> getSubBIllData(DynamicObject[] dataArr) {
        Map<String, DynamicObject> subBillIdAndDyMap = new HashMap<String, DynamicObject>(8);
        HashSet allBillIdSet = new HashSet(8);
        for (DynamicObject data : dataArr) {
            Set billLogIdSet = data.getDynamicObjectCollection("entrys").stream().map(x -> x.getLong("billlogid")).collect(Collectors.toSet());
            allBillIdSet.addAll(billLogIdSet);
        }
        QFilter qFilterBIllLogId = new QFilter("id", "in", allBillIdSet);
        QFilter qFilterSplit = new QFilter("issplit", "=", (Object)"1");
        QFilter qFilterSplitBIllId = new QFilter("splitedsubbillid", "!=", (Object)0);
        Object[] logDyArr = TmcDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id,draftid,splitedsubbillid,issplit,deleteflag", (QFilter[])new QFilter[]{qFilterBIllLogId, qFilterSplit, qFilterSplitBIllId});
        if (EmptyUtil.isNoEmpty((Object[])logDyArr)) {
            Set subBillIdSet = Arrays.stream(logDyArr).map(e -> e.getLong("splitedsubbillid")).collect(Collectors.toSet());
            QFilter qFilterSubBIllLogId = new QFilter("id", "in", subBillIdSet);
            DynamicObject[] subBillArr = TmcDataServiceHelper.load((String)"cdm_receivablebill", (String)"supperbillid,id,bizfinishdate,endorseentry,endorseentry.endorsetype,endorseentry.endorseistransfer,endorseentry.signdate,endorseentry.initiatorname,endorseentry.opponentname,equaltradebillid,endorseentry.pledgereleasedate", (QFilter[])new QFilter[]{qFilterSubBIllLogId});
            subBillIdAndDyMap = Arrays.stream(subBillArr).collect(Collectors.toMap(x -> x.getLong("supperbillid") + "_" + x.getLong("equaltradebillid"), x -> x));
        }
        return subBillIdAndDyMap;
    }

    private void fillDraftBillFinshDate(DynamicObject[] dataEntities, Map<String, DynamicObject> subBillIdAndDyMap) {
        Date date;
        if (EmptyUtil.isEmpty((Object[])dataEntities)) {
            return;
        }
        HashMap<Long, Date> finishDate = new HashMap<Long, Date>();
        HashSet<Long> payids = new HashSet<Long>();
        HashSet<Long> recids = new HashSet<Long>();
        HashSet<DynamicObject> subRecSet = new HashSet<DynamicObject>();
        for (DynamicObject drafttradbill : dataEntities) {
            DynamicObject subDraftBill;
            String keyStr;
            String tradeType = drafttradbill.getString("tradetype");
            Date bizfinishdate = drafttradbill.getDate("bizfinishdate");
            if (bizfinishdate == null) {
                bizfinishdate = drafttradbill.getDate("bizdate");
            }
            if (Objects.equals(DraftTradeTypeEnum.RLSPLEDGE.getValue(), tradeType)) {
                bizfinishdate = null;
            }
            DynamicObjectCollection entrys = drafttradbill.getDynamicObjectCollection("entrys");
            if (TRADTYPES.contains(tradeType)) {
                for (DynamicObject entry : entrys) {
                    long recid = entry.getDynamicObject("draftbill").getLong("id");
                    recids.add(recid);
                    finishDate.put(recid, bizfinishdate);
                    keyStr = recid + "_" + drafttradbill.getLong("id");
                    subDraftBill = subBillIdAndDyMap.get(keyStr);
                    if (!EmptyUtil.isNoEmpty((DynamicObject)subDraftBill)) continue;
                    subDraftBill.set("bizfinishdate", (Object)bizfinishdate);
                    subRecSet.add(subDraftBill);
                }
                continue;
            }
            if (!Objects.equals(DraftTradeTypeEnum.PAYOFF.getValue(), tradeType)) continue;
            for (DynamicObject entry : entrys) {
                long payid = entry.getDynamicObject("draftbill").getLong("id");
                payids.add(payid);
                finishDate.put(payid, bizfinishdate);
                keyStr = payid + "_" + drafttradbill.getLong("id");
                subDraftBill = subBillIdAndDyMap.get(keyStr);
                if (!EmptyUtil.isNoEmpty((DynamicObject)subDraftBill)) continue;
                subDraftBill.set("bizfinishdate", (Object)bizfinishdate);
                subRecSet.add(subDraftBill);
            }
        }
        DynamicObject[] paydynamicObjects = new DynamicObject[payids.size()];
        DynamicObject[] recdynamicObjects = new DynamicObject[recids.size()];
        if (recids != null && recids.size() > 0) {
            QFilter recqFilter = new QFilter("id", "in", (Object)recids.toArray(new Long[0]));
            recdynamicObjects = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,bizfinishdate", (QFilter[])new QFilter[]{recqFilter});
        }
        if (payids != null && payids.size() > 0) {
            QFilter qFilter = new QFilter("id", "in", (Object)payids.toArray(new Long[0]));
            paydynamicObjects = BusinessDataServiceHelper.load((String)"cdm_payablebill", (String)"id,bizfinishdate", (QFilter[])new QFilter[]{qFilter});
        }
        if (paydynamicObjects != null && paydynamicObjects.length > 0) {
            for (DynamicObject paybill : paydynamicObjects) {
                date = (Date)finishDate.get(paybill.getLong("id"));
                paybill.set("bizfinishdate", (Object)date);
            }
        }
        if (recdynamicObjects != null && recdynamicObjects.length > 0) {
            for (DynamicObject recbill : recdynamicObjects) {
                date = (Date)finishDate.get(recbill.getLong("id"));
                recbill.set("bizfinishdate", (Object)date);
            }
        }
        if (paydynamicObjects != null && paydynamicObjects.length > 0) {
            SaveServiceHelper.update((DynamicObject[])paydynamicObjects);
        }
        if (recdynamicObjects != null && recdynamicObjects.length > 0) {
            SaveServiceHelper.update((DynamicObject[])recdynamicObjects);
        }
        if (EmptyUtil.isNoEmpty(subRecSet)) {
            SaveServiceHelper.update((DynamicObject[])subRecSet.toArray(new DynamicObject[0]));
        }
        logger.info("\u786e\u8ba4\u5b8c\u6210\u56de\u586b\u7968\u636e\u4e1a\u52a1\u5904\u7406\u5b8c\u6210\u65e5\u671f\u6210\u529f!");
    }

    private void deleteGmPledgeData(DynamicObject[] dataEntities) {
        block17: {
            try {
                ArrayList pledgeList = new ArrayList();
                for (DynamicObject data : dataEntities) {
                    boolean isRlspleDge = DraftTradeTypeEnum.RLSPLEDGE.getValue().equals(data.getString("tradetype"));
                    long companyId = data.getDynamicObject("company").getLong("id");
                    boolean isReceiveOppNote = DraftHelper.getCdmParameterBoolean((long)companyId, (String)"isautogenpledge");
                    if (!isRlspleDge || !isReceiveOppNote) continue;
                    List draftBillNos = data.getDynamicObjectCollection("entrys").stream().map(row -> row.getDynamicObject("draftbill").getString("draftbillno")).collect(Collectors.toList());
                    pledgeList.addAll(draftBillNos);
                }
                logger.info("pledgeList size is:" + pledgeList.size());
                if (CollectionUtils.isEmpty(pledgeList)) break block17;
                try (TXHandle tx = TX.requiresNew();){
                    QFilter qFilter1 = new QFilter("billsource", "=", (Object)"cdm_drafttradebill");
                    QFilter qFilter2 = new QFilter("pledgename", "in", pledgeList);
                    QFilter qFilter3 = new QFilter("billstatus", "=", (Object)"A");
                    DynamicObject[] pledgebillArr = BusinessDataServiceHelper.load((String)"gm_pledgebill", (String)"id", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3});
                    Set pledgeIds = Arrays.stream(pledgebillArr).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("cdm_drafttradebill_ignore", "1");
                    OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"delete", (String)"gm_pledgebill", (Object[])pledgeIds.toArray(), (OperateOption)option, (boolean)true);
                    if (operationResult.isSuccess()) {
                        logger.info("is success" + operationResult.getSuccessPkIds());
                    } else {
                        logger.info("delete is error" + operationResult.getSuccessPkIds());
                    }
                }
            }
            catch (Exception e) {
                logger.info("delete is e" + e);
            }
        }
    }

    public void genPurPay(String sourceBillId, String draftbillno, Date bizFinishDate) {
        try (TXHandle tx = TX.requiresNew();){
            DynamicObject[] payBills = TmcDataServiceHelper.load((String)"cas_paybill", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(sourceBillId))});
            if (payBills.length > 0) {
                ArrayList<Long> ids = new ArrayList<Long>(payBills.length);
                for (DynamicObject payBill : payBills) {
                    if (BillStatusEnum.PAYED.getValue().equals(payBill.getString("billstatus"))) continue;
                    ids.add(payBill.getLong("id"));
                }
                if (!ids.isEmpty()) {
                    OperateOption create = OperateOption.create();
                    create.setVariableValue("draftbillno", draftbillno);
                    create.setVariableValue("endorse", draftbillno);
                    create.setVariableValue("fromdraw", draftbillno);
                    create.setVariableValue("bizFinishDate", DateUtils.formatString((Date)bizFinishDate, (String)"yyyy-MM-dd"));
                    TmcOperateServiceHelper.execOperate((String)"pay", (String)"cas_paybill", (Object[])ids.toArray(), (OperateOption)create);
                }
            }
        }
        catch (KDBizException kdBizException) {
            ErrorCode errorCode = kdBizException.getErrorCode();
            String message = kdBizException.getMessage();
            if (message.equals(ResManager.loadKDString((String)"\u672a\u80fd\u81ea\u52a8\u590d\u6838\u51ed\u8bc1\uff0c\u53ef\u5230\u51ed\u8bc1\u67e5\u8be2\u5217\u8868\u624b\u5de5\u590d\u6838\uff01", (String)"TradeBillDrawBillValidator_10", (String)"tmc-cdm-business", (Object[])new Object[0]))) {
                logger.error("\u786e\u8ba4\u4ed8\u6b3e\u51fa\u73b0\u51ed\u8bc1\u4e1a\u52a1\u5f02\u5e38\u3002", (Throwable)kdBizException);
            }
            logger.error("\u786e\u8ba4\u4ed8\u6b3e\u51fa\u73b0\u975e\u51ed\u8bc1\u4e1a\u52a1\u5f02\u5e38\u3002", (Throwable)kdBizException);
            throw kdBizException;
        }
        catch (Exception e) {
            logger.error("\u786e\u8ba4\u4ed8\u6b3e\u51fa\u73b0\u5f02\u5e38\u3002", (Throwable)e);
            throw e;
        }
    }

    private void depositPushPayBill(List<Object> depositPushList) {
        OperateOption operateOption = this.getOperateOption();
        operateOption.setVariableValue("deposit", String.valueOf(Boolean.TRUE));
        this.pushCasBill(DEPOSITPUSH, depositPushList.toArray(), operateOption);
    }

    private void pushCasBill(DynamicObject[] dataEntities) {
        List<String> legalType = Arrays.asList(DraftTradeTypeEnum.DISCOUNT.getValue(), DraftTradeTypeEnum.COLLECT.getValue(), DraftTradeTypeEnum.PAYOFF.getValue(), DraftTradeTypeEnum.PAYINTEREST.getValue());
        Map<String, List<DynamicObject>> typeMap = Arrays.stream(dataEntities).filter(o -> legalType.contains(o.getString("tradetype"))).collect(Collectors.groupingBy(o -> o.getString("tradetype")));
        List pushRecBillIdList = Stream.of(typeMap.get(DraftTradeTypeEnum.DISCOUNT.getValue())).filter(Objects::nonNull).flatMap(Collection::stream).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        List pushCollectRecBillIdList = Stream.of(typeMap.get(DraftTradeTypeEnum.COLLECT.getValue())).filter(Objects::nonNull).flatMap(Collection::stream).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        List<DynamicObject> pushPayingBillList = typeMap.get(DraftTradeTypeEnum.PAYOFF.getValue());
        List<DynamicObject> PayInerestBillList = typeMap.get(DraftTradeTypeEnum.PAYINTEREST.getValue());
        if (!CollectionUtils.isEmpty(pushRecBillIdList)) {
            this.pushCasBill(PUSHRECBILL, pushRecBillIdList.toArray(), OperateOption.create());
        }
        if (!CollectionUtils.isEmpty(pushCollectRecBillIdList)) {
            this.pushCasBill(PUSHANDSAVERECBILL, pushCollectRecBillIdList.toArray(), OperateOption.create());
        }
        if (!CollectionUtils.isEmpty(pushPayingBillList)) {
            Iterator<DynamicObject> iterators = pushPayingBillList.iterator();
            ArrayList<DynamicObject> pushBanks = new ArrayList<DynamicObject>();
            while (iterators.hasNext()) {
                DynamicObject ite = iterators.next();
                DynamicObject company = ite.getDynamicObject("company");
                if (company == null || !DraftHelper.getCdmParameterBoolean((long)company.getLong("id"), (String)"ispushpay") || !this.checkFromCas(ite)) continue;
                String settlementtype = ite.getDynamicObject("drafttype").getString("settlementtype");
                if (!StringUtils.equals((CharSequence)SettleMentTypeEnum.PROMISSORY.getValue(), (CharSequence)settlementtype)) continue;
                pushBanks.add(ite);
                iterators.remove();
            }
            if (!CollectionUtils.isEmpty(pushBanks)) {
                HashSet<Long> payBillSet = new HashSet<Long>(16);
                for (DynamicObject bill2 : pushBanks) {
                    DynamicObjectCollection entrys = bill2.getDynamicObjectCollection("entrys");
                    if (entrys == null || entrys.size() == 0) continue;
                    for (DynamicObject entry : entrys) {
                        DynamicObject draftBill = entry.getDynamicObject("draftbill");
                        String source = draftBill.getString("source");
                        if (!"cas".equalsIgnoreCase(source)) continue;
                        long sourceBillid = draftBill.getLong("sourcebillid");
                        payBillSet.add(sourceBillid);
                    }
                }
                if (EmptyUtil.isNoEmpty(payBillSet)) {
                    try (TXHandle tx = TX.requiresNew();){
                        DynamicObject[] payBills = TmcDataServiceHelper.load((String)"cas_paybill", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", payBillSet), new QFilter("billstatus", "=", (Object)"D")});
                        if (payBills.length > 0) {
                            Set<Object> payIdSet = Arrays.stream(payBills).map(e -> e.getLong("id")).collect(Collectors.toSet());
                            OperateOption create = OperateOption.create();
                            TmcOperateServiceHelper.execOperate((String)"manualbook", (String)"cas_paybill", (Object[])payIdSet.toArray(new Object[0]), (OperateOption)create);
                        }
                    }
                    catch (Exception e2) {
                        logger.error("\u652f\u7968\u89e3\u4ed8\u767b\u8d26\u51fa\u73b0\u5f02\u5e38\u3002", (Throwable)e2);
                        throw e2;
                    }
                }
            }
            pushPayingBillList.removeIf(bill -> Objects.equals(bill.getString("tradetype"), DraftTradeTypeEnum.PAYOFF.getValue()) && bill.getBigDecimal("depositamount").add(bill.getBigDecimal("deductamount")).compareTo(bill.getBigDecimal("amount")) == 0);
            if (!CollectionUtils.isEmpty(pushPayingBillList)) {
                this.pushCasBill(PUSHPAYBILL, pushPayingBillList.stream().map(DataEntityBase::getPkValue).toArray(), this.getOperateOption());
            }
        }
    }

    private OperateOption getOperateOption() {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("tradetype", DraftTradeTypeEnum.PAYOFF.getValue());
        return operateOption;
    }

    private boolean checkFromCas(DynamicObject info) {
        DynamicObject entry;
        DynamicObject draftBill;
        DynamicObjectCollection entrys = info.getDynamicObjectCollection("entrys");
        if (entrys != null && entrys.size() == 1 && (draftBill = (entry = (DynamicObject)entrys.get(0)).getDynamicObject("draftbill")) != null) {
            Long draftId = draftBill.getLong("id");
            if ("cas".equals(draftBill.getString("source")) || LockDraftHelper.draftIsQuoteCas(draftId).booleanValue()) {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    private void pushCasBill(String pushOpKey, Object[] pkIds, OperateOption operateOption) {
    }

    private void returnCreditLimit(DynamicObject payableBill, Date bizdate) {
        logger.info("is start returnCreditLimit");
        ReturnCreditLimitInfo creditLimitInfo = CreditLimitServiceHelper.returnCreditLimit((DynamicObject)payableBill, (DynamicObject)payableBill, (boolean)false, (BigDecimal)payableBill.getBigDecimal("amount"), (Long)payableBill.getLong("id"), (boolean)false, (Date)bizdate);
        boolean isRpcSuccess = creditLimitInfo.isSuccess();
        logger.info("returnCreditLimit isRpcSuccess" + isRpcSuccess);
        if (!isRpcSuccess) {
            throw new KDBizException(creditLimitInfo.getMessage());
        }
        this.successReturnCreditLimitMapList.add(payableBill);
    }

    private void cancelReturnCreditLimit() {
        for (DynamicObject payableBill : this.successReturnCreditLimitMapList) {
            ReturnCreditLimitInfo creditLimitInfo = CreditLimitServiceHelper.cancelReturnCreditLimit((DynamicObject)payableBill, (DynamicObject)payableBill, (boolean)false, (BigDecimal)payableBill.getBigDecimal("creditamount"), (Long)payableBill.getLong("id"));
            boolean isRpcSuccess = creditLimitInfo.isSuccess();
            if (isRpcSuccess) continue;
            logger.error("\u64a4\u9500\u8fd4\u8fd8\u6388\u4fe1\u989d\u5ea6\u5931\u8d25:" + creditLimitInfo.getMessage());
        }
    }

    private void genPledgeInfo(DynamicObject tradeBill, DynamicObject entry, Map<String, DynamicObject> subBillIdAndDyMap) {
        long draftId = entry.getDynamicObject("draftbill").getLong("id");
        String draftType = tradeBill.getString("tradetype");
        String billno = tradeBill.getString("billno");
        DynamicObject draft = TmcDataServiceHelper.loadSingle((Object)draftId, (String)"cdm_receivablebill");
        String draftBillStatus = draft.getString("draftbillstatus");
        String draftBillno = draft.getString("billno");
        logger.info("pledge trade bill billno is:" + billno + "and draft billno:" + draftBillno + " draftBillStatus is:" + draftBillStatus);
        DynamicObjectCollection dynamicObjectCollection = draft.getDynamicObjectCollection("endorseentry");
        DynamicObject dynamicObject = dynamicObjectCollection.addNew();
        String keyStr = draftId + "_" + tradeBill.getLong("id");
        DynamicObject subBill = subBillIdAndDyMap.get(keyStr);
        if (EmptyUtil.isNoEmpty((DynamicObject)subBill)) {
            DynamicObjectCollection subBilllEndorseentrys = subBill.getDynamicObjectCollection("endorseentry");
            DynamicObject subPledge = subBilllEndorseentrys.addNew();
            this.setPledgeDy(tradeBill, draft, subPledge);
            TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{subBill});
        } else {
            this.setPledgeDy(tradeBill, draft, dynamicObject);
            TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{draft});
        }
    }

    private void setPledgeDy(DynamicObject tradeBill, DynamicObject draft, DynamicObject dynamicObject) {
        dynamicObject.set("endorsetype", (Object)"pledge");
        dynamicObject.set("endorseistransfer", (Object)draft.getBoolean("istransfer"));
        dynamicObject.set("signdate", (Object)tradeBill.getDate("bizfinishdate"));
        dynamicObject.set("initiatorname", (Object)tradeBill.getDynamicObject("company").getString("name"));
        String pledgeetype = tradeBill.getString("pledgeetype");
        if ("other".equals(pledgeetype)) {
            dynamicObject.set("opponentname", (Object)tradeBill.getString("pledgeetext"));
        } else {
            dynamicObject.set("opponentname", (Object)tradeBill.getDynamicObject("pledgeebase").getString("name"));
        }
        Date pledgeenddate = tradeBill.getDate("pledgeenddate");
        dynamicObject.set("pledgereleasedate", (Object)pledgeenddate);
    }

    private void genEndorseInfo(DynamicObject tradeBill, DynamicObject entry, Map<String, DynamicObject> subBillIdAndDyMap) {
        long draftId = entry.getDynamicObject("draftbill").getLong("id");
        String draftType = tradeBill.getString("tradetype");
        String billno = tradeBill.getString("billno");
        DynamicObject draft = TmcDataServiceHelper.loadSingle((Object)draftId, (String)"cdm_receivablebill");
        String draftBillStatus = draft.getString("draftbillstatus");
        String draftBillno = draft.getString("billno");
        logger.info("endorse trade bill billno is:" + billno + "and draft billno:" + draftBillno + " draftBillStatus is:" + draftBillStatus);
        DynamicObjectCollection dynamicObjectCollection = draft.getDynamicObjectCollection("endorseentry");
        DynamicObject dynamicObject = dynamicObjectCollection.addNew();
        String keyStr = draftId + "_" + tradeBill.getLong("id");
        DynamicObject subBill = subBillIdAndDyMap.get(keyStr);
        if (EmptyUtil.isNoEmpty((DynamicObject)subBill)) {
            DynamicObjectCollection subBilllEndorseentrys = subBill.getDynamicObjectCollection("endorseentry");
            DynamicObject subEndorese = subBilllEndorseentrys.addNew();
            this.setEndorseDy(tradeBill, draft, subEndorese);
            TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{subBill});
        } else {
            this.setEndorseDy(tradeBill, draft, dynamicObject);
            TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{draft});
        }
    }

    private void setEndorseDy(DynamicObject tradeBill, DynamicObject draft, DynamicObject dynamicObject) {
        dynamicObject.set("endorsetype", (Object)"transfer");
        dynamicObject.set("endorseistransfer", (Object)draft.getBoolean("istransfer"));
        dynamicObject.set("signdate", (Object)tradeBill.getDate("bizfinishdate"));
        dynamicObject.set("initiatorname", (Object)tradeBill.getDynamicObject("company").getString("name"));
        String payeeTypeText = tradeBill.getString("payeetypetext");
        if ("other".equals(payeeTypeText)) {
            dynamicObject.set("opponentname", (Object)tradeBill.getString("beendorsortext"));
        } else {
            dynamicObject.set("opponentname", (Object)tradeBill.getDynamicObject("beendorsor").getString("name"));
        }
    }

    private void genNoteDiscountInfo(DynamicObject tradeBill, DynamicObject entry, Map<String, DynamicObject> subBillIdAndDyMap) {
        long draftId = entry.getDynamicObject("draftbill").getLong("id");
        String draftType = tradeBill.getString("tradetype");
        String billno = tradeBill.getString("billno");
        DynamicObject draft = TmcDataServiceHelper.loadSingle((Object)draftId, (String)"cdm_receivablebill");
        String draftBillStatus = draft.getString("draftbillstatus");
        String draftBillno = draft.getString("billno");
        logger.info("discount trade bill billno is:" + billno + "and draft billno:" + draftBillno + " draftBillStatus is:" + draftBillStatus);
        DynamicObjectCollection dynamicObjectCollection = draft.getDynamicObjectCollection("endorseentry");
        DynamicObject dynamicObject = dynamicObjectCollection.addNew();
        String keyStr = draftId + "_" + tradeBill.getLong("id");
        DynamicObject subBill = subBillIdAndDyMap.get(keyStr);
        if (EmptyUtil.isNoEmpty((DynamicObject)subBill)) {
            DynamicObjectCollection subBilllEndorseentrys = subBill.getDynamicObjectCollection("endorseentry");
            DynamicObject endorseDy = subBilllEndorseentrys.addNew();
            this.setDiscountEndorseDy(tradeBill, draft, endorseDy);
            TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{subBill});
        } else {
            this.setDiscountEndorseDy(tradeBill, draft, dynamicObject);
            TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{draft});
        }
    }

    private void setDiscountEndorseDy(DynamicObject tradeBill, DynamicObject draft, DynamicObject dynamicObject) {
        dynamicObject.set("endorsetype", (Object)"notediscount");
        dynamicObject.set("endorseistransfer", (Object)draft.getBoolean("istransfer"));
        dynamicObject.set("signdate", (Object)tradeBill.getDate("bizdate"));
        dynamicObject.set("initiatorname", (Object)tradeBill.getDynamicObject("company").getString("name"));
        dynamicObject.set("opponentname", (Object)tradeBill.getDynamicObject("recbody").getString("name"));
    }

    private void setRecDraftBillStatusIntoPool(DynamicObject tradeBill, Object[] recBillIds) {
        String draftType = tradeBill.getString("tradetype");
        if (DraftTradeTypeEnum.REFUND.getValue().equals(draftType)) {
            DynamicObject[] recBills = TmcDataServiceHelper.load((Object[])recBillIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_receivablebill"));
            if (recBillIds.length <= 0) {
                return;
            }
            for (DynamicObject recBill : recBills) {
                recBill.set("draftbillstatus", (Object)DraftBillStatusEnum.REGISTERED.getValue());
            }
            SaveServiceHelper.save((DynamicObject[])recBills);
            TmcOperateServiceHelper.execOperate((String)"intopool", (String)"cdm_receivablebill", (DynamicObject[])recBills, (OperateOption)OperateOption.create());
        }
    }

    private void pushSplitBill(DynamicObject dataEntities, boolean isRec) {
        String opKey = SPLITPUSHRECBILL;
        String entityName = "cdm_receivablebill";
        if (!isRec) {
            opKey = SPLITPUSHPAYCBILL;
            entityName = "cdm_payablebill";
        }
        OperateOption operateOption = OperateOption.create();
        OperationResult result = TmcOperateServiceHelper.execOperate((String)opKey, (String)"cdm_drafttradebill", (DynamicObject[])new DynamicObject[]{dataEntities}, (OperateOption)operateOption);
        if (!result.isSuccess()) {
            List successPkIds = result.getSuccessPkIds();
            if (successPkIds.size() > 0) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("cdm_drafttradebill_ignore", "1");
                OperationResult deleteResult = TmcOperateServiceHelper.execOperateWithoutThrow((String)"delete", (String)entityName, (Object[])successPkIds.toArray(), (OperateOption)option);
                if (!deleteResult.isSuccess()) {
                    successPkIds.removeAll(deleteResult.getSuccessPkIds());
                    logger.error(String.format("\u62c6\u5206\u4e0b\u6e38\u5355\u636e\u5220\u9664\u5931\u8d25: [%s], ID: %s", entityName, successPkIds.toString()));
                }
            }
            String string = TmcOperateServiceHelper.decodeErrorMsg((OperationResult)result);
        }
    }

    private void pushGmDepositBill(DynamicObject data) {
        try {
            DynamicObjectCollection suretyEntries = data.getDynamicObjectCollection("depositentry");
            Map<String, DynamicObject> payableBillMap = this.getDraftBillsMap(data);
            for (DynamicObject suretyEntry : suretyEntries) {
                OperateOption operateOption = OperateOption.create();
                HashMap<String, Object> returnDataMap = new HashMap<String, Object>(16);
                returnDataMap.put("srcEntity", data.getDataEntityType().getName());
                returnDataMap.put("bizno", data.get("billno"));
                Map suretyEntryMap = DynamicObjectCompareHelper.dynamicObj2Map((DynamicObject)suretyEntry);
                HashMap<String, Map> suretyIdEntryMap = new HashMap<String, Map>(2);
                long suretyId = suretyEntry.getDynamicObject("dpbillno").getLong("id");
                suretyIdEntryMap.put(String.valueOf(suretyId), suretyEntryMap);
                suretyEntryMap.put("repaydate", data.getDate("bizdate"));
                suretyEntryMap.put("repayamount", suretyEntry.getBigDecimal("dpdeductamount"));
                returnDataMap.put("valueMap", suretyIdEntryMap);
                String returnData = SerializationUtils.toJsonString(returnDataMap);
                operateOption.setVariableValue("returnDataMap", returnData);
                operateOption.setVariableValue("debitId", String.valueOf(data.getPkValue()));
                operateOption.setVariableValue("debitType", data.getDataEntityType().getName());
                String revenuewayStr = suretyEntry.getDynamicObject("dpbillno").getString("revenueway");
                String deducttype = data.getString("deducttype");
                operateOption.setVariableValue("repayType", deducttype);
                if ("1".equalsIgnoreCase(deducttype)) {
                    BigDecimal bigDecimal = suretyEntry.getBigDecimal("dinterestamount");
                    if (!"norevenue".equalsIgnoreCase(revenuewayStr) && EmptyUtil.isNoEmpty((BigDecimal)bigDecimal)) {
                        operateOption.setVariableValue("repayIntAmt", String.valueOf(bigDecimal));
                    } else {
                        operateOption.setVariableValue("repayType", "2");
                    }
                }
                Map variables = operateOption.getVariables();
                logger.info("param is:" + SerializationUtils.toJsonString((Object)variables));
                OperationResult result = TmcOperateServiceHelper.execOperate((String)"suretyrepay", (String)"fbd_suretybill", (Object[])new Object[]{suretyId}, (OperateOption)operateOption);
                if (!result.isSuccess()) continue;
                this.writeBackSuretyInput(payableBillMap, suretyEntry);
            }
        }
        catch (Exception e) {
            logger.error("push deposit bill has Exception:", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    private Map<String, DynamicObject> getDraftBillsMap(DynamicObject data) {
        List draftBillIds = data.getDynamicObjectCollection("entrys").stream().map(row -> row.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toList());
        QFilter idFilter = new QFilter("id", "in", draftBillIds);
        DynamicObject[] payableBills = TmcDataServiceHelper.load((String)"cdm_payablebill", (String)"id,draftbillno,suretymoney,suretyinput", (QFilter[])new QFilter[]{idFilter});
        HashMap payableBillMap = Arrays.stream(payableBills).collect(Collectors.toMap(v -> v.getString("draftbillno"), o -> o, (o1, o2) -> o1, HashMap::new));
        return payableBillMap;
    }

    private void writeBackSuretyInput(Map<String, DynamicObject> payableBillMap, DynamicObject suretyEntry) {
        String dpBillNos = suretyEntry.getString("dpbillnos_tag");
        List<String> draftBillNos = Arrays.asList(dpBillNos.split(";"));
        ArrayList<DynamicObject> needUpdatePayableBills = new ArrayList<DynamicObject>(8);
        for (String draftBillNo : draftBillNos) {
            DynamicObject payableBill = payableBillMap.get(draftBillNo);
            if (EmptyUtil.isEmpty((DynamicObject)payableBill)) continue;
            payableBill.set("suretyinput", (Object)false);
            needUpdatePayableBills.add(payableBill);
        }
        if (!EmptyUtil.isEmpty(needUpdatePayableBills)) {
            SaveServiceHelper.save((DynamicObject[])needUpdatePayableBills.toArray(new DynamicObject[0]));
        }
    }

    private void writeBackSuretyAmount(DynamicObject suretyEntry, Map<String, DynamicObject> payableBillMap) {
        this.writeBackPayableBill(suretyEntry, payableBillMap);
        this.writeBackPayableApplyBill(suretyEntry, payableBillMap);
    }

    private void writeBackPayableBill(DynamicObject suretyEntry, Map<String, DynamicObject> payableBillMap) {
        BigDecimal dpDeductAmount = suretyEntry.getBigDecimal("dpdeductamount");
        String dpBillNos = suretyEntry.getString("dpbillnos_tag");
        List<String> draftBillNos = Arrays.asList(dpBillNos.split(";"));
        ArrayList<DynamicObject> needUpdatePayableBills = new ArrayList<DynamicObject>(8);
        for (String draftBillNo : draftBillNos) {
            DynamicObject payableBill = payableBillMap.get(draftBillNo);
            if (EmptyUtil.isEmpty((DynamicObject)payableBill)) continue;
            BigDecimal suretyMoney = payableBill.getBigDecimal("suretymoney");
            needUpdatePayableBills.add(payableBill);
        }
        if (!EmptyUtil.isEmpty(needUpdatePayableBills)) {
            SaveServiceHelper.save((DynamicObject[])needUpdatePayableBills.toArray(new DynamicObject[0]));
        }
    }

    private void writeBackPayableApplyBill(DynamicObject suretyEntry, Map<String, DynamicObject> payableBillMap) {
        Set sourceBillIdSet = payableBillMap.values().stream().map(a -> a.getLong("sourcebillid")).collect(Collectors.toSet());
        QFilter entryIdsFilter = new QFilter("entryentity.id", "in", sourceBillIdSet);
        DynamicObject[] payableApplyBills = TmcDataServiceHelper.load((String)"cdm_payablebill_ap_manual", (String)"id,billno,entryentity,entryentity.id,entryentity.entry_suretyamount", (QFilter[])new QFilter[]{entryIdsFilter});
        BigDecimal dpDeductAmount = suretyEntry.getBigDecimal("dpdeductamount");
        String dpBillNos = suretyEntry.getString("dpbillnos_tag");
        List<String> draftBillNos = Arrays.asList(dpBillNos.split(";"));
        ArrayList<DynamicObject> needUpdateBills = new ArrayList<DynamicObject>(8);
        for (String draftBillNo : draftBillNos) {
            DynamicObject payableBill = payableBillMap.get(draftBillNo);
            if (EmptyUtil.isEmpty((DynamicObject)payableBill)) continue;
            long sourceBillId = payableBill.getLong("sourcebillid");
            for (DynamicObject payableApplyBill : payableApplyBills) {
                DynamicObjectCollection entrys = payableApplyBill.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entrys) {
                    long entryId = entry.getLong("id");
                    BigDecimal suretyAmount = entry.getBigDecimal("entry_suretyamount");
                    if (entryId != sourceBillId) continue;
                    needUpdateBills.add(payableApplyBill);
                }
            }
        }
        if (!EmptyUtil.isEmpty(needUpdateBills)) {
            SaveServiceHelper.save((DynamicObject[])needUpdateBills.toArray(new DynamicObject[0]));
        }
    }

    private Map<String, DynamicObject> getPayableBillMap(DynamicObject data) {
        DynamicObjectCollection suretyEntries = data.getDynamicObjectCollection("depositentry");
        Set dpBillNos = suretyEntries.stream().map(a -> a.getString("dpbillnos_tag")).collect(Collectors.toSet());
        HashSet<String> draftBillNoSet = new HashSet<String>(8);
        for (String draftBillNoStr : dpBillNos) {
            List<String> draftBillNoList = Arrays.asList(draftBillNoStr.split(";"));
            draftBillNoSet.addAll(draftBillNoList);
        }
        QFilter draftBillNoFilter = new QFilter("draftbillno", "in", draftBillNoSet);
        QFilter rpTypeFilter = new QFilter("rptype", "=", (Object)"paybill");
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"C");
        DynamicObject[] payableBills = TmcDataServiceHelper.load((String)"cdm_payablebill", (String)"id,sourcebillid,draftbillno,suretymoney", (QFilter[])new QFilter[]{draftBillNoFilter, rpTypeFilter, billStatusFilter});
        HashMap payableBillMap = Arrays.stream(payableBills).collect(Collectors.toMap(v -> v.getString("draftbillno"), o -> o, (o1, o2) -> o1, HashMap::new));
        return payableBillMap;
    }

    private void pushPayInteresttBill(DynamicObject dataEntities) {
        List successPkIds;
        String opKey = PAYINTERESTPUSH;
        String entityName = "cas_paybill";
        OperateOption operateOption = OperateOption.create();
        OperationResult result = TmcOperateServiceHelper.execOperate((String)opKey, (String)"cdm_drafttradebill", (DynamicObject[])new DynamicObject[]{dataEntities}, (OperateOption)operateOption);
        if (!result.isSuccess() && (successPkIds = result.getSuccessPkIds()).size() > 0) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("cdm_drafttradebill_ignore", "1");
            OperationResult deleteResult = TmcOperateServiceHelper.execOperateWithoutThrow((String)"delete", (String)entityName, (Object[])successPkIds.toArray(), (OperateOption)option);
            if (!deleteResult.isSuccess()) {
                successPkIds.removeAll(deleteResult.getSuccessPkIds());
                logger.error(String.format("\u4e70\u65b9\u4ed8\u606f\u4e0b\u6e38\u5355\u636e\u5220\u9664\u5931\u8d25: [%s], ID: %s", entityName, successPkIds.toString()));
            }
        }
    }

    public String setBillEleStatus(String tradeType) {
        String eleStatus = "";
        switch (tradeType) {
            case "endorse": {
                eleStatus = "recitesigned";
                break;
            }
            case "pledge": {
                eleStatus = "pledgesigned";
                break;
            }
            case "rlspledge": {
                eleStatus = "releaseofedgsigned";
                break;
            }
            case "discount": {
                eleStatus = "notediscountsigned";
                break;
            }
            case "collect": {
                eleStatus = "paymentsigned";
            }
        }
        return eleStatus;
    }

    private void dealPledgedToRegistered(Object[] tradeBillIds) {
        if (tradeBillIds.length > 0) {
            DynamicObject[] tradeBillArr;
            for (DynamicObject data : tradeBillArr = TmcDataServiceHelper.load((Object[])tradeBillIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_drafttradebill"))) {
                DynamicObject[] draftArr = TradeBillHelper.getDraftArrByTradeBillArr((DynamicObject[])new DynamicObject[]{data});
                Map<Long, DynamicObject> idAndbillMap = Arrays.stream(draftArr).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
                DynamicObjectCollection newEntrys = data.getDynamicObjectCollection("entrys");
                boolean hasFailedRec = false;
                boolean hasSuccessRec = false;
                String headTransStatus = DraftTranStatusEnum.SUCCESS.getValue();
                for (DynamicObject newEntry : newEntrys) {
                    DynamicObject draft = newEntry.getDynamicObject("draftbill");
                    newEntry.set("transtatus", (Object)DraftTranStatusEnum.SUCCESS.getValue());
                    if (DraftTranStatusEnum.SUCCESS.getValue().equals(newEntry.getString("transtatus"))) {
                        hasSuccessRec = true;
                        continue;
                    }
                    if (!DraftTranStatusEnum.FAILING.getValue().equals(newEntry.getString("transtatus"))) continue;
                    hasFailedRec = true;
                }
                if (hasFailedRec && hasSuccessRec) {
                    headTransStatus = DraftTranStatusEnum.PORSUCCESS.getValue();
                } else if (hasFailedRec) {
                    headTransStatus = DraftTranStatusEnum.FAILING.getValue();
                    data.set("electag", (Object)"0");
                } else if (hasSuccessRec) {
                    headTransStatus = DraftTranStatusEnum.SUCCESS.getValue();
                }
                data.set("draftbilltranstatus", (Object)headTransStatus);
                Date bizfinishdate = data.getDate("bizfinishdate");
                if (bizfinishdate != null) continue;
                data.set("bizfinishdate", (Object)new Date());
            }
            TmcDataServiceHelper.save((DynamicObject[])tradeBillArr);
            this.deleteGmPledgeData(tradeBillArr);
        }
    }
}

