/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.tradebill;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TradeBillEqualDifferentService
extends AbstractTmcBizOppService {
    private static final Log LOGGER = LogFactory.getLog(TradeBillEqualDifferentService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entrys");
        selector.add("isneedsplit");
        selector.add("transtatus");
        selector.add("draftbill");
        selector.add("billamt");
        selector.add("sourcebillid");
        selector.add("source");
        selector.add("tradetype");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        block8: {
            LOGGER.info("TradeBillEqualDifferentService is start");
            HashSet<DynamicObject> needSplitTradeBIllList = new HashSet<DynamicObject>();
            for (DynamicObject tradebill : dataEntities) {
                DynamicObjectCollection entrys = tradebill.getDynamicObjectCollection("entrys");
                if (CollectionUtils.isEmpty((Collection)entrys)) {
                    LOGGER.info("entrys is null");
                    continue;
                }
                for (DynamicObject entry : entrys) {
                    boolean isgenbysplit = entry.getBoolean("isneedsplit");
                    String transtatus = entry.getString("transtatus");
                    if (!isgenbysplit || !"success".equals(transtatus)) continue;
                    needSplitTradeBIllList.add(tradebill);
                }
            }
            if (EmptyUtil.isNoEmpty(needSplitTradeBIllList)) {
                LOGGER.info("needSplitTradeBIllList size is:" + needSplitTradeBIllList.size());
                try {
                    OperateOption create = OperateOption.create();
                    OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"pushsplitbilltrade", (String)"cdm_drafttradebill", (DynamicObject[])needSplitTradeBIllList.toArray(new DynamicObject[0]), (OperateOption)create);
                    if (!EmptyUtil.isNoEmpty((Object)operationResult)) break block8;
                    boolean success = operationResult.isSuccess();
                    if (success) {
                        LOGGER.info("push equaldifferent sucess");
                        break block8;
                    }
                    LOGGER.info("push equaldifferent fail");
                }
                catch (Exception e) {
                    LOGGER.error("equaldifferent has error:", (Throwable)e);
                }
            } else {
                LOGGER.info("needSplitTradeBIllList  is empty");
            }
        }
    }
}

