/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.tradebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.cdm.common.helper.TradeBillHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TradeBillRePayService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(TradeBillRePayService.class);
    public static final String ENDORSE = "endorse";
    public static final String DISCOUNT = "discount";
    public static final String COLLECT = "collect";

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("tradetype");
        selector.add("isrepay");
        selector.add("draftbilltranstatus");
        selector.add("billstatus");
        selector.add("sourcebillid");
        selector.add("sourcebilltype");
        selector.add("entrys.draftbill");
        selector.add("entrys");
        selector.add("entrys.transtatus");
        selector.add("draftbilltranstatus");
        selector.add("source");
        selector.add("isrejectrefund");
        selector.add("rptype");
        selector.add("entrys.entryisrejectrefund");
        selector.add("entrys.entryisrepay");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        List idList = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).map(Object::toString).collect(Collectors.toList());
        Map request = MutexServiceHelper.batchRequestWithLostTime(idList, (String)"cdm_drafttradebill", (String)"failRepay");
        ArrayList errors = new ArrayList();
        List requestIds = MutexServiceHelper.getRequestResultList(idList, errors, (Map)request);
        Map<Object, String> idAndBillNoMap = Arrays.stream(dataEntities).collect(Collectors.toMap(DataEntityBase::getPkValue, dy -> dy.getString("billno"), (m1, m2) -> m1));
        try {
            if (idList.size() != requestIds.size()) {
                ArrayList errorBillNos = new ArrayList(10);
                errors.forEach(error -> {
                    String billNo = idAndBillNoMap.getOrDefault(Long.parseLong(error.getPkValue().toString()), "");
                    errorBillNos.add(billNo);
                });
                throw new KDBizException(ResManager.loadKDString((String)"\u5931\u8d25\u91cd\u4ed8\u64cd\u4f5c\u7533\u8bf7\u9501\u5931\u8d25\uff0c\u5931\u8d25\u7684\u4e1a\u52a1\u5904\u7406\u5355\u7f16\u53f7\uff1a{0}", (String)"TradeBillRePayService_0", (String)"tmc-cdm-business", (Object[])new Object[]{errorBillNos}));
            }
            for (DynamicObject dataEntity : dataEntities) {
                DynamicObject[] failedReceiveDrafts;
                DynamicObjectCollection dynamicObjectList;
                OperationResult result = TmcOperateServiceHelper.execOperate((String)"pushdrafttradebill", (String)"cdm_drafttradebill", (Object[])new Object[]{dataEntity.getPkValue()}, (OperateOption)OperateOption.create());
                if (result.isSuccess()) {
                    DynamicObjectCollection entries = dataEntity.getDynamicObjectCollection("entrys");
                    if (TradeBillHelper.canRepayOrRejectRefundCallTradeBillDraw((DynamicObjectCollection)entries)) {
                        OperateOption option = OperateOption.create();
                        option.setVariableValue("COMPLETEFROM_ELEUPDATE", "true");
                        option.setVariableValue("isrepayrecall", "true");
                        OperationResult drawBillSaveResult = TmcOperateServiceHelper.execOperate((String)"drawbillsave", (String)"cdm_drafttradebill", (Object[])new Object[]{dataEntity.getPkValue()}, (OperateOption)option);
                        if (!drawBillSaveResult.isSuccess()) {
                            logger.info("TradeBillRePayService afterProcess drawBillSave is error,billNo = {},errorMsg = {}", (Object)dataEntity.getString("billno"), (Object)drawBillSaveResult.getAllErrorOrValidateInfo());
                        } else {
                            logger.info("TradeBillRePayService afterProcess drawBillSave is success,billNo = {}", (Object)dataEntity.getString("billno"));
                        }
                    }
                    dataEntity.set("isrepay", (Object)"1");
                    dynamicObjectList = dataEntity.getDynamicObjectCollection("entrys");
                    Object[] failedPkValues = dynamicObjectList.stream().filter(o -> DraftTranStatusEnum.FAILING.getValue().equals(o.getString("transtatus"))).map(o -> o.getDynamicObject("draftbill").getPkValue()).toArray();
                    for (DynamicObject failedReceiveDraft : failedReceiveDrafts = TmcDataServiceHelper.load((Object[])failedPkValues, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_receivablebill"))) {
                        failedReceiveDraft.set("draftbilltranstatus", (Object)DraftTranStatusEnum.SUCCESS.getValue());
                        failedReceiveDraft.set("electag", (Object)"0");
                    }
                } else {
                    throw new KDBizException(result.getMessage());
                }
                dynamicObjectList.stream().filter(e -> EmptyUtil.isNoEmpty((DynamicObject)e.getDynamicObject("draftbill"))).filter(TradeBillHelper::canRepayOrRejectRefundDraftEntry).forEach(e -> e.set("entryisrepay", (Object)true));
                TmcDataServiceHelper.save((DynamicObject[])failedReceiveDrafts);
                TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
            }
        }
        catch (Exception e2) {
            logger.error("\u4e1a\u52a1\u5904\u7406\u5355\u5931\u8d25\u91cd\u4ed8\u64cd\u4f5c\u5f02\u5e38\u3002", (Throwable)e2);
            if (e2 instanceof KDBizException) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u5355\u5931\u8d25\u91cd\u4ed8\u64cd\u4f5c\u5f02\u5e38\uff0c\u539f\u56e0\uff1a{0}", (String)"TradeBillRePayService_1", (String)"tmc-cdm-business", (Object[])new Object[]{e2.getMessage()}));
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u5355\u5931\u8d25\u91cd\u4ed8\u64cd\u4f5c\u5f02\u5e38\u3002", (String)"TradeBillRePayService_2", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
        finally {
            MutexServiceHelper.batchRelease((List)requestIds, (String)"cdm_drafttradebill", (String)"failRepay");
        }
    }
}

