/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.tradebill;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.model.CreditLimitInfo;
import kd.tmc.fbp.common.model.CreditLimitUseBean;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TradeBillSubmitCreaditService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(TradeBillSubmitCreaditService.class);
    private boolean isRpcSuccess = false;

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entrys");
        selector.add("source");
        selector.add("tradetype");
        selector.add("draftbill");
        selector.add("oldstatus");
        selector.add("recbody");
        selector.add("recbodyname");
        selector.add("payeetypetext");
        selector.add("beendorsortext");
        selector.add("beendorsor");
        selector.add("sourcebillid");
        selector.add("sourcebilltype");
        selector.add("allocbillentryid");
        selector.add("pledgeebase");
        selector.add("bizdate");
        selector.add("bizfinishdate");
        selector.add("bankacct");
        selector.add("bank");
        selector.add("bankcode");
        selector.add("pledgeetype");
        selector.add("pledgeeaccount");
        selector.add("pledgeeopenbank");
        selector.add("pledgeeopenbanknumber");
        selector.add("payinteramount_bank");
        selector.add("owndiscountinterest");
        selector.add("payinterestamount");
        selector.add("discount_interest");
        selector.add("allbillsamount");
        selector.add("billlogid");
        selector.add("billamt");
        selector.add("isrepaygen");
        selector.add("isrejectrefundgen");
        selector.add("billno");
        selector.add("rptype");
        selector.add("creditlimited");
        selector.add("drafttype");
        selector.add("billstatus");
        selector.add("bizdate");
        selector.add("billno");
        selector.add("tradetype");
        selector.add("entrys");
        selector.add("draftbill");
        selector.add("source");
        selector.add("sourcebillid");
        selector.add("recbody");
        selector.add("company");
        selector.add("currency");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        logger.info("TradeBillSaveService is start:" + dataEntities[0].getString("billno"));
        for (DynamicObject data : dataEntities) {
            if (!EmptyUtil.isNoEmpty((DynamicObject)data.getDynamicObject("creditlimited"))) continue;
            logger.info("start to do cfm");
            DynamicObject creditLimit = data.getDynamicObject("creditlimited");
            if (!EmptyUtil.isNoEmpty((DynamicObject)creditLimit)) continue;
            CreditLimitUseBean useBean = this.getCreditLimitUseInfo(data);
            useBean.setPreOccupy(Boolean.valueOf(false));
            useBean.setCreditLimitNo(creditLimit.getString("number"));
            useBean.setCreditLimitId(Long.valueOf(creditLimit.getLong("id")));
            CreditLimitServiceHelper.autoUseCreditLimit((CreditLimitUseBean)useBean);
            logger.info("do cfm end");
            DynamicObject srcdate = this.findSrcdate(data);
            CreditLimitInfo creditLimitInfo = CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)data, (DynamicObject)srcdate, (boolean)false, (Date)data.getDate("bizdate"));
            boolean isRpcSuccess = creditLimitInfo.isSuccess();
            if (isRpcSuccess) continue;
            this.operationResult.setSuccess(false);
            throw new TmcBizException(TmcErrorCode.COMMON, (Object[])new String[]{creditLimitInfo.getMessage()});
        }
    }

    private CreditLimitUseBean getCreditLimitUseInfo(DynamicObject bill) {
        String sourceStr;
        long billId;
        BigDecimal realamt;
        CreditLimitUseBean useBean = new CreditLimitUseBean();
        useBean.setPkId(Long.valueOf(bill.getLong("id")));
        useBean.setEntityName(bill.getDataEntityType().getName());
        useBean.setOrgId((Long)bill.getDynamicObject("company").getPkValue());
        useBean.setCurrencyId((Long)bill.getDynamicObject("currency").getPkValue());
        DynamicObject draftbilltype = bill.getDynamicObject("drafttype");
        if (EmptyUtil.isNoEmpty((DynamicObject)draftbilltype)) {
            useBean.setFinOrgId(Long.valueOf(bill.getDynamicObject("recbody").getLong("id")));
            useBean.setCreditFinType("bd_finorginfo");
            DynamicObject credittypeDO = draftbilltype.getDynamicObject("credittype");
            if (EmptyUtil.isNoEmpty((DynamicObject)credittypeDO)) {
                useBean.setCreditTypeId((Long)credittypeDO.getPkValue());
            }
            useBean.setCreditVariety(draftbilltype.getString("name"));
        }
        if (EmptyUtil.isEmpty((BigDecimal)(realamt = this.loadCreditUse(billId = bill.getLong("id")))) && "bizapply".equals(sourceStr = bill.getString("source"))) {
            billId = bill.getLong("sourcebillid");
            realamt = this.loadCreditUse(billId);
        }
        useBean.setMaxAmt(realamt);
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entrys");
        DynamicObject maxDateDy = entrys.stream().max(Comparator.comparing(e -> e.getDynamicObject("draftbill").getDate("draftbillexpiredate"))).get();
        useBean.setStartDate(bill.getDate("bizdate"));
        useBean.setEndDate(maxDateDy.getDynamicObject("draftbill").getDate("draftbillexpiredate"));
        useBean.setBizAmt(realamt);
        DynamicObject srcdate = this.findSrcdate(bill);
        if (null != srcdate) {
            logger.info("srcdate is not null");
            useBean.setSourceBillId(Long.valueOf(srcdate.getLong("id")));
            useBean.setSourceType(srcdate.getDataEntityType().getName());
        }
        return useBean;
    }

    private DynamicObject findSrcdate(DynamicObject data) {
        String source = data.getString("source");
        if (!"bizapply".equals(source)) {
            return null;
        }
        long sourcebillid = data.getLong("sourcebillid");
        QFilter qFilter = new QFilter("id", "=", (Object)sourcebillid);
        DynamicObject srcbill = BusinessDataServiceHelper.loadSingle((String)"cdm_discount_apply", (String)"id", (QFilter[])new QFilter[]{qFilter});
        return srcbill;
    }

    private BigDecimal loadCreditUse(Long sourceBillId) {
        BigDecimal realamt = BigDecimal.ZERO;
        if (EmptyUtil.isEmpty((Long)sourceBillId)) {
            return realamt;
        }
        QFilter source_qFilter = new QFilter("sourcebillid", "=", (Object)sourceBillId);
        QFilter isrele_qFilter = new QFilter("isrelease", "=", (Object)"0");
        DynamicObjectCollection creditUses = QueryServiceHelper.query((String)"cfm_credituse", (String)"sourcebillentryid, currency, realamt", (QFilter[])new QFilter[]{source_qFilter, isrele_qFilter});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)creditUses)) {
            DynamicObject creditUs = (DynamicObject)creditUses.get(0);
            realamt = creditUs.getBigDecimal("realamt");
        }
        return realamt;
    }
}

