/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.tradebill;

import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.business.opservice.tradebill.TradeBillAuditService;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.cdm.common.helper.TradeBillHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.CreditLimitInfo;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TradeBillUnAuditService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(TradeBillAuditService.class);
    private boolean isRpcSuccess;

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entrys");
        selector.add("entrys.transtatus");
        selector.add("entrys.draftbill");
        selector.add("entrys.billlogid");
        selector.add("creditlimited");
        selector.add("drafttype");
        selector.add("billstatus");
        selector.add("bizdate");
        selector.add("billno");
        selector.add("tradetype");
        selector.add("sourcebillid");
        selector.add("source");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        Object[] draftLogArr;
        DynamicObject[] draftArr;
        HashSet<Long> draftBillLogSet = new HashSet<Long>(8);
        for (DynamicObject draftTradeBill : dataEntities) {
            long sourceId;
            Object[] applyDyColl;
            draftTradeBill.set("draftbilltranstatus", null);
            DynamicObjectCollection dynamicObjects = draftTradeBill.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : dynamicObjects) {
                entry.set("transtatus", null);
                long billlogid = entry.getLong("billlogid");
                draftBillLogSet.add(billlogid);
            }
            String tradeTypeStr = draftTradeBill.getString("tradetype");
            if (!EmptyUtil.isNoEmpty((DynamicObject)draftTradeBill.getDynamicObject("creditlimited")) || !tradeTypeStr.equals("discount")) continue;
            logger.info("TradeBillUnSubmitService start cancelCreditLimit");
            String sourceStr = draftTradeBill.getString("source");
            Object sourceDy = null;
            if ("bizapply".equals(sourceStr) && EmptyUtil.isNoEmpty((Object[])(applyDyColl = BusinessDataServiceHelper.load((String)"cdm_discount_apply", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)(sourceId = draftTradeBill.getLong("sourcebillid"))), new QFilter("creditlimited", "!=", (Object)0L)})))) {
                sourceDy = applyDyColl[0];
            }
            CreditLimitInfo creditLimitInfo = CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)draftTradeBill, sourceDy, (boolean)false);
            this.isRpcSuccess = creditLimitInfo.isSuccess();
            logger.info("TradeBillUnSubmitService cancelCreditLimit isRpcSuccess:" + this.isRpcSuccess);
            if (this.isRpcSuccess) continue;
            this.operationResult.setSuccess(false);
            throw new TmcBizException(TmcErrorCode.COMMON, (Object[])new String[]{creditLimitInfo.getMessage()});
        }
        for (DynamicObject draft : draftArr = TradeBillHelper.getDraftArrByTradeBillArr((DynamicObject[])dataEntities)) {
            draft.set("draftbilltranstatus", (Object)DraftTranStatusEnum.SUCCESS.getValue());
        }
        if (EmptyUtil.isNoEmpty(draftBillLogSet) && EmptyUtil.isNoEmpty((Object[])(draftLogArr = TmcDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id,bizstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", draftBillLogSet), new QFilter("bizstatus", "=", (Object)"fail"), new QFilter("issplit", "=", (Object)Character.valueOf('0'))})))) {
            for (Object draftLog : draftLogArr) {
                draftLog.set("bizstatus", (Object)"process");
            }
            TmcDataServiceHelper.save((DynamicObject[])draftLogArr);
        }
        TmcDataServiceHelper.save((DynamicObject[])draftArr);
        TmcDataServiceHelper.save((DynamicObject[])dataEntities);
    }
}

