/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.tradebill;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.model.CreditLimitInfo;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TradeBillUnSubmitService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(TradeBillUnSubmitService.class);
    private boolean isRpcSuccess;

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("creditlimited");
        sic.add("drafttype");
        sic.add("billstatus");
        sic.add("bizdate");
        sic.add("billno");
        sic.add("tradetype");
        sic.add("entrys");
        sic.add("draftbill");
        sic.add("sourcebillid");
        sic.add("source");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataObj : dataEntities) {
            long sourceId;
            Object[] applyDyColl;
            String tradeTypeStr = dataObj.getString("tradetype");
            if (!tradeTypeStr.equals("discount") || !EmptyUtil.isNoEmpty((DynamicObject)dataObj.getDynamicObject("creditlimited"))) continue;
            logger.info("TradeBillUnSubmitService start cancelCreditLimit");
            String sourceStr = dataObj.getString("source");
            Object sourceDy = null;
            if ("bizapply".equals(sourceStr) && EmptyUtil.isNoEmpty((Object[])(applyDyColl = BusinessDataServiceHelper.load((String)"cdm_discount_apply", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)(sourceId = dataObj.getLong("sourcebillid"))), new QFilter("creditlimited", "!=", (Object)0L)})))) {
                sourceDy = applyDyColl[0];
            }
            CreditLimitInfo creditLimitInfo = CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)dataObj, sourceDy, (boolean)false);
            this.isRpcSuccess = creditLimitInfo.isSuccess();
            logger.info("TradeBillUnSubmitService cancelCreditLimit isRpcSuccess:" + this.isRpcSuccess);
            if (this.isRpcSuccess) continue;
            this.operationResult.setSuccess(false);
            throw new TmcBizException(TmcErrorCode.COMMON, (Object[])new String[]{creditLimitInfo.getMessage()});
        }
    }
}

