/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.tradebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.cdm.business.opservice.tradebill.TradeBillAuditService;
import kd.tmc.cdm.common.enums.DraftTradeTypeEnum;
import kd.tmc.cdm.common.helper.TradeBillHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;

public class TradeDrawCollectService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(TradeBillAuditService.class);
    public static final String PUSHANDSAVERECBILL = "pushandsaverecbill";

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("tradetype");
        selector.add("draftbill");
        selector.add("company");
        selector.add("drafttype");
        selector.add("billno");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        logger.info("TradeDrawCollectService is start :" + dataEntities[0].getString("billno"));
        ArrayList pushdataEmtities = new ArrayList();
        for (DynamicObject data : dataEntities) {
            TradeBillHelper.fillPushData(pushdataEmtities, (DynamicObject)data);
        }
        logger.info("pushdataEmtities size is:" + pushdataEmtities.size());
        this.pushCasBill(pushdataEmtities.toArray(new DynamicObject[0]));
        logger.info("TradeDrawCollectService is end!");
    }

    private void pushCasBill(DynamicObject[] dataEntities) {
        List pushCollectRecBillIdList = Arrays.stream(dataEntities).filter(e -> DraftTradeTypeEnum.COLLECT.getValue().equals(e.getString("tradetype"))).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(pushCollectRecBillIdList)) {
            TradeBillHelper.pushCasBill((String)PUSHANDSAVERECBILL, (Object[])pushCollectRecBillIdList.toArray(), (OperateOption)OperateOption.create(), (String)"cas_recbill");
        }
    }
}

