/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.pool.actions.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.cdm.business.pool.actions.ITransferAction;
import kd.tmc.cdm.business.pool.actions.TransferActionContext;
import kd.tmc.cdm.business.pool.state.TransferStateEnums;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.cdm.common.enums.TransBillOpStatusEnum;
import kd.tmc.cdm.common.helper.RecEleDraftHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public abstract class AbstractTransferAction
implements ITransferAction {
    private static Log logger = LogFactory.getLog(AbstractTransferAction.class);
    protected List<String> errMsgList = new ArrayList<String>();
    protected TransferActionContext context;

    @Override
    public void setContext(TransferActionContext context) {
        this.context = context;
    }

    @Override
    public boolean validate() {
        boolean isStateLegal;
        DynamicObject entry = this.context.getTransferEntry();
        String opStatus = entry.getString("e_transoptionstatus");
        String draftBill = entry.getDynamicObject("e_draftbill").getString("draftbillno");
        boolean bl = isStateLegal = EmptyUtil.isEmpty((String)opStatus) || TransBillOpStatusEnum.SUCCESS.getValue().equals(opStatus) || TransBillOpStatusEnum.FAIL.getValue().equals(opStatus);
        if (!isStateLegal) {
            String stateErrMsg = ResManager.loadKDString((String)"\u53ea\u6709\u64cd\u4f5c\u72b6\u6001\u4e3a\u7a7a\u3001\u4ea4\u6613\u6210\u529f\u3001\u4ea4\u6613\u5931\u8d25\u7684\u7968\u636e\u624d\u80fd\u6267\u884c\u7968\u636e\u8c03\u5ea6", (String)"AbstractTransferAction_1", (String)"tmc-cdm-business", (Object[])new Object[0]);
            logger.info("validate error:" + stateErrMsg + ", draftBill:" + draftBill + ",opStatus is:" + opStatus);
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        DynamicObject entry = this.context.getTransferEntry();
        boolean isSuccess = false;
        boolean hasException = false;
        String exceptionMsg = ResManager.loadKDString((String)"\u672a\u77e5\u5f02\u5e38", (String)"AbstractTransferAction_0", (String)"tmc-cdm-business", (Object[])new Object[0]);
        try {
            TransferStateEnums currStatus = this.context.getCurrState();
            entry.set("e_opbilltype", (Object)currStatus.getBillType());
            entry.set("e_opbilltsteps", (Object)currStatus.getOpVal());
            entry.set("e_transoptionstatus", (Object)TransBillOpStatusEnum.PROCESSING.getValue());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.context.getTransferBill()});
        }
        catch (Exception e) {
            hasException = true;
            exceptionMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
        }
        try {
            this.beforeDoExecute();
        }
        catch (Exception e) {
            hasException = true;
            exceptionMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
        }
        if (!hasException) {
            try {
                isSuccess = this.doExecute();
                if (isSuccess) {
                    String opStep = this.context.getTransferEntry().getString("e_opbilltsteps");
                    Boolean isSubmitele = TransferStateEnums.ENDORSE_SUBMITELE.getOpVal().equals(opStep) || TransferStateEnums.ENDORSEUP_SUBMITELE.getOpVal().equals(opStep);
                    if (isSubmitele.booleanValue()) {
                        entry.set("e_transoptionstatus", (Object)TransBillOpStatusEnum.PROCESSING.getValue());
                    } else {
                        entry.set("e_transoptionstatus", (Object)TransBillOpStatusEnum.SUCCESS.getValue());
                    }
                    entry.set("e_errmsg", null);
                    entry.set("e_errmsg_TAG", null);
                } else {
                    String errMsg = String.join((CharSequence)";", this.errMsgList);
                    entry.set("e_transoptionstatus", (Object)TransBillOpStatusEnum.FAIL.getValue());
                    if (!EmptyUtil.isEmpty((String)errMsg)) {
                        entry.set("e_errmsg", (Object)errMsg.substring(0, Math.min(errMsg.length(), 50)));
                        entry.set("e_errmsg_TAG", (Object)errMsg);
                    }
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.context.getTransferBill()});
                this.beforeCommitExecute();
            }
            catch (Exception e) {
                hasException = true;
                exceptionMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            }
        }
        try {
            this.afterDoExecute();
        }
        catch (Exception e) {
            hasException = true;
            exceptionMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
        }
        if (hasException) {
            try (TXHandle tx3 = TX.requiresNew();){
                try {
                    entry.set("e_transoptionstatus", (Object)TransBillOpStatusEnum.FAIL.getValue());
                    if (!EmptyUtil.isEmpty((String)exceptionMsg)) {
                        entry.set("e_errmsg", (Object)exceptionMsg.substring(0, Math.min(exceptionMsg.length(), 50)));
                        entry.set("e_errmsg_TAG", (Object)exceptionMsg);
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.context.getTransferBill()});
                }
                catch (Exception e) {
                    logger.error("\u8c03\u5ea6\u5931\u8d25\u72b6\u6001\u5165\u5e93\u5931\u8d25", (Throwable)e);
                    tx3.markRollback();
                }
            }
        }
        return isSuccess;
    }

    @Override
    public List<String> getErrMsgList() {
        return this.errMsgList;
    }

    protected void beforeDoExecute() {
    }

    protected abstract boolean doExecute();

    protected void beforeCommitExecute() {
    }

    protected void afterDoExecute() {
    }

    protected OperationResult doOperate(String opName, String entityName, DynamicObject[] dataArr, OperateOption option) {
        logger.info("opName is:" + opName);
        OperationResult result = TmcOperateServiceHelper.execOperate((String)opName, (String)entityName, (DynamicObject[])dataArr, (OperateOption)option);
        this.handleOpResult(result);
        return result;
    }

    protected OperationResult doOperate(String opName, String entityName, Object[] idArr, OperateOption option) {
        OperationResult result = TmcOperateServiceHelper.execOperate((String)opName, (String)entityName, (Object[])idArr, (OperateOption)option);
        this.handleOpResult(result);
        return result;
    }

    private void handleOpResult(OperationResult result) {
        if (!result.isSuccess()) {
            String errMsg = TmcOperateServiceHelper.decodeMultiErrorMsg((OperationResult)result);
            this.errMsgList.add(errMsg);
        }
    }

    protected DynamicObject getUnsuccessfulDraftTradeBill() {
        QFilter repayFilter;
        DynamicObject transBill = this.context.getTransferBill();
        DynamicObject transferEntry = this.context.getTransferEntry();
        QFilter sourceBillFilter = new QFilter("sourcebilltype", "=", (Object)transBill.getDynamicObjectType().getName()).and(new QFilter("sourcebillid", "=", transBill.getPkValue()).and(new QFilter("sourcebillentryid", "=", transferEntry.getPkValue())));
        DynamicObject[] draftTradeBills = BusinessDataServiceHelper.load((String)"cdm_drafttradebill", (String)"id", (QFilter[])sourceBillFilter.and(repayFilter = new QFilter("isrepay", "=", (Object)"0")).toArray());
        if (draftTradeBills.length > 0) {
            Object[] draftTradeIds = Arrays.stream(draftTradeBills).map(DataEntityBase::getPkValue).toArray();
            List unsuccessfulBill = Arrays.stream(draftTradeBills = BusinessDataServiceHelper.load((Object[])draftTradeIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cdm_drafttradebill"))).filter(dt -> !Objects.equals(dt.getString("draftbilltranstatus"), DraftTranStatusEnum.SUCCESS.getValue())).collect(Collectors.toList());
            if (unsuccessfulBill.size() > 1) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u51fa\u73b0%s\u5f20\u975e\u6210\u529f\u72b6\u6001\u7684\u4e1a\u52a1\u5904\u7406\u5355\uff0c\u6570\u636e\u5f02\u5e38\u3002", (String)"AbstractTransferAction_2", (String)"tmc-cdm-business", (Object[])new Object[0]), unsuccessfulBill.size()));
            }
            return unsuccessfulBill.size() == 0 ? null : (DynamicObject)unsuccessfulBill.get(0);
        }
        return null;
    }

    protected boolean isSubmitEle() {
        DynamicObject transferEntry = this.context.getTransferEntry();
        DynamicObject transferBill = this.context.getTransferBill();
        return RecEleDraftHelper.isSubmitEleNew((DynamicObject)transferBill, Collections.singletonList(transferEntry.getDynamicObject("e_draftbill").getLong("id")));
    }
}

