/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.pool.actions.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.business.pool.actions.impl.AbstractTransferAction;
import kd.tmc.cdm.common.enums.BizBusinessTypeEnum;
import kd.tmc.cdm.common.enums.DraftBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PoolOutAction
extends AbstractTransferAction {
    private static final Log logger = LogFactory.getLog(PoolOutAction.class);

    @Override
    protected boolean doExecute() {
        DynamicObject transferEntry = this.context.getTransferEntry();
        DynamicObject transferBill = this.context.getTransferBill();
        DynamicObject draftBill = transferEntry.getDynamicObject("e_draftbill");
        DynamicObject receivableBill = BusinessDataServiceHelper.loadSingle((Object)draftBill.getPkValue(), (String)"cdm_receivablebill");
        if (receivableBill.get("billpool").equals(0)) {
            return true;
        }
        HashSet<DynamicObject> receivableBillSet = new HashSet<DynamicObject>();
        this.addGenerateReceivableBills(receivableBillSet, new DynamicObject[]{receivableBill});
        List receivableBillList = receivableBillSet.stream().filter(r -> Objects.equals(r.getString("draftbillstatus"), DraftBillStatusEnum.ENDORSED.getValue())).collect(Collectors.toList());
        if (receivableBillList.stream().map(DataEntityBase::getPkValue).noneMatch(pk -> pk.equals(receivableBill.getPkValue()))) {
            receivableBillList.add(receivableBill);
        }
        Object[] draftBillIds = receivableBillList.stream().filter(bill -> Objects.nonNull(bill.getDynamicObject("billpool"))).map(DataEntityBase::getPkValue).toArray();
        OperateOption operateOptionPush = OperateOption.create();
        operateOptionPush.setVariableValue("autoallocation", "true");
        long allocId = transferBill.getLong("id");
        operateOptionPush.setVariableValue("allocationid", String.valueOf(allocId));
        OperationResult pushResult = TmcOperateServiceHelper.execOperate((String)"pushout", (String)"cdm_receivablebill", (Object[])draftBillIds, (OperateOption)operateOptionPush);
        DynamicObjectCollection outBills = null;
        if (!pushResult.isSuccess()) {
            throw new KDBizException(TmcOperateServiceHelper.decodeErrorMsg((OperationResult)pushResult));
        }
        QFilter sourceBillFilter = new QFilter("sourcebillid", "in", (Object)draftBillIds);
        QFilter typeFilter = new QFilter("businesstype", "=", (Object)BizBusinessTypeEnum.OUT.getValue());
        outBills = QueryServiceHelper.query((String)"cdm_billpoolbiz", (String)"id,bizdate,businesstype,billstatus", (QFilter[])new QFilter[]{sourceBillFilter, typeFilter});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)outBills)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e\u4e0b\u63a8\u7684\u51fa\u6c60\u7533\u8bf7\u5355\u4e3a\u7a7a\u3002", (String)"PoolOutAction_0", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("autoallocation", "true");
        operateOption.setVariableValue("allocationid", String.valueOf(allocId));
        OperationResult result = null;
        try {
            Object[] outBillIds = outBills.stream().filter(e -> "A".equalsIgnoreCase(e.getString("billstatus"))).map(e -> e.getLong("id")).toArray();
            if (EmptyUtil.isNoEmpty((Object[])outBillIds)) {
                logger.info("is will submit" + outBillIds.length);
                result = this.doOperate("submit", "cdm_billpoolbiz", outBillIds, operateOption);
                if (result.isSuccess()) {
                    logger.info("is will audit");
                    result = this.doOperate("audit", "cdm_billpoolbiz", result.getSuccessPkIds().toArray(), operateOption);
                }
            } else {
                logger.info("outBillIds is null");
            }
        }
        catch (Exception e2) {
            logger.error("\u51fa\u6c60\u7533\u8bf7\u4fdd\u5b58\u63d0\u4ea4\u5ba1\u6838\u5f02\u5e38\u3002", (Throwable)e2);
            throw e2;
        }
        if (result != null && !result.isSuccess()) {
            throw new KDBizException(TmcOperateServiceHelper.decodeErrorMsg(result));
        }
        return true;
    }

    private void addGenerateReceivableBills(Set<DynamicObject> receivableBillSet, DynamicObject[] draftBills) {
        Object[] receivableBillIds = Arrays.stream(draftBills).map(DataEntityBase::getPkValue).toArray();
        DynamicObject[] loadFromDB = BusinessDataServiceHelper.load((String)"cdm_draftbillf7", (String)"id,draftbillstatus,billpool", (QFilter[])new QFilter("sourcedraft", "in", (Object)receivableBillIds).toArray());
        if (loadFromDB.length == 0) {
            return;
        }
        receivableBillSet.addAll(Arrays.asList(loadFromDB));
        receivableBillIds = Arrays.stream(loadFromDB).map(DataEntityBase::getPkValue).toArray();
        draftBills = BusinessDataServiceHelper.load((Object[])receivableBillIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cdm_draftbillf7"));
        this.addGenerateReceivableBills(receivableBillSet, draftBills);
    }
}

