/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.pool.sync;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.business.pool.ITransferExecutor;
import kd.tmc.cdm.business.pool.TransferExecutorFactory;
import kd.tmc.cdm.business.pool.state.TransferStateEnums;
import kd.tmc.cdm.common.enums.DispatchRuleEnum;
import kd.tmc.cdm.common.enums.DraftAllocateBizTypeEnum;
import kd.tmc.cdm.common.enums.TransBillOpStatusEnum;
import kd.tmc.cdm.common.helper.RecEleDraftHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TradeBillSyncTransBillService {
    private static Log logger = LogFactory.getLog(TradeBillSyncTransBillService.class);
    private DynamicObject transBill;
    private List<DynamicObject> entryList;

    public TradeBillSyncTransBillService(DynamicObject tradeBill) {
        this.initTransBill(tradeBill);
    }

    public boolean sync() {
        ArrayList<String> allocateupList = new ArrayList<String>(2);
        allocateupList.add(TransferStateEnums.ENDORSEUP_SUBMITELE.getOpVal());
        allocateupList.add(TransferStateEnums.ENDORSEUP_COMPLETE.getOpVal());
        ArrayList<String> allocateDownList = new ArrayList<String>(2);
        allocateDownList.add(TransferStateEnums.ENDORSEDOWN_SUBMITELE.getOpVal());
        allocateDownList.add(TransferStateEnums.ENDORSEDOWN_COMPLETE.getOpVal());
        for (DynamicObject entry : this.entryList) {
            entry.set("e_transoptionstatus", (Object)TransBillOpStatusEnum.SUCCESS.getValue());
            String bizType = this.transBill.getString("biztype");
            boolean submitEle = this.isSubmitEle(entry);
            String e_opbilltsteps = entry.getString("e_opbilltsteps");
            logger.info("bizType is:" + bizType + ",submitEle :" + submitEle + ",e_opbilltsteps is:" + e_opbilltsteps);
            if (DraftAllocateBizTypeEnum.ALLOCATE.getValue().equals(bizType)) {
                ArrayList<String> directList = new ArrayList<String>(2);
                directList.add(TransferStateEnums.ENDORSE_SUBMITELE.getOpVal());
                directList.add(TransferStateEnums.ENDORSE_COMPLETE.getOpVal());
                String dispatchRule = this.transBill.getString("dispatchrule");
                if (Objects.equals(dispatchRule, DispatchRuleEnum.DIRECT.getValue()) && !directList.contains(e_opbilltsteps)) {
                    if (submitEle) {
                        entry.set("e_opbilltsteps", (Object)TransferStateEnums.ENDORSE_SUBMITELE.getOpVal());
                    } else {
                        entry.set("e_opbilltsteps", (Object)TransferStateEnums.ENDORSE_COMPLETE.getOpVal());
                    }
                }
            } else if (DraftAllocateBizTypeEnum.ALLOCATE_UP.getValue().equals(bizType) && !allocateupList.contains(e_opbilltsteps)) {
                if (submitEle) {
                    entry.set("e_opbilltsteps", (Object)TransferStateEnums.ENDORSEUP_SUBMITELE.getOpVal());
                } else {
                    entry.set("e_opbilltsteps", (Object)TransferStateEnums.ENDORSEUP_COMPLETE.getOpVal());
                }
            } else if (DraftAllocateBizTypeEnum.ALLOCATE_DOWN.getValue().equals(bizType) && !allocateDownList.contains(e_opbilltsteps)) {
                if (submitEle) {
                    entry.set("e_opbilltsteps", (Object)TransferStateEnums.ENDORSEDOWN_SUBMITELE.getOpVal());
                } else {
                    entry.set("e_opbilltsteps", (Object)TransferStateEnums.ENDORSEDOWN_COMPLETE.getOpVal());
                }
            }
            logger.info(" after e_opbilltsteps is:" + entry.getString("e_opbilltsteps"));
        }
        List<Long> entryIdList = this.entryList.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        ITransferExecutor transExecutor = TransferExecutorFactory.createTransferExecutor();
        return transExecutor.execute(this.transBill, entryIdList);
    }

    private void initTransBill(DynamicObject tradeBill) {
        tradeBill = BusinessDataServiceHelper.loadSingle((Object)tradeBill.getPkValue(), (String)tradeBill.getDynamicObjectType().getName());
        this.transBill = BusinessDataServiceHelper.loadSingle((Object)tradeBill.getLong("sourcebillid"), (String)"cdm_draftallocation");
        long sourceEntryId = tradeBill.getLong("sourcebillentryid");
        this.entryList = this.transBill.getDynamicObjectCollection("entryentity").stream().filter(row -> Objects.equals(sourceEntryId, row.getPkValue())).collect(Collectors.toList());
    }

    private boolean isSubmitEle(DynamicObject transferEntry) {
        boolean usualJudage = RecEleDraftHelper.isSubmitEleNew((DynamicObject)this.transBill, Collections.singletonList(transferEntry.getDynamicObject("e_draftbill").getLong("id")));
        Long sourceId = this.transBill.getLong("sourcebillid");
        logger.info("usualJudage is:" + usualJudage);
        if (usualJudage) {
            if (EmptyUtil.isEmpty((Long)sourceId)) {
                DynamicObject bankaccount = transferEntry.getDynamicObject("e_draftbill").getDynamicObject("bankaccount");
                Object[] electricDirect = BusinessDataServiceHelper.load((String)"cdm_electicdirconset", (String)"defaultaccount", (QFilter[])new QFilter[]{new QFilter("defaultaccount", "=", bankaccount.getPkValue())});
                if (EmptyUtil.isNoEmpty((Object[])electricDirect)) {
                    return true;
                }
                logger.info("electricDirect is null");
                return false;
            }
            DynamicObject draftBill = transferEntry.getDynamicObject("e_draftbill");
            boolean judgeOfEleOrPaperBill = RecEleDraftHelper.judgeOfEleOrPaperBill((DynamicObject)this.transBill, (DynamicObject)draftBill);
            logger.info("judgeOfEleOrPaperBill is :" + judgeOfEleOrPaperBill);
            return judgeOfEleOrPaperBill;
        }
        return false;
    }
}

