/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.business.ebservice.api.EBServiceFacadeFactory;
import kd.tmc.cdm.business.ebservice.api.IEBServiceFacade;
import kd.tmc.cdm.business.service.EleBillCommonHelper;
import kd.tmc.cdm.common.bean.EleBillDiscountCalDetail;
import kd.tmc.cdm.common.bean.EleBillDiscountCalResult;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.service.ebservice.data.NoteResult;

public class EleBillDiscountHelper {
    private static Log logger = LogFactory.getLog(EleBillDiscountHelper.class);

    public static EleBillDiscountCalResult getBillDiscountByTradeBill(DynamicObject tradeBill) {
        EleBillDiscountCalResult calResult = new EleBillDiscountCalResult();
        if (tradeBill == null) {
            calResult.setSuccessFlg(Boolean.FALSE.booleanValue());
            calResult.setResponseMsg(ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u5355\u4e0d\u5b58\u5728\uff0c\u8d34\u73b0\u8bd5\u7b97\u5931\u8d25", (String)"EleBillDiscountHelper_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
        } else {
            try {
                DynamicObjectCollection dynamicObjects = tradeBill.getDynamicObjectCollection("entrys");
                Object[] recBillIds = dynamicObjects.stream().map(o -> o.getDynamicObject("draftbill").getLong("id")).toArray();
                QFilter qFilter = new QFilter("id", "in", (Object)recBillIds);
                DynamicObject[] recBills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"sourcebillid", (QFilter[])new QFilter[]{qFilter});
                if (recBills.length <= 0) {
                    calResult.setSuccessFlg(Boolean.FALSE.booleanValue());
                    calResult.setResponseMsg(ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u5355\u9009\u62e9\u7684\u5e94\u6536\u7968\u636e\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5728\u624b\u7968\u636e\uff0c\u8d34\u73b0\u8bd5\u7b97\u5931\u8d25", (String)"EleBillDiscountHelper_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    return calResult;
                }
                Object[] eleBillIds = Arrays.stream(recBills).map(o -> o.getLong("sourcebillid")).toArray();
                DynamicObject[] eleBills = BusinessDataServiceHelper.load((Object[])eleBillIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_electronic_rec_deal"));
                if (eleBills.length <= 0) {
                    calResult.setSuccessFlg(Boolean.FALSE.booleanValue());
                    calResult.setResponseMsg(ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u5355\u9009\u62e9\u7684\u5e94\u6536\u7968\u636e\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5728\u624b\u7968\u636e\uff0c\u8d34\u73b0\u8bd5\u7b97\u5931\u8d25", (String)"EleBillDiscountHelper_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    return calResult;
                }
                Map<String, List<DynamicObject>> groupByConnectNo = Arrays.stream(eleBills).collect(Collectors.groupingBy(o -> o.getString("applicantacctext")));
                if (groupByConnectNo.size() > 1) {
                    calResult.setSuccessFlg(Boolean.FALSE.booleanValue());
                    calResult.setResponseMsg(ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u5355\u9009\u62e9\u7684\u5e94\u6536\u7968\u636e\u5bf9\u5e94\u7684\u5728\u624b\u7968\u636e\u6240\u5c5e\u7684\u7535\u7968\u76f4\u8fde\u8d26\u53f7\u4e0d\u4e00\u81f4\uff0c\u8d34\u73b0\u8bd5\u7b97\u5931\u8d25", (String)"EleBillDiscountHelper_4", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    return calResult;
                }
                ArrayList<NoteResult> returnResult = new ArrayList<NoteResult>(1);
                returnResult.add(new NoteResult());
                boolean isCorrectTime = EleBillCommonHelper.isCorrectTimeToEB(returnResult, tradeBill.getDynamicObject("company").getLong("id"));
                if (!isCorrectTime) {
                    calResult.setSuccessFlg(Boolean.FALSE.booleanValue());
                    calResult.setResponseMsg(((NoteResult)returnResult.get(0)).getErrMsg());
                    return calResult;
                }
                DynamicObjectCollection entryList = tradeBill.getDynamicObjectCollection("entrys");
                Map<Long, String> draftIdToSplitAmountMap = entryList.stream().collect(Collectors.toMap(o -> o.getDynamicObject("draftbill").getLong("id"), o -> o.getString("billamt"), (a, b) -> a));
                DynamicObjectCollection discountEntries = tradeBill.getDynamicObjectCollection("discountentry");
                Map eleBillNoMap = discountEntries.stream().collect(Collectors.toMap(o -> o.getDynamicObject("dis_selectbillid").get("id"), Function.identity(), (k1, k2) -> k1));
                boolean isEditDiscountEntry = tradeBill.getBoolean("iseditdiscountentry");
                for (DynamicObject eleBill : eleBills) {
                    long sourceId = eleBill.getLong("sourceid");
                    if (isEditDiscountEntry) {
                        DynamicObject discountEntry = (DynamicObject)eleBillNoMap.get(sourceId);
                        if (discountEntry == null) continue;
                        eleBill.set("discountdays", (Object)discountEntry.getInt("dis_days"));
                        eleBill.set("adddate", (Object)EleBillDiscountHelper.getDiffDays(tradeBill.getDate("bizdate"), eleBill.getDate("exchangebillexpiredate"), discountEntry.getInt("dis_days")));
                    } else {
                        eleBill.set("discountdays", (Object)tradeBill.getInt("discount_days"));
                        eleBill.set("adddate", (Object)EleBillDiscountHelper.getDiffDays(tradeBill.getDate("bizdate"), eleBill.getDate("exchangebillexpiredate"), tradeBill.getInt("discount_days")));
                    }
                    EleBillDiscountHelper.setDiscountPayType(tradeBill, eleBill);
                    boolean grdBag = eleBill.getBoolean("grdbag");
                    if (grdBag) {
                        eleBill.set("locamt", (Object)draftIdToSplitAmountMap.get(sourceId));
                    } else {
                        eleBill.set("locamt", (Object)eleBill.getBigDecimal("amount"));
                    }
                    eleBill.set("discountrate", (Object)tradeBill.getBigDecimal("rate"));
                    eleBill.set("promiseracc", (Object)tradeBill.getDynamicObject("bankaccount"));
                }
                IEBServiceFacade bankService = EBServiceFacadeFactory.getBankService();
                List<EleBillDiscountCalDetail> result = bankService.getDraftBillDiscountCalResult(Arrays.asList(eleBills));
                if (result.size() <= 0) {
                    calResult.setSuccessFlg(Boolean.FALSE.booleanValue());
                    calResult.setResponseMsg(ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\u8d34\u73b0\u8bd5\u7b97\u63a5\u53e3\u8fd4\u56de\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8d34\u73b0\u8bd5\u7b97\u5931\u8d25", (String)"EleBillDiscountHelper_2", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    return calResult;
                }
                calResult.setSuccessFlg(Boolean.TRUE.booleanValue());
                calResult.setDetails(result);
            }
            catch (Exception e) {
                calResult.setSuccessFlg(Boolean.FALSE.booleanValue());
                calResult.setResponseMsg(String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\u8d34\u73b0\u8bd5\u7b97\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff0c\u8d34\u73b0\u8bd5\u7b97\u5931\u8d25\uff1a%1$s", (String)"EleBillDiscountHelper_3", (String)"tmc-cdm-business", (Object[])new Object[0]), e.getMessage()));
                throw e;
            }
        }
        return calResult;
    }

    private static void setDiscountPayType(DynamicObject tradeBill, DynamicObject eleBill) {
        boolean isPayByAgree = tradeBill.getBoolean("ispaybyagree");
        if (isPayByAgree) {
            BigDecimal agreeRate = tradeBill.getBigDecimal("agreerate");
            if (agreeRate.compareTo(new BigDecimal("100")) == 0) {
                eleBill.set("discountpaytype", (Object)"2");
            } else {
                eleBill.set("discountpaytype", (Object)"3");
            }
            eleBill.set("increaserate", (Object)agreeRate);
        } else {
            eleBill.set("increaserate", (Object)"");
            eleBill.set("discountpaytype", (Object)"1");
        }
    }

    private static int getDiffDays(Date bizDate, Date endDate, int intDaysAdjust) {
        if (bizDate == null || endDate == null) {
            throw new IllegalArgumentException("getDiffDays param is null!");
        }
        bizDate = DateUtils.getDataFormat((Date)bizDate, (boolean)true);
        endDate = DateUtils.getDataFormat((Date)endDate, (boolean)true);
        long diff = (endDate.getTime() - bizDate.getTime()) / 86400000L;
        logger.info("EleBillDiscountHelper.getBillDiscountByTradeBill getDiffDays bizDate = {},endDate = {}, diff = {}", new Object[]{bizDate, endDate, diff});
        return (int)diff + intDaysAdjust;
    }
}

