/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.List;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import kd.tmc.cdm.business.lock.DraftLockServiceFactory;
import kd.tmc.cdm.business.service.DraftLockInfo;
import kd.tmc.cdm.business.service.LockDraftHelper;

public class LockDraftService {
    private static Log logger = LogFactory.getLog(LockDraftService.class);

    public String lockOrReleaseBill(String lockInfoListStr) {
        return this.lockOrReleaseBill(lockInfoListStr, true);
    }

    public String lockOrReleaseBill(String lockInfoListStr, boolean strickMode) {
        logger.info("LockDraftService lockOrReleaseBill :" + lockInfoListStr);
        List<Object> lockResults = new ArrayList(10);
        List draftLockInfos = (List)JSON.parseObject((String)lockInfoListStr, (TypeReference)new TypeReference<List<DraftLockInfo>>(){}, (Feature[])new Feature[0]);
        try (TXHandle tx = TX.requiresNew();){
            try {
                lockResults = DraftLockServiceFactory.getService().lock(draftLockInfos, strickMode);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("lockOrReleaseBill has error:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                throw e;
            }
        }
        return JSON.toJSONString(lockResults);
    }

    @Deprecated
    public void lockOrReleaseBillNew(String lockInfoListStr) {
        logger.info("LockDraftService lockOrReleaseBillNew :" + lockInfoListStr);
        List draftLockInfos = (List)JSON.parseObject((String)lockInfoListStr, (TypeReference)new TypeReference<List<DraftLockInfo>>(){}, (Feature[])new Feature[0]);
        try {
            LockDraftHelper.releaseOrLockDrafts(draftLockInfos);
        }
        catch (Exception e) {
            logger.error("lockOrReleaseBillNew has error:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            throw e;
        }
    }

    public String changeBillLockInfo(String lockInfoListStr) {
        return this.changeBillLockInfo(lockInfoListStr, true);
    }

    public String changeBillLockInfo(String lockInfoListStr, boolean strickMode) {
        logger.info("LockDraftService changeBillLockInfo :" + lockInfoListStr);
        List<Object> lockResults = new ArrayList(10);
        List lockInfoList = (List)JSON.parseObject((String)lockInfoListStr, (TypeReference)new TypeReference<List<DraftLockInfo>>(){}, (Feature[])new Feature[0]);
        try (TXHandle tx = TX.requiresNew();){
            try {
                lockResults = DraftLockServiceFactory.getService().transfer(lockInfoList, strickMode);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("changeBillLockInfo has error:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                throw e;
            }
        }
        return JSON.toJSONString(lockResults);
    }

    public String lockBillsByLog(String lockInfoListStr) {
        List<Object> lockResults = new ArrayList(10);
        logger.info("LockDraftService lockBillsByLog :" + lockInfoListStr);
        List draftAmountLockInfos = (List)JSON.parseObject((String)lockInfoListStr, (TypeReference)new TypeReference<List<DraftLockInfo>>(){}, (Feature[])new Feature[0]);
        try (TXHandle tx = TX.requiresNew();){
            try {
                lockResults = LockDraftHelper.lockBills(draftAmountLockInfos, false);
            }
            catch (Exception e) {
                logger.error("lockBillsByLog has error:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                throw e;
            }
        }
        return JSON.toJSONString(lockResults);
    }

    public String updateBillsByLog(String updateInfoListStr) {
        List<Object> lockResults = new ArrayList(10);
        logger.info("LockDraftService updateBillsByLog :" + updateInfoListStr);
        List draftAmountLockInfos = (List)JSON.parseObject((String)updateInfoListStr, (TypeReference)new TypeReference<List<DraftLockInfo>>(){}, (Feature[])new Feature[0]);
        try (TXHandle tx = TX.requiresNew();){
            try {
                lockResults = LockDraftHelper.updateBills(draftAmountLockInfos, false);
            }
            catch (Exception e) {
                logger.error("updateBillsByLog has error:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                throw e;
            }
        }
        return JSON.toJSONString(lockResults);
    }
}

