/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.service;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ExceptionUtils;
import kd.tmc.cdm.business.service.QueryHoldScheduleTask;
import kd.tmc.cdm.business.service.billstorage.RecEleBillStorageService;
import kd.tmc.cdm.common.bean.EleDraftBillQueryInfo;
import kd.tmc.cdm.common.enums.EleDraftExistCatEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.data.NoteResult;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.fbp.service.ebservice.service.IEBServiceExecutor;

public class MulThreadQueryHoldHelper {
    private static final Log logger = LogFactory.getLog(MulThreadQueryHoldHelper.class);
    private static final Map<String, ExecutorService> EXECUTOR_MAP = new HashMap<String, ExecutorService>();

    public static void batchRunQuerySchedule(EleDraftBillQueryInfo eleDraftBillQueryInfo, IEBServiceExecutor executor, IEBService<List<NoteResult>> service, List<NoteResult> resultList) {
        try {
            logger.info("\u5f00\u59cb\u5e76\u53d1\u83b7\u53d6\u5728\u624b\u7968\u636e\uff1a" + System.currentTimeMillis());
            int concurrent = eleDraftBillQueryInfo.getConcurrent();
            int coreTreadCount = Runtime.getRuntime().availableProcessors();
            if (concurrent <= 1 || concurrent > coreTreadCount) {
                concurrent = coreTreadCount;
            }
            int totalPage = eleDraftBillQueryInfo.getTotalPage();
            int concurrentPages = (int)Math.ceil((double)totalPage / (double)concurrent);
            CountDownLatch latch = new CountDownLatch(coreTreadCount);
            logger.info(Thread.currentThread().getName() + ",concurrent = " + concurrent + "; \u672c\u6b21\u6267\u884c\u7684\u603b\u9875\u6570 \uff1a" + totalPage);
            ExecutorService executorService = MulThreadQueryHoldHelper.getExecutorService();
            for (int i = 0; i < concurrent; ++i) {
                EleDraftBillQueryInfo mulEleDraftBillQueryInfo = new EleDraftBillQueryInfo();
                mulEleDraftBillQueryInfo.setObj(eleDraftBillQueryInfo.getObj());
                mulEleDraftBillQueryInfo.setStatus(eleDraftBillQueryInfo.getStatus());
                mulEleDraftBillQueryInfo.setCurrencyNumber(eleDraftBillQueryInfo.getCurrencyNumber());
                mulEleDraftBillQueryInfo.setDraftType(eleDraftBillQueryInfo.getDraftType());
                mulEleDraftBillQueryInfo.setStartDate(eleDraftBillQueryInfo.getStartDate());
                mulEleDraftBillQueryInfo.setEndDate(eleDraftBillQueryInfo.getEndDate());
                mulEleDraftBillQueryInfo.setAcct(eleDraftBillQueryInfo.getAcct());
                mulEleDraftBillQueryInfo.setBizSubType(eleDraftBillQueryInfo.getBizSubType());
                mulEleDraftBillQueryInfo.setQueryBatchSeq(eleDraftBillQueryInfo.getQueryBatchSeq());
                mulEleDraftBillQueryInfo.setIsNewECDS(eleDraftBillQueryInfo.getIsNewECDS());
                mulEleDraftBillQueryInfo.setConcurrent(concurrent);
                mulEleDraftBillQueryInfo.setPageNum(i * concurrentPages + 2);
                mulEleDraftBillQueryInfo.setStartPage(i * concurrentPages + 2);
                int endPage = (i + 1) * concurrentPages + 1;
                if (i == concurrent - 1) {
                    endPage = Math.min(eleDraftBillQueryInfo.getTotalPage(), endPage);
                }
                mulEleDraftBillQueryInfo.setEndPage(endPage);
                Future future = MulThreadQueryHoldHelper.querySchedule(executorService, mulEleDraftBillQueryInfo, executor, service, resultList, latch);
            }
            latch.await();
            logger.info("\u5e76\u53d1\u83b7\u53d6\u5728\u624b\u7968\u636e\u5b8c\u6210\uff0c \u5f00\u59cb\u6267\u884c\u66f4\u65b0\u5728\u624b\u7968\u636e\u5e93\u5b58\u6570\u636e \uff1a" + System.currentTimeMillis());
            try (TXHandle tx = TX.requiresNew();){
                try {
                    MulThreadQueryHoldHelper.updateRemainDataWhenQueryHold(eleDraftBillQueryInfo);
                    MulThreadQueryHoldHelper.storageQueryHoldBill(eleDraftBillQueryInfo);
                }
                catch (Exception e) {
                    tx.markRollback();
                    logger.error("MulThreadQueryHoldHelper update or storage Exception:", (Throwable)e);
                }
            }
            logger.info("\u6267\u884c\u66f4\u65b0\u5728\u624b\u7968\u636e\u5e93\u5b58\u6570\u636e\u7ed3\u675f\uff1a" + System.currentTimeMillis());
        }
        catch (InterruptedException e) {
            logger.info("\u8bf7\u6c42\u7ebf\u7a0b\u6c60\u6267\u884c\u5f02\u5e38\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            throw new KDBizException(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        catch (Exception e) {
            logger.error("MulThreadQueryHoldHelper update or storage Exception:", (Throwable)e);
        }
    }

    private static Future querySchedule(ExecutorService executorService, EleDraftBillQueryInfo eleDraftBillQueryInfo, IEBServiceExecutor executor, IEBService<List<NoteResult>> service, List<NoteResult> resultList, CountDownLatch latch) {
        QueryHoldScheduleTask task = new QueryHoldScheduleTask(eleDraftBillQueryInfo, resultList, latch);
        return executorService.submit(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ExecutorService getExecutorService() {
        Map<String, ExecutorService> map = EXECUTOR_MAP;
        synchronized (map) {
            String tenantId = RequestContext.get().getTenantId();
            ExecutorService executorService = EXECUTOR_MAP.get(tenantId);
            if (executorService == null) {
                executorService = ThreadPools.newCachedExecutorService((String)("MulThreadQueryHoldHelper" + tenantId), (int)MulThreadQueryHoldHelper.getCoreThreadSize(), (int)MulThreadQueryHoldHelper.getMaxThreadSize());
                EXECUTOR_MAP.put(tenantId, executorService);
            }
            return executorService;
        }
    }

    private static int getMaxThreadSize() {
        int maxThreadCount = 5;
        if (maxThreadCount <= 0) {
            maxThreadCount = 8;
        }
        logger.info("\u6700\u5927\u7ebf\u7a0b\u6570\uff1a" + maxThreadCount);
        return maxThreadCount;
    }

    private static int getCoreThreadSize() {
        int coreThreadSize = 5;
        logger.info("\u6838\u5fc3\u7ebf\u7a0b\u6570\uff1a" + coreThreadSize);
        return coreThreadSize;
    }

    /*
     * WARNING - void declaration
     */
    private static void updateRemainDataWhenQueryHold(EleDraftBillQueryInfo eleDraftBillQueryInfo) {
        if (EleDraftExistCatEnum.HOLD.getValue().equalsIgnoreCase(eleDraftBillQueryInfo.getBizSubType())) {
            String queryBatchSeq = eleDraftBillQueryInfo.getQueryBatchSeq();
            String draftType = eleDraftBillQueryInfo.getDraftType();
            String isNewECDS = eleDraftBillQueryInfo.getIsNewECDS();
            try (TXHandle tx = TX.requiresNew();){
                void var10_19;
                QFilter queryBatchSeqFilter = new QFilter("querybatchseq", "=", (Object)queryBatchSeq);
                queryBatchSeqFilter.and(new QFilter("interfacetype", "=", (Object)isNewECDS));
                Object[] batchHoldDraftBills = BusinessDataServiceHelper.load((String)"cdm_electronicbill", (String)"id,conectno,ticketstatus,querydrafttype,modifytime,modifier", (QFilter[])new QFilter[]{queryBatchSeqFilter});
                logger.info("EleDraftBillQueryServiceImpl updateRemainDataWhenQueryHold queryBatchSeq = {},batchHoldDraftBills.length = {},isNewECDS = {}", new Object[]{queryBatchSeq, batchHoldDraftBills.length, isNewECDS});
                if (EmptyUtil.isEmpty((Object[])batchHoldDraftBills)) {
                    QFilter noHoldBillFilter = new QFilter("conectno", "=", (Object)eleDraftBillQueryInfo.getAcct());
                    noHoldBillFilter.and(new QFilter("querydrafttype", "=", (Object)EleDraftExistCatEnum.HOLD.getValue()));
                    noHoldBillFilter.and(new QFilter("drafttype", "=", (Object)draftType));
                    noHoldBillFilter.and(new QFilter("interfacetype", "=", (Object)isNewECDS));
                    DynamicObject[] noHoldBills = BusinessDataServiceHelper.load((String)"cdm_electronicbill", (String)"id,conectno,ticketstatus,querydrafttype,modifytime,modifier,billno", (QFilter[])new QFilter[]{noHoldBillFilter});
                    if (noHoldBills.length > 0) {
                        for (DynamicObject noHoldBill : noHoldBills) {
                            noHoldBill.set("querydrafttype", (Object)EleDraftExistCatEnum.HISTORYHOLD.getValue());
                            noHoldBill.set("modifytime", (Object)new Date());
                            noHoldBill.set("modifier", (Object)RequestContext.get().getCurrUserId());
                            logger.info("EleDraftBillQueryServiceImpl updateRemainDataWhenQueryHold noHoldBills queryBatchSeq = {},noteNo {},isNewECDS = {},draftType = {}", new Object[]{queryBatchSeq, noHoldBill.getString("billno"), isNewECDS, draftType});
                        }
                        TmcDataServiceHelper.save((DynamicObject[])noHoldBills);
                        logger.info("updateRemainDataWhenQueryHold update hold bill to historyhold bill");
                    } else {
                        logger.info("updateRemainDataWhenQueryHold has not hold bill");
                    }
                    return;
                }
                Object[] noHoldBillFilter = batchHoldDraftBills;
                int n = noHoldBillFilter.length;
                boolean bl = false;
                while (var10_19 < n) {
                    Object batchHoldDraftBill = noHoldBillFilter[var10_19];
                    batchHoldDraftBill.set("querydrafttype", (Object)EleDraftExistCatEnum.HOLD.getValue());
                    batchHoldDraftBill.set("modifytime", (Object)new Date());
                    batchHoldDraftBill.set("modifier", (Object)RequestContext.get().getCurrUserId());
                    ++var10_19;
                }
                try {
                    TmcDataServiceHelper.save((DynamicObject[])batchHoldDraftBills);
                }
                catch (Exception e) {
                    logger.error("update batchHoldDraftBill data has Exception:", (Throwable)e);
                    tx.markRollback();
                    throw e;
                }
                logger.info("is start to update remain data");
                HashMap mapOfData = new HashMap();
                for (Object batchHoldDraftBill : batchHoldDraftBills) {
                    String connectNo = batchHoldDraftBill.getString("conectno");
                    long billId = batchHoldDraftBill.getLong("id");
                    if (mapOfData.containsKey(connectNo)) {
                        ((Set)mapOfData.get(connectNo)).add(billId);
                        continue;
                    }
                    HashSet<Long> idSet = new HashSet<Long>();
                    idSet.add(billId);
                    mapOfData.put(connectNo, idSet);
                }
                for (Map.Entry entry : mapOfData.entrySet()) {
                    String connectNo = (String)entry.getKey();
                    Set idSet = (Set)entry.getValue();
                    QFilter holdDraftBillUpdateFilter = new QFilter("conectno", "=", (Object)connectNo);
                    holdDraftBillUpdateFilter.and(new QFilter("drafttype", "=", (Object)draftType));
                    holdDraftBillUpdateFilter.and(new QFilter("querydrafttype", "=", (Object)EleDraftExistCatEnum.HOLD.getValue()));
                    holdDraftBillUpdateFilter.and(new QFilter("id", "not in", (Object)idSet));
                    holdDraftBillUpdateFilter.and(new QFilter("interfacetype", "=", (Object)isNewECDS));
                    Object[] holdDraftBillUpdateBills = TmcDataServiceHelper.load((String)"cdm_electronicbill", (String)"id,conectno,ticketstatus,querydrafttype,modifytime,modifier,billno", (QFilter[])new QFilter[]{holdDraftBillUpdateFilter});
                    logger.info("EleDraftBillQueryServiceImpl updateRemainDataWhenQueryHold holdDraftBillUpdateBills queryBatchSeq = {},holdDraftBillUpdateBills.length = {},isNewECDS = {},draftType = {}", new Object[]{queryBatchSeq, holdDraftBillUpdateBills.length, isNewECDS, draftType});
                    if (!EmptyUtil.isNoEmpty((Object[])holdDraftBillUpdateBills)) continue;
                    for (Object dynamicObject : holdDraftBillUpdateBills) {
                        dynamicObject.set("querydrafttype", (Object)EleDraftExistCatEnum.HISTORYHOLD.getValue());
                        dynamicObject.set("modifytime", (Object)new Date());
                        dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
                        logger.info("EleDraftBillQueryServiceImpl updateRemainDataWhenQueryHold holdDraftBillUpdateBills queryBatchSeq = {},noteNo {},isNewECDS = {},draftType = {}", new Object[]{queryBatchSeq, dynamicObject.getString("billno"), isNewECDS, draftType});
                    }
                    try {
                        TmcDataServiceHelper.save((DynamicObject[])holdDraftBillUpdateBills);
                    }
                    catch (Exception e) {
                        logger.error("update remain data has Exception:", (Throwable)e);
                        tx.markRollback();
                        throw e;
                    }
                }
                logger.info("update remain end");
            }
        }
    }

    private static void storageQueryHoldBill(EleDraftBillQueryInfo eleDraftBillQueryInfo) {
        if (EleDraftExistCatEnum.HOLD.getValue().equalsIgnoreCase(eleDraftBillQueryInfo.getBizSubType())) {
            try {
                String queryBatchSeq = eleDraftBillQueryInfo.getQueryBatchSeq();
                QFilter queryBatchSeqFilter = new QFilter("querybatchseq", "=", (Object)queryBatchSeq);
                DynamicObject[] batchHoldDraftBills = BusinessDataServiceHelper.load((String)"cdm_electronicbill", (String)"id,company", (QFilter[])new QFilter[]{queryBatchSeqFilter});
                Map<DynamicObject, List<DynamicObject>> companyGroupMap = Arrays.stream(batchHoldDraftBills).collect(Collectors.groupingBy(o -> o.getDynamicObject("company")));
                for (Map.Entry<DynamicObject, List<DynamicObject>> dynamicObjectListEntry : companyGroupMap.entrySet()) {
                    List<Long> electBillIds = dynamicObjectListEntry.getValue().stream().map(o -> o.getLong("id")).collect(Collectors.toList());
                    String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
                    boolean isStorageRecBill = (Boolean)TmcParameterHelper.getAppParameter((String)appId, (Long)dynamicObjectListEntry.getKey().getLong("id"), (String)"storagerecbill");
                    if (!isStorageRecBill) continue;
                    RecEleBillStorageService.storage(electBillIds, dynamicObjectListEntry.getKey());
                }
            }
            catch (Exception e) {
                logger.error("EleDraftBillQueryServiceImpl storageQueryHoldBill has Exception:", (Throwable)e);
                throw e;
            }
        }
    }
}

