/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.service;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.fileservice.UrlServiceForEreceipt;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;

public class ViewElectContractService {
    private static Log logger = LogFactory.getLog(ViewElectContractService.class);

    public void openEleContractById(IFormView view, Object pkValue) {
        DynamicObject electContract = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"cdm_electronic_pay_deal");
        if (ObjectUtils.isEmpty((Object)electContract)) {
            return;
        }
        String fileName = electContract.getString("filename");
        logger.info("\u7535\u5b50\u5408\u540c\u6587\u4ef6\u540d\u79f0filename\u5b57\u6bb5\u7684\u503c\uff1a" + fileName);
        String filePath = electContract.getString("filepath");
        logger.info("\u7535\u5b50\u5408\u540c\u6587\u4ef6\u5730\u5740filepath\u5b57\u6bb5\u7684\u503c\uff1a" + filePath);
        if (filePath.endsWith("pdf")) {
            logger.info("\u7535\u5b50\u5408\u540c\u4e3aPDF\u6587\u4ef6\u7c7b\u578b");
            String pdfUrl = UrlServiceForEreceipt.getEreceiptFullUrl((String)filePath);
            logger.info("PDF\u6587\u4ef6\u7c7b\u578b\u7535\u5b50\u5408\u540c\u751f\u6210\u7684url\uff1a" + pdfUrl);
            this.openForm(view, pdfUrl);
        } else {
            logger.info("\u7535\u5b50\u5408\u540c\u4e3a\u5176\u4ed6\u6587\u4ef6\u7c7b\u578b");
            String pdfUrl = UrlService.getImageFullUrl((String)filePath);
            logger.info("\u5176\u4ed6\u6587\u4ef6\u7c7b\u578b\u7535\u5b50\u5408\u540c\u751f\u6210\u7684url\uff1a" + pdfUrl);
            logger.info("\u5148\u901a\u8fc7showPictureView\u6253\u5f00");
            String[] urls = new String[]{pdfUrl};
            view.showPictureView(urls, 1);
            logger.info("\u518d\u901a\u8fc7showForm\u6253\u5f00-------");
            this.openForm(view, pdfUrl);
        }
    }

    private FormShowParameter buildParameter(String pdfUrl) {
        FormShowParameter para = new FormShowParameter();
        para.setFormId("bos_printpreview");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        para.setCustomParam("src", (Object)pdfUrl);
        return para;
    }

    private void openForm(IFormView view, String pdfUrl) {
        IFormView mainView = view.getMainView();
        if (mainView == null) {
            logger.info("mainView\u4e3a\u7a7a-------");
            view.openUrl(pdfUrl);
        } else {
            logger.info("view.showForm\u6253\u5f00-------");
            FormShowParameter param = this.buildParameter(pdfUrl);
            param.setCaption(ResManager.loadKDString((String)"\u8054\u67e5\u5408\u540c", (String)"ViewElectContractService_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
            view.getParentView().showForm(param);
            view.sendFormAction(view.getParentView());
        }
    }
}

