/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.service.allocation;

import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.tmc.cdm.common.helper.BotpHelper;

public class DraftAllocationService {
    private static final Log logger = LogFactory.getLog(DraftAllocationService.class);

    public static void allocation(DynamicObject paymentBill, List<Long> draftBillIds) {
        DynamicObjectCollection draftBills = paymentBill.getDynamicObjectCollection("draftbill");
        draftBills.removeIf(draft -> !draftBillIds.contains((Long)draft.getDynamicObject("fbasedataid").getPkValue()));
        DynamicObject[] pushResult = BotpHelper.push((DynamicObject)paymentBill, (String)"cdm_draftallocation");
        if (pushResult.length > 0) {
            try (TXHandle tx = TX.requiresNew();){
                try {
                    OperationResult auditResult;
                    OperationResult submitResult;
                    OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"cdm_draftallocation", (DynamicObject[])pushResult, (OperateOption)OperateOption.create());
                    if (saveResult.isSuccess() && (submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"cdm_draftallocation", (DynamicObject[])pushResult, (OperateOption)OperateOption.create())).isSuccess() && (auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"cdm_draftallocation", (DynamicObject[])pushResult, (OperateOption)OperateOption.create())).isSuccess()) {
                        OperationServiceHelper.executeOperate((String)"submitendorse", (String)"cdm_draftallocation", (DynamicObject[])pushResult, (OperateOption)OperateOption.create());
                    }
                }
                catch (Exception e) {
                    logger.error("\u7968\u636e\u6c60\u8c03\u5ea6\u4fdd\u5b58->\u63d0\u4ea4->\u5ba1\u6838->\u63d0\u4ea4\u80cc\u4e66\u51fa\u73b0\u5f02\u5e38\u3002", (Throwable)e);
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }
}

