/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.service.allocation;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.tmc.cdm.business.service.allocation.AsyncSubmitEndorse;
import kd.tmc.cdm.common.enums.BillStatusEnum;
import kd.tmc.cdm.common.enums.BizBusinessTypeEnum;
import kd.tmc.cdm.common.enums.PoolLockStatusEnum;
import kd.tmc.cdm.common.helper.BotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.data.NoteResult;
import org.apache.commons.lang3.tuple.Pair;

public class EBDraftAllocarionService {
    private static Log logger = LogFactory.getLog(EBDraftAllocarionService.class);
    private static EBDraftAllocarionService instance;

    private EBDraftAllocarionService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EBDraftAllocarionService getInstance() {
        Class<EBDraftAllocarionService> clazz = EBDraftAllocarionService.class;
        synchronized (EBDraftAllocarionService.class) {
            if (instance == null) {
                instance = new EBDraftAllocarionService();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Pair<Boolean, List<NoteResult>> autoService(DynamicObject paybill, List<Long> idList) {
        ArrayList<NoteResult> resultList = new ArrayList<NoteResult>(0);
        Pair result = Pair.of((Object)Boolean.FALSE, resultList);
        if (paybill == null || paybill.getDynamicObject("org") == null || idList == null || idList.size() == 0) {
            return result;
        }
        Object incompany = paybill.getDynamicObject("org").getPkValue();
        List<DynamicObject> draftBillList = Arrays.stream(TmcDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbillf7"))).filter(o -> o.getDynamicObject("company") != null).collect(Collectors.toList());
        if (draftBillList.size() == 0) {
            return result;
        }
        List<NoteResult> failDraftBillList = this.validate(draftBillList);
        if (failDraftBillList.size() < 1) {
            List<Long> draftAllocBillIds;
            block29: {
                draftAllocBillIds = new ArrayList<Long>();
                try (TXHandle tx = TX.requiresNew();){
                    try {
                        ArrayList<Object> botpDraftBillList = new ArrayList<Object>(0);
                        ArrayList<Object> difComDraftBillList = new ArrayList<Object>(0);
                        ArrayList<Object> poolBillLockList = new ArrayList<Object>(0);
                        ArrayList<Object> poolBillUnlockList = new ArrayList<Object>(0);
                        ArrayList<Object> outPoolList = new ArrayList<Object>(0);
                        for (DynamicObject draftBill : draftBillList) {
                            if (draftBill.getDynamicObject("billpool") == null) {
                                if (incompany.equals(draftBill.getDynamicObject("company").getPkValue())) continue;
                                difComDraftBillList.add(draftBill.getPkValue());
                                continue;
                            }
                            if (incompany.equals(draftBill.getDynamicObject("company").getPkValue())) {
                                if (PoolLockStatusEnum.UNLOCK.getValue().equals(draftBill.getString("poollockstatus"))) {
                                    outPoolList.add(draftBill.getPkValue());
                                    continue;
                                }
                                if (incompany.equals(draftBill.getDynamicObject("poollockorg").getPkValue())) {
                                    poolBillUnlockList.add(draftBill.getPkValue());
                                    outPoolList.add(draftBill.getPkValue());
                                    continue;
                                }
                                poolBillUnlockList.add(draftBill.getPkValue());
                                outPoolList.add(draftBill.getPkValue());
                                continue;
                            }
                            if (PoolLockStatusEnum.UNLOCK.getValue().equals(draftBill.getString("poollockstatus"))) {
                                poolBillLockList.add(draftBill.getPkValue());
                            }
                            botpDraftBillList.add(draftBill.getPkValue());
                        }
                        if (poolBillLockList.size() > 0) {
                            this.poolDraftLockOrUnlock(poolBillLockList, PoolLockStatusEnum.LOCK);
                        }
                        if (poolBillUnlockList.size() > 0) {
                            this.poolDraftLockOrUnlock(poolBillUnlockList, PoolLockStatusEnum.UNLOCK);
                        }
                        if (outPoolList.size() > 0) {
                            this.outPool(outPoolList);
                        }
                        botpDraftBillList.addAll(difComDraftBillList);
                        if (botpDraftBillList.size() > 0) {
                            draftAllocBillIds = this.allocation(paybill, botpDraftBillList);
                            break block29;
                        }
                        result = Pair.of((Object)Boolean.TRUE, resultList);
                    }
                    catch (Exception e) {
                        resultList.add(this.getNoteResult(null, EBResultStatusCode.ERROR, e.getMessage()));
                        tx.markRollback();
                        logger.error((Throwable)e);
                    }
                }
            }
            if (!draftAllocBillIds.isEmpty()) {
                ThreadPools.executeOnce((String)"syncreceipt", (Runnable)new AsyncSubmitEndorse(draftAllocBillIds));
            }
        } else {
            resultList.addAll(failDraftBillList);
        }
        return result;
    }

    private void poolDraftLockOrUnlock(List<Object> pkValueList, PoolLockStatusEnum lockStatus) {
        DynamicObject[] pooldraftbills = BusinessDataServiceHelper.load((Object[])pkValueList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_pooldraftbill"));
        ArrayList<DynamicObject> poolBillLogs = new ArrayList<DynamicObject>(0);
        if (PoolLockStatusEnum.UNLOCK == lockStatus) {
            for (DynamicObject pooldraftbill : pooldraftbills) {
                pooldraftbill.set("poollockstatus", (Object)lockStatus.getValue());
                pooldraftbill.set("poollockorg", null);
                pooldraftbill.set("poollocktime", null);
                DynamicObject poolBillLog = BusinessDataServiceHelper.newDynamicObject((String)"cdm_pooldraft_log");
                poolBillLog.set("poollockorg", (Object)RequestContext.get().getOrgId());
                poolBillLog.set("billpool", pooldraftbill.get("billpool"));
                poolBillLog.set("pooldraft", pooldraftbill.getPkValue());
                poolBillLog.set("operatetype", (Object)lockStatus.getValue());
                poolBillLog.set("creator", (Object)RequestContext.get().getCurrUserId());
                poolBillLog.set("createtime", (Object)new Date());
                poolBillLogs.add(poolBillLog);
            }
        } else if (PoolLockStatusEnum.LOCK == lockStatus) {
            for (DynamicObject pooldraftbill : pooldraftbills) {
                pooldraftbill.set("poollockstatus", (Object)PoolLockStatusEnum.LOCK.getValue());
                pooldraftbill.set("poollockorg", (Object)RequestContext.get().getOrgId());
                pooldraftbill.set("poollocktime", (Object)new Date());
                DynamicObject poolBillLog = BusinessDataServiceHelper.newDynamicObject((String)"cdm_pooldraft_log");
                poolBillLog.set("poollockorg", (Object)RequestContext.get().getOrgId());
                poolBillLog.set("billpool", pooldraftbill.get("billpool"));
                poolBillLog.set("pooldraft", pooldraftbill.getPkValue());
                poolBillLog.set("operatetype", (Object)lockStatus.getValue());
                poolBillLog.set("creator", (Object)RequestContext.get().getCurrUserId());
                poolBillLog.set("createtime", (Object)new Date());
                poolBillLogs.add(poolBillLog);
            }
        }
        OperationResult opResult = null;
        opResult = TmcOperateServiceHelper.execOperate((String)"save", (String)"cdm_pooldraftbill", (DynamicObject[])pooldraftbills, (OperateOption)OperateOption.create());
        if (!opResult.isSuccess()) {
            throw new KDBizException(TmcOperateServiceHelper.decodeMultiErrorMsg((OperationResult)opResult));
        }
        opResult = TmcOperateServiceHelper.execOperate((String)"save", (String)"cdm_pooldraft_log", (DynamicObject[])poolBillLogs.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        if (!opResult.isSuccess()) {
            throw new KDBizException(TmcOperateServiceHelper.decodeMultiErrorMsg((OperationResult)opResult));
        }
    }

    private List<Long> allocation(DynamicObject paymentBill, List<Object> draftBillIds) {
        DynamicObject[] pushResult = BotpHelper.push((DynamicObject)paymentBill, (String)"cdm_draftallocation");
        if (pushResult.length == 0) {
            return new ArrayList<Long>(0);
        }
        pushResult[0].getDynamicObjectCollection("entryentity").removeIf(row -> !draftBillIds.contains(row.getDynamicObject("e_draftbill").getPkValue()));
        DynamicObject dynamicObject = pushResult[0];
        DynamicObjectCollection entityCollection = dynamicObject.getDynamicObjectCollection("entryentity");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entityCollection)) {
            dynamicObject.set("draftcount", (Object)entityCollection.size());
            BigDecimal amountCount = BigDecimal.ZERO;
            for (DynamicObject entry : entityCollection) {
                BigDecimal e_subbillamt = entry.getBigDecimal("e_subbillamt");
                amountCount = amountCount.add(e_subbillamt);
            }
            dynamicObject.set("amount", (Object)amountCount);
        }
        ArrayList<Long> successPkIdList = new ArrayList<Long>(0);
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("autoallocation", "true");
        try {
            Object[] successPkIds;
            OperationResult opResult = TmcOperateServiceHelper.execOperate((String)"submit", (String)"cdm_draftallocation", (DynamicObject[])pushResult, (OperateOption)operateOption);
            if (opResult.isSuccess() && (opResult = TmcOperateServiceHelper.execOperate((String)"audit", (String)"cdm_draftallocation", (Object[])(successPkIds = opResult.getSuccessPkIds().toArray()), (OperateOption)operateOption)).isSuccess()) {
                successPkIds = opResult.getSuccessPkIds().toArray();
                successPkIdList.addAll(Arrays.stream(successPkIds).map(s -> (Long)s).collect(Collectors.toList()));
            }
            if (!opResult.isSuccess()) {
                throw new KDBizException(TmcOperateServiceHelper.decodeMultiErrorMsg((OperationResult)opResult));
            }
        }
        catch (Exception e) {
            logger.error("\u7968\u636e\u6c60\u8c03\u5ea6\u4fdd\u5b58->\u63d0\u4ea4->\u5ba1\u6838\u51fa\u73b0\u5f02\u5e38\u3002", (Throwable)e);
            throw e;
        }
        return successPkIdList;
    }

    private void outPool(List<Object> pkValueList) {
        DynamicObject[] pooldraftbills = TmcDataServiceHelper.load((Object[])pkValueList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_pooldraftbill"));
        ArrayList<DynamicObject> billPoolBizList = new ArrayList<DynamicObject>(0);
        ArrayList<DynamicObject> pooldraftbillList = new ArrayList<DynamicObject>(0);
        for (DynamicObject pooldraftbill : pooldraftbills) {
            DynamicObject billPoolBiz = BusinessDataServiceHelper.newDynamicObject((String)"cdm_billpoolbiz");
            DynamicObject companyObject = pooldraftbill.getDynamicObject("company");
            DynamicObject poolDraftObject = pooldraftbill.getDynamicObject("billpool");
            DynamicObject currencyObject = pooldraftbill.getDynamicObject("currency");
            if (companyObject != null) {
                billPoolBiz.set("company", companyObject.getPkValue());
            }
            if (poolDraftObject != null) {
                billPoolBiz.set("billpool", (Object)poolDraftObject);
            }
            if (currencyObject != null) {
                billPoolBiz.set("currency", currencyObject.getPkValue());
            }
            DynamicObjectCollection entryEntity = billPoolBiz.getDynamicObjectCollection("entryentity");
            DynamicObject entry = entryEntity.addNew();
            entry.set("e_draftbill", (Object)pooldraftbill);
            entry.set("e_billamt", (Object)pooldraftbill.getBigDecimal("amount"));
            billPoolBiz.set("draftbillcount", (Object)entryEntity.size());
            billPoolBiz.set("amount", (Object)pooldraftbill.getBigDecimal("amount"));
            billPoolBiz.set("businesstype", (Object)BizBusinessTypeEnum.OUT.getValue());
            billPoolBiz.set("bizdate", (Object)new Date());
            billPoolBiz.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            billPoolBizList.add(billPoolBiz);
            pooldraftbill.set("billpool", null);
            pooldraftbill.set("intopooltime", null);
            pooldraftbill.set("poollockstatus", (Object)PoolLockStatusEnum.UNLOCK.getValue());
            pooldraftbill.set("poollockorg", null);
            pooldraftbill.set("poollocktime", null);
            pooldraftbillList.add(pooldraftbill);
        }
        OperationResult opResult = null;
        opResult = TmcOperateServiceHelper.execOperate((String)"save", (String)"cdm_billpoolbiz", (DynamicObject[])billPoolBizList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        if (!opResult.isSuccess()) {
            throw new KDBizException(TmcOperateServiceHelper.decodeMultiErrorMsg((OperationResult)opResult));
        }
        opResult = TmcOperateServiceHelper.execOperate((String)"save", (String)"cdm_pooldraftbill", (DynamicObject[])pooldraftbillList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        if (!opResult.isSuccess()) {
            throw new KDBizException(TmcOperateServiceHelper.decodeMultiErrorMsg((OperationResult)opResult));
        }
    }

    private NoteResult getNoteResult(Long draftBillId, EBResultStatusCode statusCode, String errorMsg) {
        NoteResult result = new NoteResult();
        if (draftBillId != null) {
            result.setBillId(draftBillId);
        }
        if (EBResultStatusCode.SUCCESS != statusCode) {
            result.setErrMsg(errorMsg);
        }
        result.setStatusCode(statusCode);
        return result;
    }

    private List<NoteResult> validate(List<DynamicObject> draftBillList) {
        ArrayList<NoteResult> errList = new ArrayList<NoteResult>(0);
        return errList;
    }
}

