/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.service.billstorage;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.tmc.cdm.business.service.billstorage.bean.StorageResult;
import kd.tmc.cdm.business.writeback.ElcDraftBillWriteBackDraftBill;
import kd.tmc.cdm.common.constant.CdmBizConstant;
import kd.tmc.cdm.common.enums.BillEndorseTypeEnum;
import kd.tmc.cdm.common.enums.DraftBillStatusEnum;
import kd.tmc.cdm.common.enums.ElcDraftBillOpEnum;
import kd.tmc.cdm.common.enums.EleDraftBillStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftCirStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftIsNewECDS;
import kd.tmc.cdm.common.enums.EleDraftNoteStatusEnum;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.cdm.common.helper.EleDraftHelper;
import kd.tmc.fbp.common.builder.FormulaGetHandle;
import kd.tmc.fbp.common.builder.ISingleTaskContext;
import kd.tmc.fbp.common.builder.SingleTaskContext;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.webapi.ebentity.biz.status.EbStatus;
import org.apache.commons.lang3.tuple.Pair;

public class RecEleBillStorageService {
    private static final Log logger = LogFactory.getLog(RecEleBillStorageService.class);
    private static final String[] NEED_INSERT_SIGN_ARR = new String[]{EleDraftBillStatusEnum.INVOICESIGNED.getValue(), EleDraftBillStatusEnum.RECITESIGNED.getValue(), EleDraftBillStatusEnum.NOTEDISCOUNTSIGNED.getValue(), EleDraftBillStatusEnum.PAYMENTSIGNED.getValue(), EleDraftBillStatusEnum.CLOSEDACCOUNT.getValue(), EleDraftBillStatusEnum.PROMISESEARCHFORSIGNED.getValue(), EleDraftBillStatusEnum.PLEDGESIGNED.getValue(), EleDraftBillStatusEnum.RELEASEOFPLEDGESIGNED.getValue()};

    public static List<StorageResult> storage(List<Long> recEleBillIdS, DynamicObject company) {
        logger.info("RecEleBillStorageService.storage eleRecIds = {}", (Object)JSON.toJSONString(recEleBillIdS));
        if (recEleBillIdS == null || recEleBillIdS.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<StorageResult> storageResults = new ArrayList<StorageResult>();
        try {
            DynamicObject[] draftBillArr = TmcDataServiceHelper.load((Object[])recEleBillIdS.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_electronic_sign_deal"));
            String noteStatus = draftBillArr[0].getString("notestatus");
            String subRange = draftBillArr[0].getString("subrange");
            String isNewECDS = EleDraftHelper.isNewECDs((String)noteStatus, (String)subRange);
            if (EleDraftIsNewECDS.NEW.getValue().equals(isNewECDS)) {
                draftBillArr = (DynamicObject[])Arrays.stream(draftBillArr).filter(o -> !o.getString("backflag").equals("1")).filter(o -> o.getBoolean("isinsertpayorrec")).toArray(DynamicObject[]::new);
                logger.info("\u65b0\u7535\u7968\u63a5\u53e3\u5165\u5e93\u5e94\u6536\u7968\u636e,draftBillArr.length = {}", (Object)draftBillArr.length);
            } else {
                draftBillArr = (DynamicObject[])Arrays.stream(draftBillArr).filter(o -> !o.getString("ticketstatus").equals("destroy") || !o.getString("backflag").equals("1")).filter(o -> o.getBoolean("isinsertpayorrec")).filter(o -> RecEleBillStorageService.needInsert(o.getString("ticketstatus"))).toArray(DynamicObject[]::new);
                logger.info("\u8fc7\u6ee4\u6389\u7968\u636e\u72b6\u6001\u4e3a\u7968\u636e\u5df2\u4f5c\u5e9f\u3001\u5df2\u6253\u56de\u3001\u5f85\u7b7e\u6536\u3001\u63d0\u793a\u627f\u5151\u3001\u662f\u5426\u5165\u5e93\u5e94\u6536\u5e94\u4ed8\u7968\u636e\u4e3a\u5426\u7684\u4e0d\u5165\u5e93draftBillArr.length = {}", (Object)draftBillArr.length);
            }
            if (draftBillArr.length == 0) {
                logger.info("\u6ca1\u6709\u9700\u8981\u5165\u5e93\u7684\u6570\u636edraftBillArr=" + draftBillArr.length);
                StorageResult sr = new StorageResult();
                sr.setSuccess(Boolean.FALSE);
                sr.setErrCode("NO_NEED_STORAGE");
                sr.setErrMsg(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6389\u7968\u636e\u72b6\u6001\u4e3a\u7968\u636e\u5df2\u4f5c\u5e9f\u3001\u5df2\u6253\u56de\u3001\u5f85\u7b7e\u6536\u3001\u63d0\u793a\u627f\u5151\u3001\u662f\u5426\u5165\u5e93\u5e94\u6536\u5e94\u4ed8\u7968\u636e\u4e3a\u5426\u7684\u6570\u636e\uff0c\u6ca1\u6709\u9700\u8981\u5165\u5e93\u7684\u6570\u636e", (String)"RecEleBillStorageService_3", (String)"tmc-cdm-business", (Object[])new Object[0]));
                storageResults.add(sr);
                return storageResults;
            }
            String orgField = "orgentryentity.org";
            Set orgSet = Stream.of(draftBillArr).map(o -> o.getDynamicObject("company")).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
            QFilter orgQFilter = new QFilter(orgField, "in", orgSet);
            orgQFilter.or(QFilter.isNull((String)orgField));
            orgQFilter.and(new QFilter("enable", "=", (Object)"1"));
            DynamicObjectCollection idColl = QueryServiceHelper.query((String)"cdm_billstoragerule", (String)"id", (QFilter[])new QFilter[]{orgQFilter});
            if (idColl.size() == 0) {
                StorageResult sr = new StorageResult();
                sr.setSuccess(Boolean.FALSE);
                sr.setBillId(0L);
                sr.setErrCode("GET_RULE_FAILED");
                sr.setErrMsg(ResManager.loadKDString((String)"\u83b7\u53d6\u5165\u5e93\u89c4\u5219\u5931\u8d25, \u8bf7\u7ef4\u62a4\u540e\u91cd\u8bd5", (String)"RecEleBillStorageService_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                storageResults.add(sr);
                return storageResults;
            }
            DynamicObject[] storageRuleArr = TmcDataServiceHelper.load((Object[])idColl.stream().map(o -> o.getLong("id")).distinct().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_billstoragerule"));
            List orgNotNullStorageRule = Stream.of(storageRuleArr).filter(i -> i.getDynamicObjectCollection(orgField) != null).collect(Collectors.toList());
            Optional<DynamicObject> first = Stream.of(storageRuleArr).filter(i -> i.get(orgField) == null).findFirst();
            DynamicObject allOrgStorageRule = null;
            if (first.isPresent()) {
                allOrgStorageRule = first.get();
            }
            Set noteNoSet = Stream.of(draftBillArr).map(o -> o.getString("billno")).collect(Collectors.toSet());
            QFilter orgFilter = new QFilter("company", "=", (Object)company.getLong("id"));
            QFilter statusFilter = new QFilter("draftbillstatus", "=", (Object)DraftBillStatusEnum.REGISTERED.getValue());
            QFilter noteNoFilter = new QFilter("draftbillno", "in", noteNoSet);
            QFilter rpTypeFilter = new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.RECEIVEBILL.getValue());
            QFilter bankAccountFilter = new QFilter("bankaccount.number", "=", (Object)draftBillArr[0].getString("conectno"));
            DynamicObjectCollection recBillColl = QueryServiceHelper.query((String)"cdm_receivablebill", (String)"id", (QFilter[])new QFilter[]{orgFilter, statusFilter, noteNoFilter, rpTypeFilter, bankAccountFilter});
            DynamicObject[] recBillArr = TmcDataServiceHelper.load((Object[])recBillColl.stream().map(o -> o.getLong("id")).distinct().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_receivablebill"));
            Map recBillMap = Stream.of(recBillArr).collect(Collectors.toMap(o -> o.get("id"), Function.identity(), (k1, k2) -> k1));
            Map recBillNoToMap = Stream.of(recBillArr).collect(Collectors.toMap(o -> o.get("draftbillno") + "_" + o.get("subbillrange"), Function.identity(), (k1, k2) -> k1));
            ArrayList<DynamicObject> recbillSaveList = new ArrayList<DynamicObject>(8);
            HashMap<Long, DynamicObject> recBillEleMap = new HashMap<Long, DynamicObject>(8);
            HashMap<Long, String> recBillNoMap = new HashMap<Long, String>(8);
            for (DynamicObject eleRecDraftBill : draftBillArr) {
                Optional<DynamicObject> currRuleOptional;
                logger.info("\u7535\u7968id_billNo = {},\u5bf9\u5e94\u6536\u7968\u767b\u8bb0id = {}", (Object)(eleRecDraftBill.getPkValue() + "_" + eleRecDraftBill.get("billno")), eleRecDraftBill.get("sourceid"));
                DynamicObject currApplyRule = allOrgStorageRule;
                if (orgNotNullStorageRule.size() > 0 && (currRuleOptional = orgNotNullStorageRule.stream().filter(o -> o.getDynamicObjectCollection("org").contains(eleRecDraftBill.get("company"))).findFirst()).isPresent()) {
                    currApplyRule = currRuleOptional.get();
                }
                if (currApplyRule != null) {
                    DynamicObject needUpdateRecBill;
                    if (!org.apache.commons.lang3.ObjectUtils.isEmpty((Object)eleRecDraftBill.get("sourceid")) && eleRecDraftBill.getLong("sourceid") > 0L) {
                        DynamicObject[] existRecBill = TmcDataServiceHelper.load((Object[])new Object[]{eleRecDraftBill.getLong("sourceid")}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_receivablebill"));
                        needUpdateRecBill = existRecBill.length > 0 ? existRecBill[0] : (DynamicObject)recBillMap.get(eleRecDraftBill.get("sourceid"));
                    } else {
                        needUpdateRecBill = (DynamicObject)recBillMap.get(eleRecDraftBill.get("sourceid"));
                        if (needUpdateRecBill == null) {
                            needUpdateRecBill = (DynamicObject)recBillNoToMap.get(eleRecDraftBill.get("billno") + "_" + eleRecDraftBill.get("subrange"));
                        }
                    }
                    logger.info("RecEleBillStorageService storage needUpdateRecBill == null is {},eleRecDraftBill billNo = {},ebStatus = {},tradeType = {}", new Object[]{needUpdateRecBill == null, eleRecDraftBill.getString("billno"), eleRecDraftBill.getString("ebstatus"), eleRecDraftBill.getString("tradetype")});
                    if (needUpdateRecBill == null && (EleDraftBillStatusEnum.PAYMENTSIGNED.getValue().equals(eleRecDraftBill.getString("ticketstatus")) || EleDraftBillStatusEnum.CLOSEDACCOUNT.getValue().equals(eleRecDraftBill.getString("ticketstatus")) || EleDraftBillStatusEnum.PLEDGESIGNED.getValue().equals(eleRecDraftBill.getString("ticketstatus")) || EleDraftBillStatusEnum.RELEASEOFPLEDGESIGNED.getValue().equals(eleRecDraftBill.getString("ticketstatus")) || EleDraftNoteStatusEnum.CS03.getValue().equals(eleRecDraftBill.getString("notestatus")) && EleDraftCirStatusEnum.TF0304.getValue().equals(eleRecDraftBill.getString("cirstatus")) || EleDraftNoteStatusEnum.CS06.getValue().equals(eleRecDraftBill.getString("notestatus")) && EleDraftCirStatusEnum.TF0501.getValue().equals(eleRecDraftBill.getString("cirstatus")) || !EbStatus.BANK_SUCCESS.getName().equals(eleRecDraftBill.getString("ebstatus")) && StringUtils.isNotEmpty((CharSequence)eleRecDraftBill.getString("tradetype")))) {
                        logger.info("RecEleBillStorageService storage needUpdateRecBill == null ebStatus = {}", (Object)eleRecDraftBill.getString("ebstatus"));
                        continue;
                    }
                    logger.info("RecEleBillStorageService storage needUpdateRecBill is = {}, billNo_sourceBillId = {}", (Object)(needUpdateRecBill == null ? 1 : 0), needUpdateRecBill == null ? null : needUpdateRecBill.get("billno") + "_" + needUpdateRecBill.get("sourcebillid"));
                    DynamicObject finalRecBill = RecEleBillStorageService.buildReceivableBill(currApplyRule, needUpdateRecBill, eleRecDraftBill);
                    logger.info("\u6784\u5efa\u6536\u7968\u767b\u8bb0\u7968\u636e\u53f7 = {},\u7535\u7968\u4ea4\u6613\u72b6\u6001 = {}", (Object)finalRecBill.getString("billno"), (Object)finalRecBill.getString("draftbilltranstatus"));
                    try {
                        boolean autoApprove = RecEleBillStorageService.getIsAutoApprove(eleRecDraftBill, currApplyRule);
                        String billStatus = finalRecBill.getString("billstatus");
                        if (autoApprove && BillStatusEnum.SAVE.getValue().equals(billStatus)) {
                            finalRecBill.set("isautocommit", (Object)"1");
                        }
                        recbillSaveList.add(finalRecBill);
                        recBillEleMap.put(finalRecBill.getLong("id"), eleRecDraftBill);
                        recBillNoMap.put(finalRecBill.getLong("id"), finalRecBill.getString("billno"));
                    }
                    catch (Exception e) {
                        logger.error("RecEleBillStorageService.storage exception id = {},msg = {}", (Object)finalRecBill.getLong("id"), (Object)e);
                        StorageResult srException = new StorageResult();
                        srException.setSuccess(Boolean.FALSE);
                        srException.setBillId(finalRecBill.getLong("id"));
                        srException.setBillNo(finalRecBill.getString("billno"));
                        srException.setErrCode("INTO_STORAGE_FAILED");
                        srException.setErrMsg("error:" + e.getMessage());
                        storageResults.add(srException);
                    }
                    continue;
                }
                logger.error("RecEleBillStorageService.storage storageRule is not exist eleRecId = {}", eleRecDraftBill.getPkValue());
            }
            if (EmptyUtil.isNoEmpty(recbillSaveList)) {
                logger.info("start to batchDealBills");
                RecEleBillStorageService.batchDealBills(storageResults, recbillSaveList, recBillEleMap, recBillNoMap);
                logger.info("batchDealBills end");
            } else {
                logger.info("recbillSaveList is null");
                StorageResult srNoData = new StorageResult();
                srNoData.setSuccess(Boolean.FALSE);
                srNoData.setErrCode("NO_DATA_STORAGE");
                srNoData.setErrMsg("no data will save");
                storageResults.add(srNoData);
            }
        }
        catch (Exception e) {
            logger.error("\u7535\u7968\u6570\u636e\u81ea\u52a8\u5165\u5e93\u5230\u6536\u7968\u767b\u8bb0\u5f02\u5e38\uff1a" + e);
            throw e;
        }
        return storageResults;
    }

    private static boolean getIsAutoApprove(DynamicObject eleRecDraftBill, DynamicObject currApplyRule) {
        boolean autoApprove = false;
        String draftBillType = eleRecDraftBill.getString("drafttype");
        boolean storageAc99 = currApplyRule.getBoolean("storageac");
        String draftType = eleRecDraftBill.getString("drafttype");
        if (storageAc99 && "AC99".equals(draftType)) {
            draftBillType = "AC01";
        } else if ("AC99".equals(draftType)) {
            draftBillType = "AC02";
        }
        HashMap<String, DynamicProperty> fldProperties = new HashMap<String, DynamicProperty>();
        DynamicObjectCollection detailAllDys = RecEleBillStorageService.getElectRecBillDy(eleRecDraftBill, fldProperties);
        if (detailAllDys != null && detailAllDys.size() > 0) {
            if ("AC01".equals(draftBillType)) {
                DynamicObjectCollection smartmatchDCs = currApplyRule.getDynamicObjectCollection("bankruleentryentity");
                if (CollectionUtils.isNotEmpty((Collection)smartmatchDCs)) {
                    Collections.sort(smartmatchDCs, new Comparator<DynamicObject>(){

                        @Override
                        public int compare(DynamicObject arg0, DynamicObject arg1) {
                            Long date1 = arg0.getLong("Seq");
                            Long date2 = arg1.getLong("Seq");
                            return date1.compareTo(date2);
                        }
                    });
                    autoApprove = currApplyRule.getBoolean("autoapprove");
                    for (DynamicObject entryRule : smartmatchDCs) {
                        boolean isMatch = RecEleBillStorageService.isMatchRule(entryRule, (DynamicObject)detailAllDys.get(0), fldProperties, "bankdatafilter_tag");
                        if (!isMatch) continue;
                        autoApprove = entryRule.getBoolean("bankautoapprove");
                        break;
                    }
                } else {
                    autoApprove = currApplyRule.getBoolean("autoapprove");
                }
            } else if ("AC02".equals(draftBillType)) {
                DynamicObjectCollection smartmatchDCs = currApplyRule.getDynamicObjectCollection("businessruleentryentity");
                if (CollectionUtils.isNotEmpty((Collection)smartmatchDCs)) {
                    Collections.sort(smartmatchDCs, new Comparator<DynamicObject>(){

                        @Override
                        public int compare(DynamicObject arg0, DynamicObject arg1) {
                            Long date1 = arg0.getLong("Seq");
                            Long date2 = arg1.getLong("Seq");
                            return date1.compareTo(date2);
                        }
                    });
                    autoApprove = currApplyRule.getBoolean("autoautite");
                    for (DynamicObject entryRule : smartmatchDCs) {
                        boolean isMatch = RecEleBillStorageService.isMatchRule(entryRule, (DynamicObject)detailAllDys.get(0), fldProperties, "businessdatafilter_tag");
                        if (!isMatch) continue;
                        autoApprove = entryRule.getBoolean("businessautoautite");
                        break;
                    }
                } else {
                    autoApprove = currApplyRule.getBoolean("autoautite");
                }
            }
            return autoApprove;
        }
        return autoApprove;
    }

    private static void batchDealBills(List<StorageResult> storageResults, List<DynamicObject> recbillSaveList, Map<Long, DynamicObject> recBillEleMap, Map<Long, String> recBillNoMap) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        OperationResult operationResult = TmcOperateServiceHelper.execOperateWithoutThrow((String)"save", (String)"cdm_receivablebill", (DynamicObject[])recbillSaveList.toArray(new DynamicObject[0]), (OperateOption)option);
        if (EmptyUtil.isEmpty((Object)operationResult)) {
            logger.info("operationResult is null");
            StorageResult sr = new StorageResult();
            sr.setSuccess(Boolean.FALSE);
            sr.setErrCode("SAVE_EVENT_EXCEPTION");
            sr.setErrMsg(ResManager.loadKDString((String)"\u4fdd\u5b58\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u6392\u67e5monitor\u65e5\u5fd7", (String)"RecEleBillStorageService_2_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
            storageResults.add(sr);
            logger.error("\u6536\u7968\u767b\u8bb0\u4fdd\u5b58\u4e8b\u4ef6\u6d41\u4efb\u52a1\u6267\u884c\u5f02\u5e38\u5931\u8d25\uff01\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        } else if (EmptyUtil.isNoEmpty((Object)operationResult)) {
            logger.info("operationResult is isSuccess?" + operationResult.isSuccess());
            List successPkIds = operationResult.getSuccessPkIds();
            StringJoiner resultStr = new StringJoiner(";");
            resultStr.add("data total count:" + recbillSaveList.size());
            if (EmptyUtil.isNoEmpty((Object)successPkIds)) {
                logger.info("RecEleBillStorageService.batchDealBills successPkIds = {}", (Object)successPkIds.toString());
                ArrayList<String> billNoList = new ArrayList<String>(8);
                ArrayList<DynamicObject> needUpdateEleBills = new ArrayList<DynamicObject>(8);
                Map<Long, String> recBillMap = recbillSaveList.stream().collect(Collectors.toMap(x -> x.getLong("id"), x -> x.getString("billno")));
                for (Object successId : successPkIds) {
                    long id = (Long)successId;
                    if (!recBillNoMap.containsKey(id)) continue;
                    String billnoStr = recBillMap.get(id);
                    billNoList.add(billnoStr);
                    DynamicObject eleRecDraftBill = recBillEleMap.get(id);
                    eleRecDraftBill.set("sourceid", (Object)id);
                    eleRecDraftBill.set("sourcenumber", (Object)billnoStr);
                    needUpdateEleBills.add(eleRecDraftBill);
                }
                logger.info("RecEleBillStorageService.batchDealBills save event success,recBillNos = {},ids = {} ", (Object)SerializationUtils.toJsonString(billNoList), (Object)SerializationUtils.toJsonString((Object)successPkIds));
                SaveServiceHelper.update((DynamicObject[])needUpdateEleBills.toArray(new DynamicObject[0]));
                logger.info("RecEleBillStorageService.batchDealBills ele bills update over");
                for (Object successId : successPkIds) {
                    try {
                        ElcDraftBillWriteBackDraftBill.validateAndWriteBack(Long.parseLong(successId.toString()));
                    }
                    catch (Exception e) {
                        logger.error("validateAndWriteBack error data id = {},billNo = {},msg = {}", new Object[]{successId, recBillNoMap.get(Long.parseLong(successId.toString())), e});
                        throw new RuntimeException(e);
                    }
                    StorageResult storageResult = new StorageResult();
                    storageResult.setSuccess(Boolean.TRUE);
                    long id = Long.parseLong(successId.toString());
                    storageResult.setBillId(id);
                    storageResult.setBillNo(recBillNoMap.get(id));
                    storageResults.add(storageResult);
                }
                resultStr.add("success count:" + successPkIds.size());
            }
            List allErrorInfo = operationResult.getAllErrorOrValidateInfo();
            logger.info("RecEleBillStorageService.batchDealBills recBillNoMap is:" + SerializationUtils.toJsonString(recBillNoMap));
            if (EmptyUtil.isNoEmpty((Object)allErrorInfo)) {
                ArrayList<String> errorMsyList = new ArrayList<String>(8);
                for (IOperateInfo errorInfo : allErrorInfo) {
                    StorageResult srFail = new StorageResult();
                    srFail.setSuccess(Boolean.FALSE);
                    long id = Long.parseLong(String.valueOf(errorInfo.getPkValue()));
                    String billNoStr = recBillNoMap.get(id);
                    srFail.setBillNo(billNoStr);
                    srFail.setBillId(id);
                    srFail.setErrMsg(errorInfo.getMessage());
                    srFail.setErrCode("SAVE_EVENT_FAIL");
                    String msgStr = "fail billno:" + billNoStr + ",id:" + id + ",error msg:" + errorInfo.getMessage();
                    errorMsyList.add(msgStr);
                    storageResults.add(srFail);
                    logger.info("errorInfo is:" + SerializationUtils.toJsonString((Object)errorInfo));
                }
                resultStr.add("fail count:" + allErrorInfo.size());
                logger.error("RecEleBillStorageService.batchDealBills recBill save event fail AllErrorOrValidateInfo = {}", (Object)SerializationUtils.toJsonString(errorMsyList));
            }
            logger.info("resultStr is:" + resultStr.toString());
        }
    }

    private static DynamicObject buildReceivableBill(DynamicObject currApplyRule, DynamicObject recBill, DynamicObject eleRecDraftBill) {
        boolean isExist;
        DynamicObject result = recBill;
        boolean bl = isExist = result != null;
        if (result == null) {
            MainEntityType recBillEntityType = EntityMetadataCache.getDataEntityType((String)"cdm_receivablebill");
            long pkId = DB.genLongId((String)recBillEntityType.getAlias());
            result = new DynamicObject((DynamicObjectType)recBillEntityType, (Object)pkId);
        }
        if (!isExist) {
            logger.info("RecEleBillStorageService.buildReceivableBill not exist eleRecId = {}", eleRecDraftBill.getPkValue());
            result.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            result.set("rptype", (Object)ReceivePayTypeEnum.RECEIVEBILL.getValue());
            result.set("draftbillstatus", (Object)DraftBillStatusEnum.REGISTERED.getValue());
            result.set("bizdate", (Object)new Date());
            String draftType = eleRecDraftBill.getString("drafttype");
            DynamicObject draftBillType = RecEleBillStorageService.getDraftBillType(draftType, eleRecDraftBill, currApplyRule);
            result.set("draftbilltype", (Object)(null == draftBillType ? Integer.valueOf(0) : draftBillType));
            String deliverName = eleRecDraftBill.getString("preholdername");
            String ticketStatus = eleRecDraftBill.getString("ticketstatus");
            if ("invoice".equals(ticketStatus) || "invoicesigned".equals(ticketStatus)) {
                deliverName = eleRecDraftBill.getString("issueticketertext");
            }
            Pair<String, Object> comparableBD = RecEleBillStorageService.findComparableBD(deliverName);
            String bankNo = eleRecDraftBill.getString("conectno");
            DynamicObject bankAcct = BusinessDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)bankNo)});
            if (bankAcct != null) {
                DynamicObject bankaccount = BusinessDataServiceHelper.loadSingle((Object)bankAcct.getPkValue(), (String)"bd_accountbanks");
                result.set("bankaccount", (Object)bankaccount);
            }
            result.set("payeetype", comparableBD.getLeft());
            result.set("delivertype", comparableBD.getLeft());
            result.set("issuedate", eleRecDraftBill.get("issueticketdate"));
            result.set("acceptdate", eleRecDraftBill.get("promisedate"));
            result.set("draftbillexpiredate", eleRecDraftBill.get("exchangebillexpiredate"));
            result.set("istransfer", (Object)(eleRecDraftBill.getBoolean("istransfer") ? "1" : "0"));
            result.set("company", (Object)eleRecDraftBill.getDynamicObject("company"));
            if (null == eleRecDraftBill.get("company")) {
                logger.info("RecEleBillStorageService.buildReceivableBill bill company is null eleRecId = {}", eleRecDraftBill.getPkValue());
            }
            result.set("createtime", (Object)new Date());
            result.set("delivername", (Object)deliverName);
            if (!"other".equals(comparableBD.getLeft())) {
                result.set("deliver", org.apache.commons.lang3.ObjectUtils.isEmpty((Object)comparableBD.getRight()) ? Integer.valueOf(0) : comparableBD.getRight());
            }
            result.set("deliveraccounttext", (Object)eleRecDraftBill.getString("holderaccno"));
            result.set("deliveraccountbase", (Object)eleRecDraftBill.getString("holderaccno"));
            String deliverOpenBankNum = eleRecDraftBill.getString("holdercnapscode");
            result.set("deliveropenbanknum", (Object)deliverOpenBankNum);
            DynamicObject deliverOpenBank = EmptyUtil.isNoEmpty((String)deliverOpenBankNum) ? RecEleBillStorageService.findBeBankByUnionNumber(deliverOpenBankNum) : RecEleBillStorageService.findBeBankByName(eleRecDraftBill.getString("holderbankname"));
            result.set("deliveropenbank", (Object)deliverOpenBank);
            result.set("drawername", (Object)(StringUtils.isEmpty((CharSequence)eleRecDraftBill.getString("issueticketertext")) ? " " : eleRecDraftBill.getString("issueticketertext")));
            result.set("draweraccountname", eleRecDraftBill.get("issueticketacctext"));
            String issueTicketBankNo = eleRecDraftBill.getString("issueticketbankno");
            DynamicObject issueBank = EmptyUtil.isNoEmpty((String)issueTicketBankNo) ? RecEleBillStorageService.findBeBankByUnionNumber(issueTicketBankNo) : RecEleBillStorageService.findBeBankByName(eleRecDraftBill.getString("issueticketbanktext"));
            if (issueBank != null) {
                result.set("drawerbank", (Object)issueBank);
            }
            result.set("drawerbankno", eleRecDraftBill.get("issueticketbankno"));
            result.set("receivername", eleRecDraftBill.get("collectionertext"));
            result.set("receiveraccount", eleRecDraftBill.get("collectionacctext"));
            String collectionBankNo = eleRecDraftBill.getString("collectionbankno");
            DynamicObject recBank = EmptyUtil.isNoEmpty((String)collectionBankNo) ? RecEleBillStorageService.findBeBankByUnionNumber(collectionBankNo) : RecEleBillStorageService.findBeBankByName(eleRecDraftBill.getString("collectionbanktext"));
            if (recBank != null) {
                result.set("receiverbank", (Object)recBank);
            }
            result.set("receiverbankno", recBank == null ? eleRecDraftBill.get("collectionbankno") : recBank.getString("union_number"));
            result.set("acceptername", eleRecDraftBill.get("promisertext"));
            DynamicObject promiseBank = RecEleBillStorageService.findBeBankByNameAndNo(eleRecDraftBill.getString("promisertext"), eleRecDraftBill.getString("promiserbankno"));
            result.set("accepterbebank", (Object)(promiseBank == null ? Integer.valueOf(0) : promiseBank));
            result.set("accepteraccount", eleRecDraftBill.get("promiseracctext"));
            DynamicObject promiseBankNo = RecEleBillStorageService.findBeBankByUnionNumber(eleRecDraftBill.getString("promiserbankno"));
            if (promiseBankNo != null) {
                result.set("accepterbank", (Object)promiseBankNo);
            }
            result.set("accepterbankname", (Object)eleRecDraftBill.getString("promiserbanktext"));
            result.set("accepterbankno", eleRecDraftBill.get("promiserbankno"));
            DynamicObject currencyObj = eleRecDraftBill.getDynamicObject("currency");
            if (currencyObj != null) {
                result.set("currency", (Object)currencyObj);
            }
            result.set("amount", eleRecDraftBill.get("amount"));
            result.set("supperbillamount", eleRecDraftBill.get("amount"));
            result.set("standardbillamount", (Object)0.01);
            result.set("subbillrange", (Object)"0");
            DynamicObject issueGrade = RecEleBillStorageService.findBeBankByName(eleRecDraftBill.getString("issueticketgrade"));
            if (issueGrade != null) {
                result.set("issueticketgrade", (Object)issueGrade);
            }
            result.set("issueticketcreditlevel", eleRecDraftBill.get("issueticketcreditlevel"));
            result.set("issueticketexpiredate", eleRecDraftBill.get("issueticketexpiredate"));
            DynamicObject promiseGrade = RecEleBillStorageService.findBeBankByName(eleRecDraftBill.getString("promisegrade"));
            if (promiseGrade != null) {
                result.set("promisegrade", (Object)promiseGrade);
            }
            result.set("promisecreditlevel", eleRecDraftBill.get("promisecreditlevel"));
            result.set("promiseexpiredate", eleRecDraftBill.get("promiseexpiredate"));
            result.set("isautocommit", (Object)"0");
            RecEleBillStorageService.setBillType(result);
            RecEleBillStorageService.addNewendorseentry(eleRecDraftBill, result);
        }
        String ebstatus = eleRecDraftBill.getString("ebstatus");
        String tradetype = eleRecDraftBill.getString("tradetype");
        if (EbStatus.BANK_SUCCESS.getName().equals(ebstatus) && ElcDraftBillOpEnum.NONNEGOTIABLECANCLE.getValue().equals(tradetype)) {
            result.set("istransfer", (Object)(eleRecDraftBill.getBoolean("istransfer") ? "1" : "0"));
        }
        if (EbStatus.BANK_FAIL.getName().equals(ebstatus)) {
            result.set("electag", (Object)Boolean.FALSE);
        }
        result.set("sourcebillid", eleRecDraftBill.get("id"));
        logger.info("RecEleBillStorageService.buildReceivableBill eleRecDraftBill id = {},pkValue = {}", eleRecDraftBill.get("id"), eleRecDraftBill.getPkValue());
        result.set("sourcebilltype", (Object)"cdm_electronicbill");
        result.set("source", (Object)"bei");
        result.set("modifytime", (Object)new Date());
        DynamicObjectCollection endorseEntry = result.getDynamicObjectCollection("endorseentry");
        DynamicObjectCollection endorseInfoColl = eleRecDraftBill.getDynamicObjectCollection("entryentity");
        if (endorseInfoColl != null && endorseInfoColl.size() > 0) {
            endorseEntry.clear();
            for (int i = 0; i < endorseInfoColl.size(); ++i) {
                DynamicObject endorseInfo = (DynamicObject)endorseInfoColl.get(i);
                DynamicObject newEntry = endorseEntry.addNew();
                newEntry.set("seq", (Object)(i + 1));
                String businessCode = endorseInfo.getString("businesscode");
                if ("10".equals(businessCode)) {
                    newEntry.set("endorsetype", (Object)BillEndorseTypeEnum.TRANSFER.getValue());
                } else if ("18".equals(businessCode)) {
                    newEntry.set("endorsetype", (Object)BillEndorseTypeEnum.PLEDGE.getValue());
                } else if ("02".equals(businessCode)) {
                    newEntry.set("endorsetype", (Object)BillEndorseTypeEnum.ACCEPTANCE.getValue());
                } else {
                    if (!"03".equals(businessCode)) continue;
                    newEntry.set("endorsetype", (Object)BillEndorseTypeEnum.INVOICE.getValue());
                }
                newEntry.set("endorseistransfer", (Object)(endorseInfo.get("isendorsetransfer") == null ? "0" : "1"));
                if ("10".equals(businessCode)) {
                    newEntry.set("signdate", (Object)endorseInfo.getDate("endorsedate"));
                } else {
                    String signDate = endorseInfo.getString("signdate");
                    if (StringUtils.isNotEmpty((CharSequence)signDate)) {
                        Date date = signDate.length() == 8 ? DateUtils.stringToDate((String)signDate, (String)"yyyyMMdd") : DateUtils.stringToDate((String)signDate, (String)"yyyy-MM-dd");
                        newEntry.set("signdate", (Object)date);
                    }
                }
                newEntry.set("initiatorname", endorseInfo.get("initiatorname"));
                newEntry.set("opponentname", endorseInfo.get("opponentname"));
            }
        }
        result.set("tradetype", eleRecDraftBill.get("tradetype"));
        result.set("ebstatus", eleRecDraftBill.get("ebstatus"));
        logger.info("RecEleBillStorageService.buildReceivableBill sync eleRecId = {},ticketStatus = {},ebStatus = {}", new Object[]{eleRecDraftBill.getPkValue(), eleRecDraftBill.getString("ticketstatus"), eleRecDraftBill.getString("ebstatus")});
        result.set("draftbilltranstatus", (Object)RecEleBillStorageService.getDraftBillTranStatus(eleRecDraftBill.getString("ebstatus")));
        logger.info("RecEleBillStorageService.buildReceivableBill sync id = {},draftBillTranStatus = {}", (Object)result.getString("id"), (Object)result.getString("draftbilltranstatus"));
        result.set("eledraftstatus", eleRecDraftBill.get("ticketstatus"));
        result.set("eledraftstatusnew", eleRecDraftBill.get("notestatus"));
        result.set("elccirculatestatus", eleRecDraftBill.get("cirstatus"));
        result.set("draftbillno", eleRecDraftBill.get("billno"));
        result.set("returnnotetag", eleRecDraftBill.get("returnnotetag"));
        result.set("bankmsg", eleRecDraftBill.get("bankmsg"));
        result.set("claimnoticebillno", eleRecDraftBill.get("signnoticebill"));
        String explain = eleRecDraftBill.getString("explain");
        String remark = eleRecDraftBill.getString("remark");
        result.set("description", (Object)(StringUtils.isEmpty((CharSequence)remark) ? explain : remark));
        result.set("issplit", eleRecDraftBill.get("grdbag"));
        String subRange = eleRecDraftBill.getString("subrange");
        if (EmptyUtil.isNoEmpty((String)subRange) && subRange.contains("-") && !result.getString("subbillrange").contains("-")) {
            long subBillStartFlag = Long.parseLong(subRange.split("-")[0]);
            long subBillEndFlag = Long.parseLong(subRange.split("-")[1]);
            result.set("subbillrange", (Object)subRange);
            result.set("subbillstartflag", (Object)subBillStartFlag);
            result.set("subbillendflag", (Object)subBillEndFlag);
            result.set("subbillquantity", (Object)(subBillEndFlag - subBillStartFlag + 1L));
        }
        DraftHelper.setBillCodeinfo((DynamicObject)result);
        return result;
    }

    private static void addNewendorseentry(DynamicObject eleRecDraftBill, DynamicObject result) {
        if (EmptyUtil.isEmpty((DynamicObject)eleRecDraftBill) || EmptyUtil.isEmpty((DynamicObject)result)) {
            return;
        }
        String tradetype = eleRecDraftBill.getString("tradetype");
        String preholdername = eleRecDraftBill.getString("preholdername");
        String issueticketertext = eleRecDraftBill.getString("issueticketertext");
        Date tradetypetime = eleRecDraftBill.getDate("tradetypetime");
        Date bizdate = eleRecDraftBill.getDate("bizdate");
        String company = eleRecDraftBill.getDynamicObject("company").getString("name");
        DynamicObjectCollection endorseInfoColl = eleRecDraftBill.getDynamicObjectCollection("entryentity");
        if (endorseInfoColl == null || endorseInfoColl.size() < 1) {
            if (StringUtils.isNotEmpty((CharSequence)preholdername) && StringUtils.isNotEmpty((CharSequence)issueticketertext) && !preholdername.equals(issueticketertext)) {
                DynamicObjectCollection endorseEntry = result.getDynamicObjectCollection("endorseentry");
                DynamicObject newendorseEntry = endorseEntry.addNew();
                newendorseEntry.set("endorsetype", (Object)BillEndorseTypeEnum.TRANSFER.getValue());
                newendorseEntry.set("Seq", (Object)0);
                if (tradetypetime != null) {
                    newendorseEntry.set("signdate", (Object)tradetypetime);
                } else {
                    newendorseEntry.set("signdate", (Object)bizdate);
                }
                newendorseEntry.set("initiatorname", (Object)preholdername);
                newendorseEntry.set("opponentname", (Object)company);
                newendorseEntry.set("endorseistransfer", (Object)"1");
            }
        } else {
            Collections.sort(endorseInfoColl, new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject arg0, DynamicObject arg1) {
                    Integer seq1 = arg0.getInt("Seq");
                    Integer seq2 = arg1.getInt("Seq");
                    return seq1.compareTo(seq2);
                }
            });
            DynamicObject endorse = (DynamicObject)endorseInfoColl.get(endorseInfoColl.size() - 1);
            String endorsee = endorse.getString("endorsee");
            if (StringUtils.isNotEmpty((CharSequence)endorsee) && StringUtils.isNotEmpty((CharSequence)preholdername) && StringUtils.isNotEmpty((CharSequence)issueticketertext) && !preholdername.equals(issueticketertext)) {
                QFilter qFilter = new QFilter("name", "=", (Object)endorsee);
                qFilter.and("fisbankroll", "=", (Object)"1");
                DynamicObject[] orgs = TmcDataServiceHelper.load((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{qFilter});
                if (orgs == null || orgs.length == 0) {
                    DynamicObjectCollection endorseEntry = result.getDynamicObjectCollection("endorseentry");
                    DynamicObject newendorseEntry = endorseEntry.addNew();
                    newendorseEntry.set("endorsetype", (Object)BillEndorseTypeEnum.TRANSFER.getValue());
                    int seq = endorse.getInt("Seq");
                    newendorseEntry.set("Seq", (Object)(seq + 1));
                    if (tradetypetime != null) {
                        newendorseEntry.set("signdate", (Object)tradetypetime);
                    } else {
                        newendorseEntry.set("signdate", (Object)bizdate);
                    }
                    newendorseEntry.set("initiatorname", (Object)preholdername);
                    newendorseEntry.set("opponentname", (Object)company);
                    newendorseEntry.set("endorseistransfer", (Object)"1");
                }
            }
        }
    }

    private static Pair<String, Object> findComparableBD(String value) {
        QFilter nameQFilter = new QFilter("name", "=", (Object)value);
        DynamicObject[] customerArr = TmcDataServiceHelper.load((String)"bd_customer", (String)"id", (QFilter[])new QFilter[]{nameQFilter});
        if (customerArr.length > 0) {
            DynamicObject bdCustomer = TmcDataServiceHelper.loadSingle((Object)customerArr[0].getPkValue(), (String)"bd_customer");
            return Pair.of((Object)"bd_customer", (Object)bdCustomer);
        }
        DynamicObject[] supplierArr = TmcDataServiceHelper.load((String)"bd_supplier", (String)"id", (QFilter[])new QFilter[]{nameQFilter});
        if (supplierArr.length > 0) {
            DynamicObject bdSupplier = TmcDataServiceHelper.loadSingle((Object)supplierArr[0].getPkValue(), (String)"bd_supplier");
            return Pair.of((Object)"bd_supplier", (Object)bdSupplier);
        }
        DynamicObject[] orgArr = TmcDataServiceHelper.load((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{nameQFilter});
        if (orgArr.length > 0) {
            DynamicObject bosOrg = TmcDataServiceHelper.loadSingle((Object)orgArr[0].getPkValue(), (String)"bos_org");
            return Pair.of((Object)"bos_org", (Object)bosOrg);
        }
        DynamicObject[] userArr = TmcDataServiceHelper.load((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{nameQFilter});
        if (userArr.length > 0) {
            DynamicObject bosUser = TmcDataServiceHelper.loadSingle((Object)userArr[0].getPkValue(), (String)"bos_user");
            return Pair.of((Object)"bos_user", (Object)bosUser);
        }
        return Pair.of((Object)"other", (Object)value);
    }

    private static DynamicObject findBeBankByName(String bankName) {
        QFilter nameQFilter = new QFilter("name", "=", (Object)bankName);
        DynamicObject[] load = TmcDataServiceHelper.load((String)"bd_bebank", (String)"id,union_number", (QFilter[])new QFilter[]{nameQFilter});
        if (load.length > 0) {
            return TmcDataServiceHelper.loadSingle((Object)load[0].getPkValue(), (String)"bd_bebank");
        }
        return null;
    }

    private static DynamicObject findBeBankByNameAndNo(String bankName, String bankNo) {
        QFilter nameQFilter = new QFilter("name", "=", (Object)bankName);
        DynamicObject[] load = TmcDataServiceHelper.load((String)"bd_bebank", (String)"id,union_number", (QFilter[])new QFilter[]{nameQFilter});
        if (load.length > 0) {
            return TmcDataServiceHelper.loadSingle((Object)load[0].getPkValue(), (String)"bd_bebank");
        }
        QFilter noQFilter = new QFilter("union_number", "=", (Object)bankNo);
        DynamicObject[] load2 = TmcDataServiceHelper.load((String)"bd_bebank", (String)"id,union_number", (QFilter[])new QFilter[]{noQFilter});
        if (load2.length > 0) {
            return TmcDataServiceHelper.loadSingle((Object)load2[0].getPkValue(), (String)"bd_bebank");
        }
        return null;
    }

    private static DynamicObject findBeBankByUnionNumber(String unionNumber) {
        QFilter unionNumberQFilter = new QFilter("union_number", "=", (Object)unionNumber);
        DynamicObject[] load = TmcDataServiceHelper.load((String)"bd_bebank", (String)"id,union_number", (QFilter[])new QFilter[]{unionNumberQFilter});
        if (load.length > 0) {
            return TmcDataServiceHelper.loadSingle((Object)load[0].getPkValue(), (String)"bd_bebank");
        }
        return null;
    }

    private static DynamicObject findCurrencyByName(String currencyCode) {
        QFilter numberQFilter = new QFilter("number", "=", (Object)currencyCode);
        DynamicObject[] load = TmcDataServiceHelper.load((String)"bd_currency", (String)"id", (QFilter[])new QFilter[]{numberQFilter});
        if (load.length > 0) {
            return load[0];
        }
        return null;
    }

    private static String getDraftBillTranStatus(String ebstatus) {
        switch (ebstatus) {
            case "BANK_PROCESSING": {
                return "handleing";
            }
            case "BANK_SUCCESS": {
                return "success";
            }
            case "BANK_FAIL": {
                return "failing";
            }
            case "BANK_EXCEPTION": {
                return "handleing";
            }
            case "EB_PROCESSING": {
                return "handleing";
            }
            case "BANK_UNKNOWN": {
                return "handleing";
            }
        }
        return "";
    }

    private static DynamicObject getDraftBillType(String draftBillType, DynamicObject eleRecDraftBill, DynamicObject currApplyRule) {
        Object billTypeId = 0;
        HashMap<String, DynamicProperty> fldProperties = new HashMap<String, DynamicProperty>();
        boolean storageAc99 = currApplyRule.getBoolean("storageac");
        String draftType = eleRecDraftBill.getString("drafttype");
        if (storageAc99 && "AC99".equals(draftType)) {
            draftBillType = "AC01";
        } else if ("AC99".equals(draftType)) {
            draftBillType = "AC02";
        }
        DynamicObjectCollection detailAllDys = RecEleBillStorageService.getElectRecBillDy(eleRecDraftBill, fldProperties);
        if (detailAllDys != null && detailAllDys.size() > 0) {
            if ("AC01".equals(draftBillType)) {
                DynamicObjectCollection smartmatchDCs = currApplyRule.getDynamicObjectCollection("bankruleentryentity");
                if (CollectionUtils.isNotEmpty((Collection)smartmatchDCs)) {
                    Collections.sort(smartmatchDCs, new Comparator<DynamicObject>(){

                        @Override
                        public int compare(DynamicObject arg0, DynamicObject arg1) {
                            Long date1 = arg0.getLong("Seq");
                            Long date2 = arg1.getLong("Seq");
                            return date1.compareTo(date2);
                        }
                    });
                    billTypeId = currApplyRule.getDynamicObject("bankbilltype").getPkValue();
                    for (DynamicObject entryRule : smartmatchDCs) {
                        DynamicObject billType;
                        boolean isMatch = RecEleBillStorageService.isMatchRule(entryRule, (DynamicObject)detailAllDys.get(0), fldProperties, "bankdatafilter_tag");
                        if (!isMatch || (billType = entryRule.getDynamicObject("bankwarehousingtype")) == null) continue;
                        billTypeId = billType.getPkValue();
                        break;
                    }
                } else {
                    billTypeId = currApplyRule.getDynamicObject("bankbilltype") == null ? Integer.valueOf(0) : currApplyRule.getDynamicObject("bankbilltype").getPkValue();
                }
            } else if ("AC02".equals(draftBillType)) {
                DynamicObjectCollection smartmatchDCs = currApplyRule.getDynamicObjectCollection("businessruleentryentity");
                if (CollectionUtils.isNotEmpty((Collection)smartmatchDCs)) {
                    Collections.sort(smartmatchDCs, new /* Unavailable Anonymous Inner Class!! */);
                    billTypeId = currApplyRule.getDynamicObject("businessbilltype").getPkValue();
                    for (DynamicObject entryRule : smartmatchDCs) {
                        DynamicObject dynamicObject;
                        boolean isMatch = RecEleBillStorageService.isMatchRule(entryRule, (DynamicObject)detailAllDys.get(0), fldProperties, "businessdatafilter_tag");
                        if (!isMatch || (dynamicObject = entryRule.getDynamicObject("businesswarehousingtype")) == null) continue;
                        billTypeId = dynamicObject.getPkValue();
                        break;
                    }
                } else {
                    billTypeId = currApplyRule.getDynamicObject("bankbilltype") == null ? Integer.valueOf(0) : currApplyRule.getDynamicObject("businessbilltype").getPkValue();
                }
            }
            return TmcDataServiceHelper.loadSingle((Object)billTypeId, (String)"cdm_billtype");
        }
        return null;
    }

    private static DynamicObjectCollection getElectRecBillDy(DynamicObject eleRecDraftBill, Map<String, DynamicProperty> fldProperties) {
        Object pkValue = eleRecDraftBill.getPkValue();
        QFilter filter = new QFilter("id", "=", pkValue);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"cdm_electronic_sign_deal");
        ArrayList<String> selProps = new ArrayList<String>();
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        for (IDataEntityProperty property : properties) {
            String propName;
            if (StringUtils.isBlank((CharSequence)property.getAlias()) || (propName = property.getName()).contains("_id")) continue;
            if (property instanceof BasedataProp) {
                BasedataProp bdProp = (BasedataProp)property;
                DataEntityPropertyCollection bdProperties = bdProp.getComplexType().getProperties();
                for (IDataEntityProperty prop : bdProperties) {
                    if (StringUtils.isBlank((CharSequence)prop.getAlias())) continue;
                    String secPropName = propName + "." + prop.getName();
                    if (prop instanceof BasedataProp) {
                        BasedataProp tProp = (BasedataProp)prop;
                        DataEntityPropertyCollection tProperties = tProp.getComplexType().getProperties();
                        for (IDataEntityProperty tp : tProperties) {
                            if (StringUtils.isBlank((CharSequence)tp.getAlias())) continue;
                            selProps.add(secPropName + "." + tp.getName());
                        }
                        continue;
                    }
                    selProps.add(secPropName);
                }
                continue;
            }
            selProps.add(propName);
        }
        String selectString = StringUtils.join((Object[])selProps.toArray(new Object[selProps.size()]), (String)",");
        DynamicObjectCollection rows = null;
        DataSet dsn = QueryServiceHelper.queryDataSet((String)RecEleBillStorageService.class.getName(), (String)"cdm_electronic_sign_deal", (String)selectString, (QFilter[])new QFilter[]{filter}, null);
        Object object = null;
        try {
            rows = ORM.create().toPlainDynamicObjectCollection(dsn);
        }
        catch (Throwable bdProperties) {
            object = bdProperties;
            throw bdProperties;
        }
        finally {
            if (dsn != null) {
                if (object != null) {
                    try {
                        dsn.close();
                    }
                    catch (Throwable bdProperties) {
                        ((Throwable)object).addSuppressed(bdProperties);
                    }
                } else {
                    dsn.close();
                }
            }
        }
        if (rows != null && rows.size() > 0) {
            DynamicObjectType dType = rows.getDynamicObjectType();
            for (String prop : selProps) {
                fldProperties.put(prop, dType.getProperty(prop));
            }
        }
        return rows;
    }

    private static boolean isMatchRule(DynamicObject entryRule, DynamicObject ElectRecBillDy, Map<String, DynamicProperty> fldProperties, String fileterType) {
        boolean isMatchRule = false;
        String filterStr = entryRule.getString(fileterType);
        if (!ObjectUtils.isEmpty((Object)filterStr)) {
            CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class);
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"cdm_electronic_sign_deal");
            String baseFilterStr = filterObj.buildFullFormula(mainEntityType);
            SingleTaskContext taskContext = new SingleTaskContext();
            taskContext.setSrcEntityType(mainEntityType);
            if (!"".equals(baseFilterStr)) {
                try {
                    FormulaGetHandle basebillFilterHandle = new FormulaGetHandle((ISingleTaskContext)taskContext, baseFilterStr, (Object)Boolean.FALSE);
                    Boolean baseBoolean = (Boolean)basebillFilterHandle.GetVchFldValue(fldProperties, ElectRecBillDy, null);
                    if (baseBoolean.booleanValue()) {
                        isMatchRule = true;
                    }
                }
                catch (Exception ee) {
                    logger.error((Throwable)ee);
                }
            } else {
                isMatchRule = true;
            }
        } else {
            isMatchRule = true;
        }
        return isMatchRule;
    }

    private static boolean needInsert(String electDraftStatus) {
        return Arrays.asList(NEED_INSERT_SIGN_ARR).contains(electDraftStatus);
    }

    private static void setBillType(DynamicObject receivableBill) {
        if (EmptyUtil.isNoEmpty((DynamicObject)receivableBill)) {
            DynamicObject draftbilltypeDO = receivableBill.getDynamicObject("draftbilltype");
            String settlementtype = draftbilltypeDO.getString("settlementtype");
            if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.BANK.getValue())) {
                receivableBill.set("billtype", (Object)CdmBizConstant.RECEIVABLEBILL_BANK);
            } else if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.BUSINESS.getValue())) {
                receivableBill.set("billtype", (Object)CdmBizConstant.RECEIVABLEBILL_BUSINESS);
            } else if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.CHECK.getValue())) {
                receivableBill.set("billtype", (Object)CdmBizConstant.RECEIVABLEBILL_CHECK);
            } else if (StringUtils.equals((CharSequence)settlementtype, (CharSequence)SettleMentTypeEnum.PROMISSORY.getValue())) {
                receivableBill.set("billtype", (Object)CdmBizConstant.RECEIVABLEBILL_PROMISSORY);
            }
        }
    }
}

