/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.service.billstorage;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.business.service.billstorage.bean.StorageResult;
import kd.tmc.cdm.common.enums.BillEndorseTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;

public class RecEleBillUpdateService {
    private static final Log logger = LogFactory.getLog(RecEleBillUpdateService.class);

    public static List<StorageResult> updateDraftInfo(DynamicObject eleRecDraftBill) {
        ArrayList<StorageResult> storageResults = new ArrayList<StorageResult>();
        try {
            logger.info("RecEleBillUpdateService updateDraftInfo : ticketstatus=" + eleRecDraftBill.getString("ticketstatus") + ",ebstatus=" + eleRecDraftBill.getString("ebstatus"));
            DynamicObject[] draftBillArr = TmcDataServiceHelper.load((Object[])new Object[]{eleRecDraftBill.getLong("sourceid")}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_receivablebill"));
            logger.info("RecEleBillUpdateService updateDraftInfo : draftBillArr.length=" + draftBillArr.length + ",sourceid=" + eleRecDraftBill.getLong("sourceid"));
            if (draftBillArr.length == 0) {
                return storageResults;
            }
            for (DynamicObject recBill : draftBillArr) {
                RecEleBillUpdateService.updateReceivableBill(recBill, eleRecDraftBill);
                StorageResult storageResult = new StorageResult();
                storageResult.setBillId(recBill.getLong("id"));
                storageResult.setBillNo(recBill.getString("billno"));
                storageResults.add(storageResult);
            }
            SaveServiceHelper.save((DynamicObject[])draftBillArr);
        }
        catch (Exception e) {
            logger.error("RecEleBillUpdateService updateDraftInfo exception\uff1a" + e);
            throw e;
        }
        return storageResults;
    }

    private static void updateReceivableBill(DynamicObject recBill, DynamicObject eleRecDraftBill) {
        recBill.set("modifytime", (Object)new Date());
        DynamicObjectCollection endorseEntry = recBill.getDynamicObjectCollection("endorseentry");
        DynamicObjectCollection endorseInfoColl = eleRecDraftBill.getDynamicObjectCollection("entryentity");
        if (endorseInfoColl != null && endorseInfoColl.size() > 0) {
            endorseEntry.clear();
            for (DynamicObject endorseInfo : endorseInfoColl) {
                DynamicObject newEntry = endorseEntry.addNew();
                String businessCode = endorseInfo.getString("businesscode");
                if ("10".equals(businessCode)) {
                    newEntry.set("endorsetype", (Object)BillEndorseTypeEnum.TRANSFER.getValue());
                } else if ("18".equals(businessCode)) {
                    newEntry.set("endorsetype", (Object)BillEndorseTypeEnum.PLEDGE.getValue());
                } else if ("02".equals(businessCode)) {
                    newEntry.set("endorsetype", (Object)BillEndorseTypeEnum.ACCEPTANCE.getValue());
                } else {
                    if (!"03".equals(businessCode)) continue;
                    newEntry.set("endorsetype", (Object)BillEndorseTypeEnum.INVOICE.getValue());
                }
                newEntry.set("endorseistransfer", (Object)(endorseInfo.get("isendorsetransfer") == null ? "0" : "1"));
                if ("10".equals(businessCode)) {
                    newEntry.set("signdate", (Object)endorseInfo.getDate("endorsedate"));
                } else {
                    String signDate = endorseInfo.getString("signdate");
                    if (StringUtils.isNotEmpty((CharSequence)signDate)) {
                        Date date = signDate.length() == 8 ? DateUtils.stringToDate((String)signDate, (String)"yyyyMMdd") : DateUtils.stringToDate((String)signDate, (String)"yyyy-MM-dd");
                        newEntry.set("signdate", (Object)date);
                    }
                }
                newEntry.set("initiatorname", endorseInfo.get("initiatorname"));
                newEntry.set("opponentname", endorseInfo.get("opponentname"));
            }
        }
        recBill.set("draftbillno", eleRecDraftBill.get("billno"));
        recBill.set("returnnotetag", eleRecDraftBill.get("returnnotetag"));
    }

    private static String getDraftBillTranStatus(String ebstatus) {
        switch (ebstatus) {
            case "BANK_PROCESSING": {
                return "handleing";
            }
            case "BANK_SUCCESS": {
                return "success";
            }
            case "BANK_FAIL": {
                return "failing";
            }
            case "BANK_EXCEPTION": {
                return "handleing";
            }
            case "EB_PROCESSING": {
                return "handleing";
            }
        }
        return "";
    }
}

