/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.service.upgrade;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.fbp.common.constant.RpcResult;
import kd.tmc.fbp.common.constant.RpcResultStatusCode;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class ReceBillUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(ReceBillUpgradeService.class);

    public String upgrade() {
        RpcResult result = new RpcResult();
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
        try {
            DynamicObject[] beBanks;
            QFilter billTypeFilter = new QFilter("draftbilltype.settlementtype", "=", (Object)SettleMentTypeEnum.BANK.getValue());
            QFilter accepterNameFilter = new QFilter("acceptername", "!=", (Object)" ").and(new QFilter("acceptername", "is not null", null).and(new QFilter("accepterbebank", "=", (Object)0).or(new QFilter("accepterbebank", "is null", null))));
            DynamicObject[] receBills = TmcDataServiceHelper.load((String)"cdm_receivablebill", (String)String.join((CharSequence)",", "id", "acceptername", "accepterbebank"), (QFilter[])billTypeFilter.and(accepterNameFilter).toArray());
            if (receBills == null || receBills.length == 0) {
                return JSON.toJSONString((Object)result);
            }
            List accepterNames = Arrays.stream(receBills).map(pb -> pb.get("acceptername")).collect(Collectors.toList());
            for (DynamicObject beBank : beBanks = TmcDataServiceHelper.load((String)"bd_bebank", (String)"id", (QFilter[])new QFilter("name", "in", accepterNames).toArray())) {
                for (DynamicObject recBill : receBills) {
                    if (!Objects.equals(recBill.get("acceptername"), beBank.getLocaleString("name").getLocaleValue()) || !Objects.isNull(recBill.get("accepterbebank"))) continue;
                    recBill.set("accepterbebank", beBank.getPkValue());
                    updateList.add(recBill);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            result.setStatusCode(RpcResultStatusCode.ERROR);
            result.setMessage(e.getMessage());
            return JSON.toJSONString((Object)result);
        }
        try (TXHandle h = TX.requiresNew((String)"PayableBillUpgradeService.upgrade.save");){
            try {
                for (int i = 0; i < updateList.size(); i += 1000) {
                    SaveServiceHelper.save((DynamicObject[])updateList.subList(i, Math.min(updateList.size(), i + 1000)).toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                result.setStatusCode(RpcResultStatusCode.ERROR);
                result.setMessage(e.getMessage());
                LOGGER.error((Throwable)e);
                h.markRollback();
            }
        }
        return JSON.toJSONString((Object)result);
    }
}

