/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.service.upgrade;

import com.alibaba.fastjson.JSON;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.constant.RpcResult;
import kd.tmc.fbp.common.constant.RpcResultStatusCode;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ReceivableBillEleUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(ReceivableBillEleUpgradeService.class);

    public String upgrade() {
        LOGGER.info("ReceivableBillEleUpgradeService upgrade start...");
        RpcResult result = new RpcResult();
        try {
            QFilter eleFilter = new QFilter("sourceid", "!=", (Object)0L);
            DynamicObjectCollection eleRecDeals = QueryServiceHelper.query((String)"cdm_electronic_rec_deal", (String)"id, sourceid, tradetype, ebstatus, createtime", (QFilter[])eleFilter.toArray());
            if (eleRecDeals.isEmpty()) {
                LOGGER.info("ReceivableBillEleUpgradeService eleRecDeals is empty");
                return JSON.toJSONString((Object)result);
            }
            Map<Long, List<DynamicObject>> sourceidElesMap = eleRecDeals.stream().collect(Collectors.groupingBy(e -> e.getLong("sourceid")));
            HashMap<Long, DynamicObject> sourceidEleMap = new HashMap<Long, DynamicObject>(sourceidElesMap.size());
            for (Map.Entry<Long, List<DynamicObject>> entry : sourceidElesMap.entrySet()) {
                List<DynamicObject> eles = entry.getValue();
                if (eles.size() > 1) {
                    Optional<DynamicObject> elecOptional = eles.stream().max(Comparator.comparing(e -> e.getDate("createtime")));
                    sourceidEleMap.put(entry.getKey(), elecOptional.get());
                    continue;
                }
                sourceidEleMap.put(entry.getKey(), eles.get(0));
            }
            QFilter qFilter = new QFilter("id", "in", sourceidEleMap.keySet());
            DynamicObject[] receivablebills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,tradetype,ebstatus", (QFilter[])qFilter.toArray());
            LOGGER.info("ReceivableBillEleUpgradeService upgrade receivablebills.length is " + receivablebills.length);
            LinkedList<DynamicObject> updateBills = new LinkedList<DynamicObject>();
            for (DynamicObject receivBill : receivablebills) {
                long id = receivBill.getLong("id");
                DynamicObject ele = (DynamicObject)sourceidEleMap.get(id);
                String tradetype = ele.getString("tradetype");
                String ebstatus = ele.getString("ebstatus");
                if (!EmptyUtil.isNoEmpty((String)tradetype) && !EmptyUtil.isNoEmpty((String)ebstatus)) continue;
                receivBill.set("tradetype", (Object)tradetype);
                receivBill.set("ebstatus", (Object)ebstatus);
                updateBills.add(receivBill);
            }
            if (!updateBills.isEmpty()) {
                SaveServiceHelper.update((DynamicObject[])updateBills.toArray(new DynamicObject[0]));
                LOGGER.info("ReceivableBillEleUpgradeService upgrade updateBills size is " + updateBills.size());
            }
            LOGGER.info("ReceivableBillEleUpgradeService upgrade end.");
        }
        catch (Exception e2) {
            result.setStatusCode(RpcResultStatusCode.ERROR);
            result.setMessage(e2.getMessage());
            LOGGER.error((Throwable)e2);
        }
        return JSON.toJSONString((Object)result);
    }
}

