/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.service.upgrade;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.constant.RpcResult;
import kd.tmc.fbp.common.constant.RpcResultStatusCode;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretyReleaseBillUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(SuretyReleaseBillUpgradeService.class);

    public String upgrade() {
        LOGGER.info("SuretyReleaseBillUpgradeService upgrade start...");
        RpcResult result = new RpcResult();
        QFilter filter = new QFilter("repaybillid", "=", (Object)0L).or(new QFilter("repaybillid", "is null", null));
        DynamicObject[] suretyReleaseBills = BusinessDataServiceHelper.load((String)"fbd_suretyreleasebill", (String)"id,sourcebillno,sourcebillid,repaybillid,repaybillno,repaybilltype", (QFilter[])new QFilter[]{filter});
        if (suretyReleaseBills == null || suretyReleaseBills.length == 0) {
            LOGGER.info("SuretyReleaseBillUpgradeService suretyReleaseBills is empty");
            return JSON.toJSONString((Object)result);
        }
        List sourceBillNoList = Arrays.stream(suretyReleaseBills).filter(a -> !EmptyUtil.isEmpty((String)a.getString("sourcebillno"))).map(v -> v.getString("sourcebillno")).collect(Collectors.toList());
        QFilter sourceBillNoFilter = new QFilter("billno", "in", sourceBillNoList);
        DynamicObject[] payableBills = BusinessDataServiceHelper.load((String)"cdm_payablebill", (String)"id,billno", (QFilter[])new QFilter[]{sourceBillNoFilter});
        HashMap payableBillsMap = Arrays.stream(payableBills).collect(Collectors.toMap(v -> v.getString("billno"), o -> o, (o1, o2) -> o1, HashMap::new));
        DynamicObject[] payableBillApplys = BusinessDataServiceHelper.load((String)"cdm_payablebill_ap_manual", (String)"id,billno", (QFilter[])new QFilter[]{sourceBillNoFilter});
        HashMap payableBillApplysMap = Arrays.stream(payableBillApplys).collect(Collectors.toMap(v -> v.getString("billno"), o -> o, (o1, o2) -> o1, HashMap::new));
        ArrayList<DynamicObject> updateReleaseBills = new ArrayList<DynamicObject>();
        for (DynamicObject suretyReleaseBill : suretyReleaseBills) {
            Object[] draftTradeBills;
            HashSet pkValues;
            Map botpMap = BFTrackerServiceHelper.findSourceBills((String)"fbd_suretyreleasebill", (Long[])new Long[]{suretyReleaseBill.getLong("id")});
            if (!EmptyUtil.isEmpty((Object)botpMap) && botpMap.size() > 0 && botpMap.containsKey("cdm_drafttradebill") && null != (pkValues = (HashSet)botpMap.get("cdm_drafttradebill")) && pkValues.size() > 0 && !EmptyUtil.isEmpty((Object[])(draftTradeBills = TmcDataServiceHelper.load((String)"cdm_drafttradebill", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkValues.toArray())})))) {
                suretyReleaseBill.set("repaybillid", (Object)draftTradeBills[0].getLong("id"));
                suretyReleaseBill.set("repaybilltype", (Object)"cdm_drafttradebill");
                suretyReleaseBill.set("repaybillno", (Object)draftTradeBills[0].getString("billno"));
                updateReleaseBills.add(suretyReleaseBill);
                continue;
            }
            String sourceBillNo = suretyReleaseBill.getString("sourcebillno");
            if (EmptyUtil.isEmpty((String)sourceBillNo)) continue;
            DynamicObject payableBill = (DynamicObject)payableBillsMap.get(sourceBillNo);
            if (!EmptyUtil.isEmpty((DynamicObject)payableBill)) {
                suretyReleaseBill.set("repaybillid", (Object)payableBill.getLong("id"));
                suretyReleaseBill.set("repaybilltype", (Object)"cdm_payablebill");
                suretyReleaseBill.set("repaybillno", (Object)payableBill.getString("billno"));
                updateReleaseBills.add(suretyReleaseBill);
                continue;
            }
            DynamicObject payableBillApply = (DynamicObject)payableBillApplysMap.get(sourceBillNo);
            if (EmptyUtil.isEmpty((DynamicObject)payableBillApply)) continue;
            suretyReleaseBill.set("repaybillid", (Object)payableBillApply.getLong("id"));
            suretyReleaseBill.set("repaybilltype", (Object)"cdm_payablebill_ap_manual");
            suretyReleaseBill.set("repaybillno", (Object)payableBillApply.getString("billno"));
            updateReleaseBills.add(suretyReleaseBill);
        }
        if (!EmptyUtil.isEmpty(updateReleaseBills) && updateReleaseBills.size() > 0) {
            try (TXHandle h = TX.requiresNew((String)"SuretyReleaseBillUpgradeService.upgrade");){
                try {
                    SaveServiceHelper.save((DynamicObject[])updateReleaseBills.toArray(new DynamicObject[0]));
                }
                catch (Exception e) {
                    result.setStatusCode(RpcResultStatusCode.ERROR);
                    result.setMessage(e.getMessage());
                    LOGGER.error((Throwable)e);
                    h.markRollback();
                }
            }
        }
        LOGGER.info("SuretyReleaseBillUpgradeService upgrade end...");
        return JSON.toJSONString((Object)result);
    }
}

