/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.task;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.model.interest.ReturnCreditLimitInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DiscountBillReturnCreditTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(DiscountBillReturnCreditTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> paramMap) throws KDException {
        logger.info("DiscountBillReturnCreaditTask.execute do");
        Date today = new Date();
        if (paramMap != null && !paramMap.isEmpty()) {
            Object draftexpiredate = paramMap.get("draftexpiredate");
            if (EmptyUtil.isNoEmpty((Object)draftexpiredate)) {
                today = DateUtils.stringToDate((String)draftexpiredate.toString(), (String)"yyyy-MM-dd");
            }
            logger.info("day{}", (Object)today);
        }
        ArrayList<QFilter> flterList = new ArrayList<QFilter>(3);
        flterList.add(new QFilter("draftbillstatus", "=", (Object)"discounted"));
        flterList.add(new QFilter("rptype", "=", (Object)"receivebill"));
        flterList.add(new QFilter("draftbillexpiredate", "<=", (Object)DateUtils.getDataFormat((Date)today, (boolean)false)));
        flterList.add(new QFilter("draftbillexpiredate", ">=", (Object)DateUtils.getDataFormat((Date)today, (boolean)true)));
        DynamicObjectCollection tradeBill = QueryServiceHelper.query((String)"cdm_receivablebill", (String)"id,equaltradebillid,equaltradebilltype,supperbillid,amount", (QFilter[])flterList.toArray(new QFilter[0]));
        if (tradeBill.size() > 0) {
            Map<Long, DynamicObject> draftIdAndDyMap = tradeBill.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
            Set<Long> draftIdSet = draftIdAndDyMap.keySet();
            Object[] tradeDraftBillColl = BusinessDataServiceHelper.load((String)"cdm_drafttradebill", (String)"id,amount,creditlimited,entrys,entrys.draftbill,,entrys.billamt,entrys.billlogid,source,sourcebillid,bizdate", (QFilter[])new QFilter[]{new QFilter("tradetype", "=", (Object)"discount"), new QFilter("draftbilltranstatus", "=", (Object)"success"), new QFilter("creditlimited", "!=", (Object)0L), new QFilter("entrys.draftbill", "in", draftIdSet)});
            HashSet<Long> draftLogIdSet = new HashSet<Long>(16);
            HashSet<Long> wholeDealDraftIdSet = new HashSet<Long>(16);
            if (EmptyUtil.isNoEmpty((Object[])tradeDraftBillColl)) {
                logger.info("will deal draft");
                for (Object tradeDraftBill : tradeDraftBillColl) {
                    DynamicObjectCollection entrys = tradeDraftBill.getDynamicObjectCollection("entrys");
                    for (DynamicObject entry : entrys) {
                        DynamicObject draftDy = entry.getDynamicObject("draftbill");
                        long draftId = draftDy.getLong("id");
                        if (!draftIdSet.contains(draftId)) continue;
                        long billLog = entry.getLong("billlogid");
                        draftLogIdSet.add(billLog);
                    }
                }
                DynamicObjectCollection draftBillLogColl = QueryServiceHelper.query((String)"cdm_draftbill_log", (String)"id,deleteflag,issplit,sourcebilltype,dealamount,sourcebillid,draftid", (QFilter[])new QFilter[]{new QFilter("id", "in", draftLogIdSet), new QFilter("deleteflag", "=", (Object)Character.valueOf('0')), new QFilter("issplit", "=", (Object)Character.valueOf('0'))});
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)draftBillLogColl)) {
                    Set wholedraftLogSet = draftBillLogColl.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
                    for (Object tradeDraftBill : tradeDraftBillColl) {
                        BigDecimal releaseAmount = BigDecimal.ZERO;
                        DynamicObjectCollection entrys = tradeDraftBill.getDynamicObjectCollection("entrys");
                        for (DynamicObject entry : entrys) {
                            DynamicObject draftDy = entry.getDynamicObject("draftbill");
                            long draftId = draftDy.getLong("id");
                            long billLog = entry.getLong("billlogid");
                            if (!draftIdSet.contains(draftId) || !wholedraftLogSet.contains(billLog)) continue;
                            wholeDealDraftIdSet.add(draftId);
                            BigDecimal billamt = entry.getBigDecimal("billamt");
                            releaseAmount = releaseAmount.add(billamt);
                        }
                        if (!EmptyUtil.isNoEmpty((BigDecimal)releaseAmount)) continue;
                        ReturnCreditLimitInfo creditLimitInfo = CreditLimitServiceHelper.returnCreditLimit((DynamicObject)tradeDraftBill, (DynamicObject)tradeDraftBill, (boolean)false, (BigDecimal)releaseAmount, (Long)tradeDraftBill.getLong("id"), (boolean)false, (Date)tradeDraftBill.getDate("bizdate"));
                        boolean isRpcSuccess = creditLimitInfo.isSuccess();
                        logger.info("returnCreditLimit isRpcSuccess" + isRpcSuccess);
                    }
                }
            }
            draftIdSet.removeAll(wholeDealDraftIdSet);
            if (EmptyUtil.isNoEmpty(draftIdSet)) {
                logger.info("will deal subdraft");
                this.dealSubDraft(draftIdAndDyMap, draftIdSet, wholeDealDraftIdSet);
            }
        } else {
            logger.info("DiscountBillReturnCreaditTask.no deal draft");
        }
        logger.info("DiscountBillReturnCreaditTask.execute done");
    }

    private void dealSubDraft(Map<Long, DynamicObject> draftIdAndDyMap, Set<Long> draftIdSet, Set<Long> wholeDealDraftIdSet) {
        HashMap tradeAndSupperIdMap = new HashMap(16);
        for (Map.Entry<Long, DynamicObject> entry : draftIdAndDyMap.entrySet()) {
            DynamicObject draftDy;
            String equalTradebilltype;
            Long draftId = entry.getKey();
            if (!draftIdSet.contains(draftId) || !"discount".equals(equalTradebilltype = (draftDy = entry.getValue()).getString("equaltradebilltype"))) continue;
            long supperbillid = draftDy.getLong("supperbillid");
            long equaltradebillid = draftDy.getLong("equaltradebillid");
            if (tradeAndSupperIdMap.containsKey(equaltradebillid)) {
                ((Set)tradeAndSupperIdMap.get(equaltradebillid)).add(supperbillid);
                continue;
            }
            HashSet<Long> supperIdSet = new HashSet<Long>(1);
            supperIdSet.add(supperbillid);
            tradeAndSupperIdMap.put(equaltradebillid, supperIdSet);
        }
        if (EmptyUtil.isNoEmpty(tradeAndSupperIdMap) && tradeAndSupperIdMap.size() > 0) {
            DynamicObject[] subTradeDraftBillColl;
            Set tradeTypeIdSet = tradeAndSupperIdMap.keySet();
            for (DynamicObject tradeDraftBill : subTradeDraftBillColl = BusinessDataServiceHelper.load((String)"cdm_drafttradebill", (String)"id,amount,creditlimited,entrys,entrys.draftbill,,entrys.billamt,entrys.billlogid,source,sourcebillid,bizdate", (QFilter[])new QFilter[]{new QFilter("tradetype", "=", (Object)"discount"), new QFilter("draftbilltranstatus", "=", (Object)"success"), new QFilter("creditlimited", "!=", (Object)0L), new QFilter("id", "in", tradeTypeIdSet)})) {
                long tradeDraftId = tradeDraftBill.getLong("id");
                Set supperDraftIdSet = (Set)tradeAndSupperIdMap.get(tradeDraftId);
                BigDecimal releaseAmount = BigDecimal.ZERO;
                DynamicObjectCollection entrys = tradeDraftBill.getDynamicObjectCollection("entrys");
                for (DynamicObject entry : entrys) {
                    DynamicObject draftDy = entry.getDynamicObject("draftbill");
                    long draftId = draftDy.getLong("id");
                    if (!supperDraftIdSet.contains(draftId)) continue;
                    wholeDealDraftIdSet.add(draftId);
                    BigDecimal billamt = entry.getBigDecimal("billamt");
                    releaseAmount = releaseAmount.add(billamt);
                }
                if (!EmptyUtil.isNoEmpty((BigDecimal)releaseAmount)) continue;
                ReturnCreditLimitInfo creditLimitInfo = CreditLimitServiceHelper.returnCreditLimit((DynamicObject)tradeDraftBill, (DynamicObject)tradeDraftBill, (boolean)false, (BigDecimal)releaseAmount, (Long)tradeDraftBill.getLong("id"), (boolean)false, (Date)tradeDraftBill.getDate("bizdate"));
                boolean isRpcSuccess = creditLimitInfo.isSuccess();
                logger.info("returnCreditLimit isRpcSuccess" + isRpcSuccess);
            }
        }
    }
}

