/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.task.elecdraft;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.tmc.cdm.common.enums.ElcDraftBillOpEnum;
import kd.tmc.cdm.common.enums.EleDraftBillStatusEnum;
import kd.tmc.cdm.common.enums.SignOpinionEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import org.apache.commons.lang3.StringUtils;

public class NoteSignRejectAutoTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(NoteSignRejectAutoTask.class);
    private static final List<String> WAIT_SING = Arrays.asList(EleDraftBillStatusEnum.ACCEPTANCE.getValue(), EleDraftBillStatusEnum.INVOICE.getValue(), EleDraftBillStatusEnum.RECITE.getValue(), EleDraftBillStatusEnum.PLEDGE.getValue(), EleDraftBillStatusEnum.RELEASEPLEDGE.getValue(), EleDraftBillStatusEnum.PAYMENT.getValue());

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("\u7535\u7968\u81ea\u52a8\u62d2\u6536\u4efb\u52a1\u5f00\u59cb");
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(4);
        qFilterList.add(new QFilter("ticketstatus", "in", WAIT_SING));
        qFilterList.add(new QFilter("datasource", "=", (Object)"bank"));
        qFilterList.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        DynamicObject[] signBills = BusinessDataServiceHelper.load((String)"cdm_electronic_sign_deal", (String)"id", (QFilter[])qFilterList.toArray(new QFilter[0]));
        logger.info("\u7535\u7968\u81ea\u52a8\u62d2\u6536\u4efb\u52a1\u6267\u884c\u6570\u636esignBills.length={}", (Object)signBills.length);
        if (signBills.length > 0) {
            for (DynamicObject signBill : signBills) {
                logger.info("\u7535\u7968\u81ea\u52a8\u62d2\u6536\u4efb\u52a1\u6267\u884c\u6570\u636eid={}", signBill.getPkValue());
                signBill = BusinessDataServiceHelper.loadSingle((Object)signBill.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_electronic_sign_deal"));
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("ishasright", "true");
                operateOption.setVariableValue("opType", ElcDraftBillOpEnum.NOTESIGNINREJECT.getValue());
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)"notesigninreject", (String)"cdm_electronic_sign_deal", (Object[])new Object[]{signBill.getPkValue()}, (OperateOption)operateOption);
                if (!operationResult.isSuccess()) {
                    logger.info("\u7535\u7968\u81ea\u52a8\u62d2\u6536\u4efb\u52a1\u6267\u884c\u5f02\u5e38\uff1a{}", (Object)TmcOperateServiceHelper.decodeErrorMsg((OperationResult)operationResult));
                    throw new KDBizException(TmcOperateServiceHelper.decodeErrorMsg((OperationResult)operationResult));
                }
                String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
                boolean checkSignNotice = (Boolean)TmcParameterHelper.getAppParameter((String)appId, (Long)signBill.getDynamicObject("company").getLong("id"), (String)"checksignnotice");
                if (checkSignNotice) {
                    String signOpinion = signBill.getString("signopinion");
                    if (!SignOpinionEnum.REJECT.getValue().equals(signOpinion) && StringUtils.isNotEmpty((CharSequence)signOpinion)) {
                        logger.info("\u7cfb\u7edf\u53c2\u6570\u63a7\u5236\u7b7e\u6536\u901a\u77e5\u5355\u62d2\u6536\u65f6\u624d\u80fd\u62d2\u6536\u7968\u636e,id={}", (Object)signBill.getLong("id"));
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u53c2\u6570\u63a7\u5236\u7b7e\u6536\u901a\u77e5\u5355\u62d2\u6536\u65f6\u624d\u80fd\u62d2\u6536\u7968\u636e,id=%s", (String)"NoteSignRejectAutoTask_0", (String)"tmc-cdm-business", (Object[])new Object[0]), signBill.getLong("id")));
                    }
                    operationResult = OperationServiceHelper.executeOperate((String)"receiveop", (String)"cdm_electronic_sign_deal", (Object[])new Object[]{signBill.getPkValue()}, (OperateOption)operateOption);
                    if (operationResult.isSuccess()) continue;
                    logger.info("\u7535\u7968\u81ea\u52a8\u62d2\u6536\u4efb\u52a1\u5f02\u5e38\uff1a{}", (Object)TmcOperateServiceHelper.decodeErrorMsg((OperationResult)operationResult));
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7535\u7968\u81ea\u52a8\u62d2\u6536\u4efb\u52a1\u5f02\u5e38\uff1a%s", (String)"NoteSignRejectAutoTask_1", (String)"tmc-cdm-business", (Object[])new Object[0]), TmcOperateServiceHelper.decodeErrorMsg((OperationResult)operationResult)));
                }
                operationResult = OperationServiceHelper.executeOperate((String)"receiveop", (String)"cdm_electronic_sign_deal", (Object[])new Object[]{signBill.getPkValue()}, (OperateOption)operateOption);
                if (operationResult.isSuccess()) continue;
                logger.info("\u7535\u7968\u81ea\u52a8\u62d2\u6536\u4efb\u52a1\u5f02\u5e38\uff1a{}", (Object)TmcOperateServiceHelper.decodeErrorMsg((OperationResult)operationResult));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7535\u7968\u81ea\u52a8\u62d2\u6536\u4efb\u52a1\u5f02\u5e38\uff1a%s", (String)"NoteSignRejectAutoTask_1", (String)"tmc-cdm-business", (Object[])new Object[0]), TmcOperateServiceHelper.decodeErrorMsg((OperationResult)operationResult)));
            }
            logger.info("\u7535\u7968\u81ea\u52a8\u62d2\u6536\u4efb\u52a1\u7ed3\u675f");
        }
    }
}

