/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.task.elecdraft;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.business.ebservice.api.EBServiceFacadeFactory;
import kd.tmc.cdm.business.ebservice.api.IEBServiceFacade;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.data.NoteResult;

public class QueryBankDraftForInventoryAutoTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(QueryBankDraftForInventoryAutoTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> paramMap) throws KDException {
        logger.info("\u7535\u7968\u81ea\u52a8\u83b7\u53d6\u5728\u624b\u7968\u636e\u4efb\u52a1\u5f00\u59cb");
        if (paramMap != null && !paramMap.isEmpty()) {
            List<String> draftTypeEnums;
            List<Long> bankList;
            Object company = paramMap.get("company");
            logger.info("\u53c2\u6570company{}", company);
            List<Long> companyIds = new ArrayList<Long>(4);
            if (EmptyUtil.isNoEmpty((Object)company)) {
                String[] orgNo = company.toString().split(",");
                if (orgNo.length != 1 || "0".equals(orgNo[0])) {
                    logger.info("not only one org");
                    return;
                }
                companyIds = this.getOrgIds(orgNo);
            }
            if ((bankList = this.getIdAccounts(companyIds)) == null || bankList.size() == 0) {
                logger.info("\u94f6\u4f01\u76f4\u8fde\u8d26\u53f7\u672a\u7ef4\u62a4");
                return;
            }
            List<String> ticStatusEnums = Collections.singletonList("100006");
            Object interfaceTypeObj = paramMap.get("interfacetype");
            List<Object> interfaceTypeList = new ArrayList(2);
            HashMap<String, List<String>> interfaceTypeMap = new HashMap<String, List<String>>(4);
            if (EmptyUtil.isNoEmpty((Object)interfaceTypeObj)) {
                interfaceTypeList = Arrays.stream(interfaceTypeObj.toString().split(",")).collect(Collectors.toList());
            }
            if (interfaceTypeList.size() == 0 || "".equals(interfaceTypeList.get(0))) {
                interfaceTypeMap.put("0", ticStatusEnums);
                interfaceTypeMap.put("1", ticStatusEnums);
            } else {
                for (Object interfaceType : interfaceTypeList) {
                    interfaceTypeMap.put(String.valueOf(interfaceType), ticStatusEnums);
                }
            }
            Object draftTypes = paramMap.get("drafttype");
            if (EmptyUtil.isEmpty((Object)draftTypes)) {
                draftTypeEnums = Arrays.asList("AC01", "AC02");
            } else {
                String[] draftTypeArray = draftTypes.toString().split(",");
                draftTypeEnums = Arrays.stream(draftTypeArray).map(Object::toString).collect(Collectors.toList());
            }
            OperationResult operationResult = this.queryOp(bankList, interfaceTypeMap, draftTypeEnums, companyIds.get(0));
            if (operationResult.isSuccess()) {
                logger.info("\u7535\u7968\u81ea\u52a8\u83b7\u53d6\u5728\u624b\u7968\u636e\u4efb\u52a1\u6267\u884c\u6210\u529f");
            } else {
                logger.info("\u7535\u7968\u81ea\u52a8\u83b7\u53d6\u5728\u624b\u7968\u636e\u4efb\u52a1\u6267\u884c\u5931\u8d25{}", (Object)operationResult.getAllErrorInfo());
            }
        } else {
            logger.info("\u7535\u7968\u81ea\u52a8\u83b7\u53d6\u5728\u624b\u7968\u636e\u4efb\u52a1\u53c2\u6570\u4e3a\u7a7a");
        }
        logger.info("\u7535\u7968\u81ea\u52a8\u83b7\u53d6\u5728\u624b\u7968\u636e\u4efb\u52a1\u7ed3\u675f");
    }

    private List<Long> getIdAccounts(List<Long> companyIds) {
        QFilter[] orgFilter = EmptyUtil.isEmpty(companyIds) ? null : new QFilter("company.id", "in", companyIds).toArray();
        DynamicObjectCollection eleTicDys = QueryServiceHelper.query((String)"cdm_electicdirconset", (String)"defaultaccount.id as accountid", orgFilter);
        return eleTicDys.stream().map(i -> i.getLong("accountid")).collect(Collectors.toList());
    }

    private OperationResult queryOp(List<Long> accountIdSet, Map<String, List<String>> interfaceTypeMap, List<String> draftTypeEnums, long orgId) {
        Date dataDate = DateUtils.stringToDate((String)DateUtils.formatString((Date)new Date(), (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
        String bizTypeStr = "rec";
        OperationResult operationResult = new OperationResult();
        IEBServiceFacade bankService = EBServiceFacadeFactory.getBankService();
        List<NoteResult> noteResults = bankService.queryDraftBillByImportBankData(draftTypeEnums, interfaceTypeMap, accountIdSet, true, dataDate, bizTypeStr, orgId);
        ArrayList<Long> successBillIdList = new ArrayList<Long>(10);
        for (NoteResult noteResult : noteResults) {
            if (EBResultStatusCode.SUCCESS.equals((Object)noteResult.getStatusCode())) {
                successBillIdList.add(noteResult.getBillId());
                operationResult.setSuccess(true);
                continue;
            }
            logger.error(String.format("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff0cerrCode:{%s}\uff0cerrMsg:{%s}\u3002", noteResult.getErrCode(), noteResult.getErrMsg()));
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
            operateErrorInfo.setLevel(ErrorLevel.Error);
            operateErrorInfo.setMessage(noteResult.getErrMsg());
            operationResult.addErrorInfo(operateErrorInfo);
            operationResult.setSuccess(false);
        }
        operationResult.setBillCount(noteResults.size());
        operationResult.setSuccessPkIds(successBillIdList);
        return operationResult;
    }

    private List<Long> getOrgIds(String[] orgNo) {
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        if (orgNo.length > 0) {
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)orgNo)});
            for (DynamicObject org : coll) {
                orgIds.add(org.getLong("id"));
            }
        }
        return orgIds;
    }
}

