/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.task.elecdraft;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.business.ebservice.api.EBServiceFacadeFactory;
import kd.tmc.cdm.business.ebservice.api.IEBServiceFacade;
import kd.tmc.cdm.common.enums.EleDraftBillStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftExistCatEnum;
import kd.tmc.cdm.common.enums.EleDraftNoteStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.data.NoteResult;

public class QueryElectDraftAutoTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(QueryElectDraftAutoTask.class);
    private static final List<String> WAIT_SINGIN = Arrays.asList(EleDraftBillStatusEnum.ACCEPTANCE.getTranType(), EleDraftBillStatusEnum.INVOICE.getTranType(), EleDraftBillStatusEnum.RECITE.getTranType(), EleDraftBillStatusEnum.PLEDGE.getTranType(), EleDraftBillStatusEnum.RELEASEPLEDGE.getTranType(), EleDraftBillStatusEnum.PAYMENT.getTranType());
    private static final List<String> WAIT_SINGIN_NEW = Arrays.asList("02", "03", "10", "17", "18", "19", "20", "21");
    private static final List<String> DRAFT_TYPES = Arrays.asList("AC01", "AC02");

    public void execute(RequestContext requestContext, Map<String, Object> paramMap) throws KDException {
        logger.info("\u7535\u7968\u81ea\u52a8\u83b7\u53d6\u5f85\u7b7e\u6536\u7968\u636e\u4efb\u52a1\u5f00\u59cb");
        if (paramMap != null && !paramMap.isEmpty()) {
            List<String> draftTypeEnums;
            List<Long> bankList;
            Object company = paramMap.get("company");
            logger.info("\u53c2\u6570company{}", company);
            if (ObjectUtils.isEmpty((Object)company)) {
                return;
            }
            List<Long> companyIds = new ArrayList<Long>(4);
            if (EmptyUtil.isNoEmpty((Object)company)) {
                String[] orgNo = company.toString().split(",");
                companyIds = this.getOrgIds(orgNo);
            }
            if ((bankList = this.getIdAccounts(companyIds)) == null || bankList.size() == 0) {
                logger.info("\u94f6\u4f01\u76f4\u8fde\u8d26\u53f7\u672a\u7ef4\u62a4");
                return;
            }
            Object ticketStatus = paramMap.get("ticketstatus");
            Object noteStatus = paramMap.get("notestatus");
            Object interfaceTypeObj = paramMap.get("interfacetype");
            Object tranTypeObj = paramMap.get("trantype");
            logger.info("\u53c2\u6570ticketstatus{}", ticketStatus);
            List<Object> interfaceTypeList = new ArrayList(2);
            ArrayList<String> tranTypeList = new ArrayList(2);
            HashMap<String, List<String>> interfaceTypeMap = new HashMap<String, List<String>>(2);
            if (EmptyUtil.isNoEmpty((Object)interfaceTypeObj)) {
                interfaceTypeList = Arrays.stream(interfaceTypeObj.toString().split(",")).collect(Collectors.toList());
            }
            if (EmptyUtil.isNoEmpty((Object)tranTypeObj)) {
                tranTypeList = Arrays.stream(tranTypeObj.toString().split(",")).collect(Collectors.toList());
            }
            if (interfaceTypeList.size() == 0 || "".equals(interfaceTypeList.get(0))) {
                List<String> ticStatusEnums = this.getTicketStatusList("0", noteStatus == null ? null : Arrays.stream(noteStatus.toString().split(",")).collect(Collectors.toList()), null, tranTypeList);
                interfaceTypeMap.put("0", ticStatusEnums);
                ticStatusEnums = this.getTicketStatusList("1", null, ticketStatus == null ? null : Arrays.stream(ticketStatus.toString().split(",")).collect(Collectors.toList()), tranTypeList);
                interfaceTypeMap.put("1", ticStatusEnums);
            } else {
                for (Object interfaceType : interfaceTypeList) {
                    List<String> ticStatusEnums = "0".equals(String.valueOf(interfaceType)) ? this.getTicketStatusList(String.valueOf(interfaceType), noteStatus == null ? null : Arrays.stream(noteStatus.toString().split(",")).collect(Collectors.toList()), null, tranTypeList) : this.getTicketStatusList(String.valueOf(interfaceType), null, ticketStatus == null ? null : Arrays.stream(ticketStatus.toString().split(",")).collect(Collectors.toList()), tranTypeList);
                    interfaceTypeMap.put(String.valueOf(interfaceType), ticStatusEnums);
                }
            }
            Object draftTypes = paramMap.get("drafttype");
            if (EmptyUtil.isEmpty((Object)draftTypes)) {
                draftTypeEnums = DRAFT_TYPES;
            } else {
                String[] draftTypeArray = draftTypes.toString().split(",");
                draftTypeEnums = Arrays.stream(draftTypeArray).map(Object::toString).collect(Collectors.toList());
            }
            OperationResult operationResult = this.queryOp(bankList, interfaceTypeMap, draftTypeEnums, null, null);
            if (operationResult.isSuccess()) {
                logger.info("\u7535\u7968\u81ea\u52a8\u83b7\u53d6\u5f85\u7b7e\u6536\u7968\u636e\u4efb\u52a1\u6267\u884c\u6210\u529f");
            } else {
                logger.info("\u7535\u7968\u81ea\u52a8\u83b7\u53d6\u5f85\u7b7e\u6536\u7968\u636e\u4efb\u52a1\u6267\u884c\u5931\u8d25{}", (Object)operationResult.getAllErrorInfo());
            }
        } else {
            logger.info("\u7535\u7968\u81ea\u52a8\u83b7\u53d6\u5f85\u7b7e\u6536\u7968\u636e\u4efb\u52a1\u53c2\u6570\u4e3a\u7a7a");
        }
        logger.info("\u7535\u7968\u81ea\u52a8\u83b7\u53d6\u5f85\u7b7e\u6536\u7968\u636e\u4efb\u52a1\u7ed3\u675f");
    }

    private List<Long> getIdAccounts(List<Long> companyIds) {
        QFilter orgFilter = new QFilter("company.id", "in", companyIds);
        DynamicObjectCollection eleTicIdColl = QueryServiceHelper.query((String)"cdm_electicdirconset", (String)"id", (QFilter[])new QFilter[]{orgFilter});
        DynamicObject[] eleTicDys = TmcDataServiceHelper.load((Object[])eleTicIdColl.stream().map(i -> i.get("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_electicdirconset"));
        return Stream.of(eleTicDys).map(i -> i.getLong("defaultaccount.id")).collect(Collectors.toList());
    }

    private OperationResult queryOp(List<Long> accountIdSet, Map<String, List<String>> interfaceTypeMap, List<String> draftTypeEnums, Date startDate, Date endDate) {
        OperationResult operationResult = new OperationResult();
        IEBServiceFacade bankService = EBServiceFacadeFactory.getBankService();
        List<NoteResult> noteResults = bankService.queryDraftBill(draftTypeEnums, interfaceTypeMap, accountIdSet, startDate, endDate, EleDraftExistCatEnum.REPLY.getValue());
        ArrayList<Long> successBillIdList = new ArrayList<Long>(10);
        for (NoteResult noteResult : noteResults) {
            if (EBResultStatusCode.SUCCESS.equals((Object)noteResult.getStatusCode())) {
                successBillIdList.add(noteResult.getBillId());
                continue;
            }
            logger.error(String.format("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff0cerrCode:{%s}\uff0cerrMsg:{%s}\u3002", noteResult.getErrCode(), noteResult.getErrMsg()));
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
            operateErrorInfo.setLevel(ErrorLevel.Error);
            operateErrorInfo.setMessage(noteResult.getErrMsg());
            operationResult.addErrorInfo(operateErrorInfo);
        }
        operationResult.setBillCount(noteResults.size());
        operationResult.setSuccessPkIds(successBillIdList);
        return operationResult;
    }

    private List<Long> getOrgIds(String[] orgNo) {
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        if (orgNo.length > 0) {
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)orgNo)});
            for (DynamicObject org : coll) {
                orgIds.add(org.getLong("id"));
            }
        }
        return orgIds;
    }

    private List<String> getTicketStatusList(String interfaceType, List<Object> noteStatus, List<Object> ticketStatus, List<String> tranTypeList) {
        if (tranTypeList.size() > 0) {
            return tranTypeList;
        }
        ArrayList<String> ticStatusEnums = new ArrayList(18);
        if ("0".equals(String.valueOf(interfaceType))) {
            if (noteStatus == null || noteStatus.size() == 0 || "".equals(noteStatus.get(0))) {
                ticStatusEnums = WAIT_SINGIN_NEW;
            } else {
                for (Object status : noteStatus) {
                    List tranTypes = EleDraftNoteStatusEnum.getTranTypeByValue((String)((String)status));
                    if (tranTypes.size() == 0) continue;
                    ticStatusEnums.addAll(tranTypes);
                }
            }
        } else if (ticketStatus == null || ticketStatus.size() == 0 || "".equals(ticketStatus.get(0))) {
            ticStatusEnums = WAIT_SINGIN;
        } else {
            for (Object status : ticketStatus) {
                EleDraftBillStatusEnum byValue = EleDraftBillStatusEnum.getByValue((String)((String)status));
                if (null == byValue) continue;
                ticStatusEnums.add(byValue.getTranType());
            }
        }
        ticStatusEnums = ticStatusEnums.stream().distinct().collect(Collectors.toList());
        return ticStatusEnums;
    }
}

