/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.bankdrafts;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class QueryBankDraftsValidator
extends AbstractTmcBizOppValidator {
    private static final Log logger = LogFactory.getLog(QueryBankDraftsValidator.class);

    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("bankaccount");
        selector.add("org");
        selector.add("biztype");
        selector.add("datadate");
        selector.add("importway");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject data = extendedDataEntity.getDataEntity();
            DynamicObject bankAccount = data.getDynamicObject("bankaccount");
            long bankAccId = bankAccount.getLong("id");
            Date dataDate = data.getDate("datadate");
            DynamicObjectCollection bankDraftsDb = QueryServiceHelper.query((String)"cdm_bankdrafts", (String)"id,bankaccount,datadate,bankdraftentry.e_inventorystatus", (QFilter[])new QFilter[]{new QFilter("bankaccount", "=", (Object)bankAccId), new QFilter("datadate", "=", (Object)dataDate), new QFilter("bankdraftentry.e_inventorystatus", "=", (Object)"B")});
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)bankDraftsDb)) continue;
            String bankAccName = bankAccount.getString("name");
            String dateStr = DateUtils.formatString((Date)dataDate, (String)"yyyy-MM-dd");
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u6570\u636e\u65e5\u671f\uff1a%1$s, \u94f6\u884c\u8d26\u6237\uff1a%2$s\uff1a\u4e0d\u80fd\u91cd\u590d\u7ef4\u62a4\u5df2\u76d8\u70b9\u7684\u6570\u636e\u3002", (String)"BankDraftsSaveValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]), dateStr, bankAccName));
        }
    }
}

