/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.basedata;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class ResponseRuleSaveValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        ExtendedDataEntity extendedDataEntity = extendedDataEntities[0];
        DynamicObject dyObj = extendedDataEntity.getDataEntity();
        if (!this.ruleValidate(dyObj).booleanValue()) {
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u81f3\u5c11\u9009\u4e2d\u4e00\u4e2a\u7968\u636e\u72b6\u6001\u3002", (String)"ResponseRuleSaveValidator_0", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
            return;
        }
        DynamicObjectCollection entryEntityColl = (DynamicObjectCollection)dyObj.get("entryentity");
        if (!this.orgValidate(extendedDataEntity, entryEntityColl).booleanValue()) {
            return;
        }
    }

    private Boolean ruleValidate(DynamicObject dyObj) {
        Boolean isValidatePass = Boolean.FALSE;
        if (dyObj.getBoolean("ruleacceptance") || dyObj.getBoolean("ruleconsentpayoff") || dyObj.getBoolean("ruleensure") || dyObj.getBoolean("ruleinvoice") || dyObj.getBoolean("rulepayment") || dyObj.getBoolean("rulepledge") || dyObj.getBoolean("rulerecite") || dyObj.getBoolean("rulereleaseofpledge")) {
            isValidatePass = true;
        }
        return isValidatePass;
    }

    private Boolean orgValidate(ExtendedDataEntity extendedDataEntity, DynamicObjectCollection entryEntityColl) {
        DynamicObject allOrgDatum;
        DynamicObject[] allOrgData = TmcDataServiceHelper.load((String)"cdm_responserule", (String)"id", (QFilter[])new QFilter[]{QFilter.isNull((String)"entryentity")});
        DynamicObject dyObj = extendedDataEntity.getDataEntity();
        Object id = dyObj.get("id");
        Boolean isSelf = Boolean.FALSE;
        if (allOrgData.length > 0 && !(isSelf = Boolean.valueOf((allOrgDatum = allOrgData[0]).get("id").equals(id))).booleanValue()) {
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u9002\u7528\u4e8e\u6240\u6709\u8d44\u91d1\u7ec4\u7ec7\u7684\u9002\u5e94\u89c4\u5219\u3002", (String)"ResponseRuleSaveValidator_3", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
            return Boolean.FALSE;
        }
        if (entryEntityColl != null && entryEntityColl.size() > 0) {
            Map<Object, List<DynamicObject>> currEntryMap = entryEntityColl.stream().collect(Collectors.groupingBy(e -> e.get("org.id")));
            Iterator<Map.Entry<Object, List<DynamicObject>>> iterator = currEntryMap.entrySet().iterator();
            HashSet<String> selfReOrgName = new HashSet<String>(currEntryMap.size());
            while (iterator.hasNext()) {
                Map.Entry<Object, List<DynamicObject>> next = iterator.next();
                List<DynamicObject> value = next.getValue();
                if (value.size() <= 1) continue;
                selfReOrgName.add(value.get(0).getString("org.name"));
            }
            if (selfReOrgName.size() > 0) {
                this.addMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7(%s)\u91cd\u590d\u3002", (String)"ResponseRuleSaveValidator_2", (String)"tmc-cdm-business", (Object[])new Object[0]), String.join((CharSequence)",", selfReOrgName)), ErrorLevel.Error);
                return Boolean.FALSE;
            }
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(2);
            if (!Objects.isNull(id) && !Long.valueOf("0").equals(id)) {
                qFilterList.add(new QFilter("id", "!=", id));
            }
            List orgList = entryEntityColl.stream().map(e -> e.get("org.id")).collect(Collectors.toList());
            qFilterList.add(new QFilter("entryentity.org.id", "in", orgList));
            DynamicObject[] existData = TmcDataServiceHelper.load((String)"cdm_responserule", (String)"org", (QFilter[])qFilterList.toArray(new QFilter[0]));
            if (existData.length == 0) {
                return Boolean.TRUE;
            }
            HashSet existOrgNameSet = new HashSet();
            for (DynamicObject existDatum : existData) {
                DynamicObjectCollection entryEntity = existDatum.getDynamicObjectCollection("entryentity");
                existOrgNameSet.addAll(entryEntity.stream().map(e -> e.getString("org.name")).collect(Collectors.toSet()));
            }
            String existOrgNameS = String.join((CharSequence)",", existOrgNameSet);
            this.addMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7(%s)\u5df2\u5728\u5176\u4ed6\u5e94\u7b54\u89c4\u5219\u4e2d\u5b58\u5728\u3002", (String)"ResponseRuleSaveValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]), existOrgNameS), ErrorLevel.Error);
            return Boolean.FALSE;
        }
        DynamicObject[] ids = TmcDataServiceHelper.load((String)"cdm_responserule", (String)"id", (QFilter[])new QFilter[0]);
        isSelf = ids.length == 1 && ids[0].get("id").equals(id);
        if (ids.length > 0 && !isSelf.booleanValue()) {
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u9002\u7528\u89c4\u5219\u65f6\uff0c\u65e0\u6cd5\u914d\u7f6e\u9002\u7528\u4e8e\u6240\u6709\u7ec4\u7ec7\u7684\u9002\u7528\u89c4\u5219\u3002", (String)"ResponseRuleSaveValidator_4", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

