/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.billpool;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.common.enums.BillPoolTypeEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BaseEnableEnum;

public class BillPoolEnableValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("type");
        selector.add("bank");
        selector.add("company");
        selector.add("entryentity");
        selector.add("e_company");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        if (extendedDataEntities.length > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\u3002", (String)"BillPoolEnableValidator_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject billPool = extendedDataEntity.getDataEntity();
            if (!Objects.equals(billPool.get("enable"), BaseEnableEnum.DISABLE.getValue())) continue;
            this.checkByType(extendedDataEntity, this.getQFilters(billPool));
        }
    }

    private QFilter[] getQFilters(DynamicObject billPool) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue());
        QFilter typeFilter = new QFilter("type", "=", billPool.get("type"));
        QFilter qFilters = enableFilter.and(typeFilter);
        if (Objects.equals(billPool.get("type"), BillPoolTypeEnum.BANK.getValue())) {
            qFilters.and(new QFilter("bank", "=", billPool.getDynamicObject("bank").getPkValue()));
        }
        return qFilters.toArray();
    }

    private void checkByType(ExtendedDataEntity extendedDataEntity, QFilter[] qFilters) {
        DynamicObject[] billPools = BusinessDataServiceHelper.load((String)"cdm_billpool", (String)String.join((CharSequence)",", "name", "company", "entryentity.e_company"), (QFilter[])qFilters);
        DynamicObject billPool = extendedDataEntity.getDataEntity();
        Set<DynamicObject> currSaveBillCompanySet = this.getCompanySet(billPool);
        for (DynamicObject innerBillPool : billPools) {
            Set<DynamicObject> billCompanySet = this.getCompanySet(innerBillPool);
            Set<DynamicObject> intersectCompanySet = this.intersect(currSaveBillCompanySet, billCompanySet);
            if (CollectionUtils.isEmpty(intersectCompanySet)) continue;
            this.addErrorMessage(extendedDataEntity, this.buildErrorMessage(innerBillPool, intersectCompanySet));
        }
    }

    private String buildErrorMessage(DynamicObject innerBillPool, Set<DynamicObject> intersectCompanySet) {
        StringBuilder sb = new StringBuilder();
        for (DynamicObject company : intersectCompanySet) {
            sb.append(String.format(ResManager.loadKDString((String)"\u7968\u636e\u6c60\u201c%1$s\u201d\u5df2\u7ecf\u5b58\u5728\u201c%2$s\u201d\uff0c\u4e0d\u80fd\u542f\u7528\u3002", (String)"BillPoolEnableValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]), innerBillPool.get("name"), company.get("name")));
        }
        return sb.toString();
    }

    private Set<DynamicObject> intersect(Set<DynamicObject> currSaveBillCompanySet, Set<DynamicObject> billCompanySet) {
        HashSet<DynamicObject> set = new HashSet<DynamicObject>();
        for (DynamicObject currSaveCompany : currSaveBillCompanySet) {
            for (DynamicObject billCompany : billCompanySet) {
                if (!Objects.equals(currSaveCompany.getPkValue(), billCompany.getPkValue())) continue;
                set.add(billCompany);
            }
        }
        return set;
    }

    private Set<DynamicObject> getCompanySet(DynamicObject innerBillPool) {
        DynamicObjectCollection entry = innerBillPool.getDynamicObjectCollection("entryentity");
        Set<DynamicObject> companySet = entry.stream().map(e -> e.getDynamicObject("e_company")).filter(Objects::nonNull).collect(Collectors.toSet());
        companySet.add(innerBillPool.getDynamicObject("company"));
        return companySet;
    }
}

