/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.cheque;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;

public class ChequePurchValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        if (this.getOption().getVariables().containsKey("op_from_isc")) {
            return;
        }
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            int maxPice;
            DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
            int amount = dynamicObject.getInt("amount");
            String codeRule = dynamicObject.getString("coderule");
            String replaceChar = dynamicObject.getString("replacechar");
            Integer startNo = dynamicObject.getInt("startno");
            int count = ChequePurchValidator.findCount(codeRule, replaceChar);
            if (count == 0) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u201c\u7f16\u7801\u89c4\u5219\u201d\u5fc5\u987b\u5305\u542b\u6240\u9009\u7684\u201c\u901a\u914d\u7b26\u201d\u3002", (String)"ChequePurchValidator_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
                continue;
            }
            if (count == -1) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u201c\u7f16\u7801\u89c4\u5219\u201d\u4e2d\u7684\u201c\u901a\u914d\u7b26\u201d\u9700\u8fde\u7eed\u51fa\u73b0\u3002", (String)"ChequePurchValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                continue;
            }
            if (String.valueOf(amount).length() > count) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u201c\u5f20\u6570\u201d\u4f4d\u6570\u5fc5\u987b\u5c0f\u4e8e\u6216\u7b49\u4e8e\u201c\u7f16\u7801\u89c4\u5219\u201d\u4e2d\u7684\u901a\u914d\u7b26\u4e2a\u6570\u3002", (String)"ChequePurchValidator_2", (String)"tmc-cdm-business", (Object[])new Object[0]));
                continue;
            }
            if (startNo == null || (maxPice = (int)(Math.pow(10.0, count) - 1.0)) - startNo + 1 >= amount) continue;
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4ece\u201c\u8d77\u59cb\u6d41\u6c34\u53f7\u201c\u80fd\u521b\u5efa\u7684\u5355\u636e\u5c0f\u4e8e%s\u5f20\u3002", (String)"ChequePurchValidator_3", (String)"tmc-cdm-business", (Object[])new Object[0]), String.valueOf(amount)));
        }
    }

    private static int findCount(String src, String des) {
        int count = 0;
        if (src.isEmpty() || src.indexOf(des) == -1) {
            return 0;
        }
        String[] subStr = src.substring(src.indexOf(des), src.lastIndexOf(des) + 1).split("");
        List allIn = Arrays.stream(subStr).filter(item -> item.equals(des)).collect(Collectors.toList());
        count = allIn.size() == subStr.length ? allIn.size() : -1;
        return count;
    }
}

