/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.elcDraft;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.tmc.cdm.common.enums.ElcDraftBillOpEnum;
import kd.tmc.cdm.common.enums.EleDraftBillStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftCirStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftIsNewECDS;
import kd.tmc.cdm.common.enums.EleDraftNoteStatusEnum;
import kd.tmc.cdm.common.helper.EleDraftHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.webapi.ebentity.biz.status.EbStatus;

public class ElcDraftBusinessPayValidator
extends AbstractTmcBizOppValidator {
    private String opType;

    public ElcDraftBusinessPayValidator(String opType) {
        this.opType = opType;
    }

    public ElcDraftBusinessPayValidator() {
    }

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("sourcenumber");
        sic.add("sourceid");
        sic.add("ticketstatus");
        sic.add("ebstatus");
        sic.add("backflag");
        sic.add("fileid");
        sic.add("filename");
        sic.add("filepath");
        sic.add("notestatus");
        sic.add("cirstatus");
        sic.add("subrange");
        sic.add("billno");
        sic.add("tradetype");
        return sic;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        if (StringUtils.isEmpty((CharSequence)this.opType)) {
            this.opType = this.getOption().getVariableValue("opType");
        }
        block8: for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            if (!this.check(extendedDataEntity, this.opType)) continue;
            switch (ElcDraftBillOpEnum.getByValue((String)this.opType)) {
                case REMITREGISTER: {
                    if (this.remitRegister(extendedDataEntity)) continue block8;
                    continue block8;
                }
                case REMITCONFIRM: {
                    if (this.remitConfirm(extendedDataEntity)) continue block8;
                    continue block8;
                }
                case REMITACCEPT: {
                    if (this.remitAccept(extendedDataEntity)) continue block8;
                    continue block8;
                }
                case REMITRECEIVE: {
                    if (this.remitReceive(extendedDataEntity)) continue block8;
                    continue block8;
                }
                case TICKETGUARANTEE: {
                    if (this.ticketGuarantee(extendedDataEntity)) continue block8;
                    continue block8;
                }
                case REMITCANCLE: {
                    if (this.remitcancle(extendedDataEntity)) continue block8;
                    continue block8;
                }
            }
        }
    }

    private boolean ticketGuarantee(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        String ticketStatus = dataEntity.getString("ticketstatus");
        String noteStatus = dataEntity.getString("notestatus");
        String cirStatus = dataEntity.getString("cirstatus");
        String subRange = dataEntity.getString("subrange");
        if (EleDraftIsNewECDS.NEW.getValue().equals(EleDraftHelper.isNewECDs((String)noteStatus, (String)subRange))) {
            if (EleDraftNoteStatusEnum.CS01.getValue().equals(noteStatus) && EleDraftCirStatusEnum.TF0101.getValue().equals(cirStatus)) {
                this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u51fa\u7968\u5df2\u767b\u8bb0\u72b6\u6001\u7684\u7535\u7968\u624d\u53ef\u64cd\u4f5c\u51fa\u7968\u4fdd\u8bc1\u3002", (String)"ElcDraftBusinessPayValidator_6", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
                return false;
            }
        } else if (!ticketStatus.equals(EleDraftBillStatusEnum.REGISTED.getValue())) {
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u51fa\u7968\u5df2\u767b\u8bb0\u72b6\u6001\u7684\u7535\u7968\u624d\u53ef\u64cd\u4f5c\u51fa\u7968\u4fdd\u8bc1\u3002", (String)"ElcDraftBusinessPayValidator_6", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
            return false;
        }
        return true;
    }

    private boolean remitReceive(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        String ticketStatus = dataEntity.getString("ticketstatus");
        String noteStatus = dataEntity.getString("notestatus");
        String cirStatus = dataEntity.getString("cirstatus");
        String subRange = dataEntity.getString("subrange");
        if (EleDraftIsNewECDS.NEW.getValue().equals(EleDraftHelper.isNewECDs((String)noteStatus, (String)subRange))) {
            if (!EleDraftNoteStatusEnum.CS02.getValue().equals(noteStatus) || !EleDraftCirStatusEnum.TF0101.getValue().equals(cirStatus)) {
                this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u7968\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u627f\u5151\u201d\u4e14\u6d41\u901a\u6807\u8bc6\u4e3a\u201c\u5f85\u6536\u7968\u201d\u7684\u7968\u636e\u624d\u80fd\u8fdb\u884c\u63d0\u793a\u6536\u7968\u3002", (String)"ElcDraftBusinessPayValidator_15", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
                return false;
            }
        } else if (!ticketStatus.equals(EleDraftBillStatusEnum.ACCEPTANCESIGNED.getValue())) {
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u63d0\u793a\u627f\u5151\u5df2\u7b7e\u6536\u72b6\u6001\u7684\u7968\u636e\uff0c\u624d\u80fd\u63d0\u793a\u6536\u7968\u3002", (String)"ElcDraftBusinessPayValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
            return false;
        }
        return true;
    }

    private boolean remitcancle(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        String ticketStatus = dataEntity.getString("ticketstatus");
        String noteStatus = dataEntity.getString("notestatus");
        String cirStatus = dataEntity.getString("cirstatus");
        String subRange = dataEntity.getString("subrange");
        if (EleDraftIsNewECDS.NEW.getValue().equals(EleDraftHelper.isNewECDs((String)noteStatus, (String)subRange))) {
            if (!EleDraftCirStatusEnum.TF0302.getValue().equals(cirStatus) || !EleDraftNoteStatusEnum.CS01.getValue().equals(noteStatus) && !EleDraftNoteStatusEnum.CS02.getValue().equals(noteStatus)) {
                this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u7968\u636e\u72b6\u6001\u4e0d\u652f\u6301\u53d6\u6d88\u64cd\u4f5c\u3002", (String)"ElcDraftBusinessPayValidator_17", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
                return false;
            }
        } else if (!ticketStatus.equals(EleDraftBillStatusEnum.ACCEPTANCE.getValue()) && !ticketStatus.equals(EleDraftBillStatusEnum.INVOICE.getValue())) {
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u63d0\u793a\u627f\u5151\u5f85\u7b7e\u6536\u3001\u63d0\u793a\u6536\u7968\u5f85\u7b7e\u6536\u53ef\u4ee5\u53d6\u6d88\u64cd\u4f5c\uff0c\u5176\u4ed6\u7968\u636e\u72b6\u6001\u4e0d\u80fd\u53d1\u8d77\u53d6\u6d88\u64cd\u4f5c\u3002", (String)"ElcDraftBusinessPayValidator_16", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
            return false;
        }
        return true;
    }

    private boolean remitRegister(ExtendedDataEntity extendedDataEntity) {
        boolean isInitState;
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        String ticketStatus = dataEntity.getString("ticketstatus");
        String noteStatus = dataEntity.getString("notestatus");
        String subRange = dataEntity.getString("subrange");
        if (EleDraftIsNewECDS.NEW.getValue().equals(EleDraftHelper.isNewECDs((String)noteStatus, (String)subRange))) {
            ticketStatus = dataEntity.getString("notestatus");
        }
        boolean bl = isInitState = "innit".equals(ticketStatus) || "".equals(ticketStatus) || "preregister".equals(ticketStatus);
        if (!isInitState) {
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7968\u636e\u72b6\u6001\u4e3a\u521d\u59cb\u72b6\u6001\u65f6\u624d\u53ef\u505a\u5f00\u7968\u767b\u8bb0", (String)"ElcDraftBusinessPayValidator_2", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
            return false;
        }
        return true;
    }

    private boolean remitAccept(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        String ticketStatus = dataEntity.getString("ticketstatus");
        String noteStatus = dataEntity.getString("notestatus");
        String cirStatus = dataEntity.getString("cirstatus");
        String subRange = dataEntity.getString("subrange");
        String tradeType = dataEntity.getString("tradetype");
        if (ElcDraftBillOpEnum.REMITCANCLE.getValue().equals(tradeType)) {
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u64a4\u9500\u7684\u5355\u636e\u4e0d\u80fd\u518d\u6b21\u53d1\u8d77\u63d0\u793a\u627f\u5151", (String)"ElcDraftBusinessPayValidator_22", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
            return false;
        }
        if (EleDraftIsNewECDS.NEW.getValue().equals(EleDraftHelper.isNewECDs((String)noteStatus, (String)subRange))) {
            if (!EleDraftNoteStatusEnum.CS01.getValue().equals(noteStatus) || !EleDraftCirStatusEnum.TF0101.getValue().equals(cirStatus)) {
                this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u7968\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u51fa\u7968\u201d\u4e14\u6d41\u901a\u6807\u8bc6\u4e3a\u201c\u5f85\u6536\u7968\u201d\u7684\u7968\u636e\u624d\u80fd\u8fdb\u884c\u63d0\u793a\u627f\u5151\u3002", (String)"ElcDraftBusinessPayValidator_13", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
                return false;
            }
        } else if (!ticketStatus.equals(EleDraftBillStatusEnum.REGISTED.getValue())) {
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u51fa\u7968\u5df2\u767b\u8bb0\u72b6\u6001\u7684\u7968\u636e\u624d\u80fd\u63d0\u793a\u627f\u5151", (String)"ElcDraftBusinessPayValidator_3", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
            return false;
        }
        return true;
    }

    private boolean remitConfirm(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        String fileId = dataEntity.getString("fileid");
        String fileName = dataEntity.getString("filename");
        String filePath = dataEntity.getString("filepath");
        if (StringUtils.isEmpty((CharSequence)fileId) || StringUtils.isEmpty((CharSequence)fileName) || StringUtils.isEmpty((CharSequence)filePath)) {
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7535\u5b50\u5408\u540c\u6587\u4ef6\u4fe1\u606f\u7f3a\u5931\uff0c\u4e0d\u80fd\u8fdb\u884c\u786e\u8ba4\u5408\u540c\u64cd\u4f5c", (String)"ElcDraftBusinessPayValidator_12", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
            return false;
        }
        return true;
    }

    private boolean check(ExtendedDataEntity extendedDataEntity, String opType) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        String ebStatus = dataEntity.getString("ebstatus");
        String isBack = dataEntity.getString("backflag");
        String ticketStatus = dataEntity.getString("ticketstatus");
        String noteStatus = dataEntity.getString("notestatus");
        String cirStatus = dataEntity.getString("cirstatus");
        String subRange = dataEntity.getString("subrange");
        String billno = dataEntity.getString("billno");
        if (EleDraftIsNewECDS.NEW.getValue().equals(EleDraftHelper.isNewECDs((String)noteStatus, (String)subRange))) {
            if (EleDraftNoteStatusEnum.CS05.getValue().equals(noteStatus) && EleDraftCirStatusEnum.TF0501.getValue().equals(cirStatus)) {
                this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7968\u636e\u5df2\u4f5c\u5e9f\u4e0d\u80fd\u8fdb\u884c\u4e1a\u52a1\u64cd\u4f5c", (String)"ElcDraftBusinessPayValidator_10", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
                return false;
            }
        } else if (EleDraftBillStatusEnum.DESTROY.getValue().equals(ticketStatus)) {
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7968\u636e\u5df2\u4f5c\u5e9f\u4e0d\u80fd\u8fdb\u884c\u4e1a\u52a1\u64cd\u4f5c", (String)"ElcDraftBusinessPayValidator_10", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
            return false;
        }
        if (!ElcDraftBillOpEnum.REMITREVOCATION.getValue().equals(opType) && !ElcDraftBillOpEnum.REMITCANCLE.getValue().equals(opType) && (EbStatus.BANK_PROCESSING.getName().equals(ebStatus) || EbStatus.EB_PROCESSING.getName().equals(ebStatus) || EbStatus.BANK_EXCEPTION.getName().equals(ebStatus) || "BANK_UNKNOWN".equals(ebStatus))) {
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u66f4\u65b0\u64cd\u4f5c\u7ed3\u679c\u540e\u518d\u8fdb\u884c\u4e0b\u6b21\u64cd\u4f5c", (String)"ElcDraftBusinessPayValidator_4", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
            return false;
        }
        if (ElcDraftBillOpEnum.REMITREVOCATION.getValue().equals(opType) && StringUtils.isEmpty((CharSequence)billno)) {
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u7968\u636e\u672a\u5b8c\u6210\u51fa\u7968\uff0c\u4e0d\u80fd\u64a4\u9500\u51fa\u7968\u3002", (String)"ElcDraftBusinessPayValidator_18", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
            return false;
        }
        if (ElcDraftBillOpEnum.REMITREVOCATION.getValue().equals(opType)) {
            if (EleDraftIsNewECDS.NEW.getValue().equals(EleDraftHelper.isNewECDs((String)noteStatus, (String)subRange))) {
                if (!EleDraftCirStatusEnum.TF0101.getValue().equals(cirStatus) || !EleDraftNoteStatusEnum.CS01.getValue().equals(noteStatus) && !EleDraftNoteStatusEnum.CS02.getValue().equals(noteStatus)) {
                    this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u7968\u636e\u72b6\u6001\u4e0d\u652f\u6301\u64a4\u9500\u51fa\u7968\u3002", (String)"ElcDraftBusinessPayValidator_20", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
                    return false;
                }
            } else if (!EleDraftBillStatusEnum.REGISTED.getValue().equals(ticketStatus) && !EleDraftBillStatusEnum.ACCEPTANCESIGNED.getValue().equals(ticketStatus)) {
                this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u51fa\u7968\u5df2\u767b\u8bb0\u3001\u63d0\u793a\u627f\u5151\u5df2\u7b7e\u6536\u72b6\u6001\u53ef\u4ee5\u64a4\u9500\u51fa\u7968\u3002", (String)"ElcDraftBusinessPayValidator_19", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
                return false;
            }
        }
        if ("1".equals(isBack)) {
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5df2\u6253\u56de\u7684\u7968\u636e\u4e0d\u80fd\u8fdb\u884c\u4e1a\u52a1\u64cd\u4f5c", (String)"ElcDraftBusinessPayValidator_9", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
            return false;
        }
        return true;
    }
}

