/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.elcDraft;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.tmc.cdm.common.enums.ElcDraftBillOpEnum;
import kd.tmc.cdm.common.enums.EleDraftBillStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftCirStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftIsNewECDS;
import kd.tmc.cdm.common.enums.EleDraftNoteStatusEnum;
import kd.tmc.cdm.common.enums.SignOpinionEnum;
import kd.tmc.cdm.common.helper.EleDraftHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.service.ebservice.enums.BankReturnStatusEnum;
import kd.tmc.fbp.webapi.ebentity.biz.status.EbStatus;
import org.apache.commons.lang3.StringUtils;

public class ElcDraftBusinessRecValidator
extends AbstractTmcBizOppValidator {
    private String opType;

    public ElcDraftBusinessRecValidator(String opType) {
        this.opType = opType;
    }

    public ElcDraftBusinessRecValidator() {
    }

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("datasource");
        sic.add("ticketstatus");
        sic.add("backflag");
        sic.add("ebstatus");
        sic.add("datasource");
        sic.add("opstatus");
        sic.add("company");
        sic.add("signopinion");
        sic.add("tradetype");
        sic.add("notestatus");
        sic.add("cirstatus");
        sic.add("subrange");
        sic.add("signnoticebill");
        return sic;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        if (StringUtils.isEmpty((CharSequence)this.opType)) {
            this.opType = this.getOption().getVariableValue("opType");
        }
        block6: for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            if (!this.check(extendedDataEntity, this.opType)) continue;
            switch (ElcDraftBillOpEnum.getByValue((String)this.opType)) {
                case NOTESIGNIN: {
                    if (this.noteSignIn(extendedDataEntity)) continue block6;
                    continue block6;
                }
                case NOTEENDORSE: 
                case NOTEDISCOUNT: 
                case PLEDGENOTE: 
                case PRESENTPAYMENT: 
                case GUARANTEE: {
                    if (this.noteNorse(extendedDataEntity)) continue block6;
                    continue block6;
                }
                case NOTECANCLE: {
                    if (!this.noteCancle(extendedDataEntity)) continue block6;
                    continue block6;
                }
                case NONNEGOTIABLECANCLE: {
                    if (!this.notTransferCancle(extendedDataEntity)) continue block6;
                    continue block6;
                }
            }
        }
    }

    boolean noteSignIn(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
        boolean checkSignNotice = (Boolean)TmcParameterHelper.getAppParameter((String)appId, (Long)dataEntity.getDynamicObject("company").getLong("id"), (String)"checksignnotice");
        String signOpinion = dataEntity.getString("signopinion");
        if (checkSignNotice && !SignOpinionEnum.SIGN.getValue().equals(signOpinion)) {
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7cfb\u7edf\u53c2\u6570\u63a7\u5236\u7b7e\u6536\u901a\u77e5\u5355\u540c\u610f\u7b7e\u6536\u65f6\u624d\u80fd\u7b7e\u6536\u7968\u636e", (String)"EleDraftBillHandleList_5", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        String tradeType = dataEntity.getString("tradetype");
        String ebStatus = dataEntity.getString("ebstatus");
        if (StringUtils.isNotEmpty((CharSequence)tradeType) && !EbStatus.BANK_FAIL.getName().equals(ebStatus)) {
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8be5\u7968\u636e\u4e0d\u80fd\u64cd\u4f5c\u7b7e\u6536\u6216\u62d2\u6536", (String)"EleDraftHandleSignInValidator_6", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
            return false;
        }
        return true;
    }

    boolean noteNorse(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        String ticketStatus = dataEntity.getString("ticketstatus");
        String noteStatus = dataEntity.getString("notestatus");
        String cirStatus = dataEntity.getString("cirstatus");
        String opName = ElcDraftBillOpEnum.getByValue((String)this.opType).getName();
        String subRange = dataEntity.getString("subrange");
        if (!EleDraftIsNewECDS.NEW.getValue().equals(EleDraftHelper.isNewECDs((String)noteStatus, (String)subRange))) {
            boolean have;
            boolean bl = have = ticketStatus.equals(EleDraftBillStatusEnum.INVOICESIGNED.getValue()) || ticketStatus.equals(EleDraftBillStatusEnum.RECITESIGNED.getValue()) || ticketStatus.equals(EleDraftBillStatusEnum.RELEASEOFPLEDGESIGNED.getValue());
            if (!have) {
                String content = String.format(ResManager.loadKDString((String)"\u53ea\u6709\u80cc\u4e66\u5df2\u7b7e\u6536\u72b6\u6001,\u63d0\u793a\u6536\u7968\u5df2\u7b7e\u6536,\u8d28\u62bc\u89e3\u9664\u5df2\u7b7e\u6536\u7684\u7968\u636e\u624d\u80fd %s \u64cd\u4f5c\u3002", (String)"ElcDraftBusinessRecValidator_4", (String)"tmc-cdm-business", (Object[])new Object[0]), opName);
                this.addMessage(extendedDataEntity, content, ErrorLevel.Error);
                return false;
            }
        }
        return true;
    }

    boolean noteCancle(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        String ticketStatus = dataEntity.getString("ticketstatus");
        String noteStatus = dataEntity.getString("notestatus");
        String cirStatus = dataEntity.getString("cirstatus");
        String ebStatus = dataEntity.getString("ebstatus");
        String subRange = dataEntity.getString("subrange");
        String tradeType = dataEntity.getString("tradetype");
        if (ElcDraftBillOpEnum.NOTECANCLE.getValue().equals(tradeType)) {
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u591a\u6b21\u70b9\u51fb\u64a4\u9500\u64cd\u4f5c", (String)"ElcDraftBusinessRecValidator_7", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
            return false;
        }
        if (EleDraftIsNewECDS.NEW.getValue().equals(EleDraftHelper.isNewECDs((String)noteStatus, (String)subRange))) {
            if (!EleDraftCirStatusEnum.TF0302.getValue().equals(cirStatus)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7968\u636e\u6d41\u901a\u6807\u8bc6\u4e3a\u201c\u5df2\u9501\u5b9a\u201d\u624d\u53ef\u4ee5\u64a4\u9500\u3002", (String)"ElcDraftBusinessRecValidator_6", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
        } else {
            boolean have;
            boolean bl = have = ticketStatus.equals(EleDraftBillStatusEnum.RECITE.getValue()) || ticketStatus.equals(EleDraftBillStatusEnum.NOTEDISCOUNT.getValue()) || ticketStatus.equals(EleDraftBillStatusEnum.PLEDGE.getValue()) || ticketStatus.equals(EleDraftBillStatusEnum.ENSURE.getValue()) || ticketStatus.equals(EleDraftBillStatusEnum.RELEASEPLEDGE.getValue());
            if (!have) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u80cc\u4e66\u5f85\u7b7e\u6536,\u4e70\u65ad\u5f0f\u8d34\u73b0\u5f85\u7b7e\u6536,\u8d28\u62bc\u5f85\u7b7e\u6536,\u4fdd\u8bc1\u5f85\u7b7e\u6536,\u8d28\u62bc\u89e3\u9664\u5f85\u7b7e\u6536\u72b6\u6001\u7684\u7968\u636e\u624d\u80fd\u64a4\u9500", (String)"ElcDraftBusinessRecValidator_3", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
        }
        if (!(BankReturnStatusEnum.EB_PROCESSING.getValue().equals(ebStatus) || BankReturnStatusEnum.BANK_PROCESSING.getValue().equals(ebStatus) || BankReturnStatusEnum.BANK_UNKNOWN.getValue().equals(ebStatus) || EbStatus.BANK_EXCEPTION.getName().equals(ebStatus) || EbStatus.BANK_FAIL.getName().equals(ebStatus))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u64cd\u4f5c\u72b6\u6001\u4e3a\u94f6\u4f01\u5904\u7406\u4e2d\u3001\u94f6\u884c\u5904\u7406\u4e2d\u3001\u4ea4\u6613\u5931\u8d25\u6216\u4ea4\u6613\u672a\u786e\u8ba4\u53ef\u4ee5\u64cd\u4f5c\u64a4\u9500\u3002", (String)"ElcDraftBusinessRecValidator_5", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
        return true;
    }

    boolean check(ExtendedDataEntity extendedDataEntity, String opType) {
        String tradeType;
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        String ebStatus = dataEntity.getString("ebstatus");
        String isBack = dataEntity.getString("backflag");
        String ticketStatus = dataEntity.getString("ticketstatus");
        String noteStatus = dataEntity.getString("notestatus");
        String cirStatus = dataEntity.getString("cirstatus");
        String subRange = dataEntity.getString("subrange");
        String signNoticeBill = dataEntity.getString("signnoticebill");
        if (EleDraftIsNewECDS.NEW.getValue().equals(EleDraftHelper.isNewECDs((String)noteStatus, (String)subRange))) {
            if (EleDraftNoteStatusEnum.CS05.getValue().equals(noteStatus) && EleDraftCirStatusEnum.TF0501.getValue().equals(cirStatus)) {
                this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7968\u636e\u5df2\u4f5c\u5e9f\u4e0d\u80fd\u8fdb\u884c\u4e1a\u52a1\u64cd\u4f5c", (String)"ElcDraftBusinessPayValidator_10", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
                return false;
            }
        } else {
            if (EleDraftBillStatusEnum.DESTROY.getValue().equals(ticketStatus)) {
                this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7968\u636e\u5df2\u4f5c\u5e9f\u4e0d\u80fd\u8fdb\u884c\u4e1a\u52a1\u64cd\u4f5c", (String)"ElcDraftBusinessPayValidator_10", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
                return false;
            }
            if (!ElcDraftBillOpEnum.PRESENTPAYMENT.getValue().equals(opType) && !"wait".equals(EleDraftBillStatusEnum.getFlag((String)ticketStatus))) {
                this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u975e\u5f85\u7b7e\u6536\u7535\u7968\u72b6\u6001", (String)"EleDraftHandleSignInValidator_0", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
                return false;
            }
        }
        if ("1".equals(isBack)) {
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5df2\u6253\u56de\u7684\u7968\u636e\u4e0d\u80fd\u8fdb\u884c\u4e1a\u52a1\u64cd\u4f5c", (String)"ElcDraftBusinessPayValidator_9", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
            return false;
        }
        if (!ElcDraftBillOpEnum.NOTECANCLE.getValue().equals(opType) && (EbStatus.BANK_PROCESSING.getName().equals(ebStatus) || EbStatus.EB_PROCESSING.getName().equals(ebStatus))) {
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u66f4\u65b0\u64cd\u4f5c\u7ed3\u679c\u540e\u518d\u8fdb\u884c\u4e0b\u6b21\u64cd\u4f5c", (String)"ElcDraftBusinessPayValidator_4", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
            return false;
        }
        if (!ElcDraftBillOpEnum.NOTECANCLE.getValue().equals(opType) && BankReturnStatusEnum.EB_PROCESSING.getValue().equals(ebStatus)) {
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u94f6\u4f01\u5904\u7406\u4e2d\u72b6\u6001\u4e0d\u80fd\u91cd\u590d\u64cd\u4f5c", (String)"EleDraftHandleSignInValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
            return false;
        }
        if (!ElcDraftBillOpEnum.NOTECANCLE.getValue().equals(opType) && BankReturnStatusEnum.BANK_PROCESSING.getValue().equals(ebStatus)) {
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d\u72b6\u6001\u4e0d\u80fd\u91cd\u590d\u64cd\u4f5c", (String)"EleDraftHandleSignInValidator_3", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
            return false;
        }
        String dataSource = dataEntity.getString("datasource");
        if (!"bank".equals(dataSource)) {
            if ("notesignin".equals(opType)) {
                this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6570\u636e\u6765\u6e90\u4e3a\u975e\u94f6\u4f01\u63a5\u53e3\u7684\u8bf7\u64cd\u4f5c\u624b\u5de5\u7b7e\u6536", (String)"EleDraftHandleSignInValidator_4", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
                return false;
            }
            if ("notesigninreject".equals(opType)) {
                this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u624b\u52a8\u62d2\u6536\u6570\u636e\u6765\u6e90\u4e3a\u975e\u94f6\u4f01\u4e1a\u63a5\u53e3\u7684\u6570\u636e\u3002", (String)"EleDraftHandleSignInValidator_5", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
                return false;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(tradeType = dataEntity.getString("tradetype"))) && "notesigninreject".equals(opType) && !EbStatus.BANK_FAIL.getName().equals(ebStatus)) {
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8be5\u7968\u636e\u4e0d\u80fd\u64cd\u4f5c\u7b7e\u6536\u6216\u62d2\u6536", (String)"EleDraftHandleSignInValidator_6", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
            return false;
        }
        String signOpinion = dataEntity.getString("signopinion");
        if ((ElcDraftBillOpEnum.NOTESIGNIN.getValue().equals(opType) || ElcDraftBillOpEnum.NOTESIGNINREJECT.getValue().equals(opType)) && StringUtils.isNotEmpty((CharSequence)signNoticeBill) && StringUtils.isEmpty((CharSequence)signOpinion)) {
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u672a\u5b8c\u6210\u901a\u77e5\u8ba4\u9886\u7684\u5f85\u7b7e\u6536\u7968\u636e\u4e0d\u80fd\u64cd\u4f5c\u7b7e\u6536\u6216\u62d2\u6536\u3002", (String)"EleDraftHandleSignInValidator_7", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
            return false;
        }
        String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
        boolean checkSignNotice = (Boolean)TmcParameterHelper.getAppParameter((String)appId, (Long)dataEntity.getDynamicObject("company").getLong("id"), (String)"checksignnotice");
        if (checkSignNotice && ElcDraftBillOpEnum.NOTESIGNINREJECT.getValue().equals(opType) && !SignOpinionEnum.REJECT.getValue().equals(signOpinion)) {
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7cfb\u7edf\u53c2\u6570\u63a7\u5236\u7b7e\u6536\u901a\u77e5\u5355\u540c\u610f\u62d2\u6536\u65f6\u624d\u80fd\u62d2\u6536\u7968\u636e", (String)"EleDraftHandleSignInValidator_8", (String)"tmc-cdm-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    boolean notTransferCancle(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        String cirStatus = dataEntity.getString("cirstatus");
        String ebStatus = dataEntity.getString("ebstatus");
        boolean isNotTransfer = EleDraftCirStatusEnum.TF0303.getValue().equals(cirStatus);
        boolean isSuccess = EbStatus.BANK_SUCCESS.getName().equals(ebStatus);
        if (!isNotTransfer || !isSuccess) {
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u6d41\u901a\u6807\u8bc6\u4e3a\u4e0d\u53ef\u8f6c\u8ba9\u4e14\u4ea4\u6613\u6210\u529f\u7684\u6570\u636e\u64a4\u9500\u3002", (String)"ElcDraftBusinessRecValidator_8", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
            return false;
        }
        return true;
    }
}

