/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.elcDraft;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.tmc.cdm.common.enums.ElcDraftBillOpEnum;
import kd.tmc.cdm.common.enums.EleDraftBillStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftCirStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftIsNewECDS;
import kd.tmc.cdm.common.enums.EleDraftNoteStatusEnum;
import kd.tmc.cdm.common.helper.EleDraftHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.webapi.ebentity.biz.status.EbStatus;

public class EleDraftHandleBackValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("basedraftbillno");
        sic.add("sourcebillid");
        sic.add("ticketstatus");
        sic.add("ebstatus");
        sic.add("backflag");
        sic.add("tradetype");
        sic.add("notestatus");
        sic.add("cirstatus");
        sic.add("grdbag");
        sic.add("subrange");
        return sic;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String ticketStatus = dataEntity.getString("ticketstatus");
            String noteStatus = dataEntity.getString("notestatus");
            String cirStatus = dataEntity.getString("cirstatus");
            String subRange = dataEntity.getString("subrange");
            String ebStatus = dataEntity.getString("ebstatus");
            String tradeType = dataEntity.getString("tradetype");
            if (dataEntity.getBoolean("backflag")) {
                this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u91cd\u590d\u6253\u56de", (String)"EleDraftHandleBackValidator_2", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (ElcDraftBillOpEnum.REMITACCEPT.getValue().equals(tradeType)) {
                this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u63d0\u793a\u627f\u5151\u7684\u7968\u636e\u4e0d\u5141\u8bb8\u6253\u56de\u3002", (String)"EleDraftHandleBackValidator_3", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (EleDraftIsNewECDS.NEW.getValue().equals(EleDraftHelper.isNewECDs((String)noteStatus, (String)subRange))) {
                if (!("BANK_FAIL".equals(ebStatus) || EleDraftNoteStatusEnum.CS05.getValue().equals(noteStatus) || EleDraftCirStatusEnum.TF0501.getValue().equals(cirStatus) || ElcDraftBillOpEnum.NOTECANCLE.getValue().equals(tradeType))) {
                    this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u6253\u56de\u5982\u4e0b\u6761\u4ef6\u7684\u7968\u636e\uff1a1\u3001\u64cd\u4f5c\u7c7b\u578b\u4e3a\u201c\u64a4\u9500\u201d\u4e14\u64cd\u4f5c\u72b6\u6001\u4e3a\u201c\u4ea4\u6613\u6210\u529f\u201d\u7684\u7968\u636e\uff1b2\u3001\u64cd\u4f5c\u7c7b\u578b\u4e0d\u4e3a\u201c\u64a4\u9500\u201d\u4e14\u64cd\u4f5c\u72b6\u6001\u4e3a\u201c\u4ea4\u6613\u5931\u8d25\u201d\u7684\u7968\u636e\u3002", (String)"EleDraftHandleBackValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
                }
            } else {
                EleDraftBillStatusEnum ticStatusEnum = EleDraftBillStatusEnum.getByValue((String)ticketStatus);
                if (!"BANK_FAIL".equals(ebStatus) && ticStatusEnum != EleDraftBillStatusEnum.DESTROY && !ElcDraftBillOpEnum.NOTECANCLE.getValue().equals(tradeType)) {
                    this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u6253\u56de\u5982\u4e0b\u6761\u4ef6\u7684\u7968\u636e\uff1a1\u3001\u64cd\u4f5c\u7c7b\u578b\u4e3a\u201c\u64a4\u9500\u201d\u4e14\u64cd\u4f5c\u72b6\u6001\u4e3a\u201c\u4ea4\u6613\u6210\u529f\u201d\u7684\u7968\u636e\uff1b2\u3001\u64cd\u4f5c\u7c7b\u578b\u4e0d\u4e3a\u201c\u64a4\u9500\u201d\u4e14\u64cd\u4f5c\u72b6\u6001\u4e3a\u201c\u4ea4\u6613\u5931\u8d25\u201d\u7684\u7968\u636e\u3002", (String)"EleDraftHandleBackValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
                }
            }
            if (!ElcDraftBillOpEnum.NOTECANCLE.getValue().equals(tradeType) || EbStatus.BANK_FAIL.getName().equals(ebStatus) || EbStatus.BANK_SUCCESS.getName().equals(ebStatus)) continue;
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u6253\u56de\u5982\u4e0b\u6761\u4ef6\u7684\u7968\u636e\uff1a1\u3001\u64cd\u4f5c\u7c7b\u578b\u4e3a\u201c\u64a4\u9500\u201d\u4e14\u64cd\u4f5c\u72b6\u6001\u4e3a\u201c\u4ea4\u6613\u6210\u529f\u201d\u7684\u7968\u636e\uff1b2\u3001\u64cd\u4f5c\u7c7b\u578b\u4e0d\u4e3a\u201c\u64a4\u9500\u201d\u4e14\u64cd\u4f5c\u72b6\u6001\u4e3a\u201c\u4ea4\u6613\u5931\u8d25\u201d\u7684\u7968\u636e\u3002", (String)"EleDraftHandleBackValidator_4", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
        }
    }
}

