/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.elcDraft;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.tmc.cdm.common.enums.EleDraftBillStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftCirStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftIsNewECDS;
import kd.tmc.cdm.common.enums.EleDraftNoteStatusEnum;
import kd.tmc.cdm.common.enums.SignOpinionEnum;
import kd.tmc.cdm.common.helper.EleDraftHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import org.apache.commons.lang3.StringUtils;

public class EleDraftOfflineSignInValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("basedraftbillno");
        sic.add("sourcebillid");
        sic.add("ticketstatus");
        sic.add("backflag");
        sic.add("ebstatus");
        sic.add("datasource");
        sic.add("opstatus");
        sic.add("tradetype");
        sic.add("signopinion");
        sic.add("notestatus");
        sic.add("cirstatus");
        sic.add("grdbag");
        sic.add("subrange");
        sic.add("signnoticebill");
        return sic;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            String isBack;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String ticketStatus = dataEntity.getString("ticketstatus");
            String noteStatus = dataEntity.getString("notestatus");
            String cirStatus = dataEntity.getString("cirstatus");
            String subRange = dataEntity.getString("subrange");
            boolean checkSignNotice = (Boolean)TmcParameterHelper.getAppParameter((String)appId, (Long)dataEntity.getDynamicObject("company").getLong("id"), (String)"checksignnotice");
            String signOpinion = dataEntity.getString("signopinion");
            String signNoticeBill = dataEntity.getString("signnoticebill");
            if (StringUtils.isNotEmpty((CharSequence)signNoticeBill) && StringUtils.isEmpty((CharSequence)signOpinion)) {
                this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u672a\u5b8c\u6210\u901a\u77e5\u8ba4\u9886\u7684\u5f85\u7b7e\u6536\u7968\u636e\u4e0d\u80fd\u64cd\u4f5c\u7b7e\u6536\u6216\u62d2\u6536\u3002", (String)"EleDraftHandleSignInValidator_7", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
            }
            if (checkSignNotice && !SignOpinionEnum.SIGN.getValue().equals(signOpinion)) {
                this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7cfb\u7edf\u53c2\u6570\u63a7\u5236\u7b7e\u6536\u901a\u77e5\u5355\u540c\u610f\u7b7e\u6536\u65f6\u624d\u80fd\u7b7e\u6536\u7968\u636e", (String)"EleDraftBillHandleList_5", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            }
            if (EleDraftIsNewECDS.NEW.getValue().equals(EleDraftHelper.isNewECDs((String)noteStatus, (String)subRange))) {
                if (EleDraftNoteStatusEnum.CS05.getValue().equals(noteStatus) && EleDraftCirStatusEnum.TF0501.getValue().equals(cirStatus)) {
                    this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7968\u636e\u5df2\u4f5c\u5e9f\u4e0d\u80fd\u8fdb\u884c\u4e1a\u52a1\u64cd\u4f5c", (String)"EleDraftOfflineSignInValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
                }
            } else {
                if (EleDraftBillStatusEnum.DESTROY.getValue().equals(ticketStatus)) {
                    this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7968\u636e\u5df2\u4f5c\u5e9f\u4e0d\u80fd\u8fdb\u884c\u4e1a\u52a1\u64cd\u4f5c", (String)"EleDraftOfflineSignInValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
                    continue;
                }
                if (!"wait".equals(EleDraftBillStatusEnum.getFlag((String)ticketStatus))) {
                    this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u975e\u5f85\u7b7e\u6536\u7535\u7968\u72b6\u6001", (String)"EleDraftOfflineRejectValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
                }
            }
            if ("1".equals(isBack = dataEntity.getString("backflag"))) {
                this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5df2\u6253\u56de\u7684\u7968\u636e\u4e0d\u80fd\u8fdb\u884c\u4e1a\u52a1\u64cd\u4f5c", (String)"EleDraftOfflineSignInValidator_2", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            String tradeType = dataEntity.getString("tradetype");
            if (!StringUtils.isNotEmpty((CharSequence)tradeType)) continue;
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8be5\u7968\u636e\u4e0d\u80fd\u64cd\u4f5c\u7b7e\u6536\u6216\u62d2\u6536", (String)"EleDraftHandleSignInValidator_6", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
        }
    }
}

