/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.payablebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.common.enums.SourceEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PayableBillDeleteselfValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("lockedamount");
        sic.add("basedraftbillno");
        sic.add("billstatus");
        sic.add("relatedelcbillid");
        sic.add("isrelatedprebill");
        sic.add("source");
        sic.add("sourcebillid");
        sic.add("draftbilltype");
        sic.add("isrefund");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        HashSet<Long> casBillsIdSet = new HashSet<Long>(8);
        HashMap<Long, ExtendedDataEntity> mapData = new HashMap<Long, ExtendedDataEntity>(8);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            String sourceStr = data.getString("source");
            String sourceBillId = data.getString("sourcebillid");
            boolean isrefund = data.getBoolean("isrefund");
            if (SourceEnum.CAS.getValue().equals(sourceStr) && EmptyUtil.isNoEmpty((String)sourceBillId) && isrefund) {
                long casId = Long.parseLong(sourceBillId);
                casBillsIdSet.add(casId);
                mapData.put(casId, dataEntity);
            }
            Long payBillId = data.getLong("id");
            QFilter qFilter = new QFilter("draftid", "=", (Object)payBillId);
            QFilter qFilterStatus = new QFilter("bizstatus", "=", (Object)"process");
            qFilter.and("deleteflag", "=", (Object)"0").and(qFilterStatus);
            BigDecimal lockedamount = data.getBigDecimal("lockedamount");
            if (SourceEnum.CAS.getValue().equals(sourceStr) && EmptyUtil.isNoEmpty((String)sourceBillId)) {
                long casId = Long.parseLong(sourceBillId);
                QFilter qFilterSourceId = new QFilter("sourcebillid", "=", (Object)casId);
                qFilter.and(qFilterSourceId);
                Object[] draftLogArr = BusinessDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id,sourcebillid", (QFilter[])new QFilter[]{qFilter});
                if (EmptyUtil.isNoEmpty((Object[])draftLogArr) || lockedamount == null || lockedamount.compareTo(new BigDecimal(0)) == 0) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7968\u636e\u5df2\u7ecf\u88ab\u5355\u636e\u4f7f\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u6216\u4f5c\u5e9f\u3002", (String)"PayableBillDeleteselfValidator_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
                continue;
            }
            Object[] draftLogArr = BusinessDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id,sourcebillid", (QFilter[])new QFilter[]{qFilter});
            if (!EmptyUtil.isNoEmpty((Object[])draftLogArr) && (lockedamount == null || lockedamount.compareTo(new BigDecimal(0)) == 0)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7968\u636e\u5df2\u7ecf\u88ab\u5355\u636e\u4f7f\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u6216\u4f5c\u5e9f\u3002", (String)"PayableBillDeleteselfValidator_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
        }
        if (EmptyUtil.isNoEmpty(casBillsIdSet)) {
            DynamicObject[] payBills;
            for (DynamicObject payBill : payBills = TmcDataServiceHelper.load((String)"cas_paybill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", casBillsIdSet), new QFilter("billstatus", "=", (Object)"D")})) {
                long casBillId = payBill.getLong("id");
                ExtendedDataEntity extendedDataEntity = (ExtendedDataEntity)mapData.get(casBillId);
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u4ed8\u6b3e\u5355\u5df2\u4ed8\u6b3e\uff0c\u4e14\u7968\u636e\u5df2\u7ecf\u53d1\u751f\u9000\u7968\u7684\u7968\u636e\uff0c\u4e0d\u80fd\u5220\u9664\u6216\u4f5c\u5e9f\u3002", (String)"PayableBillDeleteselfValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
        }
    }
}

