/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.payablebill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.common.enums.DraftBillStatusEnum;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.cdm.common.helper.SystemParameterHelper;
import kd.tmc.cdm.common.resource.CdmBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PayableBillDrawValidator
extends AbstractTmcBizOppValidator {
    private static Log logger = LogFactory.getLog(PayableBillDrawValidator.class);
    private final Set<String> draftTypeSet = Stream.of(SettleMentTypeEnum.BUSINESS.getValue(), SettleMentTypeEnum.BANK.getValue()).collect(Collectors.toSet());
    private Map<Long, DynamicObject> accountIdAndCateIdMap = new HashMap<Long, DynamicObject>(16);
    private Map<String, List<DynamicObject>> subbillrangeDyMap = new HashMap<String, List<DynamicObject>>(16);

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(42);
        sic.add("draftbilltranstatus");
        sic.add("electag");
        sic.add("isendorsepay");
        sic.add("draweraccount");
        sic.add("billstatus");
        sic.add("draftbillstatus");
        sic.add("draftbilltype");
        sic.add("source");
        sic.add("draftbillno");
        sic.add("basedraftbillno");
        sic.add("sourcebillid");
        sic.add("receiver");
        sic.add("draftbillno");
        sic.add("draweraccount");
        sic.add("amount");
        sic.add("drawercompany");
        sic.add("subbillrange");
        sic.add("issplit");
        sic.add("subbillendflag");
        sic.add("subbillstartflag");
        sic.add("amount");
        sic.add("supperbillamount");
        sic.add("drawerbankno");
        sic.add("draftbillno");
        sic.add("casamount");
        sic.add("receiverbankno");
        sic.add("accepterbankno");
        sic.add("accepteraccount");
        sic.add("receivername");
        sic.add("payeetype");
        sic.add("receiveraccount");
        sic.add("billno");
        sic.add("paybilltype");
        sic.add("creditlimit");
        sic.add("guaranteeinfoentry");
        sic.add("entry_surety");
        sic.add("billpoolinfoentry");
        sic.add("subbillendflag");
        sic.add("subbillstartflag");
        sic.add("subbillquantity");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        logger.info("PayableBillConfirmDrawService validate is start:");
        boolean ischekrepeat = Boolean.parseBoolean(this.getOption().getVariableValue("ischekrepeat", "false"));
        Map<Long, String> openParamOrgIdMap = this.preDealDbData(dataEntitys);
        CdmBizResource cdmBizResource = new CdmBizResource();
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject deawAcc;
            DynamicObject data = dataEntity.getDataEntity();
            DynamicObject draftBillType = data.getDynamicObject("draftbilltype");
            String billMedium = draftBillType.getString("billmedium");
            if (!"2".equals(billMedium)) continue;
            String draftbillno = data.getString("draftbillno");
            if (EmptyUtil.isEmpty((String)draftbillno)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7968\u636e\u53f7\u7801!", (String)"PayableBillEdit_7", (String)"tmc-cdm-business", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (!ischekrepeat) continue;
            String ignorejudgereArr = openParamOrgIdMap.get(data.getLong("company.id"));
            boolean needJudgeRep = EmptyUtil.isEmpty((String)ignorejudgereArr) || !ignorejudgereArr.contains("pay");
            DynamicObject drawerAccount = data.getDynamicObject("draweraccount");
            long bankCate = 0L;
            if (EmptyUtil.isNoEmpty((DynamicObject)drawerAccount) && null != (deawAcc = this.accountIdAndCateIdMap.get(drawerAccount.getLong("id")))) {
                bankCate = deawAcc.getLong("bank.bank_cate");
            }
            String subBillRange = data.getString("subbillrange");
            boolean issplit = data.getBoolean("issplit");
            DynamicObject draftBillTypeDy = data.getDynamicObject("draftbilltype");
            String settlementType = draftBillTypeDy.getString("settlementtype");
            boolean isSupportSplit = this.draftTypeSet.contains(settlementType);
            if (0L == bankCate) {
                if (!needJudgeRep || !this.isExist(drawerAccount, data)) continue;
                this.addErrorMessage(dataEntity, cdmBizResource.getExistsDraftBillNo());
                continue;
            }
            List<Object> payableBills = new ArrayList(16);
            String draftBillNo = data.getString("draftbillno");
            List<DynamicObject> payableBillsFromMap = this.subbillrangeDyMap.get(draftBillNo);
            long bankCateId = bankCate;
            if (settlementType.equals(SettleMentTypeEnum.BUSINESS.getValue()) || settlementType.equals(SettleMentTypeEnum.BANK.getValue())) {
                if (EmptyUtil.isNoEmpty(payableBillsFromMap)) {
                    payableBills = payableBillsFromMap.stream().filter(e -> this.draftTypeSet.contains(e.getString("draftbilltype.settlementtype")) && bankCateId == e.getLong("draweraccount.bank.bank_cate")).collect(Collectors.toList());
                }
            } else if (EmptyUtil.isNoEmpty(payableBillsFromMap)) {
                payableBills = payableBillsFromMap.stream().filter(e -> settlementType.equals(e.getString("draftbilltype.settlementtype")) && bankCateId == e.getLong("draweraccount.bank.bank_cate")).collect(Collectors.toList());
            }
            if (needJudgeRep && !isSupportSplit && payableBills.size() > 0) {
                this.addErrorMessage(dataEntity, cdmBizResource.getExistsDraftBillNo());
            }
            if (needJudgeRep && isSupportSplit && !issplit && payableBills.size() > 0) {
                this.addErrorMessage(dataEntity, cdmBizResource.getExistsDraftBillNo());
            }
            boolean isExistNoSplit = false;
            for (DynamicObject dynamicObject : payableBills) {
                boolean isSplitDb = dynamicObject.getBoolean("issplit");
                if (isSplitDb) continue;
                isExistNoSplit = true;
                break;
            }
            if (needJudgeRep && isSupportSplit && issplit && isExistNoSplit) {
                this.addErrorMessage(dataEntity, cdmBizResource.getExistsDraftBillNo());
            }
            if (!needJudgeRep || !isSupportSplit || !issplit || !StringUtils.isNotEmpty((CharSequence)subBillRange) || !subBillRange.contains("-")) continue;
            Long startFlag = Long.valueOf(subBillRange.split("-")[0]);
            Long l = Long.valueOf(subBillRange.split("-")[1]);
            for (DynamicObject dynamicObject : payableBills) {
                String subBillRangeDb = dynamicObject.getString("subbillrange");
                if (!this.isRepeatDraftBillNo(subBillRangeDb, startFlag, l)) continue;
                this.addErrorMessage(dataEntity, cdmBizResource.getExistsDraftBillNo());
            }
        }
        logger.info("PayableBillConfirmDrawService validate is end:");
    }

    private Map<Long, String> preDealDbData(ExtendedDataEntity[] dataEntitys) {
        HashMap<Long, String> openParamOrgIdMap = new HashMap<Long, String>(16);
        HashSet<Long> companyIdSet = new HashSet<Long>(16);
        HashSet<Long> accIdBySet = new HashSet<Long>(16);
        HashSet<String> draftbillnoSet = new HashSet<String>(16);
        HashSet<Long> dataIdSet = new HashSet<Long>(16);
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject data = dataEntity.getDataEntity();
            DynamicObject draftBillType = data.getDynamicObject("draftbilltype");
            String billMedium = draftBillType.getString("billmedium");
            if ("2".equals(billMedium)) {
                DynamicObject drawerAccount = data.getDynamicObject("draweraccount");
                if (null != drawerAccount) {
                    long drawAccountId = drawerAccount.getLong("id");
                    accIdBySet.add(drawAccountId);
                }
                draftbillnoSet.add(data.getString("draftbillno"));
                dataIdSet.add(data.getLong("id"));
            }
            long companyId = data.getDynamicObject("company").getLong("id");
            companyIdSet.add(companyId);
        }
        if (EmptyUtil.isNoEmpty(companyIdSet)) {
            Map paraMaps = SystemParameterHelper.getSysParamMap(companyIdSet);
            for (Map.Entry paraMap : paraMaps.entrySet()) {
                String keyId = (String)paraMap.getKey();
                Map valueMap = (Map)paraMap.getValue();
                String ignorejudgere = (String)valueMap.get("ignorejudgere");
                if (!EmptyUtil.isNoEmpty((String)ignorejudgere)) continue;
                openParamOrgIdMap.put(Long.parseLong(keyId), ignorejudgere);
            }
        }
        QFilter draftBillNoFilter = new QFilter("draftbillno", "in", draftbillnoSet);
        QFilter draftBillStatusFilter = new QFilter("draftbillstatus", "=", (Object)DraftBillStatusEnum.REGISTERED.getValue());
        QFilter draftStatusFilter = new QFilter("billstatus", "!=", (Object)"H");
        QFilter exceptFilter = new QFilter("id", "not in", dataIdSet);
        QFilter payBillFilter = new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.PAYBILL.getValue());
        QFilter allAfilter = draftBillNoFilter.and(draftBillStatusFilter).and(draftStatusFilter).and(exceptFilter).and(payBillFilter);
        DynamicObjectCollection payableBillsColl = QueryServiceHelper.query((String)"cdm_payablebill", (String)"id,issplit,subbillrange,draftbillno,draweraccount,draweraccount.bank.bank_cate,draftbilltype,draftbilltype.settlementtype", (QFilter[])new QFilter[]{allAfilter});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)payableBillsColl)) {
            this.subbillrangeDyMap = payableBillsColl.stream().collect(Collectors.groupingBy(e -> e.getString("draftbillno")));
            Set payBillAccountIDSet = payableBillsColl.stream().map(e -> e.getLong("draweraccount")).collect(Collectors.toSet());
            if (EmptyUtil.isNoEmpty(payBillAccountIDSet)) {
                accIdBySet.addAll(payBillAccountIDSet);
            }
        }
        if (EmptyUtil.isNoEmpty(accIdBySet)) {
            DynamicObjectCollection drawerAccountColl = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,bank,bank.bank_cate,bank.bebank,bank.bebank.number", (QFilter[])new QFilter[]{new QFilter("id", "in", accIdBySet)});
            this.accountIdAndCateIdMap = drawerAccountColl.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
        }
        logger.info("PayableBillDrawService validator preDealDbData is end:");
        return openParamOrgIdMap;
    }

    private DynamicObject getBankProperty(DynamicObject drawerAccount, String propName) {
        DynamicObject prop = null;
        if (Objects.isNull(drawerAccount)) {
            return null;
        }
        DynamicObject bank = drawerAccount.getDynamicObject("bank");
        if (Objects.nonNull(bank)) {
            bank = BusinessDataServiceHelper.loadSingle((Object)bank.getPkValue(), (String)bank.getDynamicObjectType().getName());
            prop = bank.getDynamicObject(propName);
        }
        return prop;
    }

    private boolean isExist(DynamicObject drawerAccount, DynamicObject data) {
        String bebankNumStr = "";
        if (EmptyUtil.isNoEmpty((DynamicObject)drawerAccount)) {
            long accountId = drawerAccount.getLong("id");
            DynamicObject accountDb = this.accountIdAndCateIdMap.get(accountId);
            bebankNumStr = accountDb.getString("bank.bebank.number");
        }
        String drawerBankno = data.getString("drawerbankno");
        String subBillRange = data.getString("subbillrange");
        boolean issplit = data.getBoolean("issplit");
        DynamicObject draftBillType = data.getDynamicObject("draftbilltype");
        String settlementType = draftBillType.getString("settlementtype");
        boolean isSupportSplit = this.draftTypeSet.contains(settlementType);
        String number = "";
        if (EmptyUtil.isEmpty((String)bebankNumStr)) {
            if (EmptyUtil.isEmpty((String)drawerBankno)) {
                return true;
            }
            number = drawerBankno;
        } else {
            number = bebankNumStr;
        }
        String substring = number.substring(0, Math.min(3, number.length()));
        List<Object> payableBills = new ArrayList(16);
        String draftBillNo = data.getString("draftbillno");
        List<DynamicObject> payableBillsFromMap = this.subbillrangeDyMap.get(draftBillNo);
        if (settlementType.equals(SettleMentTypeEnum.BUSINESS.getValue()) || settlementType.equals(SettleMentTypeEnum.BANK.getValue())) {
            if (EmptyUtil.isNoEmpty(payableBillsFromMap)) {
                payableBills = payableBillsFromMap.stream().filter(e -> this.draftTypeSet.contains(e.getString("draftbilltype.settlementtype"))).collect(Collectors.toList());
            }
        } else if (EmptyUtil.isNoEmpty(payableBillsFromMap)) {
            payableBills = payableBillsFromMap.stream().filter(e -> settlementType.equals(e.getString("draftbilltype.settlementtype"))).collect(Collectors.toList());
        }
        if (!isSupportSplit && EmptyUtil.isNoEmpty(payableBills) && payableBills.size() > 0) {
            return true;
        }
        if (isSupportSplit && !issplit && EmptyUtil.isNoEmpty(payableBills) && payableBills.size() > 0) {
            return true;
        }
        boolean isExistNoSplit = false;
        for (DynamicObject dynamicObject : payableBills) {
            boolean isSplitDb = dynamicObject.getBoolean("issplit");
            if (isSplitDb) continue;
            isExistNoSplit = true;
            break;
        }
        if (isSupportSplit && issplit && isExistNoSplit) {
            return true;
        }
        if (isSupportSplit && issplit && StringUtils.isNotEmpty((CharSequence)subBillRange) && subBillRange.contains("-")) {
            Long startFlag = Long.valueOf(subBillRange.split("-")[0]);
            Long l = Long.valueOf(subBillRange.split("-")[1]);
            for (DynamicObject dynamicObject : payableBills) {
                long accountId;
                DynamicObject accountDy;
                DynamicObject drawerAccountFromDB = dynamicObject.getDynamicObject("draweraccount");
                String subBillRangeFrombase = dynamicObject.getString("subbillrange");
                String bebankNumberStr = "";
                if (null != drawerAccountFromDB && null != (accountDy = this.accountIdAndCateIdMap.get(accountId = drawerAccountFromDB.getLong("id")))) {
                    bebankNumberStr = accountDy.getString("bank.bebank.number");
                }
                boolean isSameSubBillRange = this.isRepeatDraftBillNo(subBillRangeFrombase, startFlag, l);
                if (!EmptyUtil.isNoEmpty((String)bebankNumberStr) || !bebankNumberStr.startsWith(substring) || !isSameSubBillRange) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isRepeatDraftBillNo(String subBillRangeDb, long startFlag, long endFlag) {
        if (StringUtils.isEmpty((CharSequence)subBillRangeDb) || !subBillRangeDb.contains("-")) {
            return false;
        }
        Long startFlagDb = Long.valueOf(subBillRangeDb.split("-")[0]);
        Long endFlagDb = Long.valueOf(subBillRangeDb.split("-")[1]);
        boolean isRepeat = startFlag >= startFlagDb && startFlag <= endFlagDb || endFlag >= startFlagDb && endFlag <= endFlagDb || startFlag <= startFlagDb && endFlag >= endFlagDb;
        return isRepeat;
    }
}

