/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.validate.payablebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cdm.common.resource.CdmBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;

public class PayableBillTradeRefundValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("draftbilltranstatus");
        sic.add("draftbillstatus");
        sic.add("issplit");
        sic.add("subbillquantity");
        sic.add("lockedamount");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        CdmBizResource cdmBizResource = new CdmBizResource();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject receivableBillDO = dataEntity.getDataEntity();
            BigDecimal lockedAmount = receivableBillDO.getBigDecimal("lockedamount");
            if (BigDecimal.ZERO.compareTo(lockedAmount) == 0) continue;
            this.addErrorMessage(dataEntity, cdmBizResource.getLockAmountTradeCheck());
        }
    }
}

